/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.mozilla.javascript.RhinoSecurityManager;

public class SecurityUtilities {
    public static ProtectionDomain getProtectionDomain(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz.getProtectionDomain();
            }
        });
    }

    public static ProtectionDomain getScriptProtectionDomain() {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof RhinoSecurityManager) {
            return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

                @Override
                public ProtectionDomain run() {
                    Class<?> clazz = ((RhinoSecurityManager)securityManager).getCurrentScriptClass();
                    clazz = clazz == null ? null : clazz.getProtectionDomain();
                    return clazz;
                }
            });
        }
        return null;
    }

    public static String getSystemProperty(final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string2);
            }
        });
    }
}

