/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import org.mozilla.javascript.EmbeddedSlotMap;
import org.mozilla.javascript.HashSlotMap;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SlotMap;

class SlotMapContainer
implements SlotMap {
    private static final int LARGE_HASH_SIZE = 2000;
    protected SlotMap map;

    SlotMapContainer(int n) {
        this.map = n > 2000 ? new HashSlotMap() : new EmbeddedSlotMap();
    }

    @Override
    public void addSlot(ScriptableObject.Slot slot) {
        this.checkMapSize();
        this.map.addSlot(slot);
    }

    protected void checkMapSize() {
        Object object = this.map;
        if (object instanceof EmbeddedSlotMap && object.size() >= 2000) {
            HashSlotMap hashSlotMap = new HashSlotMap();
            object = this.map.iterator();
            while (object.hasNext()) {
                hashSlotMap.addSlot((ScriptableObject.Slot)object.next());
            }
            this.map = hashSlotMap;
        }
    }

    public int dirtySize() {
        return this.map.size();
    }

    @Override
    public ScriptableObject.Slot get(Object object, int n, ScriptableObject.SlotAccess slotAccess) {
        if (slotAccess != ScriptableObject.SlotAccess.QUERY) {
            this.checkMapSize();
        }
        return this.map.get(object, n, slotAccess);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<ScriptableObject.Slot> iterator() {
        return this.map.iterator();
    }

    @Override
    public ScriptableObject.Slot query(Object object, int n) {
        return this.map.query(object, n);
    }

    public long readLock() {
        return 0L;
    }

    @Override
    public void remove(Object object, int n) {
        this.map.remove(object, n);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public void unlockRead(long l) {
    }
}

