/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Comparator;

public final class Sorting {
    private static final int SMALLSORT = 16;

    private static void hybridSort(Object[] objectArray, int n, int n2, Comparator<Object> comparator, int n3) {
        if (n < n2) {
            if (n3 != 0 && n2 - n > 16) {
                int n4 = Sorting.partition(objectArray, n, n2, comparator);
                Sorting.hybridSort(objectArray, n, n4, comparator, --n3);
                Sorting.hybridSort(objectArray, n4 + 1, n2, comparator, n3);
            } else {
                Sorting.insertionSort(objectArray, n, n2, comparator);
            }
        }
    }

    public static void hybridSort(Object[] objectArray, Comparator<Object> comparator) {
        Sorting.hybridSort(objectArray, 0, objectArray.length - 1, comparator, Sorting.log2(objectArray.length) * 2);
    }

    public static void insertionSort(Object[] objectArray, int n, int n2, Comparator<Object> comparator) {
        for (int i = n; i <= n2; ++i) {
            Object object = objectArray[i];
            for (int j = i - 1; j >= n && comparator.compare(objectArray[j], object) > 0; --j) {
                objectArray[j + 1] = objectArray[j];
            }
            objectArray[j + 1] = object;
        }
    }

    public static void insertionSort(Object[] objectArray, Comparator<Object> comparator) {
        Sorting.insertionSort(objectArray, 0, objectArray.length - 1, comparator);
    }

    private static int log2(int n) {
        return (int)(Math.log10(n) / Math.log10(2.0));
    }

    public static int median(Object[] objectArray, int n, int n2, Comparator<Object> comparator) {
        int n3 = (n2 - n) / 2 + n;
        int n4 = comparator.compare(objectArray[n], objectArray[n3]) > 0 ? n3 : n;
        int n5 = n4;
        if (comparator.compare(objectArray[n4], objectArray[n2]) > 0) {
            n5 = n2;
        }
        if (n5 == n) {
            n = n2;
            if (comparator.compare(objectArray[n3], objectArray[n2]) < 0) {
                n = n3;
            }
            return n;
        }
        if (n5 == n3) {
            if (comparator.compare(objectArray[n], objectArray[n2]) >= 0) {
                n = n2;
            }
            return n;
        }
        if (comparator.compare(objectArray[n], objectArray[n3]) >= 0) {
            n = n3;
        }
        return n;
    }

    private static int partition(Object[] objectArray, int n, int n2, Comparator<Object> comparator) {
        int n3 = Sorting.median(objectArray, n, n2, comparator);
        Object object = objectArray[n3];
        objectArray[n3] = objectArray[n];
        objectArray[n] = object;
        n3 = n2 + 1;
        int n4 = n;
        while (true) {
            int n5 = n4 + 1;
            n4 = n3;
            if (comparator.compare(objectArray[n5], object) < 0) {
                n4 = n5;
                if (n5 != n2) continue;
                n4 = n3;
            }
            while (comparator.compare(objectArray[n3 = n4 - 1], object) >= 0) {
                n4 = n3;
                if (n3 != n) continue;
            }
            if (n5 >= n3) {
                Sorting.swap(objectArray, n, n3);
                return n3;
            }
            Sorting.swap(objectArray, n5, n3);
            n4 = n5;
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }
}

