/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

class SpecialRef
extends Ref {
    private static final int SPECIAL_NONE = 0;
    private static final int SPECIAL_PARENT = 2;
    private static final int SPECIAL_PROTO = 1;
    static final long serialVersionUID = -7521596632456797847L;
    private String name;
    private Scriptable target;
    private int type;

    private SpecialRef(Scriptable scriptable, int n, String string2) {
        this.target = scriptable;
        this.type = n;
        this.name = string2;
    }

    static Ref createSpecial(Context context, Scriptable scriptable, Object object, String string2) {
        block4: {
            block7: {
                int n;
                block6: {
                    block5: {
                        if ((scriptable = ScriptRuntime.toObjectOrNull(context, object, scriptable)) == null) break block4;
                        if (!string2.equals("__proto__")) break block5;
                        n = 1;
                        break block6;
                    }
                    if (!string2.equals("__parent__")) break block7;
                    n = 2;
                }
                if (!context.hasFeature(5)) {
                    n = 0;
                }
                return new SpecialRef(scriptable, n, string2);
            }
            throw new IllegalArgumentException(string2);
        }
        throw ScriptRuntime.undefReadError(object, string2);
    }

    @Override
    public boolean delete(Context context) {
        if (this.type == 0) {
            return ScriptRuntime.deleteObjectElem(this.target, this.name, context);
        }
        return false;
    }

    @Override
    public Object get(Context context) {
        int n = this.type;
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    return this.target.getParentScope();
                }
                throw Kit.codeBug();
            }
            return this.target.getPrototype();
        }
        return ScriptRuntime.getObjectProp(this.target, this.name, context);
    }

    @Override
    public boolean has(Context context) {
        if (this.type == 0) {
            return ScriptRuntime.hasObjectElem(this.target, this.name, context);
        }
        return true;
    }

    @Override
    @Deprecated
    public Object set(Context context, Object object) {
        throw new IllegalStateException();
    }

    @Override
    public Object set(Context object, Scriptable object2, Object object3) {
        int n = this.type;
        if (n != 0) {
            block6: {
                if (n != 1 && n != 2) {
                    throw Kit.codeBug();
                }
                if ((object3 = ScriptRuntime.toObjectOrNull((Context)object, object3, (Scriptable)object2)) != null) {
                    object2 = object3;
                    while (object2 != this.target) {
                        object = this.type == 1 ? object2.getPrototype() : object2.getParentScope();
                        object2 = object;
                        if (object != null) continue;
                        break block6;
                    }
                    throw Context.reportRuntimeError1("msg.cyclic.value", this.name);
                }
            }
            if (this.type == 1) {
                this.target.setPrototype((Scriptable)object3);
            } else {
                this.target.setParentScope((Scriptable)object3);
            }
            return object3;
        }
        return ScriptRuntime.setObjectProp(this.target, this.name, object3, (Context)object);
    }
}

