/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SlotMapContainer;

class ThreadSafeSlotMapContainer
extends SlotMapContainer {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private final StampedLock lock = new StampedLock();

    ThreadSafeSlotMapContainer(int n) {
        super(n);
    }

    @Override
    public void addSlot(ScriptableObject.Slot slot) {
        long l = this.lock.writeLock();
        try {
            this.checkMapSize();
            this.map.addSlot(slot);
            return;
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    @Override
    protected void checkMapSize() {
        super.checkMapSize();
    }

    @Override
    public int dirtySize() {
        return this.map.size();
    }

    @Override
    public ScriptableObject.Slot get(Object object, int n, ScriptableObject.SlotAccess slotAccess) {
        long l = this.lock.writeLock();
        try {
            if (slotAccess != ScriptableObject.SlotAccess.QUERY) {
                this.checkMapSize();
            }
            object = this.map.get(object, n, slotAccess);
            return object;
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    @Override
    public boolean isEmpty() {
        long l = this.lock.tryOptimisticRead();
        boolean bl = this.map.isEmpty();
        if (this.lock.validate(l)) {
            return bl;
        }
        l = this.lock.readLock();
        try {
            bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlockRead(l);
        }
    }

    @Override
    public Iterator<ScriptableObject.Slot> iterator() {
        return this.map.iterator();
    }

    @Override
    public ScriptableObject.Slot query(Object object, int n) {
        long l = this.lock.tryOptimisticRead();
        ScriptableObject.Slot slot = this.map.query(object, n);
        if (this.lock.validate(l)) {
            return slot;
        }
        l = this.lock.readLock();
        try {
            object = this.map.query(object, n);
            return object;
        }
        finally {
            this.lock.unlockRead(l);
        }
    }

    @Override
    public long readLock() {
        return this.lock.readLock();
    }

    @Override
    public void remove(Object object, int n) {
        long l = this.lock.writeLock();
        try {
            this.map.remove(object, n);
            return;
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    @Override
    public int size() {
        long l = this.lock.tryOptimisticRead();
        int n = this.map.size();
        if (this.lock.validate(l)) {
            return n;
        }
        l = this.lock.readLock();
        try {
            n = this.map.size();
            return n;
        }
        finally {
            this.lock.unlockRead(l);
        }
    }

    @Override
    public void unlockRead(long l) {
        this.lock.unlockRead(l);
    }
}

