/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;

class TokenStream {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final int EOF_CHAR = -1;
    private ObjToIntMap allStrings;
    private int commentCursor = -1;
    private String commentPrefix = "";
    Token.CommentType commentType;
    int cursor;
    private boolean dirtyLine;
    private boolean hitEOF = false;
    private boolean isBinary;
    private boolean isHex;
    private boolean isOctal;
    private boolean isOldOctal;
    private int lineEndChar = -1;
    private int lineStart = 0;
    int lineno;
    private double number;
    private Parser parser;
    private int quoteChar;
    String regExpFlags;
    private char[] sourceBuffer;
    int sourceCursor;
    private int sourceEnd;
    private Reader sourceReader;
    private String sourceString;
    private String string = "";
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;
    int tokenBeg;
    int tokenEnd;
    private final int[] ungetBuffer;
    private int ungetCursor;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;
    private int xmlOpenTagsCount;

    TokenStream(Parser parser, Reader reader, String string2, int n) {
        this.allStrings = new ObjToIntMap(50);
        this.ungetBuffer = new int[3];
        this.parser = parser;
        this.lineno = n;
        if (reader != null) {
            if (string2 != null) {
                Kit.codeBug();
            }
            this.sourceReader = reader;
            this.sourceBuffer = new char[512];
            this.sourceEnd = 0;
        } else {
            if (string2 == null) {
                Kit.codeBug();
            }
            this.sourceString = string2;
            this.sourceEnd = string2.length();
        }
        this.cursor = 0;
        this.sourceCursor = 0;
    }

    private void addToString(int n) {
        int n2 = this.stringBufferTop;
        char[] cArray = this.stringBuffer;
        if (n2 == cArray.length) {
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            this.stringBuffer = cArray2;
        }
        this.stringBuffer[n2] = (char)n;
        this.stringBufferTop = n2 + 1;
    }

    private boolean canUngetChar() {
        boolean bl;
        int n = this.ungetCursor;
        boolean bl2 = bl = true;
        if (n != 0) {
            bl2 = this.ungetBuffer[n - 1] != 10 ? bl : false;
        }
        return bl2;
    }

    private final int charAt(int n) {
        if (n < 0) {
            return -1;
        }
        String string2 = this.sourceString;
        if (string2 != null) {
            if (n >= this.sourceEnd) {
                return -1;
            }
            return string2.charAt(n);
        }
        int n2 = n;
        if (n >= this.sourceEnd) {
            n2 = this.sourceCursor;
            try {
                boolean bl = this.fillSourceBuffer();
                if (!bl) {
                    return -1;
                }
                n2 = n - (n2 - this.sourceCursor);
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return this.sourceBuffer[n2];
    }

    private String convertLastCharToHex(String string2) {
        int n = string2.length() - 1;
        StringBuilder stringBuilder = new StringBuilder(string2.substring(0, n));
        stringBuilder.append("\\u");
        string2 = Integer.toHexString(string2.charAt(n));
        for (int i = 0; i < 4 - string2.length(); ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private boolean fillSourceBuffer() throws IOException {
        char[] cArray;
        int n;
        Object object;
        if (this.sourceString != null) {
            Kit.codeBug();
        }
        if (this.sourceEnd == this.sourceBuffer.length) {
            if (this.lineStart != 0 && !this.isMarkingComment()) {
                object = this.sourceBuffer;
                n = this.lineStart;
                System.arraycopy(object, n, object, 0, this.sourceEnd - n);
                int n2 = this.sourceEnd;
                n = this.lineStart;
                this.sourceEnd = n2 - n;
                this.sourceCursor -= n;
                this.lineStart = 0;
            } else {
                cArray = this.sourceBuffer;
                object = new char[cArray.length * 2];
                System.arraycopy(cArray, 0, object, 0, this.sourceEnd);
                this.sourceBuffer = (char[])object;
            }
        }
        object = this.sourceReader;
        cArray = this.sourceBuffer;
        n = this.sourceEnd;
        if ((n = ((Reader)object).read(cArray, n, cArray.length - n)) < 0) {
            return false;
        }
        this.sourceEnd += n;
        return true;
    }

    private int getChar() throws IOException {
        return this.getChar(true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getChar(boolean bl) throws IOException {
        int n;
        Object object;
        int n2 = this.ungetCursor;
        if (n2 != 0) {
            void var2_3;
            ++this.cursor;
            int[] nArray = this.ungetBuffer;
            this.ungetCursor = --var2_3;
            return nArray[var2_3];
        }
        while (true) {
            Object object2;
            if ((object2 = this.sourceString) != null) {
                object = this.sourceCursor;
                if (object == this.sourceEnd) {
                    this.hitEOF = true;
                    return -1;
                }
                ++this.cursor;
                this.sourceCursor = object + 1;
                object = ((String)object2).charAt((int)object);
            } else {
                if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                    this.hitEOF = true;
                    return -1;
                }
                ++this.cursor;
                object2 = this.sourceBuffer;
                object = this.sourceCursor;
                this.sourceCursor = object + 1;
                object = object2[object];
            }
            n = this.lineEndChar;
            if (n >= 0) {
                if (n == 13 && object == 10) {
                    this.lineEndChar = 10;
                    continue;
                }
                this.lineEndChar = -1;
                this.lineStart = this.sourceCursor - 1;
                ++this.lineno;
            }
            if (object <= 127) {
                if (object != 10) {
                    n = object;
                    if (object != 13) return n;
                }
                this.lineEndChar = object;
                return 10;
            }
            if (object == 65279) {
                return object;
            }
            if (!bl || !TokenStream.isJSFormatChar(object)) break;
        }
        n = object;
        if (!ScriptRuntime.isJSLineTerminator(object)) return n;
        this.lineEndChar = object;
        return 10;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getCharIgnoreLineEnd() throws IOException {
        int n;
        Object object;
        int n2 = this.ungetCursor;
        if (n2 != 0) {
            void var1_2;
            ++this.cursor;
            int[] nArray = this.ungetBuffer;
            this.ungetCursor = --var1_2;
            return nArray[var1_2];
        }
        do {
            Object object2;
            if ((object2 = this.sourceString) != null) {
                object = this.sourceCursor;
                if (object == this.sourceEnd) {
                    this.hitEOF = true;
                    return -1;
                }
                ++this.cursor;
                this.sourceCursor = object + 1;
                object = ((String)object2).charAt((int)object);
            } else {
                if (this.sourceCursor == this.sourceEnd && !this.fillSourceBuffer()) {
                    this.hitEOF = true;
                    return -1;
                }
                ++this.cursor;
                object2 = this.sourceBuffer;
                object = this.sourceCursor;
                this.sourceCursor = object + 1;
                object = object2[object];
            }
            if (object <= 127) {
                if (object != 10) {
                    Object object3 = object;
                    if (object != 13) return n;
                }
                this.lineEndChar = object;
                return 10;
            }
            if (object != 65279) continue;
            return object;
        } while (TokenStream.isJSFormatChar(object));
        Object object4 = object;
        if (!ScriptRuntime.isJSLineTerminator(object)) return n;
        this.lineEndChar = object;
        return 10;
    }

    private String getStringFromBuffer() {
        this.tokenEnd = this.cursor;
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private static boolean isAlpha(int n) {
        boolean bl = true;
        boolean bl2 = true;
        if (n <= 90) {
            if (65 > n) {
                bl2 = false;
            }
            return bl2;
        }
        bl2 = 97 <= n && n <= 122 ? bl : false;
        return bl2;
    }

    static boolean isDigit(int n) {
        boolean bl = 48 <= n && n <= 57;
        return bl;
    }

    private static boolean isJSFormatChar(int n) {
        boolean bl = n > 127 && Character.getType((char)n) == 16;
        return bl;
    }

    static boolean isJSSpace(int n) {
        boolean bl;
        block6: {
            block5: {
                boolean bl2 = false;
                bl = false;
                if (n <= 127) {
                    if (n == 32 || n == 9 || n == 12 || n == 11) {
                        bl = true;
                    }
                    return bl;
                }
                if (n == 160 || n == 65279) break block5;
                bl = bl2;
                if (Character.getType((char)n) != 12) break block6;
            }
            bl = true;
        }
        return bl;
    }

    static boolean isKeyword(String string2, int n, boolean bl) {
        bl = TokenStream.stringToKeyword(string2, n, bl) != 0;
        return bl;
    }

    private boolean isMarkingComment() {
        boolean bl = this.commentCursor != -1;
        return bl;
    }

    private void markCommentStart() {
        this.markCommentStart("");
    }

    private void markCommentStart(String string2) {
        if (this.parser.compilerEnv.isRecordingComments() && this.sourceReader != null) {
            this.commentPrefix = string2;
            this.commentCursor = this.sourceCursor - 1;
        }
    }

    private boolean matchChar(int n) throws IOException {
        int n2 = this.getCharIgnoreLineEnd();
        if (n2 == n) {
            this.tokenEnd = this.cursor;
            return true;
        }
        this.ungetCharIgnoreLineEnd(n2);
        return false;
    }

    private int peekChar() throws IOException {
        int n = this.getChar();
        this.ungetChar(n);
        return n;
    }

    private boolean readCDATA() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 93 && this.peekChar() == 93) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                this.addToString(this.getChar());
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readEntity() throws IOException {
        int n = this.getChar();
        int n2 = 1;
        while (n != -1) {
            this.addToString(n);
            if (n != 60) {
                if (n == 62) {
                    n2 = n = n2 - 1;
                    if (n == 0) {
                        return true;
                    }
                }
            } else {
                ++n2;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readPI() throws IOException {
        int n;
        while ((n = this.getChar()) != -1) {
            this.addToString(n);
            if (n != 63 || this.peekChar() != 62) continue;
            this.addToString(this.getChar());
            return true;
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readQuotedString(int n) throws IOException {
        int n2;
        while ((n2 = this.getChar()) != -1) {
            this.addToString(n2);
            if (n2 != n) continue;
            return true;
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private boolean readXmlComment() throws IOException {
        int n = this.getChar();
        while (n != -1) {
            this.addToString(n);
            if (n == 45 && this.peekChar() == 45) {
                n = this.getChar();
                this.addToString(n);
                if (this.peekChar() != 62) continue;
                this.addToString(this.getChar());
                return true;
            }
            n = this.getChar();
        }
        this.stringBufferTop = 0;
        this.string = null;
        this.parser.addError("msg.XML.bad.form");
        return false;
    }

    private void skipLine() throws IOException {
        int n;
        while ((n = this.getChar()) != -1 && n != 10) {
        }
        this.ungetChar(n);
        this.tokenEnd = this.cursor;
    }

    private static int stringToKeyword(String string2, int n, boolean bl) {
        if (n < 200) {
            return TokenStream.stringToKeywordForJS(string2);
        }
        return TokenStream.stringToKeywordForES(string2, bl);
    }

    /*
     * Unable to fully structure code
     */
    private static int stringToKeywordForES(String var0, boolean var1_1) {
        block24: {
            block26: {
                block25: {
                    var2_2 = var0.length();
                    var3_3 = 114;
                    switch (var2_2) {
                        default: {
                            ** GOTO lbl-1000
                        }
                        case 10: {
                            var3_3 = var0.charAt(1);
                            if (var3_3 != 109 || !var1_1) ** GOTO lbl11
                            var4_4 = "implements";
                            ** GOTO lbl114
lbl11:
                            // 1 sources

                            if (var3_3 != 110) ** GOTO lbl-1000
                            var3_3 = 53;
                            var4_4 = "instanceof";
                            ** GOTO lbl216
                        }
                        case 9: {
                            var3_3 = var0.charAt(0);
                            if (var3_3 != 105 || !var1_1) ** GOTO lbl20
                            var4_4 = "interface";
                            ** GOTO lbl114
lbl20:
                            // 1 sources

                            if (var3_3 != 112 || !var1_1) ** GOTO lbl-1000
                            var4_4 = "protected";
                            ** GOTO lbl114
                        }
                        case 8: {
                            var3_3 = var0.charAt(0);
                            if (var3_3 == 99) ** GOTO lbl34
                            if (var3_3 == 100) ** GOTO lbl31
                            if (var3_3 != 102) ** GOTO lbl-1000
                            var4_4 = "function";
                            var3_3 = 110;
                            ** GOTO lbl216
lbl31:
                            // 1 sources

                            var3_3 = 161;
                            var4_4 = "debugger";
                            ** GOTO lbl216
lbl34:
                            // 1 sources

                            var3_3 = 122;
                            var4_4 = "continue";
                            ** GOTO lbl216
                        }
                        case 7: {
                            var3_3 = var0.charAt(1);
                            if (var3_3 == 97) ** GOTO lbl53
                            if (var3_3 == 101) ** GOTO lbl56
                            if (var3_3 == 105) ** GOTO lbl50
                            if (var3_3 == 114) ** GOTO lbl45
                            if (var3_3 == 120) ** GOTO lbl-1000
                            ** GOTO lbl-1000
lbl45:
                            // 1 sources

                            if (var1_1) {
                                var4_4 = "private";
                            } else lbl-1000:
                            // 2 sources

                            {
                                var4_4 = "extends";
                            }
                            ** GOTO lbl114
lbl50:
                            // 1 sources

                            var3_3 = 126;
                            var4_4 = "finally";
                            ** GOTO lbl216
lbl53:
                            // 1 sources

                            if (!var1_1) ** GOTO lbl56
                            var4_4 = "package";
                            ** GOTO lbl114
lbl56:
                            // 2 sources

                            var4_4 = "default";
                            var3_3 = 117;
                            ** GOTO lbl216
                        }
                        case 6: {
                            var3_3 = var0.charAt(1);
                            if (var3_3 == 101) ** GOTO lbl88
                            if (var3_3 == 109) ** GOTO lbl86
                            if (var3_3 == 116) ** GOTO lbl75
                            if (var3_3 == 117) ** GOTO lbl78
                            switch (var3_3) {
                                default: {
                                    ** GOTO lbl-1000
                                }
                                case 121: {
                                    var3_3 = 32;
                                    var4_4 = "typeof";
                                    break;
                                }
                                case 120: {
                                    var4_4 = "export";
                                    ** GOTO lbl114
                                }
lbl75:
                                // 1 sources

                                if (!var1_1) ** GOTO lbl78
                                var4_4 = "static";
                                ** GOTO lbl114
lbl78:
                                // 2 sources

                                if (!var1_1) ** GOTO lbl81
                                var4_4 = "public";
                                ** GOTO lbl114
lbl81:
                                // 2 sources

                                case 119: {
                                    var4_4 = "switch";
                                    var3_3 = 115;
                                    break;
                                }
                            }
                            ** GOTO lbl216
lbl86:
                            // 1 sources

                            var4_4 = "import";
                            ** GOTO lbl114
lbl88:
                            // 1 sources

                            var3_3 = var0.charAt(0);
                            if (var3_3 != 100) ** GOTO lbl93
                            var3_3 = 31;
                            var4_4 = "delete";
                            ** GOTO lbl216
lbl93:
                            // 1 sources

                            if (var3_3 != 114) ** GOTO lbl-1000
                            var3_3 = 4;
                            var4_4 = "return";
                            ** GOTO lbl216
                        }
                        case 5: {
                            var3_3 = var0.charAt(2);
                            if (var3_3 == 97) ** GOTO lbl135
                            if (var3_3 == 101) ** GOTO lbl126
                            if (var3_3 == 105) ** GOTO lbl123
                            if (var3_3 == 108) ** GOTO lbl120
                            if (var3_3 == 110) ** GOTO lbl117
                            if (var3_3 == 112) ** GOTO lbl113
                            if (var3_3 == 114) ** GOTO lbl110
                            if (var3_3 != 116) ** GOTO lbl-1000
                            var3_3 = 125;
                            var4_4 = "catch";
                            ** GOTO lbl216
lbl110:
                            // 1 sources

                            var3_3 = 50;
                            var4_4 = "throw";
                            ** GOTO lbl216
lbl113:
                            // 1 sources

                            var4_4 = "super";
lbl114:
                            // 13 sources

                            while (true) {
                                var3_3 = 128;
                                ** GOTO lbl216
                                break;
                            }
lbl117:
                            // 1 sources

                            var3_3 = 155;
                            var4_4 = "const";
                            ** GOTO lbl216
lbl120:
                            // 1 sources

                            var3_3 = 44;
                            var4_4 = "false";
                            ** GOTO lbl216
lbl123:
                            // 1 sources

                            var4_4 = "while";
                            var3_3 = 118;
                            ** GOTO lbl216
lbl126:
                            // 1 sources

                            var3_3 = var0.charAt(0);
                            if (var3_3 != 98) ** GOTO lbl131
                            var4_4 = "break";
                            var3_3 = 121;
                            ** GOTO lbl216
lbl131:
                            // 1 sources

                            if (var3_3 != 121) ** GOTO lbl-1000
                            var3_3 = 73;
                            var4_4 = "yield";
                            ** GOTO lbl216
lbl135:
                            // 1 sources

                            var3_3 = var0.charAt(0);
                            if (var3_3 != 99) ** GOTO lbl139
                            var4_4 = "class";
                            ** GOTO lbl114
lbl139:
                            // 1 sources

                            if (var3_3 == 97) {
                                var4_4 = "await";
                                ** continue;
                            }
                            ** GOTO lbl-1000
                        }
                        case 4: {
                            var2_2 = var0.charAt(0);
                            if (var2_2 == 99) ** GOTO lbl175
                            if (var2_2 == 101) ** GOTO lbl168
                            if (var2_2 == 110) ** GOTO lbl165
                            if (var2_2 == 116) ** GOTO lbl157
                            if (var2_2 == 118) ** GOTO lbl154
                            if (var2_2 != 119) ** GOTO lbl-1000
                            var3_3 = 124;
                            var4_4 = "with";
                            ** GOTO lbl216
lbl154:
                            // 1 sources

                            var3_3 = 127;
                            var4_4 = "void";
                            ** GOTO lbl216
lbl157:
                            // 1 sources

                            var3_3 = var0.charAt(3);
                            if (var3_3 != 101) ** GOTO lbl162
                            if (var0.charAt(2) != 'u' || var0.charAt(1) != 'r') ** GOTO lbl-1000
                            var3_3 = 45;
                            break block24;
lbl162:
                            // 1 sources

                            if (var3_3 != 115 || var0.charAt(2) != 'i' || var0.charAt(1) != 'h') ** GOTO lbl-1000
                            var3_3 = 43;
                            break block24;
lbl165:
                            // 1 sources

                            var3_3 = 42;
                            var4_4 = "null";
                            ** GOTO lbl216
lbl168:
                            // 1 sources

                            var2_2 = var0.charAt(3);
                            if (var2_2 != 101) ** GOTO lbl172
                            if (var0.charAt(2) != 's' || var0.charAt(1) != 'l') ** GOTO lbl-1000
                            break block24;
lbl172:
                            // 1 sources

                            if (var2_2 != 109 || var0.charAt(2) != 'u' || var0.charAt(1) != 'n') ** GOTO lbl-1000
                            var3_3 = 128;
                            break block24;
lbl175:
                            // 1 sources

                            if (var0.charAt(3) != 'e' || var0.charAt(2) != 's' || var0.charAt(1) != 'a') ** GOTO lbl-1000
                            var3_3 = 116;
                            break block24;
                        }
                        case 3: {
                            var3_3 = var0.charAt(0);
                            if (var3_3 == 102) ** GOTO lbl196
                            if (var3_3 == 108) ** GOTO lbl193
                            if (var3_3 == 110) ** GOTO lbl190
                            if (var3_3 == 116) ** GOTO lbl187
                            if (var3_3 != 118 || var0.charAt(2) != 'r' || var0.charAt(1) != 'a') ** GOTO lbl-1000
                            var3_3 = 123;
                            break block24;
lbl187:
                            // 1 sources

                            if (var0.charAt(2) != 'y' || var0.charAt(1) != 'r') ** GOTO lbl-1000
                            var3_3 = 82;
                            break block24;
lbl190:
                            // 1 sources

                            if (var0.charAt(2) != 'w' || var0.charAt(1) != 'e') ** GOTO lbl-1000
                            var3_3 = 30;
                            break block24;
lbl193:
                            // 1 sources

                            if (var0.charAt(2) != 't' || var0.charAt(1) != 'e') ** GOTO lbl-1000
                            var3_3 = 154;
                            break block24;
lbl196:
                            // 1 sources

                            if (var0.charAt(2) != 'r' || var0.charAt(1) != 'o') ** GOTO lbl-1000
                            var3_3 = 120;
                            break block24;
                        }
                        case 2: 
                    }
                    var3_3 = var0.charAt(1);
                    if (var3_3 != 102) break block25;
                    if (var0.charAt(0) != 'i') ** GOTO lbl-1000
                    var3_3 = 113;
                    break block24;
                }
                if (var3_3 != 110) break block26;
                if (var0.charAt(0) != 'i') ** GOTO lbl-1000
                var3_3 = 52;
                break block24;
            }
            if (var3_3 == 111 && var0.charAt(0) == 'd') {
                var3_3 = 119;
            } else lbl-1000:
            // 24 sources

            {
                var4_4 = null;
                var3_3 = 0;
lbl216:
                // 21 sources

                if (var4_4 != null && var4_4 != var0 && !var4_4.equals(var0)) {
                    var3_3 = 0;
                }
            }
        }
        if (var3_3 == 0) {
            return 0;
        }
        return var3_3 & 255;
    }

    /*
     * Unable to fully structure code
     */
    private static int stringToKeywordForJS(String var0) {
        block30: {
            block32: {
                block31: {
                    switch (var0.length()) {
                        default: {
                            ** GOTO lbl-1000
                        }
                        case 12: {
                            var1_1 = "synchronized";
lbl6:
                            // 23 sources

                            while (true) {
                                var2_2 = 128;
                                ** GOTO lbl263
                                break;
                            }
                        }
                        case 10: {
                            var2_2 = var0.charAt(1);
                            if (var2_2 != 109) ** GOTO lbl14
                            var1_1 = "implements";
                            ** GOTO lbl6
lbl14:
                            // 1 sources

                            if (var2_2 != 110) ** GOTO lbl-1000
                            var2_2 = 53;
                            var1_1 = "instanceof";
                            ** GOTO lbl263
                        }
                        case 9: {
                            var2_2 = var0.charAt(0);
                            if (var2_2 != 105) ** GOTO lbl23
                            var1_1 = "interface";
                            ** GOTO lbl6
lbl23:
                            // 1 sources

                            if (var2_2 != 112) ** GOTO lbl26
                            var1_1 = "protected";
                            ** GOTO lbl6
lbl26:
                            // 1 sources

                            if (var2_2 != 116) ** GOTO lbl-1000
                            var1_1 = "transient";
                            ** GOTO lbl6
                        }
                        case 8: {
                            var2_2 = var0.charAt(0);
                            if (var2_2 == 97) ** GOTO lbl47
                            if (var2_2 == 102) ** GOTO lbl44
                            if (var2_2 == 118) ** GOTO lbl42
                            if (var2_2 == 99) ** GOTO lbl39
                            if (var2_2 != 100) ** GOTO lbl-1000
                            var2_2 = 161;
                            var1_1 = "debugger";
                            ** GOTO lbl263
lbl39:
                            // 1 sources

                            var2_2 = 122;
                            var1_1 = "continue";
                            ** GOTO lbl263
lbl42:
                            // 1 sources

                            var1_1 = "volatile";
                            ** GOTO lbl6
lbl44:
                            // 1 sources

                            var1_1 = "function";
                            var2_2 = 110;
                            ** GOTO lbl263
lbl47:
                            // 1 sources

                            var1_1 = "abstract";
                            ** GOTO lbl6
                        }
                        case 7: {
                            var2_2 = var0.charAt(1);
                            if (var2_2 == 97) ** GOTO lbl69
                            if (var2_2 == 101) ** GOTO lbl66
                            if (var2_2 == 105) ** GOTO lbl63
                            if (var2_2 == 111) ** GOTO lbl61
                            if (var2_2 == 114) ** GOTO lbl59
                            if (var2_2 != 120) ** GOTO lbl-1000
                            var1_1 = "extends";
                            ** GOTO lbl6
lbl59:
                            // 1 sources

                            var1_1 = "private";
                            ** GOTO lbl6
lbl61:
                            // 1 sources

                            var1_1 = "boolean";
                            ** GOTO lbl6
lbl63:
                            // 1 sources

                            var2_2 = 126;
                            var1_1 = "finally";
                            ** GOTO lbl263
lbl66:
                            // 1 sources

                            var1_1 = "default";
                            var2_2 = 117;
                            ** GOTO lbl263
lbl69:
                            // 1 sources

                            var1_1 = "package";
                            ** GOTO lbl6
                        }
                        case 6: {
                            var2_2 = var0.charAt(1);
                            if (var2_2 == 97) ** GOTO lbl114
                            if (var2_2 == 101) ** GOTO lbl105
                            if (var2_2 == 104) ** GOTO lbl103
                            if (var2_2 == 109) ** GOTO lbl101
                            if (var2_2 == 111) ** GOTO lbl99
                            if (var2_2 == 116) ** GOTO lbl97
                            if (var2_2 == 117) ** GOTO lbl95
                            switch (var2_2) {
                                default: {
                                    ** GOTO lbl-1000
                                }
                                case 121: {
                                    var2_2 = 32;
                                    var1_1 = "typeof";
                                    break;
                                }
                                case 120: {
                                    var1_1 = "export";
                                    ** GOTO lbl6
                                }
                                case 119: {
                                    var1_1 = "switch";
                                    var2_2 = 115;
                                    break;
                                }
                            }
                            ** GOTO lbl263
lbl95:
                            // 1 sources

                            var1_1 = "public";
                            ** GOTO lbl6
lbl97:
                            // 1 sources

                            var1_1 = "static";
                            ** GOTO lbl6
lbl99:
                            // 1 sources

                            var1_1 = "double";
                            ** GOTO lbl6
lbl101:
                            // 1 sources

                            var1_1 = "import";
                            ** GOTO lbl6
lbl103:
                            // 1 sources

                            var1_1 = "throws";
                            ** GOTO lbl6
lbl105:
                            // 1 sources

                            var2_2 = var0.charAt(0);
                            if (var2_2 != 100) ** GOTO lbl110
                            var2_2 = 31;
                            var1_1 = "delete";
                            ** GOTO lbl263
lbl110:
                            // 1 sources

                            if (var2_2 != 114) ** GOTO lbl-1000
                            var2_2 = 4;
                            var1_1 = "return";
                            ** GOTO lbl263
lbl114:
                            // 1 sources

                            var1_1 = "native";
                            ** GOTO lbl6
                        }
                        case 5: {
                            var2_2 = var0.charAt(2);
                            if (var2_2 == 97) ** GOTO lbl171
                            if (var2_2 == 101) ** GOTO lbl162
                            if (var2_2 == 105) ** GOTO lbl159
                            if (var2_2 == 108) ** GOTO lbl156
                            if (var2_2 == 114) ** GOTO lbl153
                            if (var2_2 == 116) ** GOTO lbl150
                            switch (var2_2) {
                                default: {
                                    ** GOTO lbl-1000
                                }
                                case 112: {
                                    var1_1 = "super";
                                    break;
                                }
                                case 111: {
                                    var2_2 = var0.charAt(0);
                                    if (var2_2 == 102) {
                                        var1_1 = "float";
                                        break;
                                    }
                                    if (var2_2 == 115) {
                                        var1_1 = "short";
                                        break;
                                    }
                                    ** GOTO lbl-1000
                                }
                                case 110: {
                                    var2_2 = var0.charAt(0);
                                    if (var2_2 != 99) ** GOTO lbl145
                                    var2_2 = 155;
                                    var1_1 = "const";
                                    ** GOTO lbl263
lbl145:
                                    // 1 sources

                                    if (var2_2 == 102) {
                                        var1_1 = "final";
                                        break;
                                    }
                                    ** GOTO lbl-1000
                                }
                            }
                            ** GOTO lbl6
lbl150:
                            // 1 sources

                            var2_2 = 125;
                            var1_1 = "catch";
                            ** GOTO lbl263
lbl153:
                            // 1 sources

                            var2_2 = 50;
                            var1_1 = "throw";
                            ** GOTO lbl263
lbl156:
                            // 1 sources

                            var2_2 = 44;
                            var1_1 = "false";
                            ** GOTO lbl263
lbl159:
                            // 1 sources

                            var1_1 = "while";
                            var2_2 = 118;
                            ** GOTO lbl263
lbl162:
                            // 1 sources

                            var2_2 = var0.charAt(0);
                            if (var2_2 != 98) ** GOTO lbl167
                            var1_1 = "break";
                            var2_2 = 121;
                            ** GOTO lbl263
lbl167:
                            // 1 sources

                            if (var2_2 != 121) ** GOTO lbl-1000
                            var2_2 = 73;
                            var1_1 = "yield";
                            ** GOTO lbl263
lbl171:
                            // 1 sources

                            var1_1 = "class";
                            ** GOTO lbl6
                        }
                        case 4: {
                            var2_2 = var0.charAt(0);
                            if (var2_2 == 98) ** GOTO lbl219
                            if (var2_2 == 99) ** GOTO lbl212
                            if (var2_2 == 101) ** GOTO lbl205
                            if (var2_2 == 103) ** GOTO lbl203
                            if (var2_2 == 108) ** GOTO lbl201
                            if (var2_2 == 110) ** GOTO lbl198
                            if (var2_2 == 116) ** GOTO lbl190
                            if (var2_2 == 118) ** GOTO lbl187
                            if (var2_2 != 119) ** GOTO lbl-1000
                            var2_2 = 124;
                            var1_1 = "with";
                            ** GOTO lbl263
lbl187:
                            // 1 sources

                            var2_2 = 127;
                            var1_1 = "void";
                            ** GOTO lbl263
lbl190:
                            // 1 sources

                            var2_2 = var0.charAt(3);
                            if (var2_2 != 101) ** GOTO lbl195
                            if (var0.charAt(2) != 'u' || var0.charAt(1) != 'r') ** GOTO lbl-1000
                            var2_2 = 45;
                            break block30;
lbl195:
                            // 1 sources

                            if (var2_2 != 115 || var0.charAt(2) != 'i' || var0.charAt(1) != 'h') ** GOTO lbl-1000
                            var2_2 = 43;
                            break block30;
lbl198:
                            // 1 sources

                            var2_2 = 42;
                            var1_1 = "null";
                            ** GOTO lbl263
lbl201:
                            // 1 sources

                            var1_1 = "long";
                            ** GOTO lbl6
lbl203:
                            // 1 sources

                            var1_1 = "goto";
                            ** GOTO lbl6
lbl205:
                            // 1 sources

                            var2_2 = var0.charAt(3);
                            if (var2_2 != 101) ** GOTO lbl210
                            if (var0.charAt(2) != 's' || var0.charAt(1) != 'l') ** GOTO lbl-1000
                            var2_2 = 114;
                            break block30;
lbl210:
                            // 1 sources

                            if (var2_2 != 109 || var0.charAt(2) != 'u' || var0.charAt(1) != 'n') ** GOTO lbl-1000
                            ** GOTO lbl241
lbl212:
                            // 1 sources

                            var2_2 = var0.charAt(3);
                            if (var2_2 != 101) ** GOTO lbl217
                            if (var0.charAt(2) != 's' || var0.charAt(1) != 'a') ** GOTO lbl-1000
                            var2_2 = 116;
                            break block30;
lbl217:
                            // 1 sources

                            if (var2_2 != 114 || var0.charAt(2) != 'a' || var0.charAt(1) != 'h') ** GOTO lbl-1000
                            ** GOTO lbl241
lbl219:
                            // 1 sources

                            var1_1 = "byte";
                            ** continue;
                        }
                        case 3: {
                            var2_2 = var0.charAt(0);
                            if (var2_2 == 102) ** GOTO lbl243
                            if (var2_2 == 105) ** GOTO lbl240
                            if (var2_2 == 108) ** GOTO lbl237
                            if (var2_2 == 110) ** GOTO lbl234
                            if (var2_2 == 116) ** GOTO lbl231
                            if (var2_2 != 118 || var0.charAt(2) != 'r' || var0.charAt(1) != 'a') ** GOTO lbl-1000
                            var2_2 = 123;
                            break block30;
lbl231:
                            // 1 sources

                            if (var0.charAt(2) != 'y' || var0.charAt(1) != 'r') ** GOTO lbl-1000
                            var2_2 = 82;
                            break block30;
lbl234:
                            // 1 sources

                            if (var0.charAt(2) != 'w' || var0.charAt(1) != 'e') ** GOTO lbl-1000
                            var2_2 = 30;
                            break block30;
lbl237:
                            // 1 sources

                            if (var0.charAt(2) != 't' || var0.charAt(1) != 'e') ** GOTO lbl-1000
                            var2_2 = 154;
                            break block30;
lbl240:
                            // 1 sources

                            if (var0.charAt(2) != 't' || var0.charAt(1) != 'n') ** GOTO lbl-1000
lbl241:
                            // 3 sources

                            var2_2 = 128;
                            break block30;
lbl243:
                            // 1 sources

                            if (var0.charAt(2) != 'r' || var0.charAt(1) != 'o') ** GOTO lbl-1000
                            var2_2 = 120;
                            break block30;
                        }
                        case 2: 
                    }
                    var2_2 = var0.charAt(1);
                    if (var2_2 != 102) break block31;
                    if (var0.charAt(0) != 'i') ** GOTO lbl-1000
                    var2_2 = 113;
                    break block30;
                }
                if (var2_2 != 110) break block32;
                if (var0.charAt(0) != 'i') ** GOTO lbl-1000
                var2_2 = 52;
                break block30;
            }
            if (var2_2 == 111 && var0.charAt(0) == 'd') {
                var2_2 = 119;
            } else lbl-1000:
            // 27 sources

            {
                var1_1 = null;
                var2_2 = 0;
lbl263:
                // 21 sources

                if (var1_1 != null && var1_1 != var0 && !var1_1.equals(var0)) {
                    var2_2 = 0;
                }
            }
        }
        if (var2_2 == 0) {
            return 0;
        }
        return var2_2 & 255;
    }

    private final String substring(int n, int n2) {
        String string2 = this.sourceString;
        if (string2 != null) {
            return string2.substring(n, n2);
        }
        return new String(this.sourceBuffer, n, n2 - n);
    }

    private void ungetChar(int n) {
        int n2 = this.ungetCursor;
        if (n2 != 0 && this.ungetBuffer[n2 - 1] == 10) {
            Kit.codeBug();
        }
        int[] nArray = this.ungetBuffer;
        n2 = this.ungetCursor;
        this.ungetCursor = n2 + 1;
        nArray[n2] = n;
        --this.cursor;
    }

    private void ungetCharIgnoreLineEnd(int n) {
        int[] nArray = this.ungetBuffer;
        int n2 = this.ungetCursor;
        this.ungetCursor = n2 + 1;
        nArray[n2] = n;
        --this.cursor;
    }

    final boolean eof() {
        return this.hitEOF;
    }

    final String getAndResetCurrentComment() {
        if (this.sourceString != null) {
            if (this.isMarkingComment()) {
                Kit.codeBug();
            }
            return this.sourceString.substring(this.tokenBeg, this.tokenEnd);
        }
        if (!this.isMarkingComment()) {
            Kit.codeBug();
        }
        StringBuilder stringBuilder = new StringBuilder(this.commentPrefix);
        stringBuilder.append(this.sourceBuffer, this.commentCursor, this.getTokenLength() - this.commentPrefix.length());
        this.commentCursor = -1;
        return stringBuilder.toString();
    }

    public Token.CommentType getCommentType() {
        return this.commentType;
    }

    public int getCursor() {
        return this.cursor;
    }

    int getFirstXMLToken() throws IOException {
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        if (!this.canUngetChar()) {
            return -1;
        }
        this.ungetChar(60);
        return this.getNextXMLToken();
    }

    final String getLine() {
        int n = this.sourceCursor;
        int n2 = this.lineEndChar;
        if (n2 >= 0) {
            int n3;
            n = n3 = n - 1;
            if (n2 == 10) {
                n = n3;
                if (this.charAt(n3 - 1) == 13) {
                    n = n3 - 1;
                }
            }
        } else {
            int n4;
            n -= this.lineStart;
            while ((n4 = this.charAt(this.lineStart + n)) != -1 && !ScriptRuntime.isJSLineTerminator(n4)) {
                ++n;
            }
            n += this.lineStart;
        }
        return this.substring(this.lineStart, n);
    }

    final String getLine(int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block8: {
            n6 = this.cursor + this.ungetCursor - n;
            if (n6 > (n = this.sourceCursor)) {
                return null;
            }
            n5 = 0;
            n4 = 0;
            while (n6 > 0) {
                int n7 = this.charAt(n - 1);
                int n8 = n6;
                n3 = n5;
                int n9 = n4;
                n2 = n;
                if (ScriptRuntime.isJSLineTerminator(n7)) {
                    n4 = n6;
                    n3 = n;
                    if (n7 == 10) {
                        n4 = n6;
                        n3 = n;
                        if (this.charAt(n - 2) == 13) {
                            n4 = n6 - 1;
                            n3 = n - 1;
                        }
                    }
                    n = n5 + 1;
                    n9 = n3 - 1;
                    n2 = n3;
                    n3 = n;
                    n8 = n4;
                }
                n6 = n8 - 1;
                n = n2 - 1;
                n5 = n3;
                n4 = n9;
            }
            n6 = 0;
            while (n > 0) {
                if (!ScriptRuntime.isJSLineTerminator(this.charAt(n - 1))) {
                    --n;
                    ++n6;
                    continue;
                }
                break block8;
            }
            n = 0;
        }
        n2 = this.lineno;
        n3 = this.lineEndChar >= 0 ? 1 : 0;
        nArray[0] = n2 - n5 + n3;
        nArray[1] = n6;
        if (n5 == 0) {
            return this.getLine();
        }
        return this.substring(n, n4);
    }

    final int getLineno() {
        return this.lineno;
    }

    /*
     * Enabled aggressive block sorting
     */
    int getNextXMLToken() throws IOException {
        this.tokenBeg = this.cursor;
        this.stringBufferTop = 0;
        while (true) {
            int n;
            block20: {
                block19: {
                    block21: {
                        block22: {
                            block23: {
                                if ((n = this.getChar()) == -1) {
                                    this.tokenEnd = this.cursor;
                                    this.stringBufferTop = 0;
                                    this.string = null;
                                    this.parser.addError("msg.XML.bad.form");
                                    return -1;
                                }
                                if (!this.xmlIsTagContent) break block20;
                                if (n == 9 || n == 10 || n == 13 || n == 32) break block21;
                                if (n == 34 || n == 39) break block22;
                                if (n == 47) break block23;
                                if (n == 123) {
                                    this.ungetChar(n);
                                    this.string = this.getStringFromBuffer();
                                    return 146;
                                }
                                if (n != 61) {
                                    if (n != 62) {
                                        this.addToString(n);
                                        this.xmlIsAttribute = false;
                                        break block19;
                                    } else {
                                        this.addToString(n);
                                        this.xmlIsTagContent = false;
                                        this.xmlIsAttribute = false;
                                    }
                                    break block19;
                                } else {
                                    this.addToString(n);
                                    this.xmlIsAttribute = true;
                                }
                                break block19;
                            }
                            this.addToString(n);
                            if (this.peekChar() == 62) {
                                this.addToString(this.getChar());
                                this.xmlIsTagContent = false;
                                --this.xmlOpenTagsCount;
                            }
                            break block19;
                        }
                        this.addToString(n);
                        if (!this.readQuotedString(n)) {
                            return -1;
                        }
                        break block19;
                    }
                    this.addToString(n);
                }
                if (this.xmlIsTagContent || this.xmlOpenTagsCount != 0) continue;
                this.string = this.getStringFromBuffer();
                return 149;
            }
            if (n != 60) {
                if (n == 123) {
                    this.ungetChar(n);
                    this.string = this.getStringFromBuffer();
                    return 146;
                }
                this.addToString(n);
                continue;
            }
            this.addToString(n);
            n = this.peekChar();
            if (n != 33) {
                if (n != 47) {
                    if (n != 63) {
                        this.xmlIsTagContent = true;
                        ++this.xmlOpenTagsCount;
                        continue;
                    }
                    this.addToString(this.getChar());
                    if (this.readPI()) continue;
                    return -1;
                }
                this.addToString(this.getChar());
                n = this.xmlOpenTagsCount;
                if (n == 0) {
                    this.stringBufferTop = 0;
                    this.string = null;
                    this.parser.addError("msg.XML.bad.form");
                    return -1;
                }
                this.xmlIsTagContent = true;
                this.xmlOpenTagsCount = n - 1;
                continue;
            }
            this.addToString(this.getChar());
            n = this.peekChar();
            if (n != 45) {
                if (n != 91) {
                    if (this.readEntity()) continue;
                    return -1;
                }
                this.addToString(this.getChar());
                if (this.getChar() == 67 && this.getChar() == 68 && this.getChar() == 65 && this.getChar() == 84 && this.getChar() == 65 && this.getChar() == 91) {
                    this.addToString(67);
                    this.addToString(68);
                    this.addToString(65);
                    this.addToString(84);
                    this.addToString(65);
                    this.addToString(91);
                    if (this.readCDATA()) continue;
                    return -1;
                }
                this.stringBufferTop = 0;
                this.string = null;
                this.parser.addError("msg.XML.bad.form");
                return -1;
            }
            this.addToString(this.getChar());
            n = this.getChar();
            if (n != 45) {
                this.stringBufferTop = 0;
                this.string = null;
                this.parser.addError("msg.XML.bad.form");
                return -1;
            }
            this.addToString(n);
            if (!this.readXmlComment()) break;
        }
        return -1;
    }

    final double getNumber() {
        return this.number;
    }

    final int getOffset() {
        int n;
        int n2 = n = this.sourceCursor - this.lineStart;
        if (this.lineEndChar >= 0) {
            n2 = n - 1;
        }
        return n2;
    }

    final char getQuoteChar() {
        return (char)this.quoteChar;
    }

    final String getSourceString() {
        return this.sourceString;
    }

    final String getString() {
        return this.string;
    }

    /*
     * Unable to fully structure code
     */
    final int getToken() throws IOException {
        block130: {
            block162: {
                block161: {
                    block160: {
                        block129: {
                            block128: {
                                block157: {
                                    block158: {
                                        block159: {
                                            block140: {
                                                block141: {
                                                    block142: {
                                                        block143: {
                                                            block144: {
                                                                block145: {
                                                                    block146: {
                                                                        block147: {
                                                                            block135: {
                                                                                block137: {
                                                                                    block136: {
                                                                                        block139: {
                                                                                            block138: {
                                                                                                block133: {
                                                                                                    block134: {
                                                                                                        block131: {
                                                                                                            block132: {
                                                                                                                do {
                                                                                                                    if ((var1_1 = this.getChar()) == -1) {
                                                                                                                        var1_1 = this.cursor;
                                                                                                                        this.tokenBeg = var1_1 - 1;
                                                                                                                        this.tokenEnd = var1_1;
                                                                                                                        return 0;
                                                                                                                    }
                                                                                                                    var2_2 = 1;
                                                                                                                    if (var1_1 != 10) continue;
                                                                                                                    this.dirtyLine = false;
                                                                                                                    var1_1 = this.cursor;
                                                                                                                    this.tokenBeg = var1_1 - 1;
                                                                                                                    this.tokenEnd = var1_1;
                                                                                                                    return 1;
                                                                                                                } while (TokenStream.isJSSpace(var1_1));
                                                                                                                if (var1_1 != 45) {
                                                                                                                    this.dirtyLine = true;
                                                                                                                }
                                                                                                                var3_3 = this.cursor;
                                                                                                                this.tokenBeg = var3_3 - 1;
                                                                                                                this.tokenEnd = var3_3;
                                                                                                                if (var1_1 == 64) {
                                                                                                                    return 148;
                                                                                                                }
                                                                                                                if (var1_1 != 92) break block131;
                                                                                                                var3_3 = this.getChar();
                                                                                                                if (var3_3 != 117) break block132;
                                                                                                                this.stringBufferTop = 0;
                                                                                                                var4_4 = true;
                                                                                                                var1_1 = 1;
                                                                                                                break block133;
                                                                                                            }
                                                                                                            this.ungetChar(var3_3);
                                                                                                            var3_3 = 92;
                                                                                                            var4_4 = false;
                                                                                                            break block134;
                                                                                                        }
                                                                                                        var5_5 = Character.isJavaIdentifierStart((char)var1_1);
                                                                                                        var3_3 = var1_1;
                                                                                                        var4_4 = var5_5;
                                                                                                        if (var5_5) {
                                                                                                            this.stringBufferTop = 0;
                                                                                                            this.addToString(var1_1);
                                                                                                            var4_4 = var5_5;
                                                                                                            var3_3 = var1_1;
                                                                                                        }
                                                                                                    }
                                                                                                    var1_1 = 0;
                                                                                                }
                                                                                                if (!var4_4) break block135;
                                                                                                var3_3 = var1_1;
                                                                                                while (true) {
                                                                                                    if (var1_1 != 0) {
                                                                                                        var6_6 = 0;
                                                                                                        var1_1 = 0;
                                                                                                        while (true) {
                                                                                                            var7_9 = var1_1;
                                                                                                            if (var6_6 == 4) break;
                                                                                                            var1_1 = Kit.xDigitToInt(this.getChar(), var1_1);
                                                                                                            if (var1_1 < 0) {
                                                                                                                var7_9 = var1_1;
                                                                                                                break;
                                                                                                            }
                                                                                                            ++var6_6;
                                                                                                        }
                                                                                                        if (var7_9 < 0) {
                                                                                                            this.parser.addError("msg.invalid.escape");
                                                                                                            return -1;
                                                                                                        }
                                                                                                        this.addToString(var7_9);
                                                                                                        var1_1 = 0;
                                                                                                        continue;
                                                                                                    }
                                                                                                    var6_6 = this.getChar();
                                                                                                    if (var6_6 == 92) {
                                                                                                        var1_1 = this.getChar();
                                                                                                        if (var1_1 == 117) {
                                                                                                            var3_3 = 1;
                                                                                                            var1_1 = 1;
                                                                                                            continue;
                                                                                                        }
                                                                                                        this.parser.addError("msg.illegal.character", var1_1);
                                                                                                        return -1;
                                                                                                    }
                                                                                                    if (var6_6 == -1 || var6_6 == 65279 || !Character.isJavaIdentifierPart((char)var6_6)) break;
                                                                                                    this.addToString(var6_6);
                                                                                                }
                                                                                                this.ungetChar(var6_6);
                                                                                                var8_12 = this.getStringFromBuffer();
                                                                                                if (var3_3 != 0) break block136;
                                                                                                var3_3 = TokenStream.stringToKeyword(var8_12, this.parser.compilerEnv.getLanguageVersion(), this.parser.inUseStrictDirective());
                                                                                                var9_14 = var8_12;
                                                                                                if (var3_3 == 0) break block137;
                                                                                                if (var3_3 == 154) break block138;
                                                                                                var1_1 = var3_3;
                                                                                                if (var3_3 != 73) break block139;
                                                                                            }
                                                                                            var1_1 = var3_3;
                                                                                            if (this.parser.compilerEnv.getLanguageVersion() < 170) {
                                                                                                var9_14 = var3_3 == 154 ? "let" : "yield";
                                                                                                this.string = var9_14;
                                                                                                var1_1 = 39;
                                                                                            }
                                                                                        }
                                                                                        this.string = (String)this.allStrings.intern(var8_12);
                                                                                        if (var1_1 != 128) {
                                                                                            return var1_1;
                                                                                        }
                                                                                        if (this.parser.compilerEnv.getLanguageVersion() >= 200) {
                                                                                            return var1_1;
                                                                                        }
                                                                                        var9_14 = var8_12;
                                                                                        if (!this.parser.compilerEnv.isReservedKeywordAsIdentifier()) {
                                                                                            return var1_1;
                                                                                        }
                                                                                        break block137;
                                                                                    }
                                                                                    var9_14 = var8_12;
                                                                                    if (TokenStream.isKeyword(var8_12, this.parser.compilerEnv.getLanguageVersion(), this.parser.inUseStrictDirective())) {
                                                                                        var9_14 = this.convertLastCharToHex(var8_12);
                                                                                    }
                                                                                }
                                                                                this.string = (String)this.allStrings.intern(var9_14);
                                                                                return 39;
                                                                            }
                                                                            if (TokenStream.isDigit(var3_3) || var3_3 == 46 && TokenStream.isDigit(this.peekChar())) break block140;
                                                                            if (var3_3 == 34 || var3_3 == 39) break block141;
                                                                            if (var3_3 == 33) break block142;
                                                                            if (var3_3 == 91) break block143;
                                                                            if (var3_3 == 37) break block144;
                                                                            if (var3_3 == 38) break block145;
                                                                            if (var3_3 == 93) break block146;
                                                                            if (var3_3 == 94) break block147;
                                                                            switch (var3_3) {
                                                                                default: {
                                                                                    switch (var3_3) {
                                                                                        default: {
                                                                                            switch (var3_3) {
                                                                                                default: {
                                                                                                    this.parser.addError("msg.illegal.character", var3_3);
                                                                                                    return -1;
                                                                                                }
                                                                                                case 126: {
                                                                                                    return 27;
                                                                                                }
                                                                                                case 125: {
                                                                                                    return 87;
                                                                                                }
                                                                                                case 124: {
                                                                                                    if (this.matchChar(124)) {
                                                                                                        return 105;
                                                                                                    }
                                                                                                    if (this.matchChar(61)) {
                                                                                                        return 92;
                                                                                                    }
                                                                                                    return 9;
                                                                                                }
                                                                                                case 123: 
                                                                                            }
                                                                                            return 86;
                                                                                        }
                                                                                        case 63: {
                                                                                            return 103;
                                                                                        }
                                                                                        case 62: {
                                                                                            if (this.matchChar(62)) {
                                                                                                if (this.matchChar(62)) {
                                                                                                    if (this.matchChar(61)) {
                                                                                                        return 97;
                                                                                                    }
                                                                                                    return 20;
                                                                                                }
                                                                                                if (this.matchChar(61)) {
                                                                                                    return 96;
                                                                                                }
                                                                                                return 19;
                                                                                            }
                                                                                            if (this.matchChar(61)) {
                                                                                                return 17;
                                                                                            }
                                                                                            return 16;
                                                                                        }
                                                                                        case 61: {
                                                                                            if (this.matchChar(61)) {
                                                                                                if (this.matchChar(61)) {
                                                                                                    return 46;
                                                                                                }
                                                                                                return 12;
                                                                                            }
                                                                                            if (this.matchChar(62)) {
                                                                                                return 165;
                                                                                            }
                                                                                            return 91;
                                                                                        }
                                                                                        case 60: {
                                                                                            if (this.matchChar(33)) {
                                                                                                if (this.matchChar(45)) {
                                                                                                    if (this.matchChar(45)) {
                                                                                                        this.tokenBeg = this.cursor - 4;
                                                                                                        this.skipLine();
                                                                                                        this.commentType = Token.CommentType.HTML;
                                                                                                        return 162;
                                                                                                    }
                                                                                                    this.ungetCharIgnoreLineEnd(45);
                                                                                                }
                                                                                                this.ungetCharIgnoreLineEnd(33);
                                                                                            }
                                                                                            if (this.matchChar(60)) {
                                                                                                if (this.matchChar(61)) {
                                                                                                    return 95;
                                                                                                }
                                                                                                return 18;
                                                                                            }
                                                                                            if (this.matchChar(61)) {
                                                                                                return 15;
                                                                                            }
                                                                                            return 14;
                                                                                        }
                                                                                        case 59: {
                                                                                            return 83;
                                                                                        }
                                                                                        case 58: 
                                                                                    }
                                                                                    if (this.matchChar(58)) {
                                                                                        return 145;
                                                                                    }
                                                                                    return 104;
                                                                                }
                                                                                case 47: {
                                                                                    this.markCommentStart();
                                                                                    if (this.matchChar(47)) {
                                                                                        this.tokenBeg = this.cursor - 2;
                                                                                        this.skipLine();
                                                                                        this.commentType = Token.CommentType.LINE;
                                                                                        return 162;
                                                                                    }
                                                                                    if (!this.matchChar(42)) ** GOTO lbl214
                                                                                    this.tokenBeg = this.cursor - 2;
                                                                                    if (!this.matchChar(42)) ** GOTO lbl199
                                                                                    this.commentType = Token.CommentType.JSDOC;
                                                                                    while (true) {
                                                                                        var1_1 = 1;
                                                                                        ** GOTO lbl202
                                                                                        break;
                                                                                    }
lbl199:
                                                                                    // 1 sources

                                                                                    this.commentType = Token.CommentType.BLOCK_COMMENT;
                                                                                    while (true) {
                                                                                        var1_1 = 0;
lbl202:
                                                                                        // 2 sources

                                                                                        do {
                                                                                            if ((var3_3 = this.getChar()) == -1) {
                                                                                                this.tokenEnd = this.cursor - 1;
                                                                                                this.parser.addError("msg.unterminated.comment");
                                                                                                return 162;
                                                                                            }
                                                                                            if (var3_3 == 42) ** continue;
                                                                                            if (var3_3 != 47) ** GOTO lbl212
                                                                                        } while (var1_1 == 0);
                                                                                        this.tokenEnd = this.cursor;
                                                                                        return 162;
lbl212:
                                                                                        // 1 sources

                                                                                        this.tokenEnd = this.cursor;
                                                                                    }
lbl214:
                                                                                    // 1 sources

                                                                                    if (this.matchChar(61)) {
                                                                                        return 101;
                                                                                    }
                                                                                    return 24;
                                                                                }
                                                                                case 46: {
                                                                                    if (this.matchChar(46)) {
                                                                                        return 144;
                                                                                    }
                                                                                    if (this.matchChar(40)) {
                                                                                        return 147;
                                                                                    }
                                                                                    return 109;
                                                                                }
                                                                                case 45: {
                                                                                    if (this.matchChar(61)) {
                                                                                        var1_1 = 99;
                                                                                    } else if (this.matchChar(45)) {
                                                                                        if (!this.dirtyLine && this.matchChar(62)) {
                                                                                            this.markCommentStart("--");
                                                                                            this.skipLine();
                                                                                            this.commentType = Token.CommentType.HTML;
                                                                                            return 162;
                                                                                        }
                                                                                        var1_1 = 108;
                                                                                    } else {
                                                                                        var1_1 = 22;
                                                                                    }
                                                                                    this.dirtyLine = true;
                                                                                    return var1_1;
                                                                                }
                                                                                case 44: {
                                                                                    return 90;
                                                                                }
                                                                                case 43: {
                                                                                    if (this.matchChar(61)) {
                                                                                        return 98;
                                                                                    }
                                                                                    if (this.matchChar(43)) {
                                                                                        return 107;
                                                                                    }
                                                                                    return 21;
                                                                                }
                                                                                case 42: {
                                                                                    if (this.matchChar(61)) {
                                                                                        return 100;
                                                                                    }
                                                                                    return 23;
                                                                                }
                                                                                case 41: {
                                                                                    return 89;
                                                                                }
                                                                                case 40: 
                                                                            }
                                                                            return 88;
                                                                        }
                                                                        if (this.matchChar(61)) {
                                                                            return 93;
                                                                        }
                                                                        return 10;
                                                                    }
                                                                    return 85;
                                                                }
                                                                if (this.matchChar(38)) {
                                                                    return 106;
                                                                }
                                                                if (this.matchChar(61)) {
                                                                    return 94;
                                                                }
                                                                return 11;
                                                            }
                                                            if (this.matchChar(61)) {
                                                                return 102;
                                                            }
                                                            return 25;
                                                        }
                                                        return 84;
                                                    }
                                                    if (this.matchChar(61)) {
                                                        if (this.matchChar(61)) {
                                                            return 47;
                                                        }
                                                        return 13;
                                                    }
                                                    return 26;
                                                }
                                                this.quoteChar = var3_3;
                                                this.stringBufferTop = 0;
                                                var1_1 = this.getChar(false);
                                                block37: while (var1_1 != this.quoteChar) {
                                                    block148: {
                                                        block156: {
                                                            block149: {
                                                                block150: {
                                                                    block151: {
                                                                        block152: {
                                                                            block153: {
                                                                                block154: {
                                                                                    block155: {
                                                                                        if (var1_1 == 10 || var1_1 == -1) break block148;
                                                                                        var3_3 = var1_1;
                                                                                        if (var1_1 != 92) break block149;
                                                                                        var1_1 = this.getChar();
                                                                                        if (var1_1 == 10) break block150;
                                                                                        if (var1_1 == 98) break block151;
                                                                                        if (var1_1 == 102) break block152;
                                                                                        if (var1_1 == 110) break block153;
                                                                                        if (var1_1 == 114) break block154;
                                                                                        if (var1_1 == 120) break block155;
                                                                                        switch (var1_1) {
                                                                                            default: {
                                                                                                var3_3 = var1_1;
                                                                                                if (48 > var1_1) break block149;
                                                                                                var3_3 = var1_1;
                                                                                                if (var1_1 >= 56) break block149;
                                                                                                var7_10 = var1_1 - 48;
                                                                                                var6_7 = this.getChar();
                                                                                                var3_3 = var7_10;
                                                                                                var1_1 = var6_7;
                                                                                                if (48 <= var6_7) {
                                                                                                    var3_3 = var7_10;
                                                                                                    var1_1 = var6_7;
                                                                                                    if (var6_7 < 56) {
                                                                                                        var7_10 = var7_10 * 8 + var6_7 - 48;
                                                                                                        var6_7 = this.getChar();
                                                                                                        var3_3 = var7_10;
                                                                                                        var1_1 = var6_7;
                                                                                                        if (48 <= var6_7) {
                                                                                                            var3_3 = var7_10;
                                                                                                            var1_1 = var6_7;
                                                                                                            if (var6_7 < 56) {
                                                                                                                var3_3 = var7_10;
                                                                                                                var1_1 = var6_7;
                                                                                                                if (var7_10 <= 31) {
                                                                                                                    var3_3 = var7_10 * 8 + var6_7 - 48;
                                                                                                                    var1_1 = this.getChar();
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                                this.ungetChar(var1_1);
                                                                                                break block149;
                                                                                            }
                                                                                            case 118: {
                                                                                                var3_3 = 11;
                                                                                                break block149;
                                                                                            }
                                                                                            case 117: {
                                                                                                var7_10 = this.stringBufferTop;
                                                                                                this.addToString(117);
                                                                                                var1_1 = 0;
                                                                                                for (var3_3 = 0; var3_3 != 4; ++var3_3) {
                                                                                                    var6_7 = this.getChar();
                                                                                                    var1_1 = Kit.xDigitToInt(var6_7, var1_1);
                                                                                                    if (var1_1 < 0) {
                                                                                                        var1_1 = var6_7;
                                                                                                        continue block37;
                                                                                                    }
                                                                                                    this.addToString(var6_7);
                                                                                                }
                                                                                                this.stringBufferTop = var7_10;
                                                                                                break;
                                                                                            }
                                                                                            case 116: {
                                                                                                var1_1 = 9;
                                                                                                break;
                                                                                            }
                                                                                        }
                                                                                        break block156;
                                                                                    }
                                                                                    var3_3 = this.getChar();
                                                                                    var1_1 = Kit.xDigitToInt(var3_3, 0);
                                                                                    if (var1_1 < 0) {
                                                                                        this.addToString(120);
                                                                                        var1_1 = var3_3;
                                                                                        continue;
                                                                                    }
                                                                                    var6_7 = this.getChar();
                                                                                    var1_1 = var7_10 = Kit.xDigitToInt(var6_7, var1_1);
                                                                                    if (var7_10 < 0) {
                                                                                        this.addToString(120);
                                                                                        this.addToString(var3_3);
                                                                                        var1_1 = var6_7;
                                                                                        continue;
                                                                                    }
                                                                                    break block156;
                                                                                }
                                                                                var1_1 = 13;
                                                                                break block156;
                                                                            }
                                                                            var1_1 = 10;
                                                                            break block156;
                                                                        }
                                                                        var1_1 = 12;
                                                                        break block156;
                                                                    }
                                                                    var1_1 = 8;
                                                                    break block156;
                                                                }
                                                                var1_1 = this.getChar();
                                                                continue;
                                                            }
                                                            var1_1 = var3_3;
                                                        }
                                                        this.addToString(var1_1);
                                                        var1_1 = this.getChar(false);
                                                        continue;
                                                    }
                                                    this.ungetChar(var1_1);
                                                    this.tokenEnd = this.cursor;
                                                    this.parser.addError("msg.unterminated.string.lit");
                                                    return -1;
                                                }
                                                var9_15 = this.getStringFromBuffer();
                                                this.string = (String)this.allStrings.intern(var9_15);
                                                return 41;
                                            }
                                            this.stringBufferTop = 0;
                                            this.isBinary = false;
                                            this.isOctal = false;
                                            this.isOldOctal = false;
                                            this.isHex = false;
                                            var1_1 = this.parser.compilerEnv.getLanguageVersion() >= 200 ? 1 : 0;
                                            var6_8 = var3_3;
                                            if (var3_3 != 48) break block157;
                                            var3_3 = this.getChar();
                                            if (var3_3 == 120 || var3_3 == 88) break block158;
                                            if (var1_1 != 0 && (var3_3 == 111 || var3_3 == 79)) {
                                                this.isOctal = true;
                                                var3_3 = this.getChar();
lbl401:
                                                // 2 sources

                                                while (true) {
                                                    var1_1 = 8;
                                                    break block128;
                                                    break;
                                                }
                                            }
                                            if (var1_1 == 0 || var3_3 != 98 && var3_3 != 66) break block159;
                                            this.isBinary = true;
                                            var3_3 = this.getChar();
                                            var1_1 = 2;
                                            break block128;
                                        }
                                        if (TokenStream.isDigit(var3_3)) {
                                            this.isOldOctal = true;
                                            ** continue;
                                        }
                                        this.addToString(48);
                                        var6_8 = var3_3;
                                        break block157;
                                    }
                                    this.isHex = true;
                                    var3_3 = this.getChar();
                                    var1_1 = 16;
                                    break block128;
                                }
                                var1_1 = 10;
                                var3_3 = var6_8;
                            }
                            if (var1_1 == 16) {
                                var7_11 = true;
                                var6_8 = var3_3;
                                while (true) {
                                    var3_3 = var6_8;
                                    var10_18 = var1_1;
                                    var11_19 = var7_11;
                                    if (Kit.xDigitToInt(var6_8, 0) >= 0) {
                                        this.addToString(var6_8);
                                        var6_8 = this.getChar();
                                        var7_11 = false;
                                        continue;
                                    }
                                    break block129;
                                    break;
                                }
                            }
                            var7_11 = true;
                            var6_8 = var1_1;
                            var1_1 = var3_3;
                            while (true) {
                                var3_3 = var1_1;
                                var10_18 = var6_8;
                                var11_19 = var7_11;
                                if (48 > var1_1) break;
                                var3_3 = var1_1;
                                var10_18 = var6_8;
                                var11_19 = var7_11;
                                if (var1_1 > 57) break;
                                if (var6_8 != 8 || var1_1 < 56) ** GOTO lbl459
                                if (this.isOldOctal) {
                                    var8_13 = this.parser;
                                    var9_16 = var1_1 == 56 ? "8" : "9";
                                    var8_13.addWarning("msg.bad.octal.literal", var9_16);
                                    var3_3 = 10;
                                } else {
                                    this.parser.addError("msg.caught.nfe");
                                    return -1;
lbl459:
                                    // 1 sources

                                    var3_3 = var6_8;
                                    if (var6_8 == 2) {
                                        var3_3 = var6_8;
                                        if (var1_1 >= 50) {
                                            this.parser.addError("msg.caught.nfe");
                                            return -1;
                                        }
                                    }
                                }
                                this.addToString(var1_1);
                                var1_1 = this.getChar();
                                var7_11 = false;
                                var6_8 = var3_3;
                            }
                        }
                        if (var11_19 && (this.isBinary || this.isOctal || this.isHex)) {
                            this.parser.addError("msg.caught.nfe");
                            return -1;
                        }
                        var1_1 = var3_3;
                        var6_8 = var2_2;
                        if (var10_18 != 10) break block130;
                        if (var3_3 == 46 || var3_3 == 101) break block160;
                        var1_1 = var3_3;
                        var6_8 = var2_2;
                        if (var3_3 != 69) break block130;
                    }
                    var6_8 = var3_3;
                    if (var3_3 == 46) {
                        do {
                            this.addToString(var3_3);
                            var3_3 = var6_8 = this.getChar();
                        } while (TokenStream.isDigit(var6_8));
                    }
                    if (var6_8 != 101) {
                        var1_1 = var6_8;
                        if (var6_8 != 69) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                var6_8 = 0;
                                break block130;
                                break;
                            }
                        }
                    }
                    this.addToString(var6_8);
                    var3_3 = this.getChar();
                    if (var3_3 == 43) break block161;
                    var1_1 = var3_3;
                    if (var3_3 != 45) break block162;
                }
                this.addToString(var3_3);
                var1_1 = this.getChar();
            }
            var3_3 = var1_1;
            if (!TokenStream.isDigit(var1_1)) {
                this.parser.addError("msg.missing.exponent");
                return -1;
            }
            do {
                this.addToString(var3_3);
                var3_3 = var1_1 = this.getChar();
            } while (TokenStream.isDigit(var1_1));
            ** while (true)
        }
        this.ungetChar(var1_1);
        this.string = var9_16 = this.getStringFromBuffer();
        if (var10_18 == 10 && var6_8 == 0) {
            try {
                var12_20 = Double.parseDouble(var9_16);
            }
            catch (NumberFormatException var9_17) {
                this.parser.addError("msg.caught.nfe");
                return -1;
            }
        } else {
            var12_20 = ScriptRuntime.stringPrefixToNumber(var9_16, 0, var10_18);
        }
        this.number = var12_20;
        return 40;
    }

    public int getTokenBeg() {
        return this.tokenBeg;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public int getTokenLength() {
        return this.tokenEnd - this.tokenBeg;
    }

    final boolean isNumberBinary() {
        return this.isBinary;
    }

    final boolean isNumberHex() {
        return this.isHex;
    }

    final boolean isNumberOctal() {
        return this.isOctal;
    }

    final boolean isNumberOldOctal() {
        return this.isOldOctal;
    }

    boolean isXMLAttribute() {
        return this.xmlIsAttribute;
    }

    String readAndClearRegExpFlags() {
        String string2 = this.regExpFlags;
        this.regExpFlags = null;
        return string2;
    }

    void readRegExp(int n) throws IOException {
        int n2;
        int n3 = this.tokenBeg;
        this.stringBufferTop = 0;
        if (n == 101) {
            this.addToString(61);
        } else if (n != 24) {
            Kit.codeBug();
        }
        n = 0;
        while (true) {
            int n4;
            if ((n2 = this.getChar()) == 47 && n == 0) {
                n = this.stringBufferTop;
                while (true) {
                    if (this.matchChar(103)) {
                        this.addToString(103);
                        continue;
                    }
                    if (this.matchChar(105)) {
                        this.addToString(105);
                        continue;
                    }
                    if (this.matchChar(109)) {
                        this.addToString(109);
                        continue;
                    }
                    if (!this.matchChar(121)) break;
                    this.addToString(121);
                }
                this.tokenEnd = n3 + this.stringBufferTop + 2;
                if (TokenStream.isAlpha(this.peekChar())) {
                    this.parser.reportError("msg.invalid.re.flag");
                }
                this.string = new String(this.stringBuffer, 0, n);
                this.regExpFlags = new String(this.stringBuffer, n, this.stringBufferTop - n);
                return;
            }
            if (n2 == 10 || n2 == -1) break;
            if (n2 == 92) {
                this.addToString(n2);
                n4 = this.getChar();
            } else if (n2 == 91) {
                n = 1;
                n4 = n2;
            } else {
                n4 = n2;
                if (n2 == 93) {
                    n = 0;
                    n4 = n2;
                }
            }
            this.addToString(n4);
        }
        this.ungetChar(n2);
        this.tokenEnd = this.cursor - 1;
        this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
        this.parser.reportError("msg.unterminated.re.lit");
    }

    String tokenToString(int n) {
        return "";
    }
}

