/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.mozilla.javascript.Kit;

public class UintMap
implements Serializable {
    private static final int A = -1640531527;
    private static final int DELETED = -2;
    private static final int EMPTY = -1;
    private static final boolean check = false;
    static final long serialVersionUID = 4242698212885848444L;
    private transient int ivaluesShift;
    private int keyCount;
    private transient int[] keys;
    private transient int occupiedCount;
    private int power;
    private transient Object[] values;

    public UintMap() {
        this(4);
    }

    public UintMap(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n2 = n * 4 / 3;
        n = 2;
        while (1 << n < n2) {
            ++n;
        }
        this.power = n;
    }

    private int ensureIndex(int n, boolean bl) {
        block13: {
            int n2;
            block12: {
                int n3;
                int n4;
                int[] nArray = this.keys;
                n2 = -1;
                if (nArray != null) {
                    int n5 = -1640531527 * n;
                    int n6 = this.power;
                    n4 = n5 >>> 32 - n6;
                    int n7 = nArray[n4];
                    if (n7 == n) {
                        return n4;
                    }
                    n3 = n4;
                    if (n7 != -1) {
                        int n8;
                        n3 = n7 == -2 ? n4 : -1;
                        n7 = (1 << n6) - 1;
                        n6 = UintMap.tableLookupStep(n5, n7, n6);
                        n2 = n3;
                        n5 = n4;
                        do {
                            if ((n8 = nArray[n3 = n5 + n6 & n7]) == n) {
                                return n3;
                            }
                            n4 = n2;
                            if (n8 == -2) {
                                n4 = n2;
                                if (n2 < 0) {
                                    n4 = n3;
                                }
                            }
                            n5 = n3;
                            n2 = n4;
                        } while (n8 != -1);
                        n2 = n4;
                    }
                } else {
                    n3 = -1;
                }
                if (n2 >= 0) break block12;
                if (nArray == null || (n4 = this.occupiedCount) * 4 >= (1 << this.power) * 3) break block13;
                this.occupiedCount = n4 + 1;
                n2 = n3;
            }
            nArray[n2] = n;
            ++this.keyCount;
            return n2;
        }
        this.rehashTable(bl);
        return this.insertNewKey(n);
    }

    private int findIndex(int n) {
        int[] nArray = this.keys;
        if (nArray != null) {
            int n2 = -1640531527 * n;
            int n3 = this.power;
            int n4 = n2 >>> 32 - n3;
            int n5 = nArray[n4];
            if (n5 == n) {
                return n4;
            }
            if (n5 != -1) {
                n5 = (1 << n3) - 1;
                n2 = UintMap.tableLookupStep(n2, n5, n3);
                do {
                    if ((n3 = nArray[n4 = n4 + n2 & n5]) != n) continue;
                    return n4;
                } while (n3 != -1);
            }
        }
        return -1;
    }

    private int insertNewKey(int n) {
        int n2;
        int[] nArray = this.keys;
        int n3 = -1640531527 * n;
        int n4 = this.power;
        int n5 = n2 = n3 >>> 32 - n4;
        if (nArray[n2] != -1) {
            int n6 = (1 << n4) - 1;
            n4 = UintMap.tableLookupStep(n3, n6, n4);
            do {
                n2 = n5 = n2 + n4 & n6;
            } while (nArray[n5] != -1);
        }
        nArray[n5] = n;
        ++this.occupiedCount;
        ++this.keyCount;
        return n5;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.keyCount;
        if (n != 0) {
            int n2;
            int n3 = 0;
            this.keyCount = 0;
            boolean bl = objectInputStream.readBoolean();
            boolean bl2 = objectInputStream.readBoolean();
            int n4 = 1 << this.power;
            if (bl) {
                this.keys = new int[n4 * 2];
                this.ivaluesShift = n4;
            } else {
                this.keys = new int[n4];
            }
            for (n2 = 0; n2 != n4; ++n2) {
                this.keys[n2] = -1;
            }
            n2 = n3;
            if (bl2) {
                this.values = new Object[n4];
                n2 = n3;
            }
            while (n2 != n) {
                n4 = this.insertNewKey(objectInputStream.readInt());
                if (bl) {
                    this.keys[this.ivaluesShift + n4] = n3 = objectInputStream.readInt();
                }
                if (bl2) {
                    this.values[n4] = objectInputStream.readObject();
                }
                ++n2;
            }
        }
    }

    private void rehashTable(boolean bl) {
        int n;
        int[] nArray = this.keys;
        if (nArray != null && this.keyCount * 2 >= this.occupiedCount) {
            ++this.power;
        }
        int n2 = 1 << this.power;
        int n3 = this.ivaluesShift;
        if (n3 == 0 && !bl) {
            this.keys = new int[n2];
        } else {
            this.ivaluesShift = n2;
            this.keys = new int[n2 * 2];
        }
        int n4 = 0;
        for (n = 0; n != n2; ++n) {
            this.keys[n] = -1;
        }
        Object[] objectArray = this.values;
        if (objectArray != null) {
            this.values = new Object[n2];
        }
        n2 = this.keyCount;
        this.occupiedCount = 0;
        if (n2 != 0) {
            this.keyCount = 0;
            n = n4;
            n4 = n2;
            while (n4 != 0) {
                int n5 = nArray[n];
                n2 = n4;
                if (n5 != -1) {
                    n2 = n4;
                    if (n5 != -2) {
                        n2 = this.insertNewKey(n5);
                        if (objectArray != null) {
                            this.values[n2] = objectArray[n];
                        }
                        if (n3 != 0) {
                            this.keys[this.ivaluesShift + n2] = nArray[n3 + n];
                        }
                        n2 = n4 - 1;
                    }
                }
                ++n;
                n4 = n2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int tableLookupStep(int n, int n2, int n3) {
        if ((n3 = 32 - n3 * 2) >= 0) {
            n >>>= n3;
            return n & n2 | 1;
        }
        n2 >>>= -n3;
        return n & n2 | 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.keyCount;
        if (n != 0) {
            int n2 = this.ivaluesShift;
            boolean bl = true;
            int n3 = 0;
            boolean bl2 = n2 != 0;
            if (this.values == null) {
                bl = false;
            }
            objectOutputStream.writeBoolean(bl2);
            objectOutputStream.writeBoolean(bl);
            while (n != 0) {
                int n4 = this.keys[n3];
                n2 = n;
                if (n4 != -1) {
                    n2 = n--;
                    if (n4 != -2) {
                        objectOutputStream.writeInt(n4);
                        if (bl2) {
                            objectOutputStream.writeInt(this.keys[this.ivaluesShift + n3]);
                        }
                        n2 = n;
                        if (bl) {
                            objectOutputStream.writeObject(this.values[n3]);
                            n2 = n;
                        }
                    }
                }
                ++n3;
                n = n2;
            }
        }
    }

    public void clear() {
        int n = 1 << this.power;
        if (this.keys != null) {
            int n2;
            for (n2 = 0; n2 != n; ++n2) {
                this.keys[n2] = -1;
            }
            if (this.values != null) {
                for (n2 = 0; n2 != n; ++n2) {
                    this.values[n2] = null;
                }
            }
        }
        this.ivaluesShift = 0;
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public int getExistingInt(int n) {
        int n2;
        if (n < 0) {
            Kit.codeBug();
        }
        if ((n2 = this.findIndex(n)) >= 0) {
            n = this.ivaluesShift;
            if (n != 0) {
                return this.keys[n + n2];
            }
            return 0;
        }
        Kit.codeBug();
        return 0;
    }

    public int getInt(int n, int n2) {
        if (n < 0) {
            Kit.codeBug();
        }
        if ((n = this.findIndex(n)) >= 0) {
            n2 = this.ivaluesShift;
            if (n2 != 0) {
                return this.keys[n2 + n];
            }
            return 0;
        }
        return n2;
    }

    public int[] getKeys() {
        int[] nArray = this.keys;
        int n = this.keyCount;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n != 0) {
            int n3 = nArray[n2];
            int n4 = n;
            if (n3 != -1) {
                n4 = n;
                if (n3 != -2) {
                    n4 = n - 1;
                    nArray2[n4] = n3;
                }
            }
            ++n2;
            n = n4;
        }
        return nArray2;
    }

    public Object getObject(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (this.values != null && (n = this.findIndex(n)) >= 0) {
            return this.values[n];
        }
        return null;
    }

    public boolean has(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        boolean bl = this.findIndex(n) >= 0;
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = this.keyCount == 0;
        return bl;
    }

    public void put(int n, int n2) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n3 = this.ensureIndex(n, true);
        if (this.ivaluesShift == 0) {
            int[] nArray = this.keys;
            n = nArray.length;
            int n4 = 1 << this.power;
            int n5 = n4 * 2;
            if (n != n5) {
                int[] nArray2 = new int[n5];
                System.arraycopy(nArray, 0, nArray2, 0, n4);
                this.keys = nArray2;
            }
            this.ivaluesShift = n4;
        }
        this.keys[this.ivaluesShift + n3] = n2;
    }

    public void put(int n, Object object) {
        if (n < 0) {
            Kit.codeBug();
        }
        n = this.ensureIndex(n, false);
        if (this.values == null) {
            this.values = new Object[1 << this.power];
        }
        this.values[n] = object;
    }

    public void remove(int n) {
        int n2;
        if (n < 0) {
            Kit.codeBug();
        }
        if ((n2 = this.findIndex(n)) >= 0) {
            int[] nArray = this.keys;
            nArray[n2] = -2;
            --this.keyCount;
            Object[] objectArray = this.values;
            if (objectArray != null) {
                objectArray[n2] = null;
            }
            if ((n = this.ivaluesShift) != 0) {
                nArray[n + n2] = 0;
            }
        }
    }

    public int size() {
        return this.keyCount;
    }
}

