/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Scriptable;

public class Undefined
implements Serializable {
    public static final Scriptable SCRIPTABLE_UNDEFINED;
    public static final Object instance;
    static final long serialVersionUID = 9195680630202616767L;

    static {
        instance = new Undefined();
        ClassLoader classLoader = Undefined.class.getClassLoader();
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (method.getName().equals("toString")) {
                    return "undefined";
                }
                if (method.getName().equals("equals")) {
                    boolean bl;
                    int n = objectArray.length;
                    boolean bl2 = bl = false;
                    if (n > 0) {
                        bl2 = bl;
                        if (Undefined.isUndefined(objectArray[0])) {
                            bl2 = true;
                        }
                    }
                    return bl2;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("undefined doesn't support ");
                ((StringBuilder)object).append(method.getName());
                throw new UnsupportedOperationException(((StringBuilder)object).toString());
            }
        };
        SCRIPTABLE_UNDEFINED = (Scriptable)Proxy.newProxyInstance(classLoader, new Class[]{Scriptable.class}, invocationHandler);
    }

    private Undefined() {
    }

    public static boolean isUndefined(Object object) {
        boolean bl = instance == object || SCRIPTABLE_UNDEFINED == object;
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = Undefined.isUndefined(object) || super.equals(object);
        return bl;
    }

    public int hashCode() {
        return 0;
    }

    public Object readResolve() {
        return instance;
    }
}

