/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Kit;

public final class UniqueTag
implements Serializable {
    public static final UniqueTag DOUBLE_MARK;
    private static final int ID_DOUBLE_MARK = 3;
    private static final int ID_NOT_FOUND = 1;
    private static final int ID_NULL_VALUE = 2;
    public static final UniqueTag NOT_FOUND;
    public static final UniqueTag NULL_VALUE;
    static final long serialVersionUID = -4320556826714577259L;
    private final int tagId;

    static {
        NOT_FOUND = new UniqueTag(1);
        NULL_VALUE = new UniqueTag(2);
        DOUBLE_MARK = new UniqueTag(3);
    }

    private UniqueTag(int n) {
        this.tagId = n;
    }

    public Object readResolve() {
        int n = this.tagId;
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    return DOUBLE_MARK;
                }
                throw new IllegalStateException(String.valueOf(this.tagId));
            }
            return NULL_VALUE;
        }
        return NOT_FOUND;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        int n = this.tagId;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw Kit.codeBug();
                string2 = "DOUBLE_MARK";
            } else {
                string2 = "NULL_VALUE";
            }
        } else {
            string2 = "NOT_FOUND";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

