/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.DestructuringForm;
import org.mozilla.javascript.ast.NodeVisitor;

public class ArrayLiteral
extends AstNode
implements DestructuringForm {
    private static final List<AstNode> NO_ELEMS = Collections.unmodifiableList(new ArrayList());
    private int destructuringLength;
    private List<AstNode> elements;
    private boolean isDestructuring;
    private int skipCount;

    public ArrayLiteral() {
        this.type = 66;
    }

    public ArrayLiteral(int n) {
        super(n);
        this.type = 66;
    }

    public ArrayLiteral(int n, int n2) {
        super(n, n2);
        this.type = 66;
    }

    public void addElement(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.elements == null) {
            this.elements = new ArrayList<AstNode>();
        }
        this.elements.add(astNode);
        astNode.setParent(this);
    }

    public int getDestructuringLength() {
        return this.destructuringLength;
    }

    public AstNode getElement(int n) {
        List<AstNode> list = this.elements;
        if (list != null) {
            return list.get(n);
        }
        throw new IndexOutOfBoundsException("no elements");
    }

    public List<AstNode> getElements() {
        List<AstNode> list = this.elements;
        if (list == null) {
            list = NO_ELEMS;
        }
        return list;
    }

    public int getSize() {
        List<AstNode> list = this.elements;
        int n = list == null ? 0 : list.size();
        return n;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    @Override
    public boolean isDestructuring() {
        return this.isDestructuring;
    }

    public void setDestructuringLength(int n) {
        this.destructuringLength = n;
    }

    public void setElements(List<AstNode> object) {
        if (object == null) {
            this.elements = null;
        } else {
            List<AstNode> list = this.elements;
            if (list != null) {
                list.clear();
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.addElement((AstNode)object.next());
            }
        }
    }

    @Override
    public void setIsDestructuring(boolean bl) {
        this.isDestructuring = bl;
    }

    public void setSkipCount(int n) {
        this.skipCount = n;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("[");
        List<AstNode> list = this.elements;
        if (list != null) {
            this.printList(list, stringBuilder);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            Iterator<AstNode> iterator2 = this.getElements().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().visit(nodeVisitor);
            }
        }
    }
}

