/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;

public abstract class AstNode
extends Node
implements Comparable<AstNode> {
    private static Map<Integer, String> operatorNames;
    protected int length = 1;
    protected AstNode parent;
    protected int position = -1;

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        operatorNames = hashMap;
        hashMap.put(52, "in");
        operatorNames.put(32, "typeof");
        operatorNames.put(53, "instanceof");
        operatorNames.put(31, "delete");
        operatorNames.put(90, ",");
        operatorNames.put(104, ":");
        operatorNames.put(105, "||");
        operatorNames.put(106, "&&");
        operatorNames.put(107, "++");
        operatorNames.put(108, "--");
        operatorNames.put(9, "|");
        operatorNames.put(10, "^");
        operatorNames.put(11, "&");
        operatorNames.put(12, "==");
        operatorNames.put(13, "!=");
        operatorNames.put(14, "<");
        operatorNames.put(16, ">");
        operatorNames.put(15, "<=");
        operatorNames.put(17, ">=");
        operatorNames.put(18, "<<");
        operatorNames.put(19, ">>");
        operatorNames.put(20, ">>>");
        operatorNames.put(21, "+");
        operatorNames.put(22, "-");
        operatorNames.put(23, "*");
        operatorNames.put(24, "/");
        operatorNames.put(25, "%");
        operatorNames.put(26, "!");
        operatorNames.put(27, "~");
        operatorNames.put(28, "+");
        operatorNames.put(29, "-");
        operatorNames.put(46, "===");
        operatorNames.put(47, "!==");
        operatorNames.put(91, "=");
        operatorNames.put(92, "|=");
        operatorNames.put(94, "&=");
        operatorNames.put(95, "<<=");
        operatorNames.put(96, ">>=");
        operatorNames.put(97, ">>>=");
        operatorNames.put(98, "+=");
        operatorNames.put(99, "-=");
        operatorNames.put(100, "*=");
        operatorNames.put(101, "/=");
        operatorNames.put(102, "%=");
        operatorNames.put(93, "^=");
        operatorNames.put(127, "void");
    }

    public AstNode() {
        super(-1);
    }

    public AstNode(int n) {
        this();
        this.position = n;
    }

    public AstNode(int n, int n2) {
        this();
        this.position = n;
        this.length = n2;
    }

    public static RuntimeException codeBug() throws RuntimeException {
        throw Kit.codeBug();
    }

    public static String operatorToString(int n) {
        CharSequence charSequence = operatorNames.get(n);
        if (charSequence != null) {
            return charSequence;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("Invalid operator: ");
        ((StringBuilder)charSequence).append(n);
        throw new IllegalArgumentException(((StringBuilder)charSequence).toString());
    }

    public void addChild(AstNode astNode) {
        this.assertNotNull(astNode);
        this.setLength(astNode.getPosition() + astNode.getLength() - this.getPosition());
        this.addChildToBack(astNode);
        astNode.setParent(this);
    }

    protected void assertNotNull(Object object) {
        if (object != null) {
            return;
        }
        throw new IllegalArgumentException("arg cannot be null");
    }

    @Override
    public int compareTo(AstNode astNode) {
        int n;
        if (this.equals(astNode)) {
            return 0;
        }
        int n2 = this.getAbsolutePosition();
        if (n2 < (n = astNode.getAbsolutePosition())) {
            return -1;
        }
        if (n < n2) {
            return 1;
        }
        n2 = this.getLength();
        if (n2 < (n = astNode.getLength())) {
            return -1;
        }
        if (n < n2) {
            return 1;
        }
        return this.hashCode() - astNode.hashCode();
    }

    public String debugPrint() {
        DebugPrintVisitor debugPrintVisitor = new DebugPrintVisitor(new StringBuilder(1000));
        this.visit(debugPrintVisitor);
        return debugPrintVisitor.toString();
    }

    public int depth() {
        AstNode astNode = this.parent;
        int n = astNode == null ? 0 : astNode.depth() + 1;
        return n;
    }

    public int getAbsolutePosition() {
        int n = this.position;
        for (AstNode astNode = this.parent; astNode != null; astNode = astNode.getParent()) {
            n += astNode.getPosition();
        }
        return n;
    }

    public AstRoot getAstRoot() {
        AstNode astNode;
        for (astNode = this; astNode != null && !(astNode instanceof AstRoot); astNode = astNode.getParent()) {
        }
        return (AstRoot)astNode;
    }

    public FunctionNode getEnclosingFunction() {
        AstNode astNode;
        for (astNode = this.getParent(); astNode != null && !(astNode instanceof FunctionNode); astNode = astNode.getParent()) {
        }
        return (FunctionNode)astNode;
    }

    public Scope getEnclosingScope() {
        AstNode astNode;
        for (astNode = this.getParent(); astNode != null && !(astNode instanceof Scope); astNode = astNode.getParent()) {
        }
        return (Scope)astNode;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int getLineno() {
        if (this.lineno != -1) {
            return this.lineno;
        }
        AstNode astNode = this.parent;
        if (astNode != null) {
            return astNode.getLineno();
        }
        return -1;
    }

    public AstNode getParent() {
        return this.parent;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasSideEffects() {
        int n = this.getType();
        if (n != 30 && n != 31 && n != 37 && n != 38 && n != 50 && n != 51 && n != 56 && n != 57 && n != 82 && n != 83 && n != 107 && n != 108) {
            switch (n) {
                default: {
                    switch (n) {
                        default: {
                            switch (n) {
                                default: {
                                    switch (n) {
                                        default: {
                                            return false;
                                        }
                                        case 110: 
                                        case 111: 
                                        case 112: 
                                        case 113: 
                                        case 114: 
                                        case 115: 
                                    }
                                }
                                case 69: 
                                case 70: 
                                case 71: 
                            }
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                    }
                }
                case -1: 
                case 35: 
                case 65: 
                case 73: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 135: 
                case 136: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 154: 
                case 155: 
                case 159: 
                case 160: 
            }
        }
        return true;
    }

    public String makeIndent(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }

    protected <T extends AstNode> void printList(List<T> iterable, StringBuilder stringBuilder) {
        int n = iterable.size();
        Iterator<T> iterator2 = iterable.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            iterable = (AstNode)iterator2.next();
            stringBuilder.append(((AstNode)iterable).toSource(0));
            if (n2 < n - 1) {
                stringBuilder.append(", ");
            } else if (iterable instanceof EmptyExpression) {
                stringBuilder.append(",");
            }
            ++n2;
        }
    }

    public void setBounds(int n, int n2) {
        this.setPosition(n);
        this.setLength(n2 - n);
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setParent(AstNode astNode) {
        AstNode astNode2 = this.parent;
        if (astNode == astNode2) {
            return;
        }
        if (astNode2 != null) {
            this.setRelative(-astNode2.getPosition());
        }
        this.parent = astNode;
        if (astNode != null) {
            this.setRelative(astNode.getPosition());
        }
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void setRelative(int n) {
        this.position -= n;
    }

    public String shortName() {
        String string2 = this.getClass().getName();
        return string2.substring(string2.lastIndexOf(".") + 1);
    }

    public String toSource() {
        return this.toSource(0);
    }

    public abstract String toSource(int var1);

    public abstract void visit(NodeVisitor var1);

    protected static class DebugPrintVisitor
    implements NodeVisitor {
        private static final int DEBUG_INDENT = 2;
        private StringBuilder buffer;

        public DebugPrintVisitor(StringBuilder stringBuilder) {
            this.buffer = stringBuilder;
        }

        private String makeIndent(int n) {
            int n2 = n * 2;
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (n = 0; n < n2; ++n) {
                stringBuilder.append(" ");
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return this.buffer.toString();
        }

        @Override
        public boolean visit(AstNode astNode) {
            int n = astNode.getType();
            CharSequence charSequence = Token.typeToName(n);
            StringBuilder stringBuilder = this.buffer;
            stringBuilder.append(astNode.getAbsolutePosition());
            stringBuilder.append("\t");
            this.buffer.append(this.makeIndent(astNode.depth()));
            stringBuilder = this.buffer;
            stringBuilder.append((String)charSequence);
            stringBuilder.append(" ");
            charSequence = this.buffer;
            ((StringBuilder)charSequence).append(astNode.getPosition());
            ((StringBuilder)charSequence).append(" ");
            this.buffer.append(astNode.getLength());
            if (n == 39) {
                charSequence = this.buffer;
                ((StringBuilder)charSequence).append(" ");
                ((StringBuilder)charSequence).append(((Name)astNode).getIdentifier());
            }
            this.buffer.append("\n");
            return true;
        }
    }

    public static class PositionComparator
    implements Comparator<AstNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(AstNode astNode, AstNode astNode2) {
            return astNode.position - astNode2.position;
        }
    }
}

