/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ScriptNode;

public class AstRoot
extends ScriptNode {
    private SortedSet<Comment> comments;

    public AstRoot() {
        this.type = 137;
    }

    public AstRoot(int n) {
        super(n);
        this.type = 137;
    }

    public void addComment(Comment comment) {
        this.assertNotNull(comment);
        if (this.comments == null) {
            this.comments = new TreeSet<AstNode>(new AstNode.PositionComparator());
        }
        this.comments.add(comment);
        comment.setParent(this);
    }

    public void checkParentLinks() {
        this.visit(new NodeVisitor(){

            @Override
            public boolean visit(AstNode astNode) {
                if (astNode.getType() == 137) {
                    return true;
                }
                if (astNode.getParent() != null) {
                    return true;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("No parent for node: ");
                stringBuilder.append(astNode);
                stringBuilder.append("\n");
                stringBuilder.append(astNode.toSource(0));
                throw new IllegalStateException(stringBuilder.toString());
            }
        });
    }

    @Override
    public String debugPrint() {
        AstNode.DebugPrintVisitor debugPrintVisitor = new AstNode.DebugPrintVisitor(new StringBuilder(1000));
        this.visitAll(debugPrintVisitor);
        return debugPrintVisitor.toString();
    }

    public SortedSet<Comment> getComments() {
        return this.comments;
    }

    public void setComments(SortedSet<Comment> object) {
        if (object == null) {
            this.comments = null;
        } else {
            SortedSet<Comment> sortedSet = this.comments;
            if (sortedSet != null) {
                sortedSet.clear();
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.addComment((Comment)object.next());
            }
        }
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Node> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            stringBuilder.append(((AstNode)iterator2.next()).toSource(n));
        }
        return stringBuilder.toString();
    }

    public void visitAll(NodeVisitor nodeVisitor) {
        this.visit(nodeVisitor);
        this.visitComments(nodeVisitor);
    }

    public void visitComments(NodeVisitor nodeVisitor) {
        SortedSet<Comment> sortedSet = this.comments;
        if (sortedSet != null) {
            sortedSet = sortedSet.iterator();
            while (sortedSet.hasNext()) {
                nodeVisitor.visit((Comment)sortedSet.next());
            }
        }
    }
}

