/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;

public class ContinueStatement
extends Jump {
    private Name label;
    private Loop target;

    public ContinueStatement() {
        this.type = 122;
    }

    public ContinueStatement(int n) {
        this(n, -1);
    }

    public ContinueStatement(int n, int n2) {
        this.type = 122;
        this.position = n;
        this.length = n2;
    }

    public ContinueStatement(int n, int n2, Name name) {
        this(n, n2);
        this.setLabel(name);
    }

    public ContinueStatement(int n, Name name) {
        this(n);
        this.setLabel(name);
    }

    public ContinueStatement(Name name) {
        this.type = 122;
        this.setLabel(name);
    }

    public Name getLabel() {
        return this.label;
    }

    public Loop getTarget() {
        return this.target;
    }

    public void setLabel(Name name) {
        this.label = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    public void setTarget(Loop loop) {
        this.assertNotNull(loop);
        this.target = loop;
        this.setJumpStatement(loop);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("continue");
        if (this.label != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.label.toSource(0));
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        Name name;
        if (nodeVisitor.visit(this) && (name = this.label) != null) {
            name.visit(nodeVisitor);
        }
    }
}

