/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ExpressionStatement
extends AstNode {
    private AstNode expr;

    public ExpressionStatement() {
        this.type = 134;
    }

    public ExpressionStatement(int n, int n2) {
        super(n, n2);
        this.type = 134;
    }

    public ExpressionStatement(int n, int n2, AstNode astNode) {
        super(n, n2);
        this.type = 134;
        this.setExpression(astNode);
    }

    public ExpressionStatement(AstNode astNode) {
        this(astNode.getPosition(), astNode.getLength(), astNode);
    }

    public ExpressionStatement(AstNode astNode, boolean bl) {
        this(astNode);
        if (bl) {
            this.setHasResult();
        }
    }

    public AstNode getExpression() {
        return this.expr;
    }

    @Override
    public boolean hasSideEffects() {
        boolean bl = this.type == 135 || this.expr.hasSideEffects();
        return bl;
    }

    public void setExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.expr = astNode;
        astNode.setParent(this);
        this.setLineno(astNode.getLineno());
    }

    public void setHasResult() {
        this.type = 135;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.expr.toSource(n));
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.expr.visit(nodeVisitor);
        }
    }
}

