/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.ScriptNode;

public class FunctionNode
extends ScriptNode {
    public static final int ARROW_FUNCTION = 4;
    public static final int FUNCTION_EXPRESSION = 2;
    public static final int FUNCTION_EXPRESSION_STATEMENT = 3;
    public static final int FUNCTION_STATEMENT = 1;
    private static final List<AstNode> NO_PARAMS = Collections.unmodifiableList(new ArrayList());
    private AstNode body;
    private Form functionForm = Form.FUNCTION;
    private Name functionName;
    private int functionType;
    private List<Node> generatorResumePoints;
    private boolean isExpressionClosure;
    private boolean isGenerator;
    private Map<Node, int[]> liveLocals;
    private int lp = -1;
    private AstNode memberExprNode;
    private boolean needsActivation;
    private List<AstNode> params;
    private int rp = -1;

    public FunctionNode() {
        this.type = 110;
    }

    public FunctionNode(int n) {
        super(n);
        this.type = 110;
    }

    public FunctionNode(int n, Name name) {
        super(n);
        this.type = 110;
        this.setFunctionName(name);
    }

    @Override
    public int addFunction(FunctionNode functionNode) {
        int n = super.addFunction(functionNode);
        if (this.getFunctionCount() > 0) {
            this.needsActivation = true;
        }
        return n;
    }

    public void addLiveLocals(Node node, int[] nArray) {
        if (this.liveLocals == null) {
            this.liveLocals = new HashMap<Node, int[]>();
        }
        this.liveLocals.put(node, nArray);
    }

    public void addParam(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.params == null) {
            this.params = new ArrayList<AstNode>();
        }
        this.params.add(astNode);
        astNode.setParent(this);
    }

    public void addResumptionPoint(Node node) {
        if (this.generatorResumePoints == null) {
            this.generatorResumePoints = new ArrayList<Node>();
        }
        this.generatorResumePoints.add(node);
    }

    public AstNode getBody() {
        return this.body;
    }

    public Name getFunctionName() {
        return this.functionName;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public Map<Node, int[]> getLiveLocals() {
        return this.liveLocals;
    }

    public int getLp() {
        return this.lp;
    }

    public AstNode getMemberExprNode() {
        return this.memberExprNode;
    }

    public String getName() {
        Object object = this.functionName;
        object = object != null ? ((Name)object).getIdentifier() : "";
        return object;
    }

    public List<AstNode> getParams() {
        List<AstNode> list = this.params;
        if (list == null) {
            list = NO_PARAMS;
        }
        return list;
    }

    public List<Node> getResumptionPoints() {
        return this.generatorResumePoints;
    }

    public int getRp() {
        return this.rp;
    }

    public boolean isExpressionClosure() {
        return this.isExpressionClosure;
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public boolean isGetterMethod() {
        boolean bl = this.functionForm == Form.GETTER;
        return bl;
    }

    public boolean isMethod() {
        boolean bl = this.functionForm == Form.GETTER || this.functionForm == Form.SETTER || this.functionForm == Form.METHOD;
        return bl;
    }

    public boolean isNormalMethod() {
        boolean bl = this.functionForm == Form.METHOD;
        return bl;
    }

    public boolean isParam(AstNode astNode) {
        List<AstNode> list = this.params;
        boolean bl = list == null ? false : list.contains(astNode);
        return bl;
    }

    public boolean isSetterMethod() {
        boolean bl = this.functionForm == Form.SETTER;
        return bl;
    }

    public boolean requiresActivation() {
        return this.needsActivation;
    }

    public void setBody(AstNode astNode) {
        this.assertNotNull(astNode);
        this.body = astNode;
        if (Boolean.TRUE.equals(astNode.getProp(25))) {
            this.setIsExpressionClosure(true);
        }
        int n = astNode.getPosition() + astNode.getLength();
        astNode.setParent(this);
        this.setLength(n - this.position);
        this.setEncodedSourceBounds(this.position, n);
    }

    public void setFunctionIsGetterMethod() {
        this.functionForm = Form.GETTER;
    }

    public void setFunctionIsNormalMethod() {
        this.functionForm = Form.METHOD;
    }

    public void setFunctionIsSetterMethod() {
        this.functionForm = Form.SETTER;
    }

    public void setFunctionName(Name name) {
        this.functionName = name;
        if (name != null) {
            name.setParent(this);
        }
    }

    public void setFunctionType(int n) {
        this.functionType = n;
    }

    public void setIsExpressionClosure(boolean bl) {
        this.isExpressionClosure = bl;
    }

    public void setIsGenerator() {
        this.isGenerator = true;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public void setMemberExprNode(AstNode astNode) {
        this.memberExprNode = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public void setParams(List<AstNode> object) {
        if (object == null) {
            this.params = null;
        } else {
            List<AstNode> list = this.params;
            if (list != null) {
                list.clear();
            }
            object = object.iterator();
            while (object.hasNext()) {
                this.addParam((AstNode)object.next());
            }
        }
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    public void setRequiresActivation() {
        this.needsActivation = true;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    @Override
    public String toSource(int n) {
        Iterable<AstNode> iterable;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.functionType == 4;
        if (!this.isMethod()) {
            stringBuilder.append(this.makeIndent(n));
            if (!bl) {
                stringBuilder.append("function");
            }
        }
        if (this.functionName != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.functionName.toSource(0));
        }
        if ((iterable = this.params) == null) {
            stringBuilder.append("() ");
        } else if (bl && this.lp == -1) {
            this.printList(iterable, stringBuilder);
            stringBuilder.append(" ");
        } else {
            stringBuilder.append("(");
            this.printList(this.params, stringBuilder);
            stringBuilder.append(") ");
        }
        if (bl) {
            stringBuilder.append("=> ");
        }
        if (this.isExpressionClosure) {
            iterable = this.getBody();
            if (((Node)iterable).getLastChild() instanceof ReturnStatement) {
                stringBuilder.append(((ReturnStatement)((Node)iterable).getLastChild()).getReturnValue().toSource(0));
                if (this.functionType == 1) {
                    stringBuilder.append(";");
                }
            } else {
                stringBuilder.append(" ");
                stringBuilder.append(((AstNode)iterable).toSource(0));
            }
        } else {
            stringBuilder.append(this.getBody().toSource(n).trim());
        }
        if (this.functionType == 1 || this.isMethod()) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            Object object = this.functionName;
            if (object != null) {
                ((Name)object).visit(nodeVisitor);
            }
            object = this.getParams().iterator();
            while (object.hasNext()) {
                ((AstNode)object.next()).visit(nodeVisitor);
            }
            this.getBody().visit(nodeVisitor);
            if (!this.isExpressionClosure && (object = this.memberExprNode) != null) {
                ((AstNode)object).visit(nodeVisitor);
            }
        }
    }

    public static final class Form
    extends Enum<Form> {
        private static final /* synthetic */ Form[] $VALUES;
        public static final /* enum */ Form FUNCTION;
        public static final /* enum */ Form GETTER;
        public static final /* enum */ Form METHOD;
        public static final /* enum */ Form SETTER;

        static {
            Form form;
            Form form2;
            Form form3;
            Form form4;
            FUNCTION = form4 = new Form();
            GETTER = form3 = new Form();
            SETTER = form2 = new Form();
            METHOD = form = new Form();
            $VALUES = new Form[]{form4, form3, form2, form};
        }

        public static Form valueOf(String string2) {
            return Enum.valueOf(Form.class, string2);
        }

        public static Form[] values() {
            return (Form[])$VALUES.clone();
        }
    }
}

