/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class IfStatement
extends AstNode {
    private AstNode condition;
    private AstNode elsePart;
    private int elsePosition = -1;
    private int lp = -1;
    private int rp = -1;
    private AstNode thenPart;

    public IfStatement() {
        this.type = 113;
    }

    public IfStatement(int n) {
        super(n);
        this.type = 113;
    }

    public IfStatement(int n, int n2) {
        super(n, n2);
        this.type = 113;
    }

    public AstNode getCondition() {
        return this.condition;
    }

    public AstNode getElsePart() {
        return this.elsePart;
    }

    public int getElsePosition() {
        return this.elsePosition;
    }

    public int getLp() {
        return this.lp;
    }

    public int getRp() {
        return this.rp;
    }

    public AstNode getThenPart() {
        return this.thenPart;
    }

    public void setCondition(AstNode astNode) {
        this.assertNotNull(astNode);
        this.condition = astNode;
        astNode.setParent(this);
    }

    public void setElsePart(AstNode astNode) {
        this.elsePart = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public void setElsePosition(int n) {
        this.elsePosition = n;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setThenPart(AstNode astNode) {
        this.assertNotNull(astNode);
        this.thenPart = astNode;
        astNode.setParent(this);
    }

    @Override
    public String toSource(int n) {
        String string2 = this.makeIndent(n);
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(string2);
        stringBuilder.append("if (");
        stringBuilder.append(this.condition.toSource(0));
        stringBuilder.append(") ");
        if (this.thenPart.getType() != 130) {
            stringBuilder.append("\n");
            stringBuilder.append(this.makeIndent(n + 1));
        }
        stringBuilder.append(this.thenPart.toSource(n).trim());
        if (this.elsePart != null) {
            if (this.thenPart.getType() != 130) {
                stringBuilder.append("\n");
                stringBuilder.append(string2);
                stringBuilder.append("else ");
            } else {
                stringBuilder.append(" else ");
            }
            if (this.elsePart.getType() != 130 && this.elsePart.getType() != 113) {
                stringBuilder.append("\n");
                stringBuilder.append(this.makeIndent(n + 1));
            }
            stringBuilder.append(this.elsePart.toSource(n).trim());
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.condition.visit(nodeVisitor);
            this.thenPart.visit(nodeVisitor);
            AstNode astNode = this.elsePart;
            if (astNode != null) {
                astNode.visit(nodeVisitor);
            }
        }
    }
}

