/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class InfixExpression
extends AstNode {
    protected AstNode left;
    protected int operatorPosition = -1;
    protected AstNode right;

    public InfixExpression() {
    }

    public InfixExpression(int n) {
        super(n);
    }

    public InfixExpression(int n, int n2) {
        super(n, n2);
    }

    public InfixExpression(int n, int n2, AstNode astNode, AstNode astNode2) {
        super(n, n2);
        this.setLeft(astNode);
        this.setRight(astNode2);
    }

    public InfixExpression(int n, AstNode astNode, AstNode astNode2, int n2) {
        this.setType(n);
        this.setOperatorPosition(n2 - astNode.getPosition());
        this.setLeftAndRight(astNode, astNode2);
    }

    public InfixExpression(AstNode astNode, AstNode astNode2) {
        this.setLeftAndRight(astNode, astNode2);
    }

    public AstNode getLeft() {
        return this.left;
    }

    public int getOperator() {
        return this.getType();
    }

    public int getOperatorPosition() {
        return this.operatorPosition;
    }

    public AstNode getRight() {
        return this.right;
    }

    @Override
    public boolean hasSideEffects() {
        boolean bl;
        block5: {
            block7: {
                AstNode astNode;
                boolean bl2;
                block6: {
                    int n = this.getType();
                    bl = true;
                    bl2 = true;
                    if (n == 90) break block5;
                    if (n != 105 && n != 106) {
                        return super.hasSideEffects();
                    }
                    astNode = this.left;
                    if (astNode == null) break block6;
                    bl = bl2;
                    if (astNode.hasSideEffects()) break block7;
                }
                bl = (astNode = this.right) != null && astNode.hasSideEffects() ? bl2 : false;
            }
            return bl;
        }
        AstNode astNode = this.right;
        if (astNode == null || !astNode.hasSideEffects()) {
            bl = false;
        }
        return bl;
    }

    public void setLeft(AstNode astNode) {
        this.assertNotNull(astNode);
        this.left = astNode;
        this.setLineno(astNode.getLineno());
        astNode.setParent(this);
    }

    public void setLeftAndRight(AstNode astNode, AstNode astNode2) {
        this.assertNotNull(astNode);
        this.assertNotNull(astNode2);
        this.setBounds(astNode.getPosition(), astNode2.getPosition() + astNode2.getLength());
        this.setLeft(astNode);
        this.setRight(astNode2);
    }

    public void setOperator(int n) {
        if (Token.isValidToken(n)) {
            this.setType(n);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid token: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setOperatorPosition(int n) {
        this.operatorPosition = n;
    }

    public void setRight(AstNode astNode) {
        this.assertNotNull(astNode);
        this.right = astNode;
        astNode.setParent(this);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.left.toSource());
        stringBuilder.append(" ");
        stringBuilder.append(InfixExpression.operatorToString(this.getType()));
        stringBuilder.append(" ");
        stringBuilder.append(this.right.toSource());
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.left.visit(nodeVisitor);
            this.right.visit(nodeVisitor);
        }
    }
}

