/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class KeywordLiteral
extends AstNode {
    public KeywordLiteral() {
    }

    public KeywordLiteral(int n) {
        super(n);
    }

    public KeywordLiteral(int n, int n2) {
        super(n, n2);
    }

    public KeywordLiteral(int n, int n2, int n3) {
        super(n, n2);
        this.setType(n3);
    }

    public boolean isBooleanLiteral() {
        boolean bl = this.type == 45 || this.type == 44;
        return bl;
    }

    @Override
    public KeywordLiteral setType(int n) {
        if (n != 43 && n != 42 && n != 45 && n != 44 && n != 161) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid node type: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.type = n;
        return this;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        n = this.getType();
        if (n != 161) {
            switch (n) {
                default: {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("Invalid keyword literal type: ");
                    stringBuilder.append(this.getType());
                    throw new IllegalStateException(stringBuilder.toString());
                }
                case 45: {
                    stringBuilder.append("true");
                    break;
                }
                case 44: {
                    stringBuilder.append("false");
                    break;
                }
                case 43: {
                    stringBuilder.append("this");
                    break;
                }
                case 42: {
                    stringBuilder.append("null");
                    break;
                }
            }
        } else {
            stringBuilder.append("debugger;\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

