/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.Scope;

public class Name
extends AstNode {
    private String identifier;
    private Scope scope;

    public Name() {
        this.type = 39;
    }

    public Name(int n) {
        super(n);
        this.type = 39;
    }

    public Name(int n, int n2) {
        super(n, n2);
        this.type = 39;
    }

    public Name(int n, int n2, String string2) {
        super(n, n2);
        this.type = 39;
        this.setIdentifier(string2);
    }

    public Name(int n, String string2) {
        super(n);
        this.type = 39;
        this.setIdentifier(string2);
        this.setLength(string2.length());
    }

    public Scope getDefiningScope() {
        Scope scope = this.getEnclosingScope();
        String string2 = this.getIdentifier();
        scope = scope == null ? null : scope.getDefiningScope(string2);
        return scope;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    public boolean isLocalName() {
        Scope scope = this.getDefiningScope();
        boolean bl = scope != null && scope.getParentScope() != null;
        return bl;
    }

    public int length() {
        String string2 = this.identifier;
        int n = string2 == null ? 0 : string2.length();
        return n;
    }

    public void setIdentifier(String string2) {
        this.assertNotNull(string2);
        this.identifier = string2;
        this.setLength(string2.length());
    }

    @Override
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @Override
    public String toSource(int n) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        String string3 = string2 = this.identifier;
        if (string2 == null) {
            string3 = "<null>";
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

