/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class NumberLiteral
extends AstNode {
    private double number;
    private String value;

    public NumberLiteral() {
        this.type = 40;
    }

    public NumberLiteral(double d) {
        this.type = 40;
        this.setDouble(d);
        this.setValue(Double.toString(d));
    }

    public NumberLiteral(int n) {
        super(n);
        this.type = 40;
    }

    public NumberLiteral(int n, int n2) {
        super(n, n2);
        this.type = 40;
    }

    public NumberLiteral(int n, String string2) {
        super(n);
        this.type = 40;
        this.setValue(string2);
        this.setLength(string2.length());
    }

    public NumberLiteral(int n, String string2, double d) {
        this(n, string2);
        this.setDouble(d);
    }

    public double getNumber() {
        return this.number;
    }

    public String getValue() {
        return this.value;
    }

    public void setNumber(double d) {
        this.number = d;
    }

    public void setValue(String string2) {
        this.assertNotNull(string2);
        this.value = string2;
    }

    @Override
    public String toSource(int n) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        String string3 = string2 = this.value;
        if (string2 == null) {
            string3 = "<null>";
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

