/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.InfixExpression;

public class ObjectProperty
extends InfixExpression {
    public ObjectProperty() {
        this.type = 104;
    }

    public ObjectProperty(int n) {
        super(n);
        this.type = 104;
    }

    public ObjectProperty(int n, int n2) {
        super(n, n2);
        this.type = 104;
    }

    public boolean isGetterMethod() {
        boolean bl = this.type == 152;
        return bl;
    }

    public boolean isMethod() {
        boolean bl = this.isGetterMethod() || this.isSetterMethod() || this.isNormalMethod();
        return bl;
    }

    public boolean isNormalMethod() {
        boolean bl = this.type == 164;
        return bl;
    }

    public boolean isSetterMethod() {
        boolean bl = this.type == 153;
        return bl;
    }

    public void setIsGetterMethod() {
        this.type = 152;
    }

    public void setIsNormalMethod() {
        this.type = 164;
    }

    public void setIsSetterMethod() {
        this.type = 153;
    }

    public void setNodeType(int n) {
        if (n != 104 && n != 152 && n != 153 && n != 164) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid node type: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.setType(n);
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        int n2 = n + 1;
        stringBuilder.append(this.makeIndent(n2));
        if (this.isGetterMethod()) {
            stringBuilder.append("get ");
        } else if (this.isSetterMethod()) {
            stringBuilder.append("set ");
        }
        AstNode astNode = this.left;
        if (this.getType() == 104) {
            n = 0;
        }
        stringBuilder.append(astNode.toSource(n));
        if (this.type == 104) {
            stringBuilder.append(": ");
        }
        astNode = this.right;
        n = n2;
        if (this.getType() == 104) {
            n = 0;
        }
        stringBuilder.append(astNode.toSource(n));
        return stringBuilder.toString();
    }
}

