/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.Symbol;

public class ScriptNode
extends Scope {
    private List<FunctionNode> EMPTY_LIST = Collections.emptyList();
    private Object compilerData;
    private String encodedSource;
    private int encodedSourceEnd = -1;
    private int encodedSourceStart = -1;
    private int endLineno = -1;
    private List<FunctionNode> functions;
    private boolean inStrictMode;
    private boolean[] isConsts;
    private int paramCount = 0;
    private List<RegExpLiteral> regexps;
    private String sourceName;
    private List<Symbol> symbols = new ArrayList<Symbol>(4);
    private int tempNumber = 0;
    private String[] variableNames;

    public ScriptNode() {
        this.top = this;
        this.type = 137;
    }

    public ScriptNode(int n) {
        super(n);
        this.top = this;
        this.type = 137;
    }

    public int addFunction(FunctionNode functionNode) {
        if (functionNode == null) {
            ScriptNode.codeBug();
        }
        if (this.functions == null) {
            this.functions = new ArrayList<FunctionNode>();
        }
        this.functions.add(functionNode);
        return this.functions.size() - 1;
    }

    public void addRegExp(RegExpLiteral regExpLiteral) {
        if (regExpLiteral == null) {
            ScriptNode.codeBug();
        }
        if (this.regexps == null) {
            this.regexps = new ArrayList<RegExpLiteral>();
        }
        this.regexps.add(regExpLiteral);
        regExpLiteral.putIntProp(4, this.regexps.size() - 1);
    }

    void addSymbol(Symbol symbol) {
        if (this.variableNames != null) {
            ScriptNode.codeBug();
        }
        if (symbol.getDeclType() == 88) {
            ++this.paramCount;
        }
        this.symbols.add(symbol);
    }

    public void flattenSymbolTable(boolean bl) {
        Symbol symbol;
        int n;
        Object object;
        if (!bl) {
            object = new ArrayList<Symbol>();
            if (this.symbolTable != null) {
                for (n = 0; n < this.symbols.size(); ++n) {
                    symbol = this.symbols.get(n);
                    if (symbol.getContainingTable() != this) continue;
                    object.add((Symbol)symbol);
                }
            }
            this.symbols = object;
        }
        this.variableNames = new String[this.symbols.size()];
        this.isConsts = new boolean[this.symbols.size()];
        for (n = 0; n < this.symbols.size(); ++n) {
            symbol = this.symbols.get(n);
            this.variableNames[n] = symbol.getName();
            object = this.isConsts;
            bl = symbol.getDeclType() == 155;
            object[n] = bl;
            symbol.setIndex(n);
        }
    }

    public int getBaseLineno() {
        return this.lineno;
    }

    public Object getCompilerData() {
        return this.compilerData;
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public int getEncodedSourceEnd() {
        return this.encodedSourceEnd;
    }

    public int getEncodedSourceStart() {
        return this.encodedSourceStart;
    }

    public int getEndLineno() {
        return this.endLineno;
    }

    public int getFunctionCount() {
        List<FunctionNode> list = this.functions;
        int n = list == null ? 0 : list.size();
        return n;
    }

    public FunctionNode getFunctionNode(int n) {
        return this.functions.get(n);
    }

    public List<FunctionNode> getFunctions() {
        List<FunctionNode> list;
        List<FunctionNode> list2 = list = this.functions;
        if (list == null) {
            list2 = this.EMPTY_LIST;
        }
        return list2;
    }

    public int getIndexForNameNode(Node object) {
        Scope scope;
        if (this.variableNames == null) {
            ScriptNode.codeBug();
        }
        object = (scope = ((Node)object).getScope()) == null ? null : scope.getSymbol(((Name)object).getIdentifier());
        int n = object == null ? -1 : ((Symbol)object).getIndex();
        return n;
    }

    public String getNextTempName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("$");
        int n = this.tempNumber;
        this.tempNumber = n + 1;
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    public boolean[] getParamAndVarConst() {
        if (this.variableNames == null) {
            ScriptNode.codeBug();
        }
        return this.isConsts;
    }

    public int getParamAndVarCount() {
        if (this.variableNames == null) {
            ScriptNode.codeBug();
        }
        return this.symbols.size();
    }

    public String[] getParamAndVarNames() {
        if (this.variableNames == null) {
            ScriptNode.codeBug();
        }
        return this.variableNames;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public String getParamOrVarName(int n) {
        if (this.variableNames == null) {
            ScriptNode.codeBug();
        }
        return this.variableNames[n];
    }

    public int getRegexpCount() {
        List<RegExpLiteral> list = this.regexps;
        int n = list == null ? 0 : list.size();
        return n;
    }

    public String getRegexpFlags(int n) {
        return this.regexps.get(n).getFlags();
    }

    public String getRegexpString(int n) {
        return this.regexps.get(n).getValue();
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public List<Symbol> getSymbols() {
        return this.symbols;
    }

    public boolean isInStrictMode() {
        return this.inStrictMode;
    }

    public void setBaseLineno(int n) {
        if (n < 0 || this.lineno >= 0) {
            ScriptNode.codeBug();
        }
        this.lineno = n;
    }

    public void setCompilerData(Object object) {
        this.assertNotNull(object);
        if (this.compilerData == null) {
            this.compilerData = object;
            return;
        }
        throw new IllegalStateException();
    }

    public void setEncodedSource(String string2) {
        this.encodedSource = string2;
    }

    public void setEncodedSourceBounds(int n, int n2) {
        this.encodedSourceStart = n;
        this.encodedSourceEnd = n2;
    }

    public void setEncodedSourceEnd(int n) {
        this.encodedSourceEnd = n;
    }

    public void setEncodedSourceStart(int n) {
        this.encodedSourceStart = n;
    }

    public void setEndLineno(int n) {
        if (n < 0 || this.endLineno >= 0) {
            ScriptNode.codeBug();
        }
        this.endLineno = n;
    }

    public void setInStrictMode(boolean bl) {
        this.inStrictMode = bl;
    }

    public void setSourceName(String string2) {
        this.sourceName = string2;
    }

    public void setSymbols(List<Symbol> list) {
        this.symbols = list;
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            Iterator<Node> iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                ((AstNode)iterator2.next()).visit(nodeVisitor);
            }
        }
    }
}

