/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class SwitchCase
extends AstNode {
    private AstNode expression;
    private List<AstNode> statements;

    public SwitchCase() {
        this.type = 116;
    }

    public SwitchCase(int n) {
        super(n);
        this.type = 116;
    }

    public SwitchCase(int n, int n2) {
        super(n, n2);
        this.type = 116;
    }

    public void addStatement(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.statements == null) {
            this.statements = new ArrayList<AstNode>();
        }
        this.setLength(astNode.getPosition() + astNode.getLength() - this.getPosition());
        this.statements.add(astNode);
        astNode.setParent(this);
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public List<AstNode> getStatements() {
        return this.statements;
    }

    public boolean isDefault() {
        boolean bl = this.expression == null;
        return bl;
    }

    public void setExpression(AstNode astNode) {
        this.expression = astNode;
        if (astNode != null) {
            astNode.setParent(this);
        }
    }

    public void setStatements(List<AstNode> object) {
        List<AstNode> list = this.statements;
        if (list != null) {
            list.clear();
        }
        object = object.iterator();
        while (object.hasNext()) {
            this.addStatement((AstNode)object.next());
        }
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        if (this.expression == null) {
            stringBuilder.append("default:\n");
        } else {
            stringBuilder.append("case ");
            stringBuilder.append(this.expression.toSource(0));
            stringBuilder.append(":\n");
        }
        Object object = this.statements;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                stringBuilder.append(((AstNode)object.next()).toSource(n + 1));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            Object object = this.expression;
            if (object != null) {
                ((AstNode)object).visit(nodeVisitor);
            }
            if ((object = this.statements) != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    ((AstNode)object.next()).visit(nodeVisitor);
                }
            }
        }
    }
}

