/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScope;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;

public class Require
extends BaseFunction {
    private static final ThreadLocal<Map<String, Scriptable>> loadingModuleInterfaces = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private final Map<String, Scriptable> exportedModuleInterfaces = new ConcurrentHashMap<String, Scriptable>();
    private final Object loadLock = new Object();
    private Scriptable mainExports;
    private String mainModuleId = null;
    private final ModuleScriptProvider moduleScriptProvider;
    private final Scriptable nativeScope;
    private final Scriptable paths;
    private final Script postExec;
    private final Script preExec;
    private final boolean sandboxed;

    public Require(Context object, Scriptable scriptable, ModuleScriptProvider moduleScriptProvider, Script script, Script script2, boolean bl) {
        this.moduleScriptProvider = moduleScriptProvider;
        this.nativeScope = scriptable;
        this.sandboxed = bl;
        this.preExec = script;
        this.postExec = script2;
        this.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        if (!bl) {
            this.paths = object = ((Context)object).newArray(scriptable, 0);
            Require.defineReadOnlyProperty(this, "paths", object);
        } else {
            this.paths = null;
        }
    }

    private static void defineReadOnlyProperty(ScriptableObject scriptableObject, String string2, Object object) {
        ScriptableObject.putProperty((Scriptable)scriptableObject, string2, object);
        scriptableObject.setAttributes(string2, 5);
    }

    private Scriptable executeModuleScript(Context context, String object, Scriptable scriptable, ModuleScript moduleScript, boolean bl) {
        ScriptableObject scriptableObject = (ScriptableObject)context.newObject(this.nativeScope);
        URI uRI = moduleScript.getUri();
        URI uRI2 = moduleScript.getBase();
        Require.defineReadOnlyProperty(scriptableObject, "id", object);
        if (!this.sandboxed) {
            Require.defineReadOnlyProperty(scriptableObject, "uri", uRI.toString());
        }
        object = new ModuleScope(this.nativeScope, uRI, uRI2);
        object.put("exports", (Scriptable)object, (Object)scriptable);
        object.put("module", (Scriptable)object, (Object)scriptableObject);
        scriptableObject.put("exports", (Scriptable)scriptableObject, (Object)scriptable);
        this.install((Scriptable)object);
        if (bl) {
            Require.defineReadOnlyProperty(this, "main", scriptableObject);
        }
        Require.executeOptionalScript(this.preExec, context, (Scriptable)object);
        moduleScript.getScript().exec(context, (Scriptable)object);
        Require.executeOptionalScript(this.postExec, context, (Scriptable)object);
        return ScriptRuntime.toObject(context, this.nativeScope, ScriptableObject.getProperty((Scriptable)scriptableObject, "exports"));
    }

    private static void executeOptionalScript(Script script, Context context, Scriptable scriptable) {
        if (script != null) {
            script.exec(context, scriptable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Scriptable getExportedModuleInterface(Context object, String string2, URI hashMap, URI object2, boolean bl) {
        Object object3;
        Map<String, Scriptable> map = this.exportedModuleInterfaces.get(string2);
        if (map != null) {
            if (!bl) {
                return map;
            }
            throw new IllegalStateException("Attempt to set main module after it was loaded");
        }
        ThreadLocal<Map<String, Scriptable>> threadLocal = loadingModuleInterfaces;
        map = threadLocal.get();
        if (map != null && (object3 = (Scriptable)map.get(string2)) != null) {
            return object3;
        }
        object3 = this.loadLock;
        synchronized (object3) {
            Throwable throwable2222222;
            boolean bl2;
            block18: {
                block17: {
                    Object object4 = this.exportedModuleInterfaces.get(string2);
                    if (object4 != null) {
                        return object4;
                    }
                    object4 = this.getModule((Context)object, string2, (URI)((Object)hashMap), (URI)object2);
                    if (this.sandboxed && !((ModuleScript)object4).isSandboxed()) {
                        object2 = this.nativeScope;
                        hashMap = new HashMap<String, Object>();
                        ((StringBuilder)((Object)hashMap)).append("Module \"");
                        ((StringBuilder)((Object)hashMap)).append(string2);
                        ((StringBuilder)((Object)hashMap)).append("\" is not contained in sandbox.");
                        throw ScriptRuntime.throwError((Context)object, (Scriptable)object2, ((StringBuilder)((Object)hashMap)).toString());
                    }
                    object2 = ((Context)object).newObject(this.nativeScope);
                    bl2 = map == null;
                    hashMap = map;
                    if (bl2) {
                        hashMap = new HashMap<String, Object>();
                        threadLocal.set(hashMap);
                    }
                    hashMap.put(string2, object2);
                    map = this.executeModuleScript((Context)object, string2, (Scriptable)object2, (ModuleScript)object4, bl);
                    object = object2;
                    if (object2 == map) break block17;
                    {
                        catch (Throwable throwable2222222) {
                            break block18;
                        }
                        catch (RuntimeException runtimeException) {}
                        {
                            hashMap.remove(string2);
                            throw runtimeException;
                        }
                    }
                    {
                        hashMap.put(string2, map);
                        object = map;
                    }
                }
                if (bl2) {
                    this.exportedModuleInterfaces.putAll(hashMap);
                    threadLocal.set(null);
                }
                return object;
            }
            if (bl2) {
                this.exportedModuleInterfaces.putAll(hashMap);
                loadingModuleInterfaces.set(null);
            }
            throw throwable2222222;
        }
    }

    private ModuleScript getModule(Context context, String string2, URI object, URI comparable) {
        block4: {
            object = this.moduleScriptProvider.getModuleScript(context, string2, (URI)object, (URI)comparable, this.paths);
            if (object == null) break block4;
            return object;
        }
        try {
            object = this.nativeScope;
            comparable = new Comparable<URI>();
            ((StringBuilder)comparable).append("Module \"");
            ((StringBuilder)comparable).append(string2);
            ((StringBuilder)comparable).append("\" not found.");
            throw ScriptRuntime.throwError(context, (Scriptable)object, ((StringBuilder)comparable).toString());
        }
        catch (Exception exception) {
            throw Context.throwAsScriptRuntimeEx(exception);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    @Override
    public Object call(Context context, Scriptable object, Scriptable object2, Object[] object3) {
        block8: {
            String string2;
            block11: {
                block10: {
                    block9: {
                        if (object3 == null || ((Object[])object3).length < 1) break block8;
                        string2 = (String)Context.jsToJava(object3[0], String.class);
                        if (string2.startsWith("./") || string2.startsWith("../")) break block9;
                        object3 = null;
                        object = object3;
                        object2 = string2;
                        break block10;
                    }
                    if (!(object2 instanceof ModuleScope)) break block11;
                    object2 = (ModuleScope)object2;
                    URI uRI = ((ModuleScope)object2).getBase();
                    object2 = ((ModuleScope)object2).getUri();
                    object3 = ((URI)object2).resolve(string2);
                    if (uRI == null) {
                        object2 = ((URI)object3).toString();
                    } else {
                        string2 = uRI.relativize((URI)object2).resolve(string2).toString();
                        object2 = string2;
                        if (string2.charAt(0) == '.') {
                            if (!this.sandboxed) {
                                object2 = ((URI)object3).toString();
                            } else {
                                object2 = new StringBuilder();
                                ((StringBuilder)object2).append("Module \"");
                                ((StringBuilder)object2).append(string2);
                                ((StringBuilder)object2).append("\" is not contained in sandbox.");
                                throw ScriptRuntime.throwError(context, (Scriptable)object, ((StringBuilder)object2).toString());
                            }
                        }
                    }
                    object = uRI;
                }
                return this.getExportedModuleInterface(context, (String)object2, (URI)object3, (URI)object, false);
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Can't resolve relative module ID \"");
            ((StringBuilder)object2).append(string2);
            ((StringBuilder)object2).append("\" when require() is used outside of a module");
            throw ScriptRuntime.throwError(context, (Scriptable)object, ((StringBuilder)object2).toString());
        }
        throw ScriptRuntime.throwError(context, (Scriptable)object, "require() needs one argument");
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        throw ScriptRuntime.throwError(context, scriptable, "require() can not be invoked as a constructor");
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public String getFunctionName() {
        return "require";
    }

    @Override
    public int getLength() {
        return 1;
    }

    public void install(Scriptable scriptable) {
        ScriptableObject.putProperty(scriptable, "require", (Object)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Scriptable requireMain(Context object, String string2) {
        block12: {
            Object object2;
            block14: {
                Object object3;
                block13: {
                    block11: {
                        object3 = this.mainModuleId;
                        if (object3 != null) {
                            if (((String)object3).equals(string2)) {
                                return this.mainExports;
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("Main module already set to ");
                            ((StringBuilder)object).append(this.mainModuleId);
                            throw new IllegalStateException(((StringBuilder)object).toString());
                        }
                        try {
                            object3 = this.moduleScriptProvider.getModuleScript((Context)object, string2, null, null, this.paths);
                            if (object3 == null) break block11;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        this.mainExports = this.getExportedModuleInterface((Context)object, string2, null, null, true);
                        break block12;
                    }
                    if (this.sandboxed) break block12;
                    object3 = null;
                    try {
                        object3 = object2 = new URI(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    if (object3 == null) break block13;
                    object2 = object3;
                    if (((URI)object3).isAbsolute()) break block14;
                }
                if (!((File)(object3 = new File(string2))).isFile()) {
                    object3 = this.nativeScope;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Module \"");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append("\" not found.");
                    throw ScriptRuntime.throwError((Context)object, (Scriptable)object3, ((StringBuilder)object2).toString());
                }
                object2 = ((File)object3).toURI();
            }
            this.mainExports = this.getExportedModuleInterface((Context)object, ((URI)object2).toString(), (URI)object2, null, true);
        }
        this.mainModuleId = string2;
        return this.mainExports;
    }
}

