/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;

public abstract class CachingModuleScriptProviderBase
implements ModuleScriptProvider,
Serializable {
    private static final int loadConcurrencyLevel;
    private static final int loadLockCount;
    private static final int loadLockMask;
    private static final int loadLockShift;
    private static final long serialVersionUID = 1L;
    private final Object[] loadLocks = new Object[loadLockCount];
    private final ModuleSourceProvider moduleSourceProvider;

    static {
        int n;
        loadConcurrencyLevel = Runtime.getRuntime().availableProcessors() * 8;
        int n2 = 0;
        for (n = 1; n < loadConcurrencyLevel; n <<= 1) {
            ++n2;
        }
        loadLockShift = 32 - n2;
        loadLockMask = n - 1;
        loadLockCount = n;
    }

    protected CachingModuleScriptProviderBase(ModuleSourceProvider moduleSourceProvider) {
        Object[] objectArray;
        for (int i = 0; i < (objectArray = this.loadLocks).length; ++i) {
            objectArray[i] = new Object();
        }
        this.moduleSourceProvider = moduleSourceProvider;
    }

    private static boolean equal(Object object, Object object2) {
        boolean bl = object == null ? object2 == null : object.equals(object2);
        return bl;
    }

    protected static int getConcurrencyLevel() {
        return loadLockCount;
    }

    private static Object getValidator(CachedModuleScript object) {
        object = object == null ? null : ((CachedModuleScript)object).getValidator();
        return object;
    }

    protected abstract CachedModuleScript getLoadedModule(String var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModuleScript getModuleScript(Context object, String string2, URI serializable, URI object2, Scriptable object3) throws Exception {
        Object object4 = this.getLoadedModule(string2);
        Object object5 = CachingModuleScriptProviderBase.getValidator((CachedModuleScript)object4);
        if ((serializable = serializable == null ? this.moduleSourceProvider.loadSource(string2, (Scriptable)object3, object5) : this.moduleSourceProvider.loadSource((URI)serializable, (URI)object2, object5)) == ModuleSourceProvider.NOT_MODIFIED) {
            return ((CachedModuleScript)object4).getModule();
        }
        if (serializable == null) {
            return null;
        }
        object2 = ((ModuleSource)serializable).getReader();
        try {
            int n = string2.hashCode();
            object3 = this.loadLocks[n >>> loadLockShift & loadLockMask];
            synchronized (object3) {
                object4 = this.getLoadedModule(string2);
                if (object4 == null) break block10;
            }
        }
        catch (Throwable throwable) {
            ((Reader)object2).close();
            throw throwable;
        }
        {
            block10: {
                if (!CachingModuleScriptProviderBase.equal(object5, CachingModuleScriptProviderBase.getValidator((CachedModuleScript)object4))) {
                    object = ((CachedModuleScript)object4).getModule();
                    // MONITOREXIT @DISABLED, blocks:[5, 7] lbl20 : MonitorExitStatement: MONITOREXIT : var5_6
                    ((Reader)object2).close();
                    return object;
                }
            }
            object4 = ((ModuleSource)serializable).getUri();
            object5 = new ModuleScript(((Context)object).compileReader((Reader)object2, ((URI)object4).toString(), 1, ((ModuleSource)serializable).getSecurityDomain()), (URI)object4, ((ModuleSource)serializable).getBase());
            this.putLoadedModule(string2, (ModuleScript)object5, ((ModuleSource)serializable).getValidator());
        }
        ((Reader)object2).close();
        return object5;
    }

    protected abstract void putLoadedModule(String var1, ModuleScript var2, Object var3);

    public static class CachedModuleScript {
        private final ModuleScript moduleScript;
        private final Object validator;

        public CachedModuleScript(ModuleScript moduleScript, Object object) {
            this.moduleScript = moduleScript;
            this.validator = object;
        }

        ModuleScript getModule() {
            return this.moduleScript;
        }

        Object getValidator() {
            return this.validator;
        }
    }
}

