/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;

public abstract class ModuleSourceProviderBase
implements ModuleSourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;

    private static String ensureTrailingSlash(String string2) {
        if (!string2.endsWith("/")) {
            string2 = string2.concat("/");
        }
        return string2;
    }

    private ModuleSource loadFromPathArray(String string2, Scriptable scriptable, Object object) throws IOException {
        long l = ScriptRuntime.toUint32(ScriptableObject.getProperty(scriptable, "length"));
        int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            URI uRI;
            String string3 = ModuleSourceProviderBase.ensureTrailingSlash(ScriptableObject.getTypedProperty(scriptable, i, String.class));
            try {
                serializable = uRI = new URI(string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new MalformedURLException(uRISyntaxException.getMessage());
            }
            if (!uRI.isAbsolute()) {
                serializable = new File(string3);
                serializable = ((File)serializable).toURI().resolve("");
            }
            if ((serializable = this.loadFromUri(serializable.resolve(string2), (URI)serializable, object)) == null) continue;
            return serializable;
        }
        return null;
    }

    protected boolean entityNeedsRevalidation(Object object) {
        return true;
    }

    protected ModuleSource loadFromFallbackLocations(String string2, Object object) throws IOException, URISyntaxException {
        return null;
    }

    protected ModuleSource loadFromPrivilegedLocations(String string2, Object object) throws IOException, URISyntaxException {
        return null;
    }

    protected abstract ModuleSource loadFromUri(URI var1, URI var2, Object var3) throws IOException, URISyntaxException;

    @Override
    public ModuleSource loadSource(String string2, Scriptable object, Object object2) throws IOException, URISyntaxException {
        if (!this.entityNeedsRevalidation(object2)) {
            return NOT_MODIFIED;
        }
        ModuleSource moduleSource = this.loadFromPrivilegedLocations(string2, object2);
        if (moduleSource != null) {
            return moduleSource;
        }
        if (object != null && (object = this.loadFromPathArray(string2, (Scriptable)object, object2)) != null) {
            return object;
        }
        return this.loadFromFallbackLocations(string2, object2);
    }

    @Override
    public ModuleSource loadSource(URI uRI, URI uRI2, Object object) throws IOException, URISyntaxException {
        return this.loadFromUri(uRI, uRI2, object);
    }
}

