/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.mozilla.javascript.commonjs.module.provider.DefaultUrlConnectionExpiryCalculator;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProviderBase;
import org.mozilla.javascript.commonjs.module.provider.ParsedContentType;
import org.mozilla.javascript.commonjs.module.provider.UrlConnectionExpiryCalculator;
import org.mozilla.javascript.commonjs.module.provider.UrlConnectionSecurityDomainProvider;

public class UrlModuleSourceProvider
extends ModuleSourceProviderBase {
    private static final long serialVersionUID = 1L;
    private final Iterable<URI> fallbackUris;
    private final Iterable<URI> privilegedUris;
    private final UrlConnectionExpiryCalculator urlConnectionExpiryCalculator;
    private final UrlConnectionSecurityDomainProvider urlConnectionSecurityDomainProvider;

    public UrlModuleSourceProvider(Iterable<URI> iterable, Iterable<URI> iterable2) {
        this(iterable, iterable2, new DefaultUrlConnectionExpiryCalculator(), null);
    }

    public UrlModuleSourceProvider(Iterable<URI> iterable, Iterable<URI> iterable2, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator, UrlConnectionSecurityDomainProvider urlConnectionSecurityDomainProvider) {
        this.privilegedUris = iterable;
        this.fallbackUris = iterable2;
        this.urlConnectionExpiryCalculator = urlConnectionExpiryCalculator;
        this.urlConnectionSecurityDomainProvider = urlConnectionSecurityDomainProvider;
    }

    private void close(URLConnection uRLConnection) {
        try {
            uRLConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            this.onFailedClosingUrlConnection(uRLConnection, iOException);
        }
    }

    private static String getCharacterEncoding(URLConnection object) {
        ParsedContentType parsedContentType = new ParsedContentType(((URLConnection)object).getContentType());
        if ((object = parsedContentType.getEncoding()) != null) {
            return object;
        }
        object = parsedContentType.getContentType();
        if (object != null && ((String)object).startsWith("text/")) {
            return "8859_1";
        }
        return "utf-8";
    }

    private static Reader getReader(URLConnection uRLConnection) throws IOException {
        return new InputStreamReader(uRLConnection.getInputStream(), UrlModuleSourceProvider.getCharacterEncoding(uRLConnection));
    }

    private Object getSecurityDomain(URLConnection object) {
        UrlConnectionSecurityDomainProvider urlConnectionSecurityDomainProvider = this.urlConnectionSecurityDomainProvider;
        object = urlConnectionSecurityDomainProvider == null ? null : urlConnectionSecurityDomainProvider.getSecurityDomain((URLConnection)object);
        return object;
    }

    private ModuleSource loadFromPathList(String string2, Object object, Iterable<URI> object2) throws IOException, URISyntaxException {
        if (object2 == null) {
            return null;
        }
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Serializable serializable = (URI)object2.next();
            if ((serializable = this.loadFromUri(serializable.resolve(string2), (URI)serializable, object)) == null) continue;
            return serializable;
        }
        return null;
    }

    @Override
    protected boolean entityNeedsRevalidation(Object object) {
        boolean bl = !(object instanceof URLValidator) || ((URLValidator)object).entityNeedsRevalidation();
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModuleSource loadFromActualUri(URI serializable, URI uRI, Object object) throws IOException {
        Object object2;
        void var2_6;
        Object object3 = var2_6 == null ? null : var2_6.toURL();
        object3 = new URL((URL)object3, ((URI)serializable).toString());
        long l = System.currentTimeMillis();
        object3 = this.openUrlConnection((URL)object3);
        if (!(object2 instanceof URLValidator) || !((URLValidator)(object2 = (URLValidator)object2)).appliesTo((URI)serializable)) {
            object2 = null;
        }
        if (object2 != null) {
            ((URLValidator)object2).applyConditionals((URLConnection)object3);
        }
        try {
            ((URLConnection)object3).connect();
            if (object2 != null && ((URLValidator)object2).updateValidator((URLConnection)object3, l, this.urlConnectionExpiryCalculator)) {
                this.close((URLConnection)object3);
                return NOT_MODIFIED;
            }
            object2 = UrlModuleSourceProvider.getReader((URLConnection)object3);
            Object object4 = this.getSecurityDomain((URLConnection)object3);
            URLValidator uRLValidator = new URLValidator((URI)serializable, (URLConnection)object3, l, this.urlConnectionExpiryCalculator);
            return new ModuleSource((Reader)object2, object4, (URI)serializable, (URI)var2_6, uRLValidator);
        }
        catch (IOException iOException) {
            this.close((URLConnection)object3);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.close((URLConnection)object3);
            throw runtimeException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    protected ModuleSource loadFromFallbackLocations(String string2, Object object) throws IOException, URISyntaxException {
        return this.loadFromPathList(string2, object, this.fallbackUris);
    }

    @Override
    protected ModuleSource loadFromPrivilegedLocations(String string2, Object object) throws IOException, URISyntaxException {
        return this.loadFromPathList(string2, object, this.privilegedUris);
    }

    @Override
    protected ModuleSource loadFromUri(URI serializable, URI uRI, Object object) throws IOException, URISyntaxException {
        Serializable serializable2 = new StringBuilder();
        serializable2.append(serializable);
        serializable2.append(".js");
        serializable2 = this.loadFromActualUri(new URI(serializable2.toString()), uRI, object);
        serializable = serializable2 != null ? serializable2 : this.loadFromActualUri((URI)serializable, uRI, object);
        return serializable;
    }

    protected void onFailedClosingUrlConnection(URLConnection uRLConnection, IOException iOException) {
    }

    protected URLConnection openUrlConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    private static class URLValidator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String entityTags;
        private long expiry;
        private final long lastModified;
        private final URI uri;

        public URLValidator(URI uRI, URLConnection uRLConnection, long l, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator) {
            this.uri = uRI;
            this.lastModified = uRLConnection.getLastModified();
            this.entityTags = this.getEntityTags(uRLConnection);
            this.expiry = this.calculateExpiry(uRLConnection, l, urlConnectionExpiryCalculator);
        }

        private long calculateExpiry(URLConnection uRLConnection, long l, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator) {
            boolean bl = "no-cache".equals(uRLConnection.getHeaderField("Pragma"));
            long l2 = 0L;
            if (bl) {
                return 0L;
            }
            String string2 = uRLConnection.getHeaderField("Cache-Control");
            if (string2 != null) {
                if (string2.indexOf("no-cache") != -1) {
                    return 0L;
                }
                int n = this.getMaxAge(string2);
                if (-1 != n) {
                    long l3 = System.currentTimeMillis();
                    l2 = Math.max(Math.max(0L, l3 - uRLConnection.getDate()), (long)uRLConnection.getHeaderFieldInt("Age", 0) * 1000L);
                    return (long)n * 1000L + (l3 - (l2 + (l3 - l)));
                }
            }
            if ((l = uRLConnection.getHeaderFieldDate("Expires", -1L)) != -1L) {
                return l;
            }
            l = urlConnectionExpiryCalculator == null ? l2 : urlConnectionExpiryCalculator.calculateExpiry(uRLConnection);
            return l;
        }

        private String getEntityTags(URLConnection object) {
            List<String> list = ((URLConnection)object).getHeaderFields().get("ETag");
            if (list != null && !list.isEmpty()) {
                object = new StringBuilder();
                list = list.iterator();
                ((StringBuilder)object).append((String)list.next());
                while (list.hasNext()) {
                    ((StringBuilder)object).append(", ");
                    ((StringBuilder)object).append((String)list.next());
                }
                return ((StringBuilder)object).toString();
            }
            return null;
        }

        private int getMaxAge(String string2) {
            int n = string2.indexOf("max-age");
            if (n == -1) {
                return -1;
            }
            if ((n = string2.indexOf(61, n + 7)) == -1) {
                return -1;
            }
            int n2 = n + 1;
            string2 = (n = string2.indexOf(44, n2)) == -1 ? string2.substring(n2) : string2.substring(n2, n);
            try {
                n = Integer.parseInt(string2);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        private boolean isResourceChanged(URLConnection uRLConnection) throws IOException {
            boolean bl = uRLConnection instanceof HttpURLConnection;
            boolean bl2 = true;
            boolean bl3 = true;
            if (bl) {
                if (((HttpURLConnection)uRLConnection).getResponseCode() != 304) {
                    bl3 = false;
                }
                return bl3;
            }
            bl3 = this.lastModified == uRLConnection.getLastModified() ? bl2 : false;
            return bl3;
        }

        boolean appliesTo(URI uRI) {
            return this.uri.equals(uRI);
        }

        void applyConditionals(URLConnection uRLConnection) {
            String string2;
            long l = this.lastModified;
            if (l != 0L) {
                uRLConnection.setIfModifiedSince(l);
            }
            if ((string2 = this.entityTags) != null && string2.length() > 0) {
                uRLConnection.addRequestProperty("If-None-Match", this.entityTags);
            }
        }

        boolean entityNeedsRevalidation() {
            boolean bl = System.currentTimeMillis() > this.expiry;
            return bl;
        }

        boolean updateValidator(URLConnection uRLConnection, long l, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator) throws IOException {
            boolean bl = this.isResourceChanged(uRLConnection);
            if (!bl) {
                this.expiry = this.calculateExpiry(uRLConnection, l, urlConnectionExpiryCalculator);
            }
            return bl;
        }
    }
}

