/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.json;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class JsonParser {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private Context cx;
    private int length;
    private int pos;
    private Scriptable scope;
    private String src;

    public JsonParser(Context context, Scriptable scriptable) {
        this.cx = context;
        this.scope = scriptable;
    }

    private void consume(char c) throws ParseException {
        this.consumeWhitespace();
        int n = this.pos;
        if (n < this.length) {
            CharSequence charSequence = this.src;
            this.pos = n + 1;
            char c2 = ((String)charSequence).charAt(n);
            if (c2 == c) {
                return;
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Expected ");
            ((StringBuilder)charSequence).append(c);
            ((StringBuilder)charSequence).append(" found ");
            ((StringBuilder)charSequence).append(c2);
            throw new ParseException(((StringBuilder)charSequence).toString());
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected ");
        stringBuilder.append(c);
        stringBuilder.append(" but reached end of stream");
        throw new ParseException(stringBuilder.toString());
    }

    private void consumeWhitespace() {
        int n;
        while ((n = this.pos) < this.length) {
            if ((n = (int)this.src.charAt(n)) != 9 && n != 10 && n != 13 && n != 32) {
                return;
            }
            ++this.pos;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return (char)(c - 48);
        }
        int n = 65;
        if (c >= 'A' && c <= 'F') {
            return (char)(c - n + 10);
        }
        n = 97;
        if (c < 'a') return (char)-1;
        if (c > 'f') return (char)-1;
        return (char)(c - n + 10);
    }

    private char nextOrNumberError(int n) throws ParseException {
        int n2 = this.pos;
        int n3 = this.length;
        if (n2 < n3) {
            String string2 = this.src;
            this.pos = n2 + 1;
            return string2.charAt(n2);
        }
        throw this.numberError(n, n3);
    }

    private ParseException numberError(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unsupported number format: ");
        stringBuilder.append(this.src.substring(n, n2));
        return new ParseException(stringBuilder.toString());
    }

    private Object readArray() throws ParseException {
        int n;
        this.consumeWhitespace();
        int n2 = this.pos++;
        if (n2 < this.length && this.src.charAt(n2) == ']') {
            return this.cx.newArray(this.scope, 0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        n2 = 0;
        while ((n = this.pos) < this.length) {
            block10: {
                block9: {
                    block6: {
                        block7: {
                            block8: {
                                if ((n = (int)this.src.charAt(n)) == 44) break block6;
                                if (n == 93) break block7;
                                if (n2 != 0) break block8;
                                arrayList.add(this.readValue());
                                n2 = 1;
                                break block9;
                            }
                            throw new ParseException("Missing comma in array literal");
                        }
                        if (n2 != 0) {
                            ++this.pos;
                            return this.cx.newArray(this.scope, arrayList.toArray());
                        }
                        throw new ParseException("Unexpected comma in array literal");
                    }
                    if (n2 == 0) break block10;
                    ++this.pos;
                    n2 = 0;
                }
                this.consumeWhitespace();
                continue;
            }
            throw new ParseException("Unexpected comma in array literal");
        }
        throw new ParseException("Unterminated array literal");
    }

    private void readDigits() {
        int n;
        while ((n = this.pos) < this.length && (n = (int)this.src.charAt(n)) >= 48 && n <= 57) {
            ++this.pos;
        }
    }

    private Boolean readFalse() throws ParseException {
        int n = this.length;
        int n2 = this.pos;
        if (n - n2 >= 4 && this.src.charAt(n2) == 'a' && this.src.charAt(this.pos + 1) == 'l' && this.src.charAt(this.pos + 2) == 's' && this.src.charAt(this.pos + 3) == 'e') {
            this.pos += 4;
            return Boolean.FALSE;
        }
        throw new ParseException("Unexpected token: f");
    }

    private Object readNull() throws ParseException {
        int n = this.length;
        int n2 = this.pos;
        if (n - n2 >= 3 && this.src.charAt(n2) == 'u' && this.src.charAt(this.pos + 1) == 'l' && this.src.charAt(this.pos + 2) == 'l') {
            this.pos += 3;
            return null;
        }
        throw new ParseException("Unexpected token: n");
    }

    private Number readNumber(char c) throws ParseException {
        double d;
        int n;
        block11: {
            block13: {
                block12: {
                    n = this.pos - 1;
                    char c2 = c;
                    if (c == '-' && ((c2 = this.nextOrNumberError(n)) < '0' || c2 > '9')) {
                        throw this.numberError(n, this.pos);
                    }
                    if (c2 != '0') {
                        this.readDigits();
                    }
                    if ((c = (char)this.pos) < this.length && this.src.charAt(c) == '.') {
                        ++this.pos;
                        c = this.nextOrNumberError(n);
                        if (c >= '0' && c <= '9') {
                            this.readDigits();
                        } else {
                            throw this.numberError(n, this.pos);
                        }
                    }
                    if ((c = (char)this.pos) >= this.length || (c = this.src.charAt(c)) != 'e' && c != 'E') break block11;
                    ++this.pos;
                    c2 = this.nextOrNumberError(n);
                    if (c2 == '-') break block12;
                    c = c2;
                    if (c2 != '+') break block13;
                }
                c = this.nextOrNumberError(n);
            }
            if (c >= '0' && c <= '9') {
                this.readDigits();
            } else {
                throw this.numberError(n, this.pos);
            }
        }
        if ((double)(c = (char)(d = Double.parseDouble(this.src.substring(n, this.pos)))) == d) {
            return (int)c;
        }
        return d;
    }

    private Object readObject() throws ParseException {
        int n;
        this.consumeWhitespace();
        Scriptable scriptable = this.cx.newObject(this.scope);
        int n2 = this.pos++;
        if (n2 < this.length && this.src.charAt(n2) == '}') {
            return scriptable;
        }
        n2 = 0;
        while ((n = this.pos) < this.length) {
            block13: {
                block12: {
                    String string2;
                    block10: {
                        block11: {
                            string2 = this.src;
                            this.pos = n + 1;
                            if ((n = (int)string2.charAt(n)) == 34) break block10;
                            if (n != 44) {
                                if (n == 125) {
                                    if (n2 != 0) {
                                        return scriptable;
                                    }
                                    throw new ParseException("Unexpected comma in object literal");
                                }
                                throw new ParseException("Unexpected token in object literal");
                            }
                            if (n2 == 0) break block11;
                            n2 = 0;
                            break block12;
                        }
                        throw new ParseException("Unexpected comma in object literal");
                    }
                    if (n2 != 0) break block13;
                    string2 = this.readString();
                    this.consume(':');
                    Object object = this.readValue();
                    long l = ScriptRuntime.indexFromString(string2);
                    if (l < 0L) {
                        scriptable.put(string2, scriptable, object);
                    } else {
                        scriptable.put((int)l, scriptable, object);
                    }
                    n2 = 1;
                }
                this.consumeWhitespace();
                continue;
            }
            throw new ParseException("Missing comma in object literal");
        }
        throw new ParseException("Unterminated object literal");
    }

    /*
     * Enabled aggressive block sorting
     */
    private String readString() throws ParseException {
        CharSequence charSequence;
        int n;
        int n2 = this.pos;
        while ((n = this.pos) < this.length) {
            charSequence = this.src;
            this.pos = n + 1;
            if ((n = (int)((String)charSequence).charAt(n)) <= 31) {
                throw new ParseException("String contains control character");
            }
            if (n == 92) break;
            if (n != 34) continue;
            return this.src.substring(n2, this.pos - 1);
        }
        charSequence = new StringBuilder();
        block1: while (true) {
            CharSequence charSequence2;
            block14: {
                block15: {
                    block16: {
                        block17: {
                            block18: {
                                block19: {
                                    block20: {
                                        if ((n = this.pos) >= this.length) {
                                            throw new ParseException("Unterminated string literal");
                                        }
                                        ((StringBuilder)charSequence).append(this.src, n2, n - 1);
                                        n2 = this.pos;
                                        if (n2 >= this.length) {
                                            throw new ParseException("Unterminated string");
                                        }
                                        charSequence2 = this.src;
                                        this.pos = n2 + 1;
                                        char c = ((String)charSequence2).charAt(n2);
                                        if (c == '\"') break block15;
                                        if (c == '/') break block16;
                                        if (c == '\\') break block17;
                                        if (c == 'b') break block18;
                                        if (c == 'f') break block19;
                                        if (c == 'n') break block20;
                                        if (c != 'r') {
                                            if (c != 't') {
                                                if (c != 'u') {
                                                    charSequence = new StringBuilder();
                                                    ((StringBuilder)charSequence).append("Unexpected character in string: '\\");
                                                    ((StringBuilder)charSequence).append(c);
                                                    ((StringBuilder)charSequence).append("'");
                                                    throw new ParseException(((StringBuilder)charSequence).toString());
                                                }
                                                n = this.length;
                                                n2 = this.pos;
                                                if (n - n2 < 5) {
                                                    charSequence = new StringBuilder();
                                                    ((StringBuilder)charSequence).append("Invalid character code: \\u");
                                                    ((StringBuilder)charSequence).append(this.src.substring(this.pos));
                                                    throw new ParseException(((StringBuilder)charSequence).toString());
                                                }
                                                if ((n2 = this.fromHex(this.src.charAt(n2 + 0)) << 12 | this.fromHex(this.src.charAt(this.pos + 1)) << 8 | this.fromHex(this.src.charAt(this.pos + 2)) << 4 | this.fromHex(this.src.charAt(this.pos + 3))) < 0) {
                                                    charSequence2 = new StringBuilder();
                                                    ((StringBuilder)charSequence2).append("Invalid character code: ");
                                                    charSequence = this.src;
                                                    n2 = this.pos;
                                                    ((StringBuilder)charSequence2).append(((String)charSequence).substring(n2, n2 + 4));
                                                    throw new ParseException(((StringBuilder)charSequence2).toString());
                                                }
                                                this.pos += 4;
                                                ((StringBuilder)charSequence).append((char)n2);
                                                break block14;
                                            } else {
                                                ((StringBuilder)charSequence).append('\t');
                                            }
                                            break block14;
                                        } else {
                                            ((StringBuilder)charSequence).append('\r');
                                        }
                                        break block14;
                                    }
                                    ((StringBuilder)charSequence).append('\n');
                                    break block14;
                                }
                                ((StringBuilder)charSequence).append('\f');
                                break block14;
                            }
                            ((StringBuilder)charSequence).append('\b');
                            break block14;
                        }
                        ((StringBuilder)charSequence).append('\\');
                        break block14;
                    }
                    ((StringBuilder)charSequence).append('/');
                    break block14;
                }
                ((StringBuilder)charSequence).append('\"');
            }
            n = this.pos;
            do {
                int n3 = this.pos;
                n2 = n;
                if (n3 >= this.length) continue block1;
                charSequence2 = this.src;
                this.pos = n3 + 1;
                n2 = ((String)charSequence2).charAt(n3);
                if (n2 <= 31) {
                    throw new ParseException("String contains control character");
                }
                if (n2 != 92) continue;
                n2 = n;
                continue block1;
            } while (n2 != 34);
            break;
        }
        ((StringBuilder)charSequence).append(this.src, n, this.pos - 1);
        return ((StringBuilder)charSequence).toString();
    }

    private Boolean readTrue() throws ParseException {
        int n = this.length;
        int n2 = this.pos;
        if (n - n2 >= 3 && this.src.charAt(n2) == 'r' && this.src.charAt(this.pos + 1) == 'u' && this.src.charAt(this.pos + 2) == 'e') {
            this.pos += 3;
            return Boolean.TRUE;
        }
        throw new ParseException("Unexpected token: t");
    }

    private Object readValue() throws ParseException {
        this.consumeWhitespace();
        int n = this.pos;
        if (n < this.length) {
            CharSequence charSequence = this.src;
            this.pos = n + 1;
            char c = ((String)charSequence).charAt(n);
            if (c != '\"') {
                if (c != '-') {
                    if (c != '[') {
                        if (c != 'f') {
                            if (c != 'n') {
                                if (c != 't') {
                                    if (c != '{') {
                                        switch (c) {
                                            default: {
                                                charSequence = new StringBuilder();
                                                ((StringBuilder)charSequence).append("Unexpected token: ");
                                                ((StringBuilder)charSequence).append(c);
                                                throw new ParseException(((StringBuilder)charSequence).toString());
                                            }
                                            case '0': 
                                            case '1': 
                                            case '2': 
                                            case '3': 
                                            case '4': 
                                            case '5': 
                                            case '6': 
                                            case '7': 
                                            case '8': 
                                            case '9': {
                                                return this.readNumber(c);
                                            }
                                        }
                                    }
                                    return this.readObject();
                                }
                                return this.readTrue();
                            }
                            return this.readNull();
                        }
                        return this.readFalse();
                    }
                    return this.readArray();
                }
                return this.readNumber(c);
            }
            return this.readString();
        }
        throw new ParseException("Empty JSON string");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parseValue(String object) throws ParseException {
        synchronized (this) {
            Throwable throwable2;
            block6: {
                if (object != null) {
                    block5: {
                        try {
                            this.pos = 0;
                            this.length = ((String)object).length();
                            this.src = object;
                            object = this.readValue();
                            this.consumeWhitespace();
                            int n = this.pos;
                            int n2 = this.length;
                            if (n < n2) break block5;
                        }
                        catch (Throwable throwable2) {
                            break block6;
                        }
                        return object;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Expected end of stream at char ");
                    stringBuilder.append(this.pos);
                    object = new ParseException(stringBuilder.toString());
                    throw object;
                }
                object = new ParseException("Input string may not be null");
                throw object;
            }
            throw throwable2;
        }
    }

    public static class ParseException
    extends Exception {
        static final long serialVersionUID = 4804542791749920772L;

        ParseException(Exception exception) {
            super(exception);
        }

        ParseException(String string2) {
            super(string2);
        }
    }
}

