/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.BitSet;
import java.util.HashMap;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class Block {
    static final boolean DEBUG = false;
    private static int debug_blockCount;
    private int itsBlockID;
    private int itsEndNodeIndex;
    private BitSet itsLiveOnEntrySet;
    private BitSet itsLiveOnExitSet;
    private BitSet itsNotDefSet;
    private Block[] itsPredecessors;
    private int itsStartNodeIndex;
    private Block[] itsSuccessors;
    private BitSet itsUseBeforeDefSet;

    Block(int n, int n2) {
        this.itsStartNodeIndex = n;
        this.itsEndNodeIndex = n2;
    }

    private static boolean assignType(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = n2 |= nArray[n];
        boolean bl = n3 != n2;
        return bl;
    }

    private static Block[] buildBlocks(Node[] objectArray) {
        Object object;
        int n;
        int n2;
        Object object2 = new HashMap<Object, FatBlock>();
        ObjArray objArray = new ObjArray();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            n = objectArray[n2].getType();
            if (n != 5 && n != 6 && n != 7) {
                if (n != 132) {
                    n = n4;
                } else {
                    n = n4;
                    if (n2 != n4) {
                        object = Block.newFatBlock(n4, n2 - 1);
                        if (((Node)objectArray[n4]).getType() == 132) {
                            object2.put(objectArray[n4], object);
                        }
                        objArray.add(object);
                        n = n2;
                    }
                }
            } else {
                object = Block.newFatBlock(n4, n2);
                if (objectArray[n4].getType() == 132) {
                    object2.put(objectArray[n4], object);
                }
                objArray.add(object);
                n = n2 + 1;
            }
            n4 = n;
        }
        if (n4 != objectArray.length) {
            object = Block.newFatBlock(n4, objectArray.length - 1);
            if (objectArray[n4].getType() == 132) {
                object2.put(objectArray[n4], object);
            }
            objArray.add(object);
        }
        for (n2 = 0; n2 < objArray.size(); ++n2) {
            object = (FatBlock)objArray.get(n2);
            FatBlock fatBlock = object;
            Object object3 = objectArray[((FatBlock)object).realBlock.itsEndNodeIndex];
            n = ((Node)object3).getType();
            if (n != 5 && n2 < objArray.size() - 1) {
                FatBlock fatBlock2 = fatBlock = (FatBlock)objArray.get(n2 + 1);
                ((FatBlock)object).addSuccessor(fatBlock);
                fatBlock.addPredecessor((FatBlock)object);
            }
            if (n != 7 && n != 6 && n != 5) continue;
            object3 = ((Jump)object3).target;
            fatBlock = (FatBlock)object2.get(object3);
            ((Node)object3).putProp(6, fatBlock.realBlock);
            ((FatBlock)object).addSuccessor(fatBlock);
            fatBlock.addPredecessor((FatBlock)object);
        }
        objectArray = new Block[objArray.size()];
        for (n2 = n3; n2 < objArray.size(); ++n2) {
            object2 = (FatBlock)objArray.get(n2);
            object = (FatBlock)object2;
            object = ((FatBlock)object2).realBlock;
            ((Block)object).itsSuccessors = ((FatBlock)object2).getSuccessors();
            ((Block)object).itsPredecessors = ((FatBlock)object2).getPredecessors();
            ((Block)object).itsBlockID = n2;
            objectArray[n2] = object;
        }
        return objectArray;
    }

    private boolean doReachedUseDataFlow() {
        this.itsLiveOnExitSet.clear();
        if (this.itsSuccessors != null) {
            Block[] blockArray;
            for (int i = 0; i < (blockArray = this.itsSuccessors).length; ++i) {
                this.itsLiveOnExitSet.or(blockArray[i].itsLiveOnEntrySet);
            }
        }
        return this.updateEntrySet(this.itsLiveOnEntrySet, this.itsLiveOnExitSet, this.itsUseBeforeDefSet, this.itsNotDefSet);
    }

    private boolean doTypeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, int[] nArray) {
        boolean bl = false;
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            Node node = nodeArray[i];
            boolean bl2 = bl;
            if (node != null) {
                bl2 = bl | Block.findDefPoints(optFunctionNode, node, nArray);
            }
            bl = bl2;
        }
        return bl;
    }

    private static boolean findDefPoints(OptFunctionNode optFunctionNode, Node node, int[] nArray) {
        boolean bl;
        block11: {
            int n;
            int n2;
            boolean bl2;
            block12: {
                Node node2;
                block10: {
                    node2 = node.getFirstChild();
                    bl2 = false;
                    for (Node node3 = node2; node3 != null; node3 = node3.getNext()) {
                        bl2 |= Block.findDefPoints(optFunctionNode, node3, nArray);
                    }
                    n2 = node.getType();
                    if (n2 == 56 || n2 == 157) break block10;
                    if (n2 != 107 && n2 != 108) {
                        bl = bl2;
                    } else {
                        bl = bl2;
                        if (node2.getType() == 55) {
                            n2 = optFunctionNode.getVarIndex(node2);
                            bl = bl2;
                            if (!optFunctionNode.fnode.getParamAndVarConst()[n2]) {
                                bl = Block.assignType(nArray, n2, 1) | bl2;
                            }
                        }
                    }
                    break block11;
                }
                n = Block.findExpressionType(optFunctionNode, node2.getNext(), nArray);
                n2 = optFunctionNode.getVarIndex(node);
                if (node.getType() != 56) break block12;
                bl = bl2;
                if (optFunctionNode.fnode.getParamAndVarConst()[n2]) break block11;
            }
            bl = bl2 | Block.assignType(nArray, n2, n);
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private static int findExpressionType(OptFunctionNode var0, Node var1_2, int[] var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initLiveOnEntrySets(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n = optFunctionNode.getVarCount();
        this.itsUseBeforeDefSet = new BitSet(n);
        this.itsNotDefSet = new BitSet(n);
        this.itsLiveOnEntrySet = new BitSet(n);
        this.itsLiveOnExitSet = new BitSet(n);
        for (int i = this.itsStartNodeIndex; i <= this.itsEndNodeIndex; ++i) {
            this.lookForVariableAccess(optFunctionNode, nodeArray[i]);
        }
        this.itsNotDefSet.flip(0, n);
    }

    private void lookForVariableAccess(OptFunctionNode optFunctionNode, Node node) {
        block10: {
            int n;
            block6: {
                block7: {
                    block8: {
                        block9: {
                            n = node.getType();
                            if (n == 55) break block6;
                            if (n == 56) break block7;
                            if (n == 107 || n == 108) break block8;
                            if (n == 138) break block9;
                            if (n == 157) break block7;
                            for (node = node.getFirstChild(); node != null; node = node.getNext()) {
                                this.lookForVariableAccess(optFunctionNode, node);
                            }
                            break block10;
                        }
                        n = optFunctionNode.fnode.getIndexForNameNode(node);
                        if (n > -1 && !this.itsNotDefSet.get(n)) {
                            this.itsUseBeforeDefSet.set(n);
                        }
                        break block10;
                    }
                    if ((node = node.getFirstChild()).getType() == 55) {
                        n = optFunctionNode.getVarIndex(node);
                        if (!this.itsNotDefSet.get(n)) {
                            this.itsUseBeforeDefSet.set(n);
                        }
                        this.itsNotDefSet.set(n);
                    } else {
                        this.lookForVariableAccess(optFunctionNode, node);
                    }
                    break block10;
                }
                this.lookForVariableAccess(optFunctionNode, node.getFirstChild().getNext());
                this.itsNotDefSet.set(optFunctionNode.getVarIndex(node));
                break block10;
            }
            n = optFunctionNode.getVarIndex(node);
            if (!this.itsNotDefSet.get(n)) {
                this.itsUseBeforeDefSet.set(n);
            }
        }
    }

    private void markAnyTypeVariables(int[] nArray) {
        for (int i = 0; i != nArray.length; ++i) {
            if (!this.itsLiveOnEntrySet.get(i)) continue;
            Block.assignType(nArray, i, 3);
        }
    }

    private static FatBlock newFatBlock(int n, int n2) {
        FatBlock fatBlock = new FatBlock();
        fatBlock.realBlock = new Block(n, n2);
        return fatBlock;
    }

    private void printLiveOnEntrySet(OptFunctionNode optFunctionNode) {
    }

    private static void reachingDefDataFlow(OptFunctionNode object, Node[] objectArray, Block[] blockArray, int[] nArray) {
        int n;
        for (n = 0; n < blockArray.length; ++n) {
            blockArray[n].initLiveOnEntrySets((OptFunctionNode)object, (Node[])objectArray);
        }
        object = new boolean[blockArray.length];
        boolean[] blArray = new boolean[blockArray.length];
        int n2 = blockArray.length - 1;
        object[n2] = true;
        block1: while (true) {
            n = 0;
            while (true) {
                int n3;
                block12: {
                    block11: {
                        if (object[n2] != false) break block11;
                        n3 = n;
                        if (blArray[n2]) break block12;
                    }
                    blArray[n2] = true;
                    object[n2] = false;
                    n3 = n;
                    if (blockArray[n2].doReachedUseDataFlow()) {
                        objectArray = blockArray[n2].itsPredecessors;
                        n3 = n;
                        if (objectArray != null) {
                            int n4 = 0;
                            while (true) {
                                n3 = n;
                                if (n4 >= objectArray.length) break;
                                n3 = ((Block)objectArray[n4]).itsBlockID;
                                object[n3] = true;
                                n3 = n3 > n2 ? 1 : 0;
                                n |= n3;
                                ++n4;
                            }
                        }
                    }
                }
                if (n2 == 0) {
                    if (n3 != 0) {
                        n2 = blockArray.length - 1;
                        continue block1;
                    }
                    blockArray[0].markAnyTypeVariables(nArray);
                    return;
                }
                --n2;
                n = n3;
            }
            break;
        }
    }

    static void runFlowAnalyzes(OptFunctionNode optFunctionNode, Node[] nodeArray) {
        int n;
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = optFunctionNode.fnode.getParamAndVarCount();
        int[] nArray = new int[n3];
        for (n = 0; n != n2; ++n) {
            nArray[n] = 3;
        }
        for (n = n2; n != n3; ++n) {
            nArray[n] = 0;
        }
        Block[] blockArray = Block.buildBlocks(nodeArray);
        Block.reachingDefDataFlow(optFunctionNode, nodeArray, blockArray, nArray);
        Block.typeFlow(optFunctionNode, nodeArray, blockArray, nArray);
        while (n2 != n3) {
            if (nArray[n2] == 1) {
                optFunctionNode.setIsNumberVar(n2);
            }
            ++n2;
        }
    }

    private static String toString(Block[] blockArray, Node[] nodeArray) {
        return null;
    }

    private static void typeFlow(OptFunctionNode optFunctionNode, Node[] nodeArray, Block[] blockArray, int[] nArray) {
        boolean[] blArray = new boolean[blockArray.length];
        boolean[] blArray2 = new boolean[blockArray.length];
        blArray[0] = true;
        block0: while (true) {
            int n = 0;
            int n2 = 0;
            while (true) {
                int n3;
                block10: {
                    block9: {
                        if (blArray[n]) break block9;
                        n3 = n2;
                        if (blArray2[n]) break block10;
                    }
                    blArray2[n] = true;
                    blArray[n] = false;
                    n3 = n2;
                    if (blockArray[n].doTypeFlow(optFunctionNode, nodeArray, nArray)) {
                        Block[] blockArray2 = blockArray[n].itsSuccessors;
                        n3 = n2;
                        if (blockArray2 != null) {
                            int n4 = 0;
                            while (true) {
                                n3 = n2;
                                if (n4 >= blockArray2.length) break;
                                n3 = blockArray2[n4].itsBlockID;
                                blArray[n3] = true;
                                n3 = n3 < n ? 1 : 0;
                                n2 |= n3;
                                ++n4;
                            }
                        }
                    }
                }
                if (n == blockArray.length - 1) {
                    if (n3 != 0) continue block0;
                    return;
                }
                ++n;
                n2 = n3;
            }
            break;
        }
    }

    private boolean updateEntrySet(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        int n = bitSet.cardinality();
        bitSet.or(bitSet2);
        bitSet.and(bitSet4);
        bitSet.or(bitSet3);
        boolean bl = bitSet.cardinality() != n;
        return bl;
    }

    private static class FatBlock {
        private ObjToIntMap predecessors;
        Block realBlock;
        private ObjToIntMap successors = new ObjToIntMap();

        private FatBlock() {
            this.predecessors = new ObjToIntMap();
        }

        private static Block[] reduceToArray(ObjToIntMap object) {
            if (!object.isEmpty()) {
                Block[] blockArray = new Block[object.size()];
                int n = 0;
                ObjToIntMap.Iterator iterator2 = object.newIterator();
                iterator2.start();
                while (true) {
                    object = blockArray;
                    if (!iterator2.done()) {
                        FatBlock fatBlock = (FatBlock)iterator2.getKey();
                        object = fatBlock;
                        blockArray[n] = fatBlock.realBlock;
                        iterator2.next();
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                object = null;
            }
            return object;
        }

        void addPredecessor(FatBlock fatBlock) {
            this.predecessors.put(fatBlock, 0);
        }

        void addSuccessor(FatBlock fatBlock) {
            this.successors.put(fatBlock, 0);
        }

        Block[] getPredecessors() {
            return FatBlock.reduceToArray(this.predecessors);
        }

        Block[] getSuccessors() {
            return FatBlock.reduceToArray(this.successors);
        }
    }
}

