/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;

class BodyCodegen {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final int ECMAERROR_EXCEPTION = 2;
    private static final int EVALUATOR_EXCEPTION = 1;
    private static final int EXCEPTION_MAX = 5;
    private static final int FINALLY_EXCEPTION = 4;
    static final int GENERATOR_START = 0;
    static final int GENERATOR_TERMINATE = -1;
    static final int GENERATOR_YIELD_START = 1;
    private static final int JAVASCRIPT_EXCEPTION = 0;
    private static final int MAX_LOCALS = 1024;
    private static final int THROWABLE_EXCEPTION = 3;
    private short argsLocal;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    private short contextLocal;
    private int enterAreaStartLabel;
    private int epilogueLabel;
    private ExceptionManager exceptionManager = new ExceptionManager();
    private Map<Node, FinallyReturnPoint> finallys;
    private short firstFreeLocal;
    private OptFunctionNode fnCurrent;
    private short funObjLocal;
    private short generatorStateLocal;
    private int generatorSwitch;
    private boolean hasVarsInRegs;
    private boolean inDirectCallFunction;
    private boolean inLocalBlock;
    private boolean isGenerator;
    private boolean itsForcedObjectParameters;
    private int itsLineNumber;
    private short itsOneArgArray;
    private short itsZeroArgArray;
    private List<Node> literals;
    private int[] locals;
    private short localsMax;
    private int maxLocals = 0;
    private int maxStack = 0;
    private short operationLocal;
    private short popvLocal;
    private int savedCodeOffset;
    ScriptNode scriptOrFn;
    public int scriptOrFnIndex;
    private short thisObjLocal;
    private short[] varRegisters;
    private short variableObjectLocal;

    BodyCodegen() {
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private void addGoto(Node node, int n) {
        int n2 = this.getTargetLabel(node);
        this.cfw.add(n, n2);
    }

    private void addGotoWithReturn(Node node) {
        FinallyReturnPoint finallyReturnPoint = this.finallys.get(node);
        this.cfw.addLoadConstant(finallyReturnPoint.jsrPoints.size());
        this.addGoto(node, 167);
        int n = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        finallyReturnPoint.jsrPoints.add(n);
    }

    private void addInstructionCount() {
        this.addInstructionCount(Math.max(this.cfw.getCurrentCodeOffset() - this.savedCodeOffset, 1));
    }

    private void addInstructionCount(int n) {
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(n);
        this.addScriptRuntimeInvoke("addInstructionCount", "(Lorg/mozilla/javascript/Context;I)V");
    }

    private void addJumpedBooleanWrap(int n, int n2) {
        this.cfw.markLabel(n2);
        n2 = this.cfw.acquireLabel();
        this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cfw.add(167, n2);
        this.cfw.markLabel(n);
        this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        this.cfw.markLabel(n2);
        this.cfw.adjustStackTop(-1);
    }

    private void addLoadPropertyIds(Object[] objectArray, int n) {
        this.addNewObjectArray(n);
        for (int i = 0; i != n; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            Object object = objectArray[i];
            if (object instanceof String) {
                this.cfw.addPush((String)object);
            } else {
                this.cfw.addPush((Integer)object);
                this.addScriptRuntimeInvoke("wrapInt", "(I)Ljava/lang/Integer;");
            }
            this.cfw.add(83);
        }
    }

    private void addLoadPropertyValues(Node node, Node node2, int n) {
        int n2;
        boolean bl = this.isGenerator;
        int n3 = 0;
        if (bl) {
            for (n2 = 0; n2 != n; ++n2) {
                int n4 = node2.getType();
                if (n4 != 152 && n4 != 153 && n4 != 164) {
                    this.generateExpression(node2, node);
                } else {
                    this.generateExpression(node2.getFirstChild(), node);
                }
                node2 = node2.getNext();
            }
            this.addNewObjectArray(n);
            for (n2 = n3; n2 != n; ++n2) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(n - n2 - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            this.addNewObjectArray(n);
            for (n2 = 0; n2 != n; ++n2) {
                this.cfw.add(89);
                this.cfw.addPush(n2);
                n3 = node2.getType();
                if (n3 != 152 && n3 != 153 && n3 != 164) {
                    this.generateExpression(node2, node);
                } else {
                    this.generateExpression(node2.getFirstChild(), node);
                }
                this.cfw.add(83);
                node2 = node2.getNext();
            }
        }
    }

    private void addNewObjectArray(int n) {
        if (n == 0) {
            n = this.itsZeroArgArray;
            if (n >= 0) {
                this.cfw.addALoad(n);
            } else {
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else {
            this.cfw.addPush(n);
            this.cfw.add(189, "java/lang/Object");
        }
    }

    private void addObjectToDouble() {
        this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
    }

    private void addOptRuntimeInvoke(String string2, String string3) {
        this.cfw.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", string2, string3);
    }

    private void addScriptRuntimeInvoke(String string2, String string3) {
        this.cfw.addInvoke(184, "org.mozilla.javascript.ScriptRuntime", string2, string3);
    }

    private void dcpLoadAsNumber(int n) {
        this.cfw.addALoad(n);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int n2 = this.cfw.acquireLabel();
        this.cfw.add(165, n2);
        short s = this.cfw.getStackTop();
        this.cfw.addALoad(n);
        this.addObjectToDouble();
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        this.cfw.markLabel(n2, s);
        this.cfw.addDLoad(n + 1);
        this.cfw.markLabel(n3);
    }

    private void dcpLoadAsObject(int n) {
        this.cfw.addALoad(n);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int n2 = this.cfw.acquireLabel();
        this.cfw.add(165, n2);
        short s = this.cfw.getStackTop();
        this.cfw.addALoad(n);
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        this.cfw.markLabel(n2, s);
        this.cfw.addDLoad(n + 1);
        this.addDoubleWrap();
        this.cfw.markLabel(n3);
    }

    private void decReferenceWordLocal(short s) {
        int[] nArray = this.locals;
        nArray[s] = nArray[s] - 1;
    }

    private String exceptionTypeToName(int n) {
        if (n == 0) {
            return "org/mozilla/javascript/JavaScriptException";
        }
        if (n == 1) {
            return "org/mozilla/javascript/EvaluatorException";
        }
        if (n == 2) {
            return "org/mozilla/javascript/EcmaError";
        }
        if (n == 3) {
            return "java/lang/Throwable";
        }
        if (n == 4) {
            return null;
        }
        throw Kit.codeBug();
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        if (n2 != -1) {
            switch (n) {
                default: {
                    throw Codegen.badTree();
                }
                case 17: {
                    this.cfw.add(151);
                    this.cfw.add(156, n2);
                    break;
                }
                case 16: {
                    this.cfw.add(151);
                    this.cfw.add(157, n2);
                    break;
                }
                case 15: {
                    this.cfw.add(152);
                    this.cfw.add(158, n2);
                    break;
                }
                case 14: {
                    this.cfw.add(152);
                    this.cfw.add(155, n2);
                }
            }
            if (n3 != -1) {
                this.cfw.add(167, n3);
            }
            return;
        }
        throw Codegen.badTree();
    }

    private void generateActivationExit() {
        if (this.fnCurrent != null && !this.hasVarsInRegs) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("exitActivationFunction", "(Lorg/mozilla/javascript/Context;)V");
            return;
        }
        throw Kit.codeBug();
    }

    private void generateArrayLiteralFactory(Node node, int n) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.codegen.getBodyMethodName(this.scriptOrFn));
        charSequence.append("_literal");
        charSequence.append(n);
        charSequence = charSequence.toString();
        this.initBodyGeneration();
        n = this.firstFreeLocal;
        short s = (short)(n + 1);
        this.firstFreeLocal = s;
        this.argsLocal = (short)n;
        this.localsMax = s;
        this.cfw.startMethod((String)charSequence, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)2);
        this.visitArrayLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateCallArgArray(Node node, Node node2, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getNext()) {
            ++n3;
        }
        if (n3 == 1 && (n = this.itsOneArgArray) >= 0) {
            this.cfw.addALoad(n);
        } else {
            this.addNewObjectArray(n3);
        }
        while (n2 != n3) {
            if (!this.isGenerator) {
                this.cfw.add(89);
                this.cfw.addPush(n2);
            }
            if (!bl) {
                this.generateExpression(node2, node);
            } else {
                n = this.nodeIsDirectCallParameter(node2);
                if (n >= 0) {
                    this.dcpLoadAsObject(n);
                } else {
                    this.generateExpression(node2, node);
                    if (node2.getIntProp(8, -1) == 0) {
                        this.addDoubleWrap();
                    }
                }
            }
            if (this.isGenerator) {
                short s = this.getNewWordLocal();
                this.cfw.addAStore(s);
                this.cfw.add(192, "[Ljava/lang/Object;");
                this.cfw.add(89);
                this.cfw.addPush(n2);
                this.cfw.addALoad(s);
                this.releaseWordLocal(s);
            }
            this.cfw.add(83);
            node2 = node2.getNext();
            ++n2;
        }
    }

    private void generateCatchBlock(int n, short s, int n2, int n3, int n4) {
        int n5 = n4;
        if (n4 == 0) {
            n5 = this.cfw.acquireLabel();
        }
        this.cfw.markHandler(n5);
        this.cfw.addAStore(n3);
        this.cfw.addALoad(s);
        this.cfw.addAStore(this.variableObjectLocal);
        this.exceptionTypeToName(n);
        this.cfw.add(167, n2);
    }

    private void generateCheckForThrowOrClose(int n, boolean bl, int n2) {
        int n3 = this.cfw.acquireLabel();
        int n4 = this.cfw.acquireLabel();
        this.cfw.markLabel(n3);
        this.cfw.addALoad(this.argsLocal);
        this.generateThrowJavaScriptException();
        this.cfw.markLabel(n4);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.add(192, "java/lang/Throwable");
        this.cfw.add(191);
        if (n != -1) {
            this.cfw.markLabel(n);
        }
        if (!bl) {
            this.cfw.markTableSwitchCase(this.generatorSwitch, n2);
        }
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(2);
        this.cfw.add(159, n4);
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(1);
        this.cfw.add(159, n3);
    }

    private void generateEpilogue() {
        int n;
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.addInstructionCount();
        }
        if (this.isGenerator) {
            int n2;
            Map<Node, int[]> map = ((FunctionNode)this.scriptOrFn).getLiveLocals();
            if (map != null) {
                List<Node> object = ((FunctionNode)this.scriptOrFn).getResumptionPoints();
                for (n = 0; n < object.size(); ++n) {
                    Node node = object.get(n);
                    int[] nArray = (int[])map.get(node);
                    if (nArray == null) continue;
                    this.cfw.markTableSwitchCase(this.generatorSwitch, this.getNextGeneratorState(node));
                    this.generateGetGeneratorLocalsState();
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        this.cfw.add(89);
                        this.cfw.addLoadConstant(n2);
                        this.cfw.add(50);
                        this.cfw.addAStore(nArray[n2]);
                    }
                    this.cfw.add(87);
                    this.cfw.add(167, this.getTargetLabel(node));
                }
            }
            if ((map = this.finallys) != null) {
                for (Node node : map.keySet()) {
                    if (node.getType() != 126) continue;
                    FinallyReturnPoint finallyReturnPoint = this.finallys.get(node);
                    this.cfw.markLabel(finallyReturnPoint.tableLabel, (short)1);
                    int n3 = this.cfw.addTableSwitch(0, finallyReturnPoint.jsrPoints.size() - 1);
                    this.cfw.markTableSwitchDefault(n3);
                    n = 0;
                    for (n2 = 0; n2 < finallyReturnPoint.jsrPoints.size(); ++n2) {
                        this.cfw.markTableSwitchCase(n3, n);
                        this.cfw.add(167, finallyReturnPoint.jsrPoints.get(n2));
                        ++n;
                    }
                }
            }
        }
        if ((n = this.epilogueLabel) != -1) {
            this.cfw.markLabel(n);
        }
        if (this.hasVarsInRegs) {
            this.cfw.add(176);
            return;
        }
        if (this.isGenerator) {
            if (((FunctionNode)this.scriptOrFn).getResumptionPoints() != null) {
                this.cfw.markTableSwitchDefault(this.generatorSwitch);
            }
            this.generateSetGeneratorResumptionPoint(-1);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addOptRuntimeInvoke("throwStopIteration", "(Ljava/lang/Object;)V");
            Codegen.pushUndefined(this.cfw);
            this.cfw.add(176);
        } else if (this.fnCurrent == null) {
            this.cfw.addALoad(this.popvLocal);
            this.cfw.add(176);
        } else {
            this.generateActivationExit();
            this.cfw.add(176);
            n = this.cfw.acquireLabel();
            this.cfw.markHandler(n);
            short s = this.getNewWordLocal();
            this.cfw.addAStore(s);
            this.generateActivationExit();
            this.cfw.addALoad(s);
            this.releaseWordLocal(s);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(this.enterAreaStartLabel, this.epilogueLabel, n, null);
        }
    }

    /*
     * Exception decompiling
     */
    private void generateExpression(Node var1_1, Node var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateFunctionAndThisObj(Node object, Node node) {
        block7: {
            int n;
            block5: {
                block6: {
                    n = ((Node)object).getType();
                    int n2 = ((Node)object).getType();
                    if (n2 == 33) break block5;
                    if (n2 == 34) break block6;
                    if (n2 == 36) break block5;
                    if (n2 != 39) {
                        this.generateExpression((Node)object, node);
                        this.cfw.addALoad(this.contextLocal);
                        this.addScriptRuntimeInvoke("getValueFunctionAndThis", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Callable;");
                    } else {
                        object = ((Node)object).getString();
                        this.cfw.addPush((String)object);
                        this.cfw.addALoad(this.contextLocal);
                        this.cfw.addALoad(this.variableObjectLocal);
                        this.addScriptRuntimeInvoke("getNameFunctionAndThis", "(Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
                    }
                    break block7;
                }
                throw Kit.codeBug();
            }
            node = ((Node)object).getFirstChild();
            this.generateExpression(node, (Node)object);
            node = node.getNext();
            if (n == 33) {
                object = node.getString();
                this.cfw.addPush((String)object);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getPropFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
            } else {
                this.generateExpression(node, (Node)object);
                if (((Node)object).getIntProp(8, -1) != -1) {
                    this.addDoubleWrap();
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getElemFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("lastStoredScriptable", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void generateGenerator() {
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        short s2 = (short)(s + 1);
        this.firstFreeLocal = s2;
        this.argsLocal = s;
        this.localsMax = s2;
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        this.cfw.addALoad(this.funObjLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addPush(this.scriptOrFn.isInStrictMode());
        this.addScriptRuntimeInvoke("createFunctionActivation", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Z)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(this.scriptOrFnIndex);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        this.generateNestedFunctionInits();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.thisObjLocal);
        this.cfw.addLoadConstant(this.maxLocals);
        this.cfw.addLoadConstant(this.maxStack);
        this.addOptRuntimeInvoke("createNativeGenerator", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;II)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateGetGeneratorLocalsState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorLocalsState", "(Ljava/lang/Object;)[Ljava/lang/Object;");
    }

    private void generateGetGeneratorResumptionPoint() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", "I");
    }

    private void generateGetGeneratorStackState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorStackState", "(Ljava/lang/Object;)[Ljava/lang/Object;");
    }

    /*
     * Unable to fully structure code
     */
    private void generateIfJump(Node var1_1, Node var2_2, int var3_3, int var4_4) {
        block7: {
            block6: {
                var5_5 = var1_1.getType();
                var6_6 = var1_1.getFirstChild();
                if (var5_5 == 26) break block6;
                if (var5_5 == 46 || var5_5 == 47) ** GOTO lbl-1000
                if (var5_5 == 52 || var5_5 == 53) ** GOTO lbl-1000
                if (var5_5 == 105 || var5_5 == 106) ** GOTO lbl14
                switch (var5_5) {
                    default: {
                        this.generateExpression(var1_1, var2_2);
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                        this.cfw.add(154, var3_3);
                        this.cfw.add(167, var4_4);
                        break;
                    }
lbl14:
                    // 1 sources

                    var7_7 = this.cfw.acquireLabel();
                    if (var5_5 == 106) {
                        this.generateIfJump(var6_6, var1_1, var7_7, var4_4);
                    } else {
                        this.generateIfJump(var6_6, var1_1, var3_3, var7_7);
                    }
                    this.cfw.markLabel(var7_7);
                    this.generateIfJump(var6_6.getNext(), var1_1, var3_3, var4_4);
                    break;
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: lbl-1000:
                    // 2 sources

                    {
                        this.visitIfJumpRelOp(var1_1, var6_6, var3_3, var4_4);
                        break;
                    }
                    case 12: 
                    case 13: lbl-1000:
                    // 2 sources

                    {
                        this.visitIfJumpEqOp(var1_1, var6_6, var3_3, var4_4);
                        break;
                    }
                }
                break block7;
            }
            this.generateIfJump(var6_6, var1_1, var4_4, var3_3);
        }
    }

    private void generateIntegerUnwrap() {
        this.cfw.addInvoke(182, "java/lang/Integer", "intValue", "()I");
    }

    private void generateIntegerWrap() {
        this.cfw.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
    }

    private void generateNestedFunctionInits() {
        int n = this.scriptOrFn.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, i);
            if (optFunctionNode.fnode.getFunctionType() != 1) continue;
            this.visitFunction(optFunctionNode, 1);
        }
    }

    private void generateObjectLiteralFactory(Node node, int n) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.codegen.getBodyMethodName(this.scriptOrFn));
        charSequence.append("_literal");
        charSequence.append(n);
        charSequence = charSequence.toString();
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        n = (short)(s + 1);
        this.firstFreeLocal = (short)n;
        this.argsLocal = s;
        this.localsMax = (short)n;
        this.cfw.startMethod((String)charSequence, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)2);
        this.visitObjectLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generatePrologue() {
        int n;
        int n2;
        Object object;
        short s;
        int n3;
        if (this.inDirectCallFunction) {
            n3 = this.scriptOrFn.getParamCount();
            if (this.firstFreeLocal != 4) {
                Kit.codeBug();
            }
            for (s = 0; s != n3; s = (short)(s + 1)) {
                object = this.varRegisters;
                n2 = this.firstFreeLocal;
                object[s] = (short)n2;
                this.firstFreeLocal = (short)(n2 + 3);
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (s = 0; s != n3; s = (short)(s + 1)) {
                    n2 = this.varRegisters[s];
                    this.cfw.addALoad(n2);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    n = this.cfw.acquireLabel();
                    this.cfw.add(166, n);
                    this.cfw.addDLoad(n2 + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(n2);
                    this.cfw.markLabel(n);
                }
            }
        }
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        n3 = this.firstFreeLocal;
        s = (short)(n3 + 1);
        this.firstFreeLocal = s;
        this.argsLocal = (short)n3;
        this.localsMax = s;
        if (this.isGenerator) {
            n3 = (short)(s + 1);
            this.firstFreeLocal = (short)n3;
            this.operationLocal = s;
            this.localsMax = (short)n3;
            this.cfw.addALoad(this.thisObjLocal);
            s = this.firstFreeLocal;
            n3 = (short)(s + 1);
            this.firstFreeLocal = (short)n3;
            this.generatorStateLocal = s;
            this.localsMax = (short)n3;
            this.cfw.add(192, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState");
            this.cfw.add(89);
            this.cfw.addAStore(this.generatorStateLocal);
            this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "thisObj", "Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.thisObjLocal);
            if (this.epilogueLabel == -1) {
                this.epilogueLabel = this.cfw.acquireLabel();
            }
            if ((object = (Object)((FunctionNode)this.scriptOrFn).getResumptionPoints()) != null) {
                this.generateGetGeneratorResumptionPoint();
                this.generatorSwitch = this.cfw.addTableSwitch(0, object.size() + 0);
                this.generateCheckForThrowOrClose(-1, false, 0);
            }
        }
        if (this.fnCurrent == null && this.scriptOrFn.getRegexpCount() != 0) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addInvoke(184, this.codegen.mainClassName, "_reInit", "(Lorg/mozilla/javascript/Context;)V");
        }
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.saveCurrentCodeOffset();
        }
        if (this.hasVarsInRegs) {
            s = (short)this.scriptOrFn.getParamCount();
            if (s > 0 && !this.inDirectCallFunction) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add(190);
                this.cfw.addPush(s);
                n3 = this.cfw.acquireLabel();
                this.cfw.add(162, n3);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(s);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(n3);
            }
            int n4 = this.fnCurrent.fnode.getParamCount();
            int n5 = this.fnCurrent.fnode.getParamAndVarCount();
            boolean[] blArray = this.fnCurrent.fnode.getParamAndVarConst();
            s = (short)-1;
            for (n2 = 0; n2 != n5; ++n2) {
                if (n2 < n4) {
                    if (!this.inDirectCallFunction) {
                        n = this.getNewWordLocal();
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(n2);
                        this.cfw.add(50);
                        this.cfw.addAStore(n);
                        n3 = s;
                        s = (short)n;
                    } else {
                        n = -1;
                        n3 = s;
                        s = (short)n;
                    }
                } else if (this.fnCurrent.isNumberVar(n2)) {
                    n = this.getNewWordPairLocal(blArray[n2]);
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(n);
                    n3 = s;
                    s = (short)n;
                } else {
                    n = this.getNewWordLocal(blArray[n2]);
                    if (s == -1) {
                        Codegen.pushUndefined(this.cfw);
                        n3 = n;
                    } else {
                        this.cfw.addALoad(s);
                        n3 = s;
                    }
                    this.cfw.addAStore(n);
                    s = (short)n;
                }
                if (s >= 0) {
                    if (blArray[n2]) {
                        this.cfw.addPush(0);
                        object = this.cfw;
                        n = this.fnCurrent.isNumberVar(n2) ? 2 : 1;
                        ((ClassFileWriter)object).addIStore(n + s);
                    }
                    this.varRegisters[n2] = s;
                }
                if (this.compilerEnv.isGenerateDebugInfo()) {
                    String string2 = this.fnCurrent.fnode.getParamOrVarName(n2);
                    object = this.fnCurrent.isNumberVar(n2) ? (Object)"D" : (Object)"Ljava/lang/Object;";
                    int n6 = this.cfw.getCurrentCodeOffset();
                    n = s;
                    if (s < 0) {
                        n = this.varRegisters[n2];
                    }
                    this.cfw.addVariableDescriptor(string2, (String)object, n6, n);
                }
                s = (short)n3;
            }
            return;
        }
        if (this.isGenerator) {
            return;
        }
        object = this.scriptOrFn;
        s = object instanceof FunctionNode && ((FunctionNode)object).getFunctionType() == 4 ? (short)1 : 0;
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.argsLocal);
            object = s != 0 ? (Object)"createArrowFunctionActivation" : (Object)"createFunctionActivation";
            this.cfw.addPush(this.scriptOrFn.isInStrictMode());
            this.addScriptRuntimeInvoke((String)object, "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Z)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("enterActivationFunction", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V");
            object = "activation";
        } else {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Z)V");
            object = "global";
        }
        this.enterAreaStartLabel = this.cfw.acquireLabel();
        this.epilogueLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(this.enterAreaStartLabel);
        this.generateNestedFunctionInits();
        if (this.compilerEnv.isGenerateDebugInfo()) {
            ClassFileWriter classFileWriter = this.cfw;
            classFileWriter.addVariableDescriptor((String)object, "Lorg/mozilla/javascript/Scriptable;", classFileWriter.getCurrentCodeOffset(), this.variableObjectLocal);
        }
        if ((object = (Object)this.fnCurrent) == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            s = (short)this.scriptOrFn.getEndLineno();
            if (s != -1) {
                this.cfw.addLineNumberEntry(s);
            }
        } else {
            if (((OptFunctionNode)object).itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add(189, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private boolean generateSaveLocals(Node node) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.firstFreeLocal; ++n2) {
            n = n4;
            if (this.locals[n2] != 0) {
                n = n4 + 1;
            }
            n4 = n;
        }
        if (n4 == 0) {
            ((FunctionNode)this.scriptOrFn).addLiveLocals(node, null);
            return false;
        }
        n2 = this.maxLocals;
        if (n2 <= n4) {
            n2 = n4;
        }
        this.maxLocals = n2;
        int[] nArray = new int[n4];
        int n5 = 0;
        for (n2 = 0; n2 < this.firstFreeLocal; ++n2) {
            n = n5;
            if (this.locals[n2] != 0) {
                nArray[n5] = n2;
                n = n5 + 1;
            }
            n5 = n;
        }
        ((FunctionNode)this.scriptOrFn).addLiveLocals(node, nArray);
        this.generateGetGeneratorLocalsState();
        for (n2 = n3; n2 < n4; ++n2) {
            this.cfw.add(89);
            this.cfw.addLoadConstant(n2);
            this.cfw.addALoad(nArray[n2]);
            this.cfw.add(83);
        }
        this.cfw.add(87);
        return true;
    }

    private void generateSetGeneratorResumptionPoint(int n) {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.addLoadConstant(n);
        this.cfw.add(181, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", "I");
    }

    /*
     * Exception decompiling
     */
    private void generateStatement(Node var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CASE]], but top level block is 10[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateThrowJavaScriptException() {
        this.cfw.add(187, "org/mozilla/javascript/JavaScriptException");
        this.cfw.add(90);
        this.cfw.add(95);
        this.cfw.addPush(this.scriptOrFn.getSourceName());
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addInvoke(183, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
        this.cfw.add(191);
    }

    private void generateYieldPoint(Node node, boolean bl) {
        Node node2;
        int n = this.maxStack;
        int n2 = this.cfw.getStackTop();
        if (n <= n2) {
            n = n2;
        }
        this.maxStack = n;
        n = this.cfw.getStackTop();
        int n3 = 0;
        if (n != 0) {
            this.generateGetGeneratorStackState();
            for (n = 0; n < n2; ++n) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addLoadConstant(n);
                this.cfw.add(95);
                this.cfw.add(83);
            }
            this.cfw.add(87);
        }
        if ((node2 = node.getFirstChild()) != null) {
            this.generateExpression(node2, node);
        } else {
            Codegen.pushUndefined(this.cfw);
        }
        n = this.getNextGeneratorState(node);
        this.generateSetGeneratorResumptionPoint(n);
        boolean bl2 = this.generateSaveLocals(node);
        this.cfw.add(176);
        this.generateCheckForThrowOrClose(this.getTargetLabel(node), bl2, n);
        if (n2 != 0) {
            this.generateGetGeneratorStackState();
            for (n = n3; n < n2; ++n) {
                this.cfw.add(89);
                this.cfw.addLoadConstant(n2 - n - 1);
                this.cfw.add(50);
                this.cfw.add(95);
            }
            this.cfw.add(87);
        }
        if (bl) {
            this.cfw.addALoad(this.argsLocal);
        }
    }

    private Node getFinallyAtTarget(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getType() == 126) {
            return node;
        }
        if (node != null && node.getType() == 132 && (node = node.getNext()) != null && node.getType() == 126) {
            return node;
        }
        throw Kit.codeBug("bad finally target");
    }

    private int getLocalBlockRegister(Node node) {
        return ((Node)node.getProp(3)).getExistingIntProp(2);
    }

    private short getNewWordIntern(int n) {
        short s;
        int[] nArray;
        block14: {
            nArray = this.locals;
            if (n > 1) {
                int n2 = this.firstFreeLocal;
                block0: while (n2 + n <= 1024) {
                    int n3 = 0;
                    while (true) {
                        s = (short)n2;
                        if (n3 < n) {
                            if (nArray[n2 + n3] != 0) {
                                n2 += n3 + 1;
                                continue block0;
                            }
                            ++n3;
                            continue;
                        }
                        break block14;
                        break;
                    }
                }
                s = -1;
            } else {
                s = this.firstFreeLocal;
            }
        }
        if (s != -1) {
            nArray[s] = 1;
            if (n > 1) {
                nArray[s + 1] = 1;
            }
            if (n > 2) {
                nArray[s + 2] = 1;
            }
            if (s == this.firstFreeLocal) {
                n += s;
                while (n < 1024) {
                    if (nArray[n] == 0) {
                        n = (short)n;
                        this.firstFreeLocal = (short)n;
                        if (this.localsMax < n) {
                            this.localsMax = (short)n;
                        }
                        return s;
                    }
                    ++n;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short getNewWordLocal() {
        return this.getNewWordIntern(1);
    }

    private short getNewWordLocal(boolean bl) {
        int n = bl ? 2 : 1;
        return this.getNewWordIntern(n);
    }

    private short getNewWordPairLocal(boolean bl) {
        int n = bl ? 3 : 2;
        return this.getNewWordIntern(n);
    }

    private int getNextGeneratorState(Node node) {
        return ((FunctionNode)this.scriptOrFn).getResumptionPoints().indexOf(node) + 1;
    }

    private int getTargetLabel(Node node) {
        int n;
        int n2 = n = node.labelId();
        if (n == -1) {
            n2 = this.cfw.acquireLabel();
            node.labelId(n2);
        }
        return n2;
    }

    private void incReferenceWordLocal(short s) {
        int[] nArray = this.locals;
        nArray[s] = nArray[s] + 1;
    }

    private void initBodyGeneration() {
        this.varRegisters = null;
        if (this.scriptOrFn.getType() == 110) {
            int n;
            boolean bl;
            OptFunctionNode optFunctionNode;
            this.fnCurrent = optFunctionNode = OptFunctionNode.get(this.scriptOrFn);
            this.hasVarsInRegs = bl = optFunctionNode.fnode.requiresActivation() ^ true;
            if (bl && (n = this.fnCurrent.fnode.getParamAndVarCount()) != 0) {
                this.varRegisters = new short[n];
            }
            this.inDirectCallFunction = bl = this.fnCurrent.isTargetOfDirectCall();
            if (bl && !this.hasVarsInRegs) {
                Codegen.badTree();
            }
        } else {
            this.fnCurrent = null;
            this.hasVarsInRegs = false;
            this.inDirectCallFunction = false;
        }
        this.locals = new int[1024];
        this.funObjLocal = (short)0;
        this.contextLocal = (short)1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.epilogueLabel = -1;
        this.enterAreaStartLabel = -1;
        this.generatorStateLocal = (short)-1;
    }

    private void inlineFinally(Node node) {
        int n = this.cfw.acquireLabel();
        int n2 = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        this.inlineFinally(node, n, n2);
        this.cfw.markLabel(n2);
    }

    private void inlineFinally(Node node, int n, int n2) {
        Node node2 = this.getFinallyAtTarget(node);
        node2.resetTargets();
        this.exceptionManager.markInlineFinallyStart(node2, n);
        for (node = node2.getFirstChild(); node != null; node = node.getNext()) {
            this.generateStatement(node);
        }
        this.exceptionManager.markInlineFinallyEnd(node2, n2);
    }

    private static boolean isArithmeticNode(Node node) {
        int n = node.getType();
        boolean bl = n == 22 || n == 25 || n == 24 || n == 23;
        return bl;
    }

    private int nodeIsDirectCallParameter(Node node) {
        int n;
        if (node.getType() == 55 && this.inDirectCallFunction && !this.itsForcedObjectParameters && this.fnCurrent.isParameter(n = this.fnCurrent.getVarIndex(node))) {
            return this.varRegisters[n];
        }
        return -1;
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = 0;
    }

    private void saveCurrentCodeOffset() {
        this.savedCodeOffset = this.cfw.getCurrentCodeOffset();
    }

    private void updateLineNumber(Node node) {
        int n;
        this.itsLineNumber = n = node.getLineno();
        if (n == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)n);
    }

    private boolean varIsDirectCallParameter(int n) {
        boolean bl = this.fnCurrent.isParameter(n) && this.inDirectCallFunction && !this.itsForcedObjectParameters;
        return bl;
    }

    private void visitArithmetic(Node node, int n, Node node2, Node node3) {
        if (node.getIntProp(8, -1) != -1) {
            this.generateExpression(node2, node);
            this.generateExpression(node2.getNext(), node);
            this.cfw.add(n);
        } else {
            boolean bl = BodyCodegen.isArithmeticNode(node3);
            this.generateExpression(node2, node);
            if (!BodyCodegen.isArithmeticNode(node2)) {
                this.addObjectToDouble();
            }
            this.generateExpression(node2.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(node2.getNext())) {
                this.addObjectToDouble();
            }
            this.cfw.add(n);
            if (!bl) {
                this.addDoubleWrap();
            }
        }
    }

    private void visitArrayLiteral(Node object, Node node, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            ++n3;
        }
        if (!(bl || n3 <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new LinkedList<Node>();
            }
            this.literals.add((Node)object);
            object = new StringBuilder();
            ((StringBuilder)object).append(this.codegen.getBodyMethodName(this.scriptOrFn));
            ((StringBuilder)object).append("_literal");
            ((StringBuilder)object).append(this.literals.size());
            object = ((StringBuilder)object).toString();
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(182, this.codegen.mainClassName, (String)object, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        if (this.isGenerator) {
            for (n = 0; n != n3; ++n) {
                this.generateExpression(node, (Node)object);
                node = node.getNext();
            }
            this.addNewObjectArray(n3);
            for (n = n2; n != n3; ++n) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(n3 - n - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            this.addNewObjectArray(n3);
            while (n != n3) {
                this.cfw.add(89);
                this.cfw.addPush(n);
                this.generateExpression(node, (Node)object);
                this.cfw.add(83);
                node = node.getNext();
                ++n;
            }
        }
        if ((object = (Object)((int[])((Node)object).getProp(11))) == null) {
            this.cfw.add(1);
            this.cfw.add(3);
        } else {
            this.cfw.addPush(OptRuntime.encodeIntArray((int[])object));
            this.cfw.addPush(((Object)object).length);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", "([Ljava/lang/Object;Ljava/lang/String;ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitBitOp(Node node, int n, Node node2) {
        int n2 = node.getIntProp(8, -1);
        this.generateExpression(node2, node);
        if (n == 20) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)J");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.cfw.addPush(31);
            this.cfw.add(126);
            this.cfw.add(125);
            this.cfw.add(138);
            this.addDoubleWrap();
            return;
        }
        if (n2 == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
        }
        if (n != 18) {
            if (n != 19) {
                switch (n) {
                    default: {
                        throw Codegen.badTree();
                    }
                    case 11: {
                        this.cfw.add(126);
                        break;
                    }
                    case 10: {
                        this.cfw.add(130);
                        break;
                    }
                    case 9: {
                        this.cfw.add(128);
                        break;
                    }
                }
            } else {
                this.cfw.add(122);
            }
        } else {
            this.cfw.add(120);
        }
        this.cfw.add(135);
        if (n2 == -1) {
            this.addDoubleWrap();
        }
    }

    private void visitDotQuery(Node node, Node node2) {
        this.updateLineNumber(node);
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterDotQuery", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(1);
        int n = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        this.cfw.add(87);
        this.generateExpression(node2.getNext(), node);
        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("updateDotQuery", "(ZLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        this.cfw.add(89);
        this.cfw.add(198, n);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveDotQuery", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private void visitFunction(OptFunctionNode optFunctionNode, int n) {
        int n2 = this.codegen.getIndex(optFunctionNode.fnode);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(n2);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        if (n == 4) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.addOptRuntimeInvoke("bindThis", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Function;");
        }
        if (n != 2 && n != 4) {
            this.cfw.addPush(n);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V");
        }
    }

    private void visitGetProp(Node node, Node node2) {
        this.generateExpression(node2, node);
        Node node3 = node2.getNext();
        this.generateExpression(node3, node);
        if (node.getType() == 34) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getObjectPropNoWarn", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            return;
        }
        if (node2.getType() == 43 && node3.getType() == 41) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
        } else {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitGetVar(Node node) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        short s = this.varRegisters[n];
        if (this.varIsDirectCallParameter(n)) {
            if (node.getIntProp(8, -1) != -1) {
                this.dcpLoadAsNumber(s);
            } else {
                this.dcpLoadAsObject(s);
            }
        } else if (this.fnCurrent.isNumberVar(n)) {
            this.cfw.addDLoad(s);
        } else {
            this.cfw.addALoad(s);
        }
    }

    private void visitGoto(Jump jump, int n, Node node) {
        block11: {
            block10: {
                Node node2;
                block9: {
                    node2 = jump.target;
                    if (n == 6 || n == 7) break block9;
                    if (n == 136) {
                        if (this.isGenerator) {
                            this.addGotoWithReturn(node2);
                        } else {
                            this.inlineFinally(node2);
                        }
                    } else {
                        this.addGoto(node2, 167);
                    }
                    break block10;
                }
                if (node == null) break block11;
                int n2 = this.getTargetLabel(node2);
                int n3 = this.cfw.acquireLabel();
                if (n == 6) {
                    this.generateIfJump(node, jump, n2, n3);
                } else {
                    this.generateIfJump(node, jump, n3, n2);
                }
                this.cfw.markLabel(n3);
            }
            return;
        }
        throw Codegen.badTree();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitIfJumpEqOp(Node object, Node object2, int n, int n2) {
        short s;
        block14: {
            Node node;
            int n3;
            Object object3;
            block8: {
                int n4;
                block13: {
                    block11: {
                        block9: {
                            block12: {
                                block10: {
                                    object3 = object2;
                                    if (n == -1 || n2 == -1) throw Codegen.badTree();
                                    s = this.cfw.getStackTop();
                                    n3 = ((Node)object).getType();
                                    node = ((Node)object2).getNext();
                                    if (((Node)object2).getType() == 42 || node.getType() == 42) break block8;
                                    n4 = this.nodeIsDirectCallParameter((Node)object3);
                                    if (n4 != -1 && node.getType() == 150 && ((Node)(object2 = node.getFirstChild())).getType() == 40) {
                                        this.cfw.addALoad(n4);
                                        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                                        int n5 = this.cfw.acquireLabel();
                                        this.cfw.add(166, n5);
                                        this.cfw.addDLoad(n4 + 1);
                                        this.cfw.addPush(((Node)object2).getDouble());
                                        this.cfw.add(151);
                                        if (n3 == 12) {
                                            this.cfw.add(153, n);
                                        } else {
                                            this.cfw.add(154, n);
                                        }
                                        this.cfw.add(167, n2);
                                        this.cfw.markLabel(n5);
                                    }
                                    this.generateExpression((Node)object3, (Node)object);
                                    this.generateExpression(node, (Node)object);
                                    object2 = "shallowEq";
                                    if (n3 == 12) break block9;
                                    if (n3 == 13) break block10;
                                    object = object2;
                                    if (n3 == 46) break block11;
                                    if (n3 != 47) throw Codegen.badTree();
                                    object = object2;
                                    break block12;
                                }
                                object = "eq";
                            }
                            n4 = 153;
                            break block13;
                        }
                        object = "eq";
                    }
                    n4 = 154;
                }
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                this.cfw.add(n4, n);
                this.cfw.add(167, n2);
                break block14;
            }
            if (((Node)object2).getType() == 42) {
                object3 = node;
            }
            this.generateExpression((Node)object3, (Node)object);
            int n6 = 199;
            if (n3 != 46 && n3 != 47) {
                int n7 = n;
                n6 = n2;
                if (n3 != 12) {
                    if (n3 != 13) throw Codegen.badTree();
                    n7 = n2;
                    n6 = n;
                }
                this.cfw.add(89);
                n = this.cfw.acquireLabel();
                this.cfw.add(199, n);
                short s2 = this.cfw.getStackTop();
                this.cfw.add(87);
                this.cfw.add(167, n7);
                this.cfw.markLabel(n, s2);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add(165, n7);
                n2 = n6;
            } else {
                if (n3 == 46) {
                    n6 = 198;
                }
                this.cfw.add(n6, n);
            }
            this.cfw.add(167, n2);
        }
        if (s != this.cfw.getStackTop()) throw Codegen.badTree();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitIfJumpRelOp(Node object, Node node, int n, int n2) {
        if (n == -1 || n2 == -1) throw Codegen.badTree();
        int n3 = ((Node)object).getType();
        Node node2 = node.getNext();
        if (n3 != 53 && n3 != 52) {
            int n4 = ((Node)object).getIntProp(8, -1);
            int n5 = this.nodeIsDirectCallParameter(node);
            int n6 = this.nodeIsDirectCallParameter(node2);
            if (n4 != -1) {
                if (n4 != 2) {
                    this.generateExpression(node, (Node)object);
                } else if (n5 != -1) {
                    this.dcpLoadAsNumber(n5);
                } else {
                    this.generateExpression(node, (Node)object);
                    this.addObjectToDouble();
                }
                if (n4 != 1) {
                    this.generateExpression(node2, (Node)object);
                } else if (n6 != -1) {
                    this.dcpLoadAsNumber(n6);
                } else {
                    this.generateExpression(node2, (Node)object);
                    this.addObjectToDouble();
                }
                this.genSimpleCompare(n3, n, n2);
                return;
            } else {
                if (n5 != -1 && n6 != -1) {
                    n4 = this.cfw.getStackTop();
                    int n7 = this.cfw.acquireLabel();
                    this.cfw.addALoad(n5);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    this.cfw.add(166, n7);
                    this.cfw.addDLoad(n5 + 1);
                    this.dcpLoadAsNumber(n6);
                    this.genSimpleCompare(n3, n, n2);
                    if (n4 != this.cfw.getStackTop()) throw Codegen.badTree();
                    this.cfw.markLabel(n7);
                    n7 = this.cfw.acquireLabel();
                    this.cfw.addALoad(n6);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    this.cfw.add(166, n7);
                    this.cfw.addALoad(n5);
                    this.addObjectToDouble();
                    this.cfw.addDLoad(n6 + 1);
                    this.genSimpleCompare(n3, n, n2);
                    if (n4 != this.cfw.getStackTop()) throw Codegen.badTree();
                    this.cfw.markLabel(n7);
                    this.cfw.addALoad(n5);
                    this.cfw.addALoad(n6);
                } else {
                    this.generateExpression(node, (Node)object);
                    this.generateExpression(node2, (Node)object);
                }
                if (n3 == 17 || n3 == 16) {
                    this.cfw.add(95);
                }
                object = n3 != 14 && n3 != 16 ? "cmp_LE" : "cmp_LT";
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                this.cfw.add(154, n);
                this.cfw.add(167, n2);
            }
            return;
        }
        this.generateExpression(node, (Node)object);
        this.generateExpression(node2, (Node)object);
        this.cfw.addALoad(this.contextLocal);
        object = n3 == 53 ? "instanceOf" : "in";
        this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Z");
        this.cfw.add(154, n);
        this.cfw.add(167, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitIncDec(Node object) {
        int n = ((Node)object).getExistingIntProp(13);
        Node node = ((Node)object).getFirstChild();
        int n2 = node.getType();
        if (n2 != 33) {
            if (n2 == 34) throw Kit.codeBug();
            if (n2 != 36) {
                if (n2 != 39) {
                    if (n2 != 55) {
                        if (n2 != 68) {
                            Codegen.badTree();
                            return;
                        } else {
                            this.generateExpression(node.getFirstChild(), (Node)object);
                            this.cfw.addALoad(this.contextLocal);
                            this.cfw.addALoad(this.variableObjectLocal);
                            this.cfw.addPush(n);
                            this.addScriptRuntimeInvoke("refIncrDecr", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                        }
                        return;
                    } else {
                        if (!this.hasVarsInRegs) {
                            Kit.codeBug();
                        }
                        n2 = (n & 2) != 0 ? 1 : 0;
                        int n3 = this.fnCurrent.getVarIndex(node);
                        int n4 = this.varRegisters[n3];
                        if (this.fnCurrent.fnode.getParamAndVarConst()[n3]) {
                            if (((Node)object).getIntProp(8, -1) != -1) {
                                n3 = this.varIsDirectCallParameter(n3) ? 1 : 0;
                                this.cfw.addDLoad(n4 + n3);
                                if (n2 != 0) return;
                                this.cfw.addPush(1.0);
                                if ((n & 1) == 0) {
                                    this.cfw.add(99);
                                    return;
                                } else {
                                    this.cfw.add(103);
                                }
                                return;
                            } else {
                                if (this.varIsDirectCallParameter(n3)) {
                                    this.dcpLoadAsObject(n4);
                                } else {
                                    this.cfw.addALoad(n4);
                                }
                                if (n2 != 0) {
                                    this.cfw.add(89);
                                    this.addObjectToDouble();
                                    this.cfw.add(88);
                                    return;
                                } else {
                                    this.addObjectToDouble();
                                    this.cfw.addPush(1.0);
                                    if ((n & 1) == 0) {
                                        this.cfw.add(99);
                                    } else {
                                        this.cfw.add(103);
                                    }
                                    this.addDoubleWrap();
                                }
                            }
                            return;
                        } else if (((Node)object).getIntProp(8, -1) != -1) {
                            n3 = this.varIsDirectCallParameter(n3) ? 1 : 0;
                            object = this.cfw;
                            ((ClassFileWriter)object).addDLoad(n4 += n3);
                            if (n2 != 0) {
                                this.cfw.add(92);
                            }
                            this.cfw.addPush(1.0);
                            if ((n & 1) == 0) {
                                this.cfw.add(99);
                            } else {
                                this.cfw.add(103);
                            }
                            if (n2 == 0) {
                                this.cfw.add(92);
                            }
                            this.cfw.addDStore(n4);
                            return;
                        } else {
                            if (this.varIsDirectCallParameter(n3)) {
                                this.dcpLoadAsObject(n4);
                            } else {
                                this.cfw.addALoad(n4);
                            }
                            this.addObjectToDouble();
                            if (n2 != 0) {
                                this.cfw.add(92);
                            }
                            this.cfw.addPush(1.0);
                            if ((n & 1) == 0) {
                                this.cfw.add(99);
                            } else {
                                this.cfw.add(103);
                            }
                            this.addDoubleWrap();
                            if (n2 == 0) {
                                this.cfw.add(89);
                            }
                            this.cfw.addAStore(n4);
                            if (n2 == 0) return;
                            this.addDoubleWrap();
                        }
                    }
                    return;
                } else {
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.cfw.addPush(node.getString());
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addPush(n);
                    this.addScriptRuntimeInvoke("nameIncrDecr", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                }
                return;
            } else {
                node = node.getFirstChild();
                this.generateExpression(node, (Node)object);
                this.generateExpression(node.getNext(), (Node)object);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(n);
                if (node.getNext().getIntProp(8, -1) != -1) {
                    this.addOptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                    return;
                } else {
                    this.addScriptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                }
            }
            return;
        } else {
            node = node.getFirstChild();
            this.generateExpression(node, (Node)object);
            this.generateExpression(node.getNext(), (Node)object);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(n);
            this.addScriptRuntimeInvoke("propIncrDecr", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
        }
    }

    private void visitObjectLiteral(Node object, Node node, boolean bl) {
        int n;
        int n2;
        int n3;
        block13: {
            Object[] objectArray = (Object[])((Node)object).getProp(12);
            n3 = objectArray.length;
            if (!(bl || n3 <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
                if (this.literals == null) {
                    this.literals = new LinkedList<Node>();
                }
                this.literals.add((Node)object);
                object = new StringBuilder();
                ((StringBuilder)object).append(this.codegen.getBodyMethodName(this.scriptOrFn));
                ((StringBuilder)object).append("_literal");
                ((StringBuilder)object).append(this.literals.size());
                object = ((StringBuilder)object).toString();
                this.cfw.addALoad(this.funObjLocal);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addALoad(this.thisObjLocal);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addInvoke(182, this.codegen.mainClassName, (String)object, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            if (this.isGenerator) {
                this.addLoadPropertyValues((Node)object, node, n3);
                this.addLoadPropertyIds(objectArray, n3);
                this.cfw.add(95);
            } else {
                this.addLoadPropertyIds(objectArray, n3);
                this.addLoadPropertyValues((Node)object, node, n3);
            }
            n2 = 0;
            object = node;
            for (n = 0; n != n3; ++n) {
                int n4 = ((Node)object).getType();
                if (n4 != 152 && n4 != 153) {
                    object = ((Node)object).getNext();
                    continue;
                }
                n = 1;
                break block13;
            }
            n = 0;
        }
        if (n != 0) {
            this.cfw.addPush(n3);
            this.cfw.add(188, 10);
            for (n = n2; n != n3; ++n) {
                this.cfw.add(89);
                this.cfw.addPush(n);
                n2 = node.getType();
                if (n2 == 152) {
                    this.cfw.add(2);
                } else if (n2 == 153) {
                    this.cfw.add(4);
                } else {
                    this.cfw.add(3);
                }
                this.cfw.add(79);
                node = node.getNext();
            }
        } else {
            this.cfw.add(1);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("newObjectLiteral", "([Ljava/lang/Object;[Ljava/lang/Object;[ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    /*
     * WARNING - void declaration
     */
    private void visitOptimizedCall(Node node, OptFunctionNode optFunctionNode, int n, Node object) {
        void var8_10;
        int n2;
        Node node2 = ((Node)object).getNext();
        String string2 = this.codegen.mainClassName;
        if (n == 30) {
            this.generateExpression((Node)object, node);
            int s = n2 = 0;
        } else {
            this.generateFunctionAndThisObj((Node)object, node);
            n2 = this.getNewWordLocal();
            this.cfw.addAStore(n2);
            int n3 = n2;
        }
        int n4 = this.cfw.acquireLabel();
        int n5 = this.cfw.acquireLabel();
        this.cfw.add(89);
        this.cfw.add(193, string2);
        this.cfw.add(153, n5);
        this.cfw.add(192, string2);
        this.cfw.add(89);
        this.cfw.add(180, string2, "_id", "I");
        this.cfw.addPush(this.codegen.getIndex(optFunctionNode.fnode));
        this.cfw.add(160, n5);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (n == 30) {
            this.cfw.add(1);
        } else {
            this.cfw.addALoad((int)var8_10);
        }
        for (object = node2; object != null; object = ((Node)object).getNext()) {
            n2 = this.nodeIsDirectCallParameter((Node)object);
            if (n2 >= 0) {
                this.cfw.addALoad(n2);
                this.cfw.addDLoad(n2 + 1);
                continue;
            }
            if (((Node)object).getIntProp(8, -1) == 0) {
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.generateExpression((Node)object, node);
                continue;
            }
            this.generateExpression((Node)object, node);
            this.cfw.addPush(0.0);
        }
        this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
        ClassFileWriter classFileWriter = this.cfw;
        string2 = this.codegen.mainClassName;
        object = n == 30 ? this.codegen.getDirectCtorName(optFunctionNode.fnode) : this.codegen.getBodyMethodName(optFunctionNode.fnode);
        classFileWriter.addInvoke(184, string2, (String)object, this.codegen.getBodyMethodSignature(optFunctionNode.fnode));
        this.cfw.add(167, n4);
        this.cfw.markLabel(n5);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (n != 30) {
            this.cfw.addALoad((int)var8_10);
            this.releaseWordLocal((short)var8_10);
        }
        this.generateCallArgArray(node, node2, true);
        if (n == 30) {
            this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.cfw.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.cfw.markLabel(n4);
    }

    private void visitSetConst(Node node, Node node2) {
        String string2 = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(string2);
        this.addScriptRuntimeInvoke("setConst", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetConstVar(Node object, Node node, boolean bl) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex((Node)object);
        this.generateExpression(node.getNext(), (Node)object);
        int n2 = ((Node)object).getIntProp(8, -1) != -1 ? 1 : 0;
        n = this.varRegisters[n];
        int n3 = this.cfw.acquireLabel();
        int n4 = this.cfw.acquireLabel();
        if (n2 != 0) {
            object = this.cfw;
            n2 = n + 2;
            ((ClassFileWriter)object).addILoad(n2);
            this.cfw.add(154, n4);
            short s = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(n2);
            this.cfw.addDStore(n);
            if (bl) {
                this.cfw.addDLoad(n);
                this.cfw.markLabel(n4, s);
            } else {
                this.cfw.add(167, n3);
                this.cfw.markLabel(n4, s);
                this.cfw.add(88);
            }
        } else {
            object = this.cfw;
            n2 = n + 1;
            ((ClassFileWriter)object).addILoad(n2);
            this.cfw.add(154, n4);
            short s = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(n2);
            this.cfw.addAStore(n);
            if (bl) {
                this.cfw.addALoad(n);
                this.cfw.markLabel(n4, s);
            } else {
                this.cfw.add(167, n3);
                this.cfw.markLabel(n4, s);
                this.cfw.add(87);
            }
        }
        this.cfw.markLabel(n3);
    }

    private void visitSetElem(int n, Node node, Node node2) {
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 141) {
            this.cfw.add(89);
        }
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        boolean bl = node.getIntProp(8, -1) != -1;
        if (n == 141) {
            if (bl) {
                this.cfw.add(93);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (bl) {
            this.addScriptRuntimeInvoke("setObjectIndex", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("setObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitSetName(Node node, Node node2) {
        String string2 = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string2);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetProp(int n, Node node, Node node2) {
        this.generateExpression(node2, node);
        Node node3 = node2.getNext();
        if (n == 140) {
            this.cfw.add(89);
        }
        this.generateExpression(node3, node);
        Node node4 = node3.getNext();
        if (n == 140) {
            this.cfw.add(90);
            if (node2.getType() == 43 && node3.getType() == 41) {
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            } else {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(node4, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        this.generateExpression(node2.getNext(), node);
        int n2 = node.getIntProp(8, -1) != -1 ? 1 : 0;
        short s = this.varRegisters[n];
        if (this.fnCurrent.fnode.getParamAndVarConst()[n]) {
            if (!bl) {
                if (n2 != 0) {
                    this.cfw.add(88);
                } else {
                    this.cfw.add(87);
                }
            }
        } else if (this.varIsDirectCallParameter(n)) {
            if (n2 != 0) {
                if (bl) {
                    this.cfw.add(92);
                }
                this.cfw.addALoad(s);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                n = this.cfw.acquireLabel();
                n2 = this.cfw.acquireLabel();
                this.cfw.add(165, n);
                short s2 = this.cfw.getStackTop();
                this.addDoubleWrap();
                this.cfw.addAStore(s);
                this.cfw.add(167, n2);
                this.cfw.markLabel(n, s2);
                this.cfw.addDStore(s + 1);
                this.cfw.markLabel(n2);
            } else {
                if (bl) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(s);
            }
        } else {
            boolean bl2 = this.fnCurrent.isNumberVar(n);
            if (n2 != 0) {
                if (bl2) {
                    this.cfw.addDStore(s);
                    if (bl) {
                        this.cfw.addDLoad(s);
                    }
                } else {
                    if (bl) {
                        this.cfw.add(92);
                    }
                    this.addDoubleWrap();
                    this.cfw.addAStore(s);
                }
            } else {
                if (bl2) {
                    Kit.codeBug();
                }
                this.cfw.addAStore(s);
                if (bl) {
                    this.cfw.addALoad(s);
                }
            }
        }
    }

    private void visitSpecialCall(Node object, int n, int n2, Node object2) {
        this.cfw.addALoad(this.contextLocal);
        if (n == 30) {
            this.generateExpression((Node)object2, (Node)object);
        } else {
            this.generateFunctionAndThisObj((Node)object2, (Node)object);
        }
        this.generateCallArgArray((Node)object, ((Node)object2).getNext(), false);
        if (n == 30) {
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(n2);
            object2 = "newObjectSpecial";
            object = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;";
        } else {
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(n2);
            object2 = this.scriptOrFn.getSourceName();
            ClassFileWriter classFileWriter = this.cfw;
            object = object2;
            if (object2 == null) {
                object = "";
            }
            classFileWriter.addPush((String)object);
            this.cfw.addPush(this.itsLineNumber);
            object2 = "callSpecial";
            object = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;I)Ljava/lang/Object;";
        }
        this.addOptRuntimeInvoke((String)object2, (String)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visitStandardCall(Node object, Node object2) {
        if (((Node)object).getType() != 38) throw Codegen.badTree();
        Node node = ((Node)object2).getNext();
        int n = ((Node)object2).getType();
        if (node == null) {
            if (n == 39) {
                object = ((Node)object2).getString();
                this.cfw.addPush((String)object);
                object = "callName0";
                object2 = "(Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (n == 33) {
                object2 = ((Node)object2).getFirstChild();
                this.generateExpression((Node)object2, (Node)object);
                object = ((Node)object2).getNext().getString();
                this.cfw.addPush((String)object);
                object = "callProp0";
                object2 = "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                if (n == 34) throw Kit.codeBug();
                this.generateFunctionAndThisObj((Node)object2, (Node)object);
                object = "call0";
                object2 = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        } else if (n == 39) {
            object2 = ((Node)object2).getString();
            this.generateCallArgArray((Node)object, node, false);
            this.cfw.addPush((String)object2);
            object = "callName";
            object2 = "([Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        } else {
            n = 0;
            for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
                ++n;
            }
            this.generateFunctionAndThisObj((Node)object2, (Node)object);
            if (n == 1) {
                this.generateExpression(node, (Node)object);
                object = "call1";
                object2 = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (n == 2) {
                this.generateExpression(node, (Node)object);
                this.generateExpression(node.getNext(), (Node)object);
                object = "call2";
                object2 = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                this.generateCallArgArray((Node)object, node, false);
                object = "callN";
                object2 = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke((String)object, (String)object2);
    }

    private void visitStandardNew(Node node, Node node2) {
        if (node.getType() == 30) {
            Node node3 = node2.getNext();
            this.generateExpression(node2, node);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.generateCallArgArray(node, node3, false);
            this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        throw Codegen.badTree();
    }

    private void visitStrictSetName(Node node, Node node2) {
        String string2 = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string2);
        this.addScriptRuntimeInvoke("strictSetName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSwitch(Jump jump, Node node) {
        this.generateExpression(node, jump);
        short s = this.getNewWordLocal();
        this.cfw.addAStore(s);
        for (jump = (Jump)node.getNext(); jump != null; jump = (Jump)jump.getNext()) {
            if (jump.getType() == 116) {
                this.generateExpression(jump.getFirstChild(), jump);
                this.cfw.addALoad(s);
                this.addScriptRuntimeInvoke("shallowEq", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
                this.addGoto(jump.target, 154);
                continue;
            }
            throw Codegen.badTree();
        }
        this.releaseWordLocal(s);
    }

    private void visitTryCatchFinally(Jump object, Node node) {
        int n;
        int n2;
        Object object2;
        short s = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(s);
        int n3 = this.cfw.acquireLabel();
        this.cfw.markLabel(n3, (short)0);
        Node node2 = ((Jump)object).target;
        Node node3 = ((Jump)object).getFinally();
        int[] nArray = new int[5];
        this.exceptionManager.pushExceptionInfo((Jump)object);
        if (node2 != null) {
            nArray[0] = this.cfw.acquireLabel();
            nArray[1] = this.cfw.acquireLabel();
            nArray[2] = this.cfw.acquireLabel();
            object2 = Context.getCurrentContext();
            if (object2 != null && ((Context)object2).hasFeature(13)) {
                nArray[3] = this.cfw.acquireLabel();
            }
        }
        if (node3 != null) {
            nArray[4] = this.cfw.acquireLabel();
        }
        this.exceptionManager.setHandlers(nArray, n3);
        if (this.isGenerator && node3 != null) {
            object2 = new FinallyReturnPoint();
            if (this.finallys == null) {
                this.finallys = new HashMap<Node, FinallyReturnPoint>();
            }
            this.finallys.put(node3, (FinallyReturnPoint)object2);
            this.finallys.put(node3.getNext(), (FinallyReturnPoint)object2);
        }
        while (node != null) {
            if (node == node2) {
                n2 = this.getTargetLabel(node2);
                this.exceptionManager.removeHandler(0, n2);
                this.exceptionManager.removeHandler(1, n2);
                this.exceptionManager.removeHandler(2, n2);
                this.exceptionManager.removeHandler(3, n2);
            }
            this.generateStatement(node);
            node = node.getNext();
        }
        int n4 = this.cfw.acquireLabel();
        this.cfw.add(167, n4);
        n2 = this.getLocalBlockRegister((Node)object);
        if (node2 != null) {
            n = node2.labelId();
            this.generateCatchBlock(0, s, n, n2, nArray[0]);
            this.generateCatchBlock(1, s, n, n2, nArray[1]);
            this.generateCatchBlock(2, s, n, n2, nArray[2]);
            object = Context.getCurrentContext();
            if (object != null && ((Context)object).hasFeature(13)) {
                this.generateCatchBlock(3, s, n, n2, nArray[3]);
            }
        }
        if (node3 != null) {
            int n5 = this.cfw.acquireLabel();
            n = this.cfw.acquireLabel();
            this.cfw.markHandler(n5);
            if (!this.isGenerator) {
                this.cfw.markLabel(nArray[4]);
            }
            this.cfw.addAStore(n2);
            this.cfw.addALoad(s);
            this.cfw.addAStore(this.variableObjectLocal);
            int n6 = node3.labelId();
            if (this.isGenerator) {
                this.addGotoWithReturn(node3);
            } else {
                this.inlineFinally(node3, nArray[4], n);
            }
            this.cfw.addALoad(n2);
            if (this.isGenerator) {
                this.cfw.add(192, "java/lang/Throwable");
            }
            this.cfw.add(191);
            this.cfw.markLabel(n);
            if (this.isGenerator) {
                this.cfw.addExceptionHandler(n3, n6, n5, null);
            }
        }
        this.releaseWordLocal(s);
        this.cfw.markLabel(n4);
        if (!this.isGenerator) {
            this.exceptionManager.popExceptionInfo();
        }
    }

    private void visitTypeofname(Node node) {
        int n;
        if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getIndexForNameNode(node)) >= 0) {
            if (this.fnCurrent.isNumberVar(n)) {
                this.cfw.addPush("number");
            } else if (this.varIsDirectCallParameter(n)) {
                int n2 = this.varRegisters[n];
                this.cfw.addALoad(n2);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                n = this.cfw.acquireLabel();
                this.cfw.add(165, n);
                short s = this.cfw.getStackTop();
                this.cfw.addALoad(n2);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                n2 = this.cfw.acquireLabel();
                this.cfw.add(167, n2);
                this.cfw.markLabel(n, s);
                this.cfw.addPush("number");
                this.cfw.markLabel(n2);
            } else {
                this.cfw.addALoad(this.varRegisters[n]);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    void generateBodyCode() {
        Object object;
        this.isGenerator = Codegen.isGenerator(this.scriptOrFn);
        this.initBodyGeneration();
        if (this.isGenerator) {
            object = new StringBuilder();
            ((StringBuilder)object).append("(");
            ((StringBuilder)object).append(this.codegen.mainClassSignature);
            ((StringBuilder)object).append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
            String string2 = ((StringBuilder)object).toString();
            object = this.cfw;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.codegen.getBodyMethodName(this.scriptOrFn));
            stringBuilder.append("_gen");
            ((ClassFileWriter)object).startMethod(stringBuilder.toString(), string2, (short)10);
        } else {
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        }
        this.generatePrologue();
        object = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateStatement((Node)object);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1));
        if (this.isGenerator) {
            this.generateGenerator();
        }
        if (this.literals != null) {
            for (int i = 0; i < this.literals.size(); ++i) {
                object = this.literals.get(i);
                int n = ((Node)object).getType();
                if (n != 66) {
                    if (n != 67) {
                        Kit.codeBug(Token.typeToName(n));
                        continue;
                    }
                    this.generateObjectLiteralFactory((Node)object, i + 1);
                    continue;
                }
                this.generateArrayLiteralFactory((Node)object, i + 1);
            }
        }
    }

    private class ExceptionManager {
        private LinkedList<ExceptionInfo> exceptionInfo = new LinkedList();

        ExceptionManager() {
        }

        private void endCatch(ExceptionInfo exceptionInfo, int n, int n2) {
            if (exceptionInfo.exceptionStarts[n] != 0) {
                int n3 = exceptionInfo.exceptionStarts[n];
                if (BodyCodegen.this.cfw.getLabelPC(n3) != BodyCodegen.this.cfw.getLabelPC(n2)) {
                    BodyCodegen.this.cfw.addExceptionHandler(exceptionInfo.exceptionStarts[n], n2, exceptionInfo.handlerLabels[n], BodyCodegen.this.exceptionTypeToName(n));
                }
                return;
            }
            throw new IllegalStateException("bad exception start");
        }

        private ExceptionInfo getTop() {
            return this.exceptionInfo.getLast();
        }

        void addHandler(int n, int n2, int n3) {
            ExceptionInfo exceptionInfo = this.getTop();
            exceptionInfo.handlerLabels[n] = n2;
            exceptionInfo.exceptionStarts[n] = n3;
        }

        void markInlineFinallyEnd(Node node, int n) {
            Object object = this.exceptionInfo;
            object = ((LinkedList)object).listIterator(((LinkedList)object).size());
            while (object.hasPrevious()) {
                ExceptionInfo exceptionInfo = (ExceptionInfo)object.previous();
                for (int i = 0; i < 5; ++i) {
                    if (exceptionInfo.handlerLabels[i] == 0 || exceptionInfo.currentFinally != node) continue;
                    exceptionInfo.exceptionStarts[i] = n;
                    exceptionInfo.currentFinally = null;
                }
                if (exceptionInfo.finallyBlock != node) continue;
            }
        }

        void markInlineFinallyStart(Node node, int n) {
            Object object = this.exceptionInfo;
            object = ((LinkedList)object).listIterator(((LinkedList)object).size());
            while (object.hasPrevious()) {
                ExceptionInfo exceptionInfo = (ExceptionInfo)object.previous();
                for (int i = 0; i < 5; ++i) {
                    if (exceptionInfo.handlerLabels[i] == 0 || exceptionInfo.currentFinally != null) continue;
                    this.endCatch(exceptionInfo, i, n);
                    exceptionInfo.exceptionStarts[i] = 0;
                    exceptionInfo.currentFinally = node;
                }
                if (exceptionInfo.finallyBlock != node) continue;
            }
        }

        void popExceptionInfo() {
            this.exceptionInfo.removeLast();
        }

        void pushExceptionInfo(Jump object) {
            object = new ExceptionInfo((Jump)object, BodyCodegen.this.getFinallyAtTarget(((Jump)object).getFinally()));
            this.exceptionInfo.add((ExceptionInfo)object);
        }

        int removeHandler(int n, int n2) {
            ExceptionInfo exceptionInfo = this.getTop();
            if (exceptionInfo.handlerLabels[n] != 0) {
                int n3 = exceptionInfo.handlerLabels[n];
                this.endCatch(exceptionInfo, n, n2);
                exceptionInfo.handlerLabels[n] = 0;
                return n3;
            }
            return 0;
        }

        void setHandlers(int[] nArray, int n) {
            this.getTop();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                this.addHandler(i, nArray[i], n);
            }
        }

        private class ExceptionInfo {
            Node currentFinally;
            int[] exceptionStarts;
            Node finallyBlock;
            int[] handlerLabels;
            Jump node;

            ExceptionInfo(Jump jump, Node node) {
                this.node = jump;
                this.finallyBlock = node;
                this.handlerLabels = new int[5];
                this.exceptionStarts = new int[5];
                this.currentFinally = null;
            }
        }
    }

    static class FinallyReturnPoint {
        public List<Integer> jsrPoints = new ArrayList<Integer>();
        public int tableLabel = 0;

        FinallyReturnPoint() {
        }
    }
}

