/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.BodyCodegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
implements Evaluator {
    static final String DEFAULT_MAIN_METHOD_CLASS = "org.mozilla.javascript.optimizer.OptRuntime";
    static final String FUNCTION_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V";
    static final String FUNCTION_INIT_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V";
    static final String ID_FIELD_NAME = "_id";
    static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/Context;)V";
    private static final String SUPER_CLASS_NAME = "org.mozilla.javascript.NativeFunction";
    private static final Object globalLock = new Object();
    private static int globalSerialClassCounter;
    private CompilerEnvirons compilerEnv;
    private ObjArray directCallTargets;
    private double[] itsConstantList;
    private int itsConstantListSize;
    String mainClassName;
    String mainClassSignature;
    private String mainMethodClass = "org.mozilla.javascript.optimizer.OptRuntime";
    private ObjToIntMap scriptOrFnIndexes;
    ScriptNode[] scriptOrFnNodes;

    private static void addDoubleWrap(ClassFileWriter classFileWriter) {
        classFileWriter.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    private static void collectScriptNodes_r(ScriptNode scriptNode, ObjArray objArray) {
        objArray.add(scriptNode);
        int n = scriptNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            Codegen.collectScriptNodes_r(scriptNode.getFunctionNode(i), objArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> defineClass(Object clazz, Object object) {
        void var1_4;
        Object[] objectArray = (Object[])clazz;
        clazz = (String)objectArray[0];
        objectArray = (byte[])objectArray[1];
        object = SecurityController.createLoader(this.getClass().getClassLoader(), object);
        try {
            clazz = object.defineClass((String)((Object)clazz), (byte[])objectArray);
            object.linkClass(clazz);
            return clazz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Malformed optimizer package ");
        ((StringBuilder)object).append(var1_4);
        throw new RuntimeException(((StringBuilder)object).toString());
    }

    private void emitConstantDudeInitializers(ClassFileWriter classFileWriter) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        classFileWriter.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        for (int i = 0; i != n; ++i) {
            double d = dArray[i];
            CharSequence charSequence = new StringBuilder();
            charSequence.append("_k");
            charSequence.append(i);
            String string2 = charSequence.toString();
            charSequence = Codegen.getStaticConstantWrapperType(d);
            classFileWriter.addField(string2, (String)charSequence, (short)10);
            int n2 = (int)d;
            if ((double)n2 == d) {
                classFileWriter.addPush(n2);
                classFileWriter.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
            classFileWriter.add(179, this.mainClassName, string2, (String)charSequence);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)0);
    }

    private void emitDirectConstructor(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        int n;
        classFileWriter.startMethod(this.getDirectCtorName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode), (short)10);
        int n2 = optFunctionNode.fnode.getParamCount();
        int n3 = n2 * 3 + 4;
        int n4 = n3 + 1;
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "org/mozilla/javascript/BaseFunction", "createObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addAStore(n4);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(n4);
        for (n = 0; n < n2; ++n) {
            int n5 = n * 3;
            classFileWriter.addALoad(n5 + 4);
            classFileWriter.addDLoad(n5 + 5);
        }
        classFileWriter.addALoad(n3);
        classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode));
        n = classFileWriter.acquireLabel();
        classFileWriter.add(89);
        classFileWriter.add(193, "org/mozilla/javascript/Scriptable");
        classFileWriter.add(153, n);
        classFileWriter.add(192, "org/mozilla/javascript/Scriptable");
        classFileWriter.add(176);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(n4);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)(n4 + 1));
    }

    private void emitRegExpInit(ClassFileWriter classFileWriter) {
        Object object;
        int n;
        int n2 = 0;
        for (n = 0; n != ((ScriptNode[])(object = this.scriptOrFnNodes)).length; ++n) {
            n2 += object[n].getRegexpCount();
        }
        if (n2 == 0) {
            return;
        }
        classFileWriter.startMethod(REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE, (short)10);
        classFileWriter.addField("_reInitDone", "Z", (short)74);
        classFileWriter.add(178, this.mainClassName, "_reInitDone", "Z");
        n2 = classFileWriter.acquireLabel();
        classFileWriter.add(153, n2);
        classFileWriter.add(177);
        classFileWriter.markLabel(n2);
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "checkRegExpProxy", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/RegExpProxy;");
        classFileWriter.addAStore(1);
        for (n2 = 0; n2 != ((ScriptNode[])(object = this.scriptOrFnNodes)).length; ++n2) {
            ScriptNode scriptNode = object[n2];
            int n3 = scriptNode.getRegexpCount();
            for (n = 0; n != n3; ++n) {
                String string2 = this.getCompiledRegexpName(scriptNode, n);
                String string3 = scriptNode.getRegexpString(n);
                object = scriptNode.getRegexpFlags(n);
                classFileWriter.addField(string2, "Ljava/lang/Object;", (short)10);
                classFileWriter.addALoad(1);
                classFileWriter.addALoad(0);
                classFileWriter.addPush(string3);
                if (object == null) {
                    classFileWriter.add(1);
                } else {
                    classFileWriter.addPush((String)object);
                }
                classFileWriter.addInvoke(185, "org/mozilla/javascript/RegExpProxy", "compileRegExp", "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                classFileWriter.add(179, this.mainClassName, string2, "Ljava/lang/Object;");
            }
        }
        classFileWriter.addPush(1);
        classFileWriter.add(179, this.mainClassName, "_reInitDone", "Z");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)2);
    }

    private void generateCallMethod(ClassFileWriter classFileWriter, boolean bl) {
        int n;
        classFileWriter.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        int n2 = classFileWriter.acquireLabel();
        classFileWriter.addALoad(1);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "hasTopCall", "(Lorg/mozilla/javascript/Context;)Z");
        classFileWriter.add(154, n2);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        classFileWriter.addPush(bl);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "doTopCall", "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Z)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.markLabel(n2);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        int n3 = this.scriptOrFnNodes.length;
        n2 = 2 <= n3 ? 1 : 0;
        if (n2 != 0) {
            classFileWriter.addLoadThis();
            classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
            n = classFileWriter.addTableSwitch(1, n3 - 1);
        } else {
            n = 0;
        }
        int n4 = 0;
        for (int i = 0; i != n3; ++i) {
            int n5;
            OptFunctionNode optFunctionNode;
            ScriptNode scriptNode = this.scriptOrFnNodes[i];
            int n6 = n4;
            if (n2 != 0) {
                if (i == 0) {
                    classFileWriter.markTableSwitchDefault(n);
                    n6 = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n, i - 1, n4);
                    n6 = n4;
                }
            }
            if (scriptNode.getType() == 110 && (optFunctionNode = OptFunctionNode.get(scriptNode)).isTargetOfDirectCall() && (n5 = optFunctionNode.fnode.getParamCount()) != 0) {
                for (n4 = 0; n4 != n5; ++n4) {
                    classFileWriter.add(190);
                    classFileWriter.addPush(n4);
                    int n7 = classFileWriter.acquireLabel();
                    int n8 = classFileWriter.acquireLabel();
                    classFileWriter.add(164, n7);
                    classFileWriter.addALoad(4);
                    classFileWriter.addPush(n4);
                    classFileWriter.add(50);
                    classFileWriter.add(167, n8);
                    classFileWriter.markLabel(n7);
                    Codegen.pushUndefined(classFileWriter);
                    classFileWriter.markLabel(n8);
                    classFileWriter.adjustStackTop(-1);
                    classFileWriter.addPush(0.0);
                    classFileWriter.addALoad(4);
                }
            }
            classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(scriptNode), this.getBodyMethodSignature(scriptNode));
            classFileWriter.add(176);
            n4 = n6;
        }
        classFileWriter.stopMethod((short)5);
    }

    private byte[] generateCode(String object) {
        Object object2 = this.scriptOrFnNodes;
        int n = 0;
        int n2 = object2[0].getType();
        int n3 = 1;
        n2 = n2 == 137 ? 1 : 0;
        object2 = this.scriptOrFnNodes;
        int n4 = n3;
        if (((ScriptNode[])object2).length <= 1) {
            n4 = n2 == 0 ? n3 : 0;
        }
        boolean bl = object2[0].isInStrictMode();
        object2 = null;
        if (this.compilerEnv.isGenerateDebugInfo()) {
            object2 = this.scriptOrFnNodes[0].getSourceName();
        }
        object2 = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, (String)object2);
        ((ClassFileWriter)object2).addField(ID_FIELD_NAME, "I", (short)2);
        if (n4 != 0) {
            this.generateFunctionConstructor((ClassFileWriter)object2);
        }
        if (n2 != 0) {
            ((ClassFileWriter)object2).addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor((ClassFileWriter)object2);
            this.generateMain((ClassFileWriter)object2);
            this.generateExecute((ClassFileWriter)object2);
        }
        this.generateCallMethod((ClassFileWriter)object2, bl);
        this.generateResumeGenerator((ClassFileWriter)object2);
        this.generateNativeFunctionOverrides((ClassFileWriter)object2, (String)object);
        n4 = this.scriptOrFnNodes.length;
        for (n2 = n; n2 != n4; ++n2) {
            object = this.scriptOrFnNodes[n2];
            BodyCodegen bodyCodegen = new BodyCodegen();
            bodyCodegen.cfw = object2;
            bodyCodegen.codegen = this;
            bodyCodegen.compilerEnv = this.compilerEnv;
            bodyCodegen.scriptOrFn = object;
            bodyCodegen.scriptOrFnIndex = n2;
            try {
                bodyCodegen.generateBodyCode();
            }
            catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
                throw this.reportClassFileFormatException((ScriptNode)object, classFileFormatException.getMessage());
            }
            if (((Node)object).getType() != 110) continue;
            object = OptFunctionNode.get((ScriptNode)object);
            this.generateFunctionInit((ClassFileWriter)object2, (OptFunctionNode)object);
            if (!((OptFunctionNode)object).isTargetOfDirectCall()) continue;
            this.emitDirectConstructor((ClassFileWriter)object2, (OptFunctionNode)object);
        }
        this.emitRegExpInit((ClassFileWriter)object2);
        this.emitConstantDudeInitializers((ClassFileWriter)object2);
        return ((ClassFileWriter)object2).toByteArray();
    }

    private void generateExecute(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("exec", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;", (short)17);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.add(89);
        classFileWriter.add(1);
        classFileWriter.addInvoke(182, classFileWriter.getClassName(), "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)3);
    }

    private void generateFunctionConstructor(ClassFileWriter classFileWriter) {
        boolean bl = true;
        classFileWriter.startMethod("<init>", FUNCTION_CONSTRUCTOR_SIGNATURE, (short)1);
        short s = 0;
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addILoad(3);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(1);
        int n = this.scriptOrFnNodes[0].getType() == 137 ? 1 : 0;
        int n2 = this.scriptOrFnNodes.length;
        if (n != n2) {
            int n3;
            if (2 > n2 - n) {
                bl = false;
            }
            if (bl) {
                classFileWriter.addILoad(3);
                n3 = classFileWriter.addTableSwitch(n + 1, n2 - 1);
            } else {
                n3 = 0;
            }
            for (int i = n; i != n2; ++i) {
                short s2 = s;
                if (bl) {
                    if (i == n) {
                        classFileWriter.markTableSwitchDefault(n3);
                        s2 = classFileWriter.getStackTop();
                    } else {
                        classFileWriter.markTableSwitchCase(n3, i - 1 - n, s);
                        s2 = s;
                    }
                }
                OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFnNodes[i]);
                classFileWriter.addInvoke(183, this.mainClassName, this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE);
                classFileWriter.add(177);
                s = s2;
            }
            classFileWriter.stopMethod((short)4);
            return;
        }
        throw Codegen.badTree();
    }

    private void generateFunctionInit(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        classFileWriter.startMethod(this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE, (short)18);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "org/mozilla/javascript/NativeFunction", "initScriptFunction", FUNCTION_INIT_SIGNATURE);
        if (optFunctionNode.fnode.getRegexpCount() != 0) {
            classFileWriter.addALoad(1);
            classFileWriter.addInvoke(184, this.mainClassName, REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)3);
    }

    private void generateMain(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        classFileWriter.add(187, classFileWriter.getClassName());
        classFileWriter.add(89);
        classFileWriter.addInvoke(183, classFileWriter.getClassName(), "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, this.mainMethodClass, "main", "(Lorg/mozilla/javascript/Script;[Ljava/lang/String;)V");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateNativeFunctionOverrides(ClassFileWriter classFileWriter, String string2) {
        classFileWriter.startMethod("getLanguageVersion", "()I", (short)1);
        classFileWriter.addPush(this.compilerEnv.getLanguageVersion());
        classFileWriter.add(172);
        classFileWriter.stopMethod((short)1);
        for (int i = 0; i != 6; ++i) {
            int n;
            int n2;
            block33: {
                block34: {
                    block27: {
                        block28: {
                            block29: {
                                block30: {
                                    block31: {
                                        block32: {
                                            if (i == 4 && string2 == null) continue;
                                            if (i == 0) break block27;
                                            if (i == 1) break block28;
                                            if (i == 2) break block29;
                                            if (i == 3) break block30;
                                            if (i == 4) break block31;
                                            if (i != 5) break block32;
                                            classFileWriter.startMethod("getParamOrVarConst", "(I)Z", (short)1);
                                            n = n2 = 3;
                                            break block33;
                                        }
                                        throw Kit.codeBug();
                                    }
                                    classFileWriter.startMethod("getEncodedSource", "()Ljava/lang/String;", (short)1);
                                    classFileWriter.addPush(string2);
                                    break block34;
                                }
                                classFileWriter.startMethod("getParamOrVarName", "(I)Ljava/lang/String;", (short)1);
                                n = n2 = 2;
                                break block33;
                            }
                            classFileWriter.startMethod("getParamAndVarCount", "()I", (short)1);
                            break block34;
                        }
                        classFileWriter.startMethod("getParamCount", "()I", (short)1);
                        break block34;
                    }
                    classFileWriter.startMethod("getFunctionName", "()Ljava/lang/String;", (short)1);
                }
                n = n2 = 1;
            }
            int n3 = this.scriptOrFnNodes.length;
            if (n3 > 1) {
                classFileWriter.addLoadThis();
                classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
                n2 = classFileWriter.addTableSwitch(1, n3 - 1);
            } else {
                n2 = 0;
            }
            int n4 = 0;
            for (int j = 0; j != n3; ++j) {
                Object object = this.scriptOrFnNodes[j];
                if (j == 0) {
                    if (n3 > 1) {
                        classFileWriter.markTableSwitchDefault(n2);
                        n4 = classFileWriter.getStackTop();
                    }
                } else {
                    classFileWriter.markTableSwitchCase(n2, j - 1, n4);
                }
                if (i != 0) {
                    if (i != 1) {
                        if (i != 2) {
                            int n5;
                            int n6;
                            int n7;
                            if (i != 3) {
                                if (i != 4) {
                                    if (i == 5) {
                                        n7 = ((ScriptNode)object).getParamAndVarCount();
                                        object = ((ScriptNode)object).getParamAndVarConst();
                                        if (n7 == 0) {
                                            classFileWriter.add(3);
                                            classFileWriter.add(172);
                                            continue;
                                        }
                                        if (n7 == 1) {
                                            classFileWriter.addPush((boolean)object[0]);
                                            classFileWriter.add(172);
                                            continue;
                                        }
                                        classFileWriter.addILoad(1);
                                        n6 = classFileWriter.addTableSwitch(1, n7 - 1);
                                        for (n5 = 0; n5 != n7; ++n5) {
                                            if (classFileWriter.getStackTop() != 0) {
                                                Kit.codeBug();
                                            }
                                            if (n5 == 0) {
                                                classFileWriter.markTableSwitchDefault(n6);
                                            } else {
                                                classFileWriter.markTableSwitchCase(n6, n5 - 1, 0);
                                            }
                                            classFileWriter.addPush((boolean)object[n5]);
                                            classFileWriter.add(172);
                                        }
                                        continue;
                                    }
                                    throw Kit.codeBug();
                                }
                                classFileWriter.addPush(((ScriptNode)object).getEncodedSourceStart());
                                classFileWriter.addPush(((ScriptNode)object).getEncodedSourceEnd());
                                classFileWriter.addInvoke(182, "java/lang/String", "substring", "(II)Ljava/lang/String;");
                                classFileWriter.add(176);
                                continue;
                            }
                            n6 = ((ScriptNode)object).getParamAndVarCount();
                            if (n6 == 0) {
                                classFileWriter.add(1);
                                classFileWriter.add(176);
                                continue;
                            }
                            if (n6 == 1) {
                                classFileWriter.addPush(((ScriptNode)object).getParamOrVarName(0));
                                classFileWriter.add(176);
                                continue;
                            }
                            classFileWriter.addILoad(1);
                            n7 = classFileWriter.addTableSwitch(1, n6 - 1);
                            for (n5 = 0; n5 != n6; ++n5) {
                                if (classFileWriter.getStackTop() != 0) {
                                    Kit.codeBug();
                                }
                                String string3 = ((ScriptNode)object).getParamOrVarName(n5);
                                if (n5 == 0) {
                                    classFileWriter.markTableSwitchDefault(n7);
                                } else {
                                    classFileWriter.markTableSwitchCase(n7, n5 - 1, 0);
                                }
                                classFileWriter.addPush(string3);
                                classFileWriter.add(176);
                            }
                            continue;
                        }
                        classFileWriter.addPush(((ScriptNode)object).getParamAndVarCount());
                        classFileWriter.add(172);
                        continue;
                    }
                    classFileWriter.addPush(((ScriptNode)object).getParamCount());
                    classFileWriter.add(172);
                    continue;
                }
                if (((Node)object).getType() == 137) {
                    classFileWriter.addPush("");
                } else {
                    classFileWriter.addPush(((FunctionNode)object).getName());
                }
                classFileWriter.add(176);
            }
            classFileWriter.stopMethod((short)n);
        }
    }

    private void generateResumeGenerator(ClassFileWriter classFileWriter) {
        Object object;
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < ((ScriptNode[])(object = this.scriptOrFnNodes)).length; ++n) {
            if (!Codegen.isGenerator(object[n])) continue;
            n3 = 1;
        }
        if (n3 == 0) {
            return;
        }
        classFileWriter.startMethod("resumeGenerator", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;ILjava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(4);
        classFileWriter.addALoad(5);
        classFileWriter.addILoad(3);
        classFileWriter.addLoadThis();
        classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        int n4 = classFileWriter.addTableSwitch(0, this.scriptOrFnNodes.length - 1);
        classFileWriter.markTableSwitchDefault(n4);
        n3 = classFileWriter.acquireLabel();
        for (n = n2; n < ((ScriptNode[])(object = this.scriptOrFnNodes)).length; ++n) {
            object = object[n];
            classFileWriter.markTableSwitchCase(n4, n, 6);
            if (Codegen.isGenerator((ScriptNode)object)) {
                CharSequence charSequence = new StringBuilder();
                charSequence.append("(");
                charSequence.append(this.mainClassSignature);
                charSequence.append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
                charSequence = charSequence.toString();
                String string2 = this.mainClassName;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.getBodyMethodName((ScriptNode)object));
                stringBuilder.append("_gen");
                classFileWriter.addInvoke(184, string2, stringBuilder.toString(), (String)charSequence);
                classFileWriter.add(176);
                continue;
            }
            classFileWriter.add(167, n3);
        }
        classFileWriter.markLabel(n3);
        Codegen.pushUndefined(classFileWriter);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)6);
    }

    private void generateScriptCtor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.addLoadThis();
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addPush(0);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private static String getStaticConstantWrapperType(double d) {
        if ((double)((int)d) == d) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    private static void initOptFunctions_r(ScriptNode scriptNode) {
        int n = scriptNode.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = scriptNode.getFunctionNode(i);
            new OptFunctionNode(functionNode);
            Codegen.initOptFunctions_r(functionNode);
        }
    }

    private void initScriptNodesData(ScriptNode objectArray) {
        ObjArray objArray = new ObjArray();
        Codegen.collectScriptNodes_r((ScriptNode)objectArray, objArray);
        int n = objArray.size();
        objectArray = new ScriptNode[n];
        this.scriptOrFnNodes = objectArray;
        objArray.toArray(objectArray);
        this.scriptOrFnIndexes = new ObjToIntMap(n);
        for (int i = 0; i != n; ++i) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[i], i);
        }
    }

    static boolean isGenerator(ScriptNode scriptNode) {
        boolean bl = scriptNode.getType() == 110 && ((FunctionNode)scriptNode).isGenerator();
        return bl;
    }

    static void pushUndefined(ClassFileWriter classFileWriter) {
        classFileWriter.add(178, "org/mozilla/javascript/Undefined", "instance", "Ljava/lang/Object;");
    }

    private RuntimeException reportClassFileFormatException(ScriptNode scriptNode, String string2) {
        string2 = scriptNode instanceof FunctionNode ? ScriptRuntime.getMessage2("msg.while.compiling.fn", ((FunctionNode)scriptNode).getFunctionName(), string2) : ScriptRuntime.getMessage1("msg.while.compiling.script", string2);
        return Context.reportRuntimeError(string2, scriptNode.getSourceName(), scriptNode.getLineno(), null, 0);
    }

    private void transform(ScriptNode scriptNode) {
        Codegen.initOptFunctions_r(scriptNode);
        int n = this.compilerEnv.getOptimizationLevel();
        String string2 = null;
        String string3 = null;
        Object object = string2;
        if (n > 0) {
            object = string2;
            if (scriptNode.getType() == 137) {
                int n2 = scriptNode.getFunctionCount();
                int n3 = 0;
                while (true) {
                    object = string3;
                    if (n3 == n2) break;
                    OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptNode, n3);
                    object = string3;
                    if (optFunctionNode.fnode.getFunctionType() == 1) {
                        string2 = optFunctionNode.fnode.getName();
                        object = string3;
                        if (string2.length() != 0) {
                            object = string3;
                            if (string3 == null) {
                                object = new HashMap();
                            }
                            object.put(string2, optFunctionNode);
                        }
                    }
                    ++n3;
                    string3 = object;
                }
            }
        }
        if (object != null) {
            this.directCallTargets = new ObjArray();
        }
        new OptTransformer((Map<String, OptFunctionNode>)object, this.directCallTargets).transform(scriptNode, this.compilerEnv);
        if (n > 0) {
            new Optimizer().optimize(scriptNode);
        }
    }

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        throw new UnsupportedOperationException();
    }

    String cleanName(ScriptNode object) {
        object = object instanceof FunctionNode ? ((object = ((FunctionNode)object).getFunctionName()) == null ? "anonymous" : ((Name)object).getIdentifier()) : "script";
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptNode scriptNode, String string2, boolean bl) {
        CharSequence charSequence;
        int n;
        Object object = globalLock;
        synchronized (object) {
            globalSerialClassCounter = n = globalSerialClassCounter + 1;
        }
        object = "c";
        if (scriptNode.getSourceName().length() > 0) {
            charSequence = scriptNode.getSourceName().replaceAll("\\W", "_");
            object = charSequence;
            if (!Character.isJavaIdentifierStart(((String)charSequence).charAt(0))) {
                object = new StringBuilder();
                ((StringBuilder)object).append("_");
                ((StringBuilder)object).append((String)charSequence);
                object = ((StringBuilder)object).toString();
            }
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("org.mozilla.javascript.gen.");
        ((StringBuilder)charSequence).append((String)object);
        ((StringBuilder)charSequence).append("_");
        ((StringBuilder)charSequence).append(n);
        object = ((StringBuilder)charSequence).toString();
        return new Object[]{object, this.compileToClassFile(compilerEnvirons, (String)object, scriptNode, string2, bl)};
    }

    public byte[] compileToClassFile(CompilerEnvirons object, String object2, ScriptNode scriptNode, String string2, boolean bl) {
        this.compilerEnv = object;
        this.transform(scriptNode);
        object = scriptNode;
        if (bl) {
            object = scriptNode.getFunctionNode(0);
        }
        this.initScriptNodesData((ScriptNode)object);
        this.mainClassName = object2;
        this.mainClassSignature = ClassFileWriter.classNameToSignature((String)object2);
        try {
            object2 = this.generateCode(string2);
            return object2;
        }
        catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
            throw this.reportClassFileFormatException((ScriptNode)object, classFileFormatException.getMessage());
        }
    }

    @Override
    public Function createFunctionObject(Context object, Scriptable object2, Object clazz, Object object3) {
        clazz = this.defineClass(clazz, object3);
        try {
            object = (NativeFunction)clazz.getConstructors()[0].newInstance(object2, object, 0);
            return object;
        }
        catch (Exception exception) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unable to instantiate compiled class:");
            ((StringBuilder)object2).append(exception.toString());
            throw new RuntimeException(((StringBuilder)object2).toString());
        }
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        object = this.defineClass(object, object2);
        try {
            object = (Script)((Class)object).newInstance();
            return object;
        }
        catch (Exception exception) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unable to instantiate compiled class:");
            ((StringBuilder)object2).append(exception.toString());
            throw new RuntimeException(((StringBuilder)object2).toString());
        }
    }

    String getBodyMethodName(ScriptNode scriptNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_c_");
        stringBuilder.append(this.cleanName(scriptNode));
        stringBuilder.append("_");
        stringBuilder.append(this.getIndex(scriptNode));
        return stringBuilder.toString();
    }

    String getBodyMethodSignature(ScriptNode object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(this.mainClassSignature);
        stringBuilder.append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        if (((Node)object).getType() == 110 && ((OptFunctionNode)(object = OptFunctionNode.get((ScriptNode)object))).isTargetOfDirectCall()) {
            int n = ((OptFunctionNode)object).fnode.getParamCount();
            for (int i = 0; i != n; ++i) {
                stringBuilder.append("Ljava/lang/Object;D");
            }
        }
        stringBuilder.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return stringBuilder.toString();
    }

    String getCompiledRegexpName(ScriptNode scriptNode, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_re");
        stringBuilder.append(this.getIndex(scriptNode));
        stringBuilder.append("_");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    String getDirectCtorName(ScriptNode scriptNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_n");
        stringBuilder.append(this.getIndex(scriptNode));
        return stringBuilder.toString();
    }

    String getFunctionInitMethodName(OptFunctionNode optFunctionNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("_i");
        stringBuilder.append(this.getIndex(optFunctionNode.fnode));
        return stringBuilder.toString();
    }

    int getIndex(ScriptNode scriptNode) {
        return this.scriptOrFnIndexes.getExisting(scriptNode);
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    void pushNumberAsObject(ClassFileWriter classFileWriter, double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "zeroObj", "Ljava/lang/Double;");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
        } else {
            if (d == 1.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "oneObj", "Ljava/lang/Double;");
                return;
            }
            if (d == -1.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Double;");
            } else if (d != d) {
                classFileWriter.add(178, "org/mozilla/javascript/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else {
                int n = this.itsConstantListSize;
                if (n >= 2000) {
                    classFileWriter.addPush(d);
                    Codegen.addDoubleWrap(classFileWriter);
                } else {
                    Object object;
                    int n2 = 0;
                    if (n == 0) {
                        this.itsConstantList = new double[64];
                    } else {
                        object = this.itsConstantList;
                        for (n2 = 0; n2 != n && object[n2] != d; ++n2) {
                        }
                        if (n == ((double[])object).length) {
                            object = new double[n * 2];
                            System.arraycopy(this.itsConstantList, 0, object, 0, n);
                            this.itsConstantList = (double[])object;
                        }
                    }
                    if (n2 == n) {
                        this.itsConstantList[n] = d;
                        this.itsConstantListSize = n + 1;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("_k");
                    ((StringBuilder)object).append(n2);
                    object = ((StringBuilder)object).toString();
                    String string2 = Codegen.getStaticConstantWrapperType(d);
                    classFileWriter.add(178, this.mainClassName, (String)object, string2);
                }
            }
        }
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        throw new UnsupportedOperationException();
    }

    public void setMainMethodClass(String string2) {
        this.mainMethodClass = string2;
    }
}

