/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.ArrowFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGenerator;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class OptRuntime
extends ScriptRuntime {
    public static final Double minusOneObj;
    public static final Double oneObj;
    public static final Double zeroObj;

    static {
        zeroObj = new Double(0.0);
        oneObj = new Double(1.0);
        minusOneObj = new Double(-1.0);
    }

    public static Object add(double d, Object object) {
        Object object2 = object;
        if (object instanceof Scriptable) {
            object2 = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object2 instanceof CharSequence)) {
            return OptRuntime.wrapDouble(OptRuntime.toNumber(object2) + d);
        }
        return new ConsString(OptRuntime.toString(d), (CharSequence)object2);
    }

    public static Object add(Object object, double d) {
        Object object2 = object;
        if (object instanceof Scriptable) {
            object2 = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object2 instanceof CharSequence)) {
            return OptRuntime.wrapDouble(OptRuntime.toNumber(object2) + d);
        }
        return new ConsString((CharSequence)object2, OptRuntime.toString(d));
    }

    public static Function bindThis(NativeFunction nativeFunction, Context context, Scriptable scriptable, Scriptable scriptable2) {
        return new ArrowFunction(context, scriptable, nativeFunction, scriptable2);
    }

    public static Object call0(Callable callable, Scriptable scriptable, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, ScriptRuntime.emptyArgs);
    }

    public static Object call1(Callable callable, Scriptable scriptable, Object object, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, new Object[]{object});
    }

    public static Object call2(Callable callable, Scriptable scriptable, Object object, Object object2, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, new Object[]{object, object2});
    }

    public static Object callN(Callable callable, Scriptable scriptable, Object[] objectArray, Context context, Scriptable scriptable2) {
        return callable.call(context, scriptable2, scriptable, objectArray);
    }

    public static Object callName(Object[] objectArray, String string2, Context context, Scriptable scriptable) {
        return OptRuntime.getNameFunctionAndThis(string2, context, scriptable).call(context, scriptable, OptRuntime.lastStoredScriptable(context), objectArray);
    }

    public static Object callName0(String string2, Context context, Scriptable scriptable) {
        return OptRuntime.getNameFunctionAndThis(string2, context, scriptable).call(context, scriptable, OptRuntime.lastStoredScriptable(context), ScriptRuntime.emptyArgs);
    }

    public static Object callProp0(Object object, String string2, Context context, Scriptable scriptable) {
        return OptRuntime.getPropFunctionAndThis(object, string2, context, scriptable).call(context, scriptable, OptRuntime.lastStoredScriptable(context), ScriptRuntime.emptyArgs);
    }

    public static Object callSpecial(Context context, Callable callable, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, Scriptable scriptable3, int n, String string2, int n2) {
        return ScriptRuntime.callSpecial(context, callable, scriptable, objectArray, scriptable2, scriptable3, n, string2, n2);
    }

    public static Scriptable createNativeGenerator(NativeFunction nativeFunction, Scriptable scriptable, Scriptable scriptable2, int n, int n2) {
        return new NativeGenerator(scriptable, nativeFunction, new GeneratorState(scriptable2, n, n2));
    }

    private static int[] decodeIntArray(String string2, int n) {
        if (n == 0) {
            if (string2 == null) {
                return null;
            }
            throw new IllegalArgumentException();
        }
        int n2 = string2.length();
        if (n2 != n * 2 + 1 && string2.charAt(0) != '\u0001') {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[n];
        for (int i = 0; i != n; ++i) {
            int n3 = i * 2 + 1;
            n2 = string2.charAt(n3);
            nArray[i] = string2.charAt(n3 + 1) | n2 << 16;
        }
        return nArray;
    }

    @Deprecated
    public static Object elemIncrDecr(Object object, double d, Context context, int n) {
        return OptRuntime.elemIncrDecr(object, d, context, OptRuntime.getTopCallScope(context), n);
    }

    public static Object elemIncrDecr(Object object, double d, Context context, Scriptable scriptable, int n) {
        return ScriptRuntime.elemIncrDecr(object, new Double(d), context, scriptable, n);
    }

    static String encodeIntArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        char[] cArray = new char[n * 2 + 1];
        cArray[0] = (char)1;
        for (int i = 0; i != n; ++i) {
            int n2 = nArray[i];
            int n3 = i * 2 + 1;
            cArray[n3] = (char)(n2 >>> 16);
            cArray[n3 + 1] = (char)n2;
        }
        return new String(cArray);
    }

    public static Object[] getGeneratorLocalsState(Object object) {
        object = (GeneratorState)object;
        if (((GeneratorState)object).localsState == null) {
            ((GeneratorState)object).localsState = new Object[((GeneratorState)object).maxLocals];
        }
        return ((GeneratorState)object).localsState;
    }

    public static Object[] getGeneratorStackState(Object object) {
        object = (GeneratorState)object;
        if (((GeneratorState)object).stackState == null) {
            ((GeneratorState)object).stackState = new Object[((GeneratorState)object).maxStack];
        }
        return ((GeneratorState)object).stackState;
    }

    public static void initFunction(NativeFunction nativeFunction, int n, Scriptable scriptable, Context context) {
        ScriptRuntime.initFunction(context, scriptable, nativeFunction, n, false);
    }

    public static void main(final Script script, final String[] stringArray) {
        ContextFactory.getGlobal().call(new ContextAction(){

            @Override
            public Object run(Context context) {
                ScriptableObject scriptableObject = ScriptRuntime.getGlobal(context);
                String[] stringArray2 = stringArray;
                Object[] objectArray = new Object[stringArray2.length];
                System.arraycopy(stringArray2, 0, objectArray, 0, stringArray2.length);
                scriptableObject.defineProperty("arguments", (Object)context.newArray((Scriptable)scriptableObject, objectArray), 2);
                script.exec(context, scriptableObject);
                return null;
            }
        });
    }

    public static Scriptable newArrayLiteral(Object[] objectArray, String string2, int n, Context context, Scriptable scriptable) {
        return OptRuntime.newArrayLiteral(objectArray, OptRuntime.decodeIntArray(string2, n), context, scriptable);
    }

    public static Object newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, int n) {
        return ScriptRuntime.newSpecial(context, object, objectArray, scriptable, n);
    }

    public static Object[] padStart(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length + n];
        System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
        return objectArray2;
    }

    public static void throwStopIteration(Object object) {
        throw new JavaScriptException(NativeIterator.getStopIterationObject((Scriptable)object), "", 0);
    }

    public static Double wrapDouble(double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                return zeroObj;
            }
        } else {
            if (d == 1.0) {
                return oneObj;
            }
            if (d == -1.0) {
                return minusOneObj;
            }
            if (d != d) {
                return NaNobj;
            }
        }
        return new Double(d);
    }

    public static class GeneratorState {
        static final String CLASS_NAME = "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState";
        static final String resumptionPoint_NAME = "resumptionPoint";
        static final String resumptionPoint_TYPE = "I";
        static final String thisObj_NAME = "thisObj";
        static final String thisObj_TYPE = "Lorg/mozilla/javascript/Scriptable;";
        Object[] localsState;
        int maxLocals;
        int maxStack;
        public int resumptionPoint;
        Object[] stackState;
        public Scriptable thisObj;

        GeneratorState(Scriptable scriptable, int n, int n2) {
            this.thisObj = scriptable;
            this.maxLocals = n;
            this.maxStack = n2;
        }
    }
}

