/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RECompiled;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    protected String input;
    protected SubString lastMatch;
    protected SubString lastParen;
    protected SubString leftContext;
    protected boolean multiline;
    protected SubString[] parens;
    protected SubString rightContext;

    private static NativeRegExp createRegExp(Context object, Scriptable object2, Object[] objectArray, int n, boolean bl) {
        Scriptable scriptable = ScriptableObject.getTopLevelScope((Scriptable)object2);
        if (objectArray.length != 0 && objectArray[0] != Undefined.instance) {
            if (objectArray[0] instanceof NativeRegExp) {
                object = (NativeRegExp)objectArray[0];
            } else {
                String string2 = ScriptRuntime.toString(objectArray[0]);
                if (n < objectArray.length) {
                    objectArray[0] = string2;
                    object2 = ScriptRuntime.toString(objectArray[n]);
                } else {
                    object2 = null;
                }
                object = new NativeRegExp(scriptable, NativeRegExp.compileRE((Context)object, string2, (String)object2, bl));
            }
        } else {
            object = new NativeRegExp(scriptable, NativeRegExp.compileRE((Context)object, "", "", false));
        }
        return object;
    }

    private static void do_replace(GlobData object, Context context, RegExpImpl regExpImpl) {
        StringBuilder stringBuilder = ((GlobData)object).charBuf;
        String string2 = ((GlobData)object).repstr;
        int n = ((GlobData)object).dollar;
        int n2 = 0;
        if (n != -1) {
            int n3;
            int[] nArray = new int[1];
            int n4 = 0;
            do {
                stringBuilder.append(string2.substring(n4, n));
                object = RegExpImpl.interpretDollar(context, regExpImpl, string2, n, nArray);
                if (object != null) {
                    n2 = ((SubString)object).length;
                    if (n2 > 0) {
                        stringBuilder.append(((SubString)object).str, ((SubString)object).index, ((SubString)object).index + n2);
                    }
                    n2 = nArray[0] + n;
                    n += nArray[0];
                } else {
                    n2 = n++;
                }
                n3 = string2.indexOf(36, n);
                n4 = n2;
                n = n3;
            } while (n3 >= 0);
        }
        if ((n = string2.length()) > n2) {
            stringBuilder.append(string2.substring(n2, n));
        }
    }

    private static int find_split(Context context, Scriptable scriptable, String string2, String string3, int n, RegExpProxy regExpProxy, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n2 = nArray[0];
        int n3 = string2.length();
        int n4 = -1;
        if (n == 120 && scriptable2 == null && string3.length() == 1 && string3.charAt(0) == ' ') {
            n4 = n2;
            if (n2 == 0) {
                for (n4 = n2; n4 < n3 && Character.isWhitespace(string2.charAt(n4)); ++n4) {
                }
                nArray[0] = n4;
            }
            if (n4 == n3) {
                return -1;
            }
            for (n = n4; n < n3 && !Character.isWhitespace(string2.charAt(n)); ++n) {
            }
            for (n4 = n; n4 < n3 && Character.isWhitespace(string2.charAt(n4)); ++n4) {
            }
            nArray2[0] = n4 - n;
            return n;
        }
        if (n2 > n3) {
            return -1;
        }
        if (scriptable2 != null) {
            return regExpProxy.find_split(context, scriptable, string2, string3, scriptable2, nArray, nArray2, blArray, stringArray);
        }
        if (n != 0 && n < 130 && n3 == 0) {
            return -1;
        }
        if (string3.length() == 0) {
            if (n == 120) {
                if (n2 == n3) {
                    nArray2[0] = 1;
                    return n2;
                }
                return n2 + 1;
            }
            n = n2 == n3 ? n4 : n2 + 1;
            return n;
        }
        if (nArray[0] >= n3) {
            return n3;
        }
        n4 = string2.indexOf(string3, nArray[0]);
        n = n3;
        if (n4 != -1) {
            n = n4;
        }
        return n;
    }

    private static SubString interpretDollar(Context subStringArray, RegExpImpl regExpImpl, String string2, int n, int[] nArray) {
        int n2;
        if (string2.charAt(n) != '$') {
            Kit.codeBug();
        }
        if ((n2 = subStringArray.getLanguageVersion()) != 0 && n2 <= 140 && n > 0 && string2.charAt(n - 1) == '\\') {
            return null;
        }
        int n3 = n + 1;
        int n4 = string2.length();
        if (n3 >= n4) {
            return null;
        }
        char c = string2.charAt(n3);
        if (NativeRegExp.isDigit(c)) {
            int n5;
            int n6;
            block18: {
                if (n2 != 0 && n2 <= 140) {
                    if (c == '0') {
                        return null;
                    }
                    n3 = n;
                    n2 = 0;
                    while (true) {
                        n6 = n2;
                        n5 = ++n3;
                        if (n3 >= n4) break block18;
                        c = string2.charAt(n3);
                        n6 = n2;
                        n5 = n3;
                        if (!NativeRegExp.isDigit(c)) break block18;
                        n6 = n2 * 10 + (c - 48);
                        if (n6 < n2) {
                            n6 = n2;
                            n5 = n3;
                            break block18;
                        }
                        n2 = n6;
                    }
                }
                n6 = c - 48;
                subStringArray = regExpImpl.parens;
                n2 = subStringArray == null ? 0 : subStringArray.length;
                if (n6 > n2) {
                    return null;
                }
                n5 = n + 2;
                if (n5 < n4 && NativeRegExp.isDigit(c = string2.charAt(n5)) && (n3 = n6 * 10 + (c - 48)) <= n2) {
                    n6 = n5 + 1;
                    n2 = n3;
                    n3 = n6;
                } else {
                    n3 = n5;
                    n2 = n6;
                }
                n6 = n2;
                n5 = n3;
                if (n2 == 0) {
                    return null;
                }
            }
            nArray[0] = n5 - n;
            return regExpImpl.getParenSubString(n6 - 1);
        }
        nArray[0] = 2;
        if (c != '$') {
            if (c != '+') {
                if (c != '`') {
                    if (c != '&') {
                        if (c != '\'') {
                            return null;
                        }
                        return regExpImpl.rightContext;
                    }
                    return regExpImpl.lastMatch;
                }
                if (n2 == 120) {
                    regExpImpl.leftContext.index = 0;
                    regExpImpl.leftContext.length = regExpImpl.lastMatch.index;
                }
                return regExpImpl.leftContext;
            }
            return regExpImpl.lastParen;
        }
        return new SubString("$");
    }

    private static Object matchOrReplace(Context object, Scriptable scriptable, Scriptable object2, Object[] objectArray, RegExpImpl regExpImpl, GlobData globData, NativeRegExp nativeRegExp) {
        String string2 = globData.str;
        boolean bl = (nativeRegExp.getFlags() & 1) != 0;
        globData.global = bl;
        objectArray = new int[1];
        objectArray[0] = false;
        object2 = null;
        if (globData.mode == 3) {
            object2 = (object = nativeRegExp.executeRegExp((Context)object, scriptable, regExpImpl, string2, (int[])objectArray, 0)) != null && object.equals(Boolean.TRUE) ? Integer.valueOf(regExpImpl.leftContext.length) : Integer.valueOf(-1);
        } else if (globData.global) {
            nativeRegExp.lastIndex = 0.0;
            int n = 0;
            while (objectArray[0] <= string2.length() && (object2 = nativeRegExp.executeRegExp((Context)object, scriptable, regExpImpl, string2, (int[])objectArray, 0)) != null && object2.equals(Boolean.TRUE)) {
                if (globData.mode == 1) {
                    RegExpImpl.match_glob(globData, (Context)object, scriptable, n, regExpImpl);
                } else {
                    if (globData.mode != 2) {
                        Kit.codeBug();
                    }
                    SubString subString = regExpImpl.lastMatch;
                    int n2 = globData.leftIndex;
                    int n3 = subString.index;
                    globData.leftIndex = subString.index + subString.length;
                    RegExpImpl.replace_glob(globData, (Context)object, scriptable, regExpImpl, n2, n3 - n2);
                }
                if (regExpImpl.lastMatch.length == 0) {
                    if (objectArray[0] == string2.length()) break;
                    objectArray[0] = objectArray[0] + true;
                }
                ++n;
            }
        } else {
            int n = globData.mode == 2 ? 0 : 1;
            object2 = nativeRegExp.executeRegExp((Context)object, scriptable, regExpImpl, string2, (int[])objectArray, n);
        }
        return object2;
    }

    private static void match_glob(GlobData globData, Context object, Scriptable scriptable, int n, RegExpImpl regExpImpl) {
        if (globData.arrayobj == null) {
            globData.arrayobj = ((Context)object).newArray(scriptable, 0);
        }
        object = regExpImpl.lastMatch.toString();
        globData.arrayobj.put(n, globData.arrayobj, object);
    }

    private static void replace_glob(GlobData globData, Context context, Scriptable object, RegExpImpl regExpImpl, int n, int n2) {
        int n3;
        int n4;
        Object object2 = globData.lambda;
        if (object2 != null) {
            Object object3 = regExpImpl.parens;
            n4 = object3 == null ? 0 : ((SubString[])object3).length;
            object2 = new Object[n4 + 3];
            object2[0] = regExpImpl.lastMatch.toString();
            for (n3 = 0; n3 < n4; ++n3) {
                SubString subString = object3[n3];
                object2[n3 + 1] = subString != null ? subString.toString() : Undefined.instance;
            }
            object2[n4 + 1] = regExpImpl.leftContext.length;
            object2[n4 + 2] = globData.str;
            if (regExpImpl != ScriptRuntime.getRegExpProxy(context)) {
                Kit.codeBug();
            }
            object3 = new RegExpImpl();
            object3.multiline = regExpImpl.multiline;
            object3.input = regExpImpl.input;
            ScriptRuntime.setRegExpProxy(context, (RegExpProxy)object3);
            try {
                object = ScriptableObject.getTopLevelScope((Scriptable)object);
                object = ScriptRuntime.toString(globData.lambda.call(context, (Scriptable)object, (Scriptable)object, (Object[])object2));
                n4 = ((String)object).length();
            }
            finally {
                ScriptRuntime.setRegExpProxy(context, regExpImpl);
            }
        } else {
            int n5;
            object2 = null;
            n4 = n5 = globData.repstr.length();
            object = object2;
            if (globData.dollar >= 0) {
                int n6;
                object = new int[1];
                n3 = globData.dollar;
                do {
                    SubString subString;
                    if ((subString = RegExpImpl.interpretDollar(context, regExpImpl, globData.repstr, n3, (int[])object)) != null) {
                        n4 = n5 + (subString.length - object[0]);
                        n3 += object[0];
                    } else {
                        ++n3;
                        n4 = n5;
                    }
                    n6 = globData.repstr.indexOf(36, n3);
                    n5 = n4;
                    n3 = n6;
                } while (n6 >= 0);
                object = object2;
            }
        }
        n4 = n4 + n2 + regExpImpl.rightContext.length;
        object2 = globData.charBuf;
        if (object2 == null) {
            globData.charBuf = object2 = new StringBuilder(n4);
        } else {
            ((StringBuilder)object2).ensureCapacity(globData.charBuf.length() + n4);
        }
        ((StringBuilder)object2).append(regExpImpl.leftContext.str, n, n2 + n);
        if (globData.lambda != null) {
            ((StringBuilder)object2).append((String)object);
        } else {
            RegExpImpl.do_replace(globData, context, regExpImpl);
        }
    }

    @Override
    public Object action(Context object, Scriptable scriptable, Scriptable object2, Object[] objectArray, int n) {
        GlobData globData = new GlobData();
        globData.mode = n;
        globData.str = ScriptRuntime.toString(object2);
        if (n != 1) {
            Function function;
            Object object3;
            NativeRegExp nativeRegExp;
            if (n != 2) {
                if (n == 3) {
                    return RegExpImpl.matchOrReplace((Context)object, scriptable, (Scriptable)object2, objectArray, this, globData, RegExpImpl.createRegExp((Context)object, scriptable, objectArray, 1, false));
                }
                throw Kit.codeBug();
            }
            n = objectArray.length > 0 && objectArray[0] instanceof NativeRegExp || objectArray.length > 2 ? 1 : 0;
            if (n != 0) {
                nativeRegExp = RegExpImpl.createRegExp((Context)object, scriptable, objectArray, 2, true);
                object3 = null;
            } else {
                object3 = objectArray.length < 1 ? Undefined.instance : objectArray[0];
                object3 = ScriptRuntime.toString(object3);
                nativeRegExp = null;
            }
            Object object4 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
            if (object4 instanceof Function) {
                function = (Function)object4;
                object4 = null;
            } else {
                object4 = ScriptRuntime.toString(object4);
                function = null;
            }
            globData.lambda = function;
            globData.repstr = object4;
            int n2 = object4 == null ? -1 : ((String)object4).indexOf(36);
            globData.dollar = n2;
            globData.charBuf = null;
            globData.leftIndex = 0;
            if (n != 0) {
                object2 = RegExpImpl.matchOrReplace((Context)object, scriptable, (Scriptable)object2, objectArray, this, globData, nativeRegExp);
            } else {
                object2 = globData.str;
                n = ((String)object2).indexOf((String)object3);
                if (n >= 0) {
                    n2 = ((String)object3).length();
                    this.lastParen = null;
                    this.leftContext = new SubString((String)object2, 0, n);
                    this.lastMatch = new SubString((String)object2, n, n2);
                    this.rightContext = new SubString((String)object2, n + n2, ((String)object2).length() - n - n2);
                    object2 = Boolean.TRUE;
                } else {
                    object2 = Boolean.FALSE;
                }
            }
            if (globData.charBuf == null) {
                if (!globData.global && object2 != null && object2.equals(Boolean.TRUE)) {
                    object2 = this.leftContext;
                    RegExpImpl.replace_glob(globData, (Context)object, scriptable, this, ((SubString)object2).index, ((SubString)object2).length);
                } else {
                    return globData.str;
                }
            }
            object = this.rightContext;
            globData.charBuf.append(((SubString)object).str, ((SubString)object).index, ((SubString)object).index + ((SubString)object).length);
            return globData.charBuf.toString();
        }
        object = RegExpImpl.matchOrReplace((Context)object, scriptable, (Scriptable)object2, objectArray, this, globData, RegExpImpl.createRegExp((Context)object, scriptable, objectArray, 1, false));
        if (globData.arrayobj != null) {
            object = globData.arrayobj;
        }
        return object;
    }

    @Override
    public Object compileRegExp(Context context, String string2, String string3) {
        return NativeRegExp.compileRE(context, string2, string3, false);
    }

    @Override
    public int find_split(Context object, Scriptable scriptable, String string2, String object2, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n;
        int n2;
        int n3;
        block5: {
            n3 = nArray[0];
            n2 = string2.length();
            n = ((Context)object).getLanguageVersion();
            object2 = (NativeRegExp)scriptable2;
            while (true) {
                int n4 = nArray[0];
                nArray[0] = ++n3;
                if (((NativeRegExp)object2).executeRegExp((Context)object, scriptable, this, string2, nArray, 0) != Boolean.TRUE) {
                    nArray[0] = n4;
                    nArray2[0] = 1;
                    blArray[0] = false;
                    return n2;
                }
                n3 = nArray[0];
                nArray[0] = n4;
                blArray[0] = true;
                nArray2[0] = this.lastMatch.length;
                if (nArray2[0] != 0 || n3 != nArray[0]) break;
                if (n3 != n2) continue;
                if (n == 120) {
                    nArray2[0] = 1;
                } else {
                    n3 = -1;
                }
                break block5;
            }
            n3 -= nArray2[0];
        }
        object = this.parens;
        n = object == null ? 0 : ((SubString[])object).length;
        stringArray[0] = new String[n];
        for (n2 = 0; n2 < n; ++n2) {
            object = this.getParenSubString(n2);
            stringArray[0][n2] = ((SubString)object).toString();
        }
        return n3;
    }

    SubString getParenSubString(int n) {
        Object object = this.parens;
        if (object != null && n < ((SubString[])object).length && (object = object[n]) != null) {
            return object;
        }
        return new SubString();
    }

    @Override
    public boolean isRegExp(Scriptable scriptable) {
        return scriptable instanceof NativeRegExp;
    }

    @Override
    public Object js_split(Context context, Scriptable scriptable, String string2, Object[] object) {
        Scriptable scriptable2 = context.newArray(scriptable, 0);
        boolean bl = ((Object[])object).length > 1 && object[1] != Undefined.instance;
        long l = 0L;
        if (bl) {
            long l2;
            l = l2 = ScriptRuntime.toUint32(object[1]);
            if (l2 > (long)string2.length()) {
                l = string2.length() + 1;
            }
        }
        if (((Object[])object).length >= 1 && object[0] != Undefined.instance) {
            int n;
            Object object2;
            RegExpProxy regExpProxy;
            int[] nArray = new int[1];
            if (object[0] instanceof Scriptable) {
                regExpProxy = ScriptRuntime.getRegExpProxy(context);
                if (regExpProxy == null || !regExpProxy.isRegExp((Scriptable)(object2 = (Scriptable)object[0]))) {
                    object2 = null;
                }
            } else {
                regExpProxy = null;
                object2 = regExpProxy;
            }
            if (object2 == null) {
                object = ScriptRuntime.toString(object[0]);
                nArray[0] = ((String)object).length();
            } else {
                object = null;
            }
            int[] nArray2 = new int[]{0};
            boolean[] blArray = new boolean[]{false};
            String[][] stringArray = new String[][]{null};
            int n2 = context.getLanguageVersion();
            int n3 = 0;
            while (!((n = RegExpImpl.find_split(context, scriptable, string2, (String)object, n2, regExpProxy, (Scriptable)object2, nArray2, nArray, blArray, stringArray)) < 0 || bl && (long)n3 >= l || n > string2.length())) {
                int n4;
                String string3 = string2.length() == 0 ? string2 : string2.substring(nArray2[0], n);
                scriptable2.put(n3, scriptable2, (Object)string3);
                n3 = n4 = n3 + 1;
                if (object2 != null) {
                    n3 = n4;
                    if (blArray[0]) {
                        int n5 = stringArray[0].length;
                        int n6 = 0;
                        n3 = n4;
                        for (n4 = n6; !(n4 >= n5 || bl && (long)n3 >= l); ++n4) {
                            scriptable2.put(n3, scriptable2, (Object)stringArray[0][n4]);
                            ++n3;
                        }
                        blArray[0] = false;
                    }
                }
                nArray2[0] = n + nArray[0];
                if (n2 >= 130 || n2 == 0 || bl || nArray2[0] != string2.length()) continue;
                break;
            }
            return scriptable2;
        }
        scriptable2.put(0, scriptable2, (Object)string2);
        return scriptable2;
    }

    @Override
    public Scriptable wrapRegExp(Context context, Scriptable scriptable, Object object) {
        return new NativeRegExp(scriptable, (RECompiled)object);
    }
}

