/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.serialize.ScriptableOutputStream;

public class ScriptableInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;
    private Scriptable scope;

    public ScriptableInputStream(InputStream object, Scriptable scriptable) throws IOException {
        super((InputStream)object);
        this.scope = scriptable;
        this.enableResolveObject(true);
        object = Context.getCurrentContext();
        if (object != null) {
            this.classLoader = ((Context)object).getApplicationClassLoader();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string2 = objectStreamClass.getName();
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) return super.resolveClass(objectStreamClass);
        try {
            return classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(objectStreamClass);
        }
    }

    @Override
    protected Object resolveObject(Object object) throws IOException {
        Object object2;
        if (object instanceof ScriptableOutputStream.PendingLookup) {
            object2 = ScriptableOutputStream.lookupQualifiedName(this.scope, (String)(object = ((ScriptableOutputStream.PendingLookup)object).getName()));
            if (object2 == Scriptable.NOT_FOUND) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Object ");
                ((StringBuilder)object2).append((String)object);
                ((StringBuilder)object2).append(" not found upon deserialization.");
                throw new IOException(((StringBuilder)object2).toString());
            }
        } else if (object instanceof UniqueTag) {
            object2 = ((UniqueTag)object).readResolve();
        } else {
            object2 = object;
            if (object instanceof Undefined) {
                object2 = ((Undefined)object).readResolve();
            }
        }
        return object2;
    }
}

