/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.serialize;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public class ScriptableOutputStream
extends ObjectOutputStream {
    private Scriptable scope;
    private Map<Object, String> table;

    public ScriptableOutputStream(OutputStream object, Scriptable scriptable) throws IOException {
        super((OutputStream)object);
        this.scope = scriptable;
        this.table = object = new HashMap();
        object.put(scriptable, "");
        this.enableReplaceObject(true);
        this.excludeStandardObjectNames();
    }

    static Object lookupQualifiedName(Scriptable object, String object2) {
        block1: {
            Object object3;
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ".");
            do {
                object2 = object;
                if (!stringTokenizer.hasMoreTokens()) break block1;
                object2 = stringTokenizer.nextToken();
                object2 = object3 = ScriptableObject.getProperty((Scriptable)object, (String)object2);
                if (object3 == null) break block1;
                object = object3;
            } while (object3 instanceof Scriptable);
            object2 = object3;
        }
        return object2;
    }

    public void addExcludedName(String string2) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string2);
        if (object instanceof Scriptable) {
            this.table.put(object, string2);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Object for excluded name ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(" not found.");
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public void addOptionalExcludedName(String string2) {
        Object object = ScriptableOutputStream.lookupQualifiedName(this.scope, string2);
        if (object != null && object != UniqueTag.NOT_FOUND) {
            if (object instanceof Scriptable) {
                this.table.put(object, string2);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Object for excluded name ");
                stringBuilder.append(string2);
                stringBuilder.append(" is not a Scriptable, it is ");
                stringBuilder.append(object.getClass().getName());
                throw new IllegalArgumentException(stringBuilder.toString());
            }
        }
    }

    public void excludeAllIds(Object[] objectArray) {
        for (Object object : objectArray) {
            Scriptable scriptable;
            if (!(object instanceof String) || !((scriptable = this.scope).get((String)(object = (String)object), scriptable) instanceof Scriptable)) continue;
            this.addExcludedName((String)object);
        }
    }

    public void excludeStandardObjectNames() {
        int n;
        int n2 = 0;
        for (n = 0; n < 21; ++n) {
            this.addExcludedName((new String[]{"Object", "Object.prototype", "Function", "Function.prototype", "String", "String.prototype", "Math", "Array", "Array.prototype", "Error", "Error.prototype", "Number", "Number.prototype", "Date", "Date.prototype", "RegExp", "RegExp.prototype", "Script", "Script.prototype", "Continuation", "Continuation.prototype"})[n]);
        }
        for (n = n2; n < 4; ++n) {
            this.addOptionalExcludedName((new String[]{"XML", "XML.prototype", "XMLList", "XMLList.prototype"})[n]);
        }
    }

    public boolean hasExcludedName(String string2) {
        boolean bl = this.table.get(string2) != null;
        return bl;
    }

    public void removeExcludedName(String string2) {
        this.table.remove(string2);
    }

    @Override
    protected Object replaceObject(Object object) throws IOException {
        String string2 = this.table.get(object);
        if (string2 == null) {
            return object;
        }
        return new PendingLookup(string2);
    }

    static class PendingLookup
    implements Serializable {
        static final long serialVersionUID = -2692990309789917727L;
        private String name;

        PendingLookup(String string2) {
            this.name = string2;
        }

        String getName() {
            return this.name;
        }
    }
}

