/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.WrappedException;

public class ToolErrorReporter
implements ErrorReporter {
    private static final String messagePrefix = "js: ";
    private PrintStream err;
    private boolean hasReportedErrorFlag;
    private boolean reportWarnings;

    public ToolErrorReporter(boolean bl) {
        this(bl, System.err);
    }

    public ToolErrorReporter(boolean bl, PrintStream printStream) {
        this.reportWarnings = bl;
        this.err = printStream;
    }

    private String buildIndicator(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - 1; ++i) {
            stringBuilder.append(".");
        }
        stringBuilder.append("^");
        return stringBuilder.toString();
    }

    private static String getExceptionMessage(RhinoException object) {
        object = object instanceof JavaScriptException ? ToolErrorReporter.getMessage("msg.uncaughtJSException", ((RhinoException)object).details()) : (object instanceof EcmaError ? ToolErrorReporter.getMessage("msg.uncaughtEcmaError", ((RhinoException)object).details()) : (object instanceof EvaluatorException ? ((RhinoException)object).details() : ((Throwable)object).toString()));
        return object;
    }

    public static String getMessage(String string2) {
        Object[] objectArray = null;
        return ToolErrorReporter.getMessage(string2, null);
    }

    public static String getMessage(String string2, Object object, Object object2) {
        return ToolErrorReporter.getMessage(string2, new Object[]{object, object2});
    }

    public static String getMessage(String string2, String string3) {
        return ToolErrorReporter.getMessage(string2, new Object[]{string3});
    }

    public static String getMessage(String string2, Object[] objectArray) {
        Object object;
        block2: {
            object = Context.getCurrentContext();
            object = object == null ? Locale.getDefault() : ((Context)object).getLocale();
            object = ResourceBundle.getBundle("org.mozilla.javascript.tools.resources.Messages", (Locale)object);
            try {
                object = ((ResourceBundle)object).getString(string2);
                if (objectArray != null) break block2;
                return object;
            }
            catch (MissingResourceException missingResourceException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("no message resource found for message property ");
                stringBuilder.append(string2);
                throw new RuntimeException(stringBuilder.toString());
            }
        }
        return new MessageFormat((String)object).format(objectArray);
    }

    private void reportErrorMessage(String object, String object2, int n, String string2, int n2, boolean bl) {
        CharSequence charSequence;
        if (n > 0) {
            charSequence = String.valueOf(n);
            object = object2 != null ? ToolErrorReporter.getMessage("msg.format3", new Object[]{object2, charSequence, object}) : ToolErrorReporter.getMessage("msg.format2", new Object[]{charSequence, object});
        } else {
            object = ToolErrorReporter.getMessage("msg.format1", new Object[]{object});
        }
        object2 = object;
        if (bl) {
            object2 = ToolErrorReporter.getMessage("msg.warning", (String)object);
        }
        object = this.err;
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(messagePrefix);
        ((StringBuilder)charSequence).append((String)object2);
        ((PrintStream)object).println(((StringBuilder)charSequence).toString());
        if (string2 != null) {
            object = this.err;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(messagePrefix);
            ((StringBuilder)object2).append(string2);
            ((PrintStream)object).println(((StringBuilder)object2).toString());
            object2 = this.err;
            object = new StringBuilder();
            ((StringBuilder)object).append(messagePrefix);
            ((StringBuilder)object).append(this.buildIndicator(n2));
            ((PrintStream)object2).println(((StringBuilder)object).toString());
        }
    }

    public static void reportException(ErrorReporter errorReporter, RhinoException rhinoException) {
        if (errorReporter instanceof ToolErrorReporter) {
            ((ToolErrorReporter)errorReporter).reportException(rhinoException);
        } else {
            errorReporter.error(ToolErrorReporter.getExceptionMessage(rhinoException), rhinoException.sourceName(), rhinoException.lineNumber(), rhinoException.lineSource(), rhinoException.columnNumber());
        }
    }

    @Override
    public void error(String string2, String string3, int n, String string4, int n2) {
        this.hasReportedErrorFlag = true;
        this.reportErrorMessage(string2, string3, n, string4, n2, false);
    }

    public boolean hasReportedError() {
        return this.hasReportedErrorFlag;
    }

    public boolean isReportingWarnings() {
        return this.reportWarnings;
    }

    public void reportException(RhinoException rhinoException) {
        if (rhinoException instanceof WrappedException) {
            ((WrappedException)rhinoException).printStackTrace(this.err);
        } else {
            String string2 = SecurityUtilities.getSystemProperty("line.separator");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ToolErrorReporter.getExceptionMessage(rhinoException));
            stringBuilder.append(string2);
            stringBuilder.append(rhinoException.getScriptStackTrace());
            this.reportErrorMessage(stringBuilder.toString(), rhinoException.sourceName(), rhinoException.lineNumber(), rhinoException.lineSource(), rhinoException.columnNumber(), false);
        }
    }

    @Override
    public EvaluatorException runtimeError(String string2, String string3, int n, String string4, int n2) {
        return new EvaluatorException(string2, string3, n, string4, n2);
    }

    public void setIsReportingWarnings(boolean bl) {
        this.reportWarnings = bl;
    }

    @Override
    public void warning(String string2, String string3, int n, String string4, int n2) {
        if (!this.reportWarnings) {
            return;
        }
        this.reportErrorMessage(string2, string3, n, string4, n2, true);
    }
}

