/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableObject;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SourceProvider;

public class Dim {
    public static final int BREAK = 4;
    public static final int EXIT = 5;
    public static final int GO = 3;
    private static final int IPROXY_COMPILE_SCRIPT = 2;
    private static final int IPROXY_DEBUG = 0;
    private static final int IPROXY_EVAL_SCRIPT = 3;
    private static final int IPROXY_LISTEN = 1;
    private static final int IPROXY_OBJECT_IDS = 7;
    private static final int IPROXY_OBJECT_PROPERTY = 6;
    private static final int IPROXY_OBJECT_TO_STRING = 5;
    private static final int IPROXY_STRING_IS_COMPILABLE = 4;
    public static final int STEP_INTO = 1;
    public static final int STEP_OUT = 2;
    public static final int STEP_OVER = 0;
    private boolean breakFlag;
    private boolean breakOnEnter;
    private boolean breakOnExceptions;
    private boolean breakOnReturn;
    private GuiCallback callback;
    private ContextFactory contextFactory;
    private StackFrame evalFrame;
    private String evalRequest;
    private String evalResult;
    private Object eventThreadMonitor;
    private int frameIndex = -1;
    private final Map<String, FunctionSource> functionNames;
    private final Map<DebuggableScript, FunctionSource> functionToSource;
    private boolean insideInterruptLoop;
    private volatile ContextData interruptedContextData;
    private DimIProxy listener;
    private Object monitor = new Object();
    private volatile int returnValue = -1;
    private ScopeProvider scopeProvider;
    private SourceProvider sourceProvider;
    private final Map<String, SourceInfo> urlToSourceInfo;

    public Dim() {
        this.eventThreadMonitor = new Object();
        this.urlToSourceInfo = Collections.synchronizedMap(new HashMap());
        this.functionNames = Collections.synchronizedMap(new HashMap());
        this.functionToSource = Collections.synchronizedMap(new HashMap());
    }

    private static void collectFunctions_r(DebuggableScript debuggableScript, ObjArray objArray) {
        objArray.add(debuggableScript);
        for (int i = 0; i != debuggableScript.getFunctionCount(); ++i) {
            Dim.collectFunctions_r(debuggableScript.getFunction(i), objArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String do_eval(Context object, StackFrame object2, String string2) {
        Throwable throwable2;
        int n;
        Object object3;
        Debugger debugger;
        block6: {
            block5: {
                String string3 = "";
                debugger = ((Context)object).getDebugger();
                object3 = ((Context)object).getDebuggerContextData();
                n = ((Context)object).getOptimizationLevel();
                ((Context)object).setDebugger(null, null);
                ((Context)object).setOptimizationLevel(-1);
                ((Context)object).setGeneratingDebug(false);
                try {
                    try {
                        object2 = ((Callable)((Object)((Context)object).compileString(string2, "", 0, null))).call((Context)object, ((StackFrame)object2).scope, ((StackFrame)object2).thisObj, ScriptRuntime.emptyArgs);
                        if (object2 == Undefined.instance) {
                            object2 = string3;
                            break block5;
                        }
                        object2 = ScriptRuntime.toString(object2);
                    }
                    catch (Exception exception) {
                        object2 = exception.getMessage();
                    }
                }
                catch (Throwable throwable2) {
                    break block6;
                }
            }
            ((Context)object).setGeneratingDebug(true);
            ((Context)object).setOptimizationLevel(n);
            ((Context)object).setDebugger(debugger, object3);
            object = object2;
            if (object2 != null) return object;
            return "null";
        }
        ((Context)object).setGeneratingDebug(true);
        ((Context)object).setOptimizationLevel(n);
        ((Context)object).setDebugger(debugger, object3);
        throw throwable2;
    }

    private FunctionSource functionSource(DebuggableScript debuggableScript) {
        return this.functionToSource.get(debuggableScript);
    }

    private static DebuggableScript[] getAllFunctions(DebuggableScript objectArray) {
        ObjArray objArray = new ObjArray();
        Dim.collectFunctions_r((DebuggableScript)objectArray, objArray);
        objectArray = new DebuggableScript[objArray.size()];
        objArray.toArray(objectArray);
        return objectArray;
    }

    private FunctionSource getFunctionSource(DebuggableScript debuggableScript) {
        Object object;
        Object object2 = object = this.functionSource(debuggableScript);
        if (object == null) {
            String string2 = this.getNormalizedUrl(debuggableScript);
            object2 = object;
            if (this.sourceInfo(string2) == null) {
                object2 = object;
                if (!debuggableScript.isGeneratedScript()) {
                    string2 = this.loadSource(string2);
                    object2 = object;
                    if (string2 != null) {
                        object2 = debuggableScript;
                        while (true) {
                            if ((object = object2.getParent()) == null) {
                                this.registerTopScript((DebuggableScript)object2, string2);
                                object2 = this.functionSource(debuggableScript);
                                break;
                            }
                            object2 = object;
                        }
                    }
                }
            }
        }
        return object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getNormalizedUrl(DebuggableScript object) {
        String string2 = object.getSourceName();
        if (string2 == null) {
            return "<stdin>";
        }
        int n = string2.length();
        StringBuilder stringBuilder = null;
        int n2 = 0;
        while (true) {
            int n3;
            block10: {
                block9: {
                    int n4;
                    char c;
                    int n5;
                    if ((n3 = string2.indexOf(35, n2)) < 0) break block9;
                    for (n5 = n4 = n3 + 1; n5 != n && '0' <= (c = string2.charAt(n5)) && c <= '9'; ++n5) {
                    }
                    object = "(eval)";
                    if (n5 != n4 && "(eval)".regionMatches(0, string2, n5, 6)) {
                        n2 = n5 + 6;
                    } else {
                        object = null;
                    }
                    if (object != null) break block10;
                }
                object = string2;
                if (stringBuilder == null) return object;
                if (n2 == n) return stringBuilder.toString();
                stringBuilder.append(string2.substring(n2));
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder == null) {
                stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string2.substring(0, n3));
            }
            stringBuilder2.append((String)object);
            stringBuilder = stringBuilder2;
        }
    }

    private Object[] getObjectIdsImpl(Context objectArray, Object objectArray2) {
        if (objectArray2 instanceof Scriptable && objectArray2 != Undefined.instance) {
            objectArray = (objectArray2 = (Scriptable)objectArray2) instanceof DebuggableObject ? ((DebuggableObject)objectArray2).getAllIds() : objectArray2.getIds();
            Scriptable scriptable = objectArray2.getPrototype();
            Scriptable scriptable2 = objectArray2.getParentScope();
            int n = 1;
            int n2 = scriptable != null ? 1 : 0;
            int n3 = n2;
            if (scriptable2 != null) {
                n3 = n2 + 1;
            }
            objectArray2 = objectArray;
            if (n3 != 0) {
                objectArray2 = new Object[objectArray.length + n3];
                System.arraycopy(objectArray, 0, objectArray2, n3, objectArray.length);
                if (scriptable != null) {
                    objectArray2[0] = "__proto__";
                    n2 = n;
                } else {
                    n2 = 0;
                }
                if (scriptable2 != null) {
                    objectArray2[n2] = "__parent__";
                }
            }
            return objectArray2;
        }
        return Context.emptyArgs;
    }

    private Object getObjectPropertyImpl(Context object, Object object2, Object object3) {
        object = (Scriptable)object2;
        if (object3 instanceof String) {
            object2 = (String)object3;
            if (!((String)object2).equals("this")) {
                if (((String)object2).equals("__proto__")) {
                    object = object.getPrototype();
                } else if (((String)object2).equals("__parent__")) {
                    object = object.getParentScope();
                } else {
                    object = object2 = ScriptableObject.getProperty((Scriptable)object, (String)object2);
                    if (object2 == ScriptableObject.NOT_FOUND) {
                        object = Undefined.instance;
                    }
                }
            }
        } else {
            object = object2 = ScriptableObject.getProperty((Scriptable)object, (Integer)object3);
            if (object2 == ScriptableObject.NOT_FOUND) {
                object = Undefined.instance;
            }
        }
        return object;
    }

    private void handleBreakpointHit(StackFrame stackFrame, Context context) {
        this.breakFlag = false;
        this.interrupted(context, stackFrame, null);
    }

    private void handleExceptionThrown(Context context, Throwable throwable, StackFrame stackFrame) {
        ContextData contextData;
        if (this.breakOnExceptions && (contextData = stackFrame.contextData()).lastProcessedException != throwable) {
            this.interrupted(context, stackFrame, throwable);
            ContextData.access$302(contextData, throwable);
        }
    }

    /*
     * Exception decompiling
     */
    private void interrupted(Context var1_1, StackFrame var2_7, Throwable var3_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 14[TRYBLOCK] [19 : 292->298)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadSource(String object) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        block16: {
            int n = ((String)object).indexOf(35);
            object6 = object;
            if (n >= 0) {
                object6 = ((String)object).substring(0, n);
            }
            object4 = object5 = null;
            object3 = object6;
            n = ((String)object6).indexOf(58);
            object = object6;
            if (n < 0) {
                block17: {
                    object4 = object5;
                    object3 = object6;
                    try {
                        if (((String)object6).startsWith("~/")) {
                            object4 = object5;
                            object3 = object6;
                            String string2 = SecurityUtilities.getSystemProperty("user.home");
                            if (string2 != null) {
                                object4 = object5;
                                object3 = object6;
                                String string3 = ((String)object6).substring(2);
                                object4 = object5;
                                object3 = object6;
                                object4 = object5;
                                object3 = object6;
                                object4 = object5;
                                object3 = object6;
                                object = new File(string2);
                                object4 = object5;
                                object3 = object6;
                                object2 = new File((File)object, string3);
                                object4 = object5;
                                object3 = object6;
                                if (((File)object2).exists()) {
                                    object4 = object5;
                                    object3 = object6;
                                    object4 = object5;
                                    object3 = object6;
                                    object = new FileInputStream((File)object2);
                                    break block16;
                                }
                            }
                        }
                        object4 = object5;
                        object3 = object6;
                        object4 = object5;
                        object3 = object6;
                        object = new File((String)object6);
                        object4 = object5;
                        object3 = object6;
                        if (!((File)object).exists()) break block17;
                        object4 = object5;
                        object3 = object6;
                        object = new FileInputStream((File)object);
                        break block16;
                    }
                    catch (SecurityException securityException) {}
                }
                object4 = object5;
                object3 = object6;
                if (((String)object6).startsWith("//")) {
                    object4 = object5;
                    object3 = object6;
                    object4 = object5;
                    object3 = object6;
                    object = new StringBuilder();
                    object4 = object5;
                    object3 = object6;
                    ((StringBuilder)object).append("http:");
                    object4 = object5;
                    object3 = object6;
                    ((StringBuilder)object).append((String)object6);
                    object4 = object5;
                    object3 = object6;
                    object = ((StringBuilder)object).toString();
                } else {
                    object4 = object5;
                    object3 = object6;
                    if (((String)object6).startsWith("/")) {
                        object4 = object5;
                        object3 = object6;
                        object4 = object5;
                        object3 = object6;
                        object = new StringBuilder();
                        object4 = object5;
                        object3 = object6;
                        ((StringBuilder)object).append("http://127.0.0.1");
                        object4 = object5;
                        object3 = object6;
                        ((StringBuilder)object).append((String)object6);
                        object4 = object5;
                        object3 = object6;
                        object = ((StringBuilder)object).toString();
                    } else {
                        object4 = object5;
                        object3 = object6;
                        object4 = object5;
                        object3 = object6;
                        object = new StringBuilder();
                        object4 = object5;
                        object3 = object6;
                        ((StringBuilder)object).append("http://");
                        object4 = object5;
                        object3 = object6;
                        ((StringBuilder)object).append((String)object6);
                        object4 = object5;
                        object3 = object6;
                        object = ((StringBuilder)object).toString();
                    }
                }
            }
            object4 = object5;
            object3 = object;
            object4 = object5;
            object3 = object;
            object6 = new URL((String)object);
            object4 = object5;
            object3 = object;
            object2 = ((URL)object6).openStream();
            object6 = object;
            object = object2;
        }
        object3 = new InputStreamReader((InputStream)object);
        object4 = object2 = Kit.readReader((Reader)object3);
        object3 = object6;
        {
            catch (Throwable throwable) {
                object4 = object5;
                object3 = object6;
                ((InputStream)object).close();
                object4 = object5;
                object3 = object6;
                throw throwable;
            }
        }
        try {
            ((InputStream)object).close();
            return object2;
        }
        catch (IOException iOException) {
            object6 = System.err;
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to load source from ");
            ((StringBuilder)object).append((String)object3);
            ((StringBuilder)object).append(": ");
            ((StringBuilder)object).append(iOException);
            ((PrintStream)object6).println(((StringBuilder)object).toString());
        }
        return object4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerTopScript(DebuggableScript object, String map) {
        int n;
        int n2;
        if (!object.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        Object object2 = this.getNormalizedUrl((DebuggableScript)object);
        DebuggableScript[] debuggableScriptArray = Dim.getAllFunctions((DebuggableScript)object);
        SourceProvider sourceProvider = this.sourceProvider;
        Object object3 = map;
        if (sourceProvider != null) {
            object = sourceProvider.getSource((DebuggableScript)object);
            object3 = map;
            if (object != null) {
                object3 = object;
            }
        }
        object = new SourceInfo((String)object3, debuggableScriptArray, (String)object2);
        map = this.urlToSourceInfo;
        synchronized (map) {
            object3 = this.urlToSourceInfo.get(object2);
            if (object3 != null) {
                ((SourceInfo)object).copyBreakpointsFrom((SourceInfo)object3);
            }
            this.urlToSourceInfo.put((String)object2, (SourceInfo)object);
            n2 = 0;
            for (n = 0; n != ((SourceInfo)object).functionSourcesTop(); ++n) {
                object2 = ((SourceInfo)object).functionSource(n);
                object3 = ((FunctionSource)object2).name();
                if (((String)object3).length() == 0) continue;
                this.functionNames.put((String)object3, (FunctionSource)object2);
            }
        }
        map = this.functionToSource;
        synchronized (map) {
            n = n2;
            while (true) {
                if (n == debuggableScriptArray.length) {
                    // MONITOREXIT @DISABLED, blocks:[7, 9, 10] lbl34 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.callback.updateSourceText((SourceInfo)object);
                    return;
                }
                object3 = ((SourceInfo)object).functionSource(n);
                this.functionToSource.put(debuggableScriptArray[n], (FunctionSource)object3);
                ++n;
            }
        }
    }

    public void attachTo(ContextFactory contextFactory) {
        DimIProxy dimIProxy;
        this.detach();
        this.contextFactory = contextFactory;
        this.listener = dimIProxy = new DimIProxy(this, 1);
        contextFactory.addListener(dimIProxy);
    }

    public void clearAllBreakpoints() {
        Iterator<SourceInfo> iterator2 = this.urlToSourceInfo.values().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().removeAllBreakpoints();
        }
    }

    public void compileScript(String string2, String string3) {
        DimIProxy dimIProxy = new DimIProxy(this, 2);
        DimIProxy.access$502(dimIProxy, string2);
        DimIProxy.access$602(dimIProxy, string3);
        dimIProxy.withContext();
    }

    public void contextSwitch(int n) {
        this.frameIndex = n;
    }

    public ContextData currentContextData() {
        return this.interruptedContextData;
    }

    public void detach() {
        DimIProxy dimIProxy = this.listener;
        if (dimIProxy != null) {
            this.contextFactory.removeListener(dimIProxy);
            this.contextFactory = null;
            this.listener = null;
        }
    }

    public void dispose() {
        this.detach();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String eval(String string2) {
        String string3 = "undefined";
        if (string2 == null) {
            return "undefined";
        }
        Object object = this.currentContextData();
        if (object == null) return "undefined";
        if (this.frameIndex >= ((ContextData)object).frameCount()) {
            return "undefined";
        }
        StackFrame stackFrame = ((ContextData)object).getFrame(this.frameIndex);
        if (((ContextData)object).eventThreadFlag) {
            return Dim.do_eval(Context.getCurrentContext(), stackFrame, string2);
        }
        object = this.monitor;
        synchronized (object) {
            if (!this.insideInterruptLoop) return string3;
            this.evalRequest = string2;
            this.evalFrame = stackFrame;
            this.monitor.notify();
            try {
                do {
                    this.monitor.wait();
                } while (this.evalRequest != null);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            string3 = this.evalResult;
            return string3;
        }
    }

    public void evalScript(String string2, String string3) {
        DimIProxy dimIProxy = new DimIProxy(this, 3);
        DimIProxy.access$502(dimIProxy, string2);
        DimIProxy.access$602(dimIProxy, string3);
        dimIProxy.withContext();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] functionNames() {
        Map<String, SourceInfo> map = this.urlToSourceInfo;
        synchronized (map) {
            return this.functionNames.keySet().toArray(new String[this.functionNames.size()]);
        }
    }

    public FunctionSource functionSourceByName(String string2) {
        return this.functionNames.get(string2);
    }

    public Object[] getObjectIds(Object object) {
        DimIProxy dimIProxy = new DimIProxy(this, 7);
        DimIProxy.access$802(dimIProxy, object);
        dimIProxy.withContext();
        return dimIProxy.objectArrayResult;
    }

    public Object getObjectProperty(Object object, Object object2) {
        DimIProxy dimIProxy = new DimIProxy(this, 6);
        DimIProxy.access$802(dimIProxy, object);
        DimIProxy.access$1102(dimIProxy, object2);
        dimIProxy.withContext();
        return dimIProxy.objectResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void go() {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = 3;
            this.monitor.notifyAll();
            return;
        }
    }

    public String objectToString(Object object) {
        DimIProxy dimIProxy = new DimIProxy(this, 5);
        DimIProxy.access$802(dimIProxy, object);
        dimIProxy.withContext();
        return dimIProxy.stringResult;
    }

    public void setBreak() {
        this.breakFlag = true;
    }

    public void setBreakOnEnter(boolean bl) {
        this.breakOnEnter = bl;
    }

    public void setBreakOnExceptions(boolean bl) {
        this.breakOnExceptions = bl;
    }

    public void setBreakOnReturn(boolean bl) {
        this.breakOnReturn = bl;
    }

    public void setGuiCallback(GuiCallback guiCallback) {
        this.callback = guiCallback;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReturnValue(int n) {
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = n;
            this.monitor.notify();
            return;
        }
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public SourceInfo sourceInfo(String string2) {
        return this.urlToSourceInfo.get(string2);
    }

    public boolean stringIsCompilableUnit(String string2) {
        DimIProxy dimIProxy = new DimIProxy(this, 4);
        DimIProxy.access$602(dimIProxy, string2);
        dimIProxy.withContext();
        return dimIProxy.booleanResult;
    }

    public static class ContextData {
        private boolean breakNextLine;
        private boolean eventThreadFlag;
        private ObjArray frameStack = new ObjArray();
        private Throwable lastProcessedException;
        private int stopAtFrameDepth = -1;

        static /* synthetic */ boolean access$1402(ContextData contextData, boolean bl) {
            contextData.breakNextLine = bl;
            return bl;
        }

        static /* synthetic */ int access$1502(ContextData contextData, int n) {
            contextData.stopAtFrameDepth = n;
            return n;
        }

        static /* synthetic */ Throwable access$302(ContextData contextData, Throwable throwable) {
            contextData.lastProcessedException = throwable;
            return throwable;
        }

        static /* synthetic */ boolean access$402(ContextData contextData, boolean bl) {
            contextData.eventThreadFlag = bl;
            return bl;
        }

        public static ContextData get(Context context) {
            return (ContextData)context.getDebuggerContextData();
        }

        private void popFrame() {
            this.frameStack.pop();
        }

        private void pushFrame(StackFrame stackFrame) {
            this.frameStack.push(stackFrame);
        }

        public int frameCount() {
            return this.frameStack.size();
        }

        public StackFrame getFrame(int n) {
            int n2 = this.frameStack.size();
            return (StackFrame)this.frameStack.get(n2 - n - 1);
        }
    }

    private static class DimIProxy
    implements ContextAction,
    ContextFactory.Listener,
    Debugger {
        private boolean booleanResult;
        private Dim dim;
        private Object id;
        private Object object;
        private Object[] objectArrayResult;
        private Object objectResult;
        private String stringResult;
        private String text;
        private int type;
        private String url;

        private DimIProxy(Dim dim, int n) {
            this.dim = dim;
            this.type = n;
        }

        static /* synthetic */ Object access$1102(DimIProxy dimIProxy, Object object) {
            dimIProxy.id = object;
            return object;
        }

        static /* synthetic */ String access$502(DimIProxy dimIProxy, String string2) {
            dimIProxy.url = string2;
            return string2;
        }

        static /* synthetic */ String access$602(DimIProxy dimIProxy, String string2) {
            dimIProxy.text = string2;
            return string2;
        }

        static /* synthetic */ Object access$802(DimIProxy dimIProxy, Object object) {
            dimIProxy.object = object;
            return object;
        }

        private void withContext() {
            this.dim.contextFactory.call(this);
        }

        @Override
        public void contextCreated(Context context) {
            if (this.type != 1) {
                Kit.codeBug();
            }
            ContextData contextData = new ContextData();
            context.setDebugger(new DimIProxy(this.dim, 0), contextData);
            context.setGeneratingDebug(true);
            context.setOptimizationLevel(-1);
        }

        @Override
        public void contextReleased(Context context) {
            if (this.type != 1) {
                Kit.codeBug();
            }
        }

        @Override
        public DebugFrame getFrame(Context context, DebuggableScript object) {
            if (this.type != 0) {
                Kit.codeBug();
            }
            if ((object = this.dim.getFunctionSource((DebuggableScript)object)) == null) {
                return null;
            }
            return new StackFrame(context, this.dim, (FunctionSource)object);
        }

        @Override
        public void handleCompilationDone(Context context, DebuggableScript debuggableScript, String string2) {
            if (this.type != 0) {
                Kit.codeBug();
            }
            if (!debuggableScript.isTopLevel()) {
                return;
            }
            this.dim.registerTopScript(debuggableScript, string2);
        }

        @Override
        public Object run(Context object) {
            switch (this.type) {
                default: {
                    throw Kit.codeBug();
                }
                case 7: {
                    this.objectArrayResult = this.dim.getObjectIdsImpl((Context)object, this.object);
                    break;
                }
                case 6: {
                    this.objectResult = this.dim.getObjectPropertyImpl((Context)object, this.object, this.id);
                    break;
                }
                case 5: {
                    if (this.object == Undefined.instance) {
                        this.stringResult = "undefined";
                        break;
                    }
                    object = this.object;
                    if (object == null) {
                        this.stringResult = "null";
                        break;
                    }
                    if (object instanceof NativeCall) {
                        this.stringResult = "[object Call]";
                        break;
                    }
                    this.stringResult = Context.toString(object);
                    break;
                }
                case 4: {
                    this.booleanResult = ((Context)object).stringIsCompilableUnit(this.text);
                    break;
                }
                case 3: {
                    Scriptable scriptable = this.dim.scopeProvider != null ? this.dim.scopeProvider.getScope() : null;
                    Scriptable scriptable2 = scriptable;
                    if (scriptable == null) {
                        scriptable2 = new ImporterTopLevel((Context)object);
                    }
                    ((Context)object).evaluateString(scriptable2, this.text, this.url, 1, null);
                    break;
                }
                case 2: {
                    ((Context)object).compileString(this.text, this.url, 1, null);
                }
            }
            return null;
        }
    }

    public static class FunctionSource {
        private int firstLine;
        private String name;
        private SourceInfo sourceInfo;

        private FunctionSource(SourceInfo sourceInfo, int n, String string2) {
            if (string2 != null) {
                this.sourceInfo = sourceInfo;
                this.firstLine = n;
                this.name = string2;
                return;
            }
            throw new IllegalArgumentException();
        }

        public int firstLine() {
            return this.firstLine;
        }

        public String name() {
            return this.name;
        }

        public SourceInfo sourceInfo() {
            return this.sourceInfo;
        }
    }

    public static class SourceInfo {
        private static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
        private boolean[] breakableLines;
        private boolean[] breakpoints;
        private FunctionSource[] functionSources;
        private String source;
        private String url;

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private SourceInfo(String object, DebuggableScript[] debuggableScriptArray, String object2) {
            int[] nArray;
            boolean bl;
            int n;
            block19: {
                void var6_11;
                int n2;
                void var6_7;
                this.source = object;
                this.url = object2;
                n = debuggableScriptArray.length;
                object = new int[n][];
                bl = false;
                boolean bl2 = false;
                while (var6_7 != n) {
                    object[var6_7] = debuggableScriptArray[var6_7].getLineNumbers();
                    ++var6_7;
                }
                nArray = new int[n];
                int n3 = 0;
                boolean bl3 = false;
                int n4 = -1;
                while (true) {
                    Object object3;
                    block23: {
                        int n5;
                        Object object4;
                        block25: {
                            block24: {
                                block22: {
                                    block20: {
                                        block21: {
                                            if (n3 == n) break block20;
                                            object2 = object[n3];
                                            if (object2 == null || ((Object)object2).length == 0) break block21;
                                            object4 = object3 = (Object)object2[0];
                                            break block22;
                                        }
                                        nArray[n3] = -1;
                                        object3 = n4;
                                        break block23;
                                    }
                                    if (n5 > n4) {
                                        object = EMPTY_BOOLEAN_ARRAY;
                                        this.breakableLines = (boolean[])object;
                                        this.breakpoints = (boolean[])object;
                                        break block19;
                                    } else {
                                        if (n5 < 0) {
                                            throw new IllegalStateException(String.valueOf(n5));
                                        }
                                        int n6 = n4 + 1;
                                        this.breakableLines = new boolean[n6];
                                        this.breakpoints = new boolean[n6];
                                        boolean bl4 = false;
                                        break;
                                    }
                                }
                                for (n2 = 1; n2 != ((Object)object2).length; ++n2) {
                                    Object object5;
                                    Object object6;
                                    Object object7 = object2[n2];
                                    if (object7 < object3) {
                                        object6 = object7;
                                        object5 = object4;
                                    } else {
                                        object6 = object3;
                                        object5 = object4;
                                        if (object7 > object4) {
                                            object5 = object7;
                                            object6 = object3;
                                        }
                                    }
                                    object3 = object6;
                                    object4 = object5;
                                }
                                nArray[n3] = object3;
                                if (n5 <= n4) break block24;
                                n2 = object3;
                                break block25;
                            }
                            n2 = n5;
                            if (object3 < n5) {
                                n2 = object3;
                            }
                            n5 = n2;
                            object3 = n4;
                            if (object4 <= n4) break block23;
                        }
                        object3 = object4;
                        n5 = n2;
                    }
                    ++n3;
                    n4 = object3;
                }
                while (var6_11 != n) {
                    object2 = object[var6_11];
                    if (object2 != null && ((Object)object2).length != 0) {
                        for (n2 = 0; n2 != ((Object)object2).length; ++n2) {
                            Object object8 = object2[n2];
                            this.breakableLines[object8] = true;
                        }
                    }
                    ++var6_11;
                }
            }
            this.functionSources = new FunctionSource[n];
            boolean bl5 = bl;
            void var6_13;
            while (var6_13 != n) {
                object = object2 = debuggableScriptArray[var6_13].getFunctionName();
                if (object2 == null) {
                    object = "";
                }
                this.functionSources[var6_13] = new FunctionSource(this, nArray[var6_13], (String)object);
                ++var6_13;
            }
            return;
        }

        private void copyBreakpointsFrom(SourceInfo sourceInfo) {
            int n = sourceInfo.breakpoints.length;
            boolean[] blArray = this.breakpoints;
            int n2 = n;
            if (n > blArray.length) {
                n2 = blArray.length;
            }
            for (n = 0; n != n2; ++n) {
                if (!sourceInfo.breakpoints[n]) continue;
                this.breakpoints[n] = true;
            }
        }

        public boolean breakableLine(int n) {
            boolean[] blArray = this.breakableLines;
            boolean bl = n < blArray.length && blArray[n];
            return bl;
        }

        public boolean breakpoint(int n) {
            if (this.breakableLine(n)) {
                boolean[] blArray = this.breakpoints;
                boolean bl = n < blArray.length && blArray[n];
                return bl;
            }
            throw new IllegalArgumentException(String.valueOf(n));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean breakpoint(int n, boolean bl) {
            if (!this.breakableLine(n)) {
                throw new IllegalArgumentException(String.valueOf(n));
            }
            boolean[] blArray = this.breakpoints;
            synchronized (blArray) {
                boolean[] blArray2 = this.breakpoints;
                if (blArray2[n] == bl) return false;
                blArray2[n] = bl;
                return true;
            }
        }

        public FunctionSource functionSource(int n) {
            return this.functionSources[n];
        }

        public int functionSourcesTop() {
            return this.functionSources.length;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void removeAllBreakpoints() {
            boolean[] blArray = this.breakpoints;
            synchronized (blArray) {
                int n = 0;
                boolean[] blArray2;
                while (n != (blArray2 = this.breakpoints).length) {
                    blArray2[n] = false;
                    ++n;
                }
                return;
            }
        }

        public String source() {
            return this.source;
        }

        public String url() {
            return this.url;
        }
    }

    public static class StackFrame
    implements DebugFrame {
        private boolean[] breakpoints;
        private ContextData contextData;
        private Dim dim;
        private FunctionSource fsource;
        private int lineNumber;
        private Scriptable scope;
        private Scriptable thisObj;

        private StackFrame(Context context, Dim dim, FunctionSource functionSource) {
            this.dim = dim;
            this.contextData = ContextData.get(context);
            this.fsource = functionSource;
            this.breakpoints = functionSource.sourceInfo().breakpoints;
            this.lineNumber = functionSource.firstLine();
        }

        public ContextData contextData() {
            return this.contextData;
        }

        public String getFunctionName() {
            return this.fsource.name();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getUrl() {
            return this.fsource.sourceInfo().url();
        }

        @Override
        public void onDebuggerStatement(Context context) {
            this.dim.handleBreakpointHit(this, context);
        }

        @Override
        public void onEnter(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            this.contextData.pushFrame(this);
            this.scope = scriptable;
            this.thisObj = scriptable2;
            if (this.dim.breakOnEnter) {
                this.dim.handleBreakpointHit(this, context);
            }
        }

        @Override
        public void onExceptionThrown(Context context, Throwable throwable) {
            this.dim.handleExceptionThrown(context, throwable, this);
        }

        @Override
        public void onExit(Context context, boolean bl, Object object) {
            if (this.dim.breakOnReturn && !bl) {
                this.dim.handleBreakpointHit(this, context);
            }
            this.contextData.popFrame();
        }

        @Override
        public void onLineChange(Context context, int n) {
            this.lineNumber = n;
            if (!this.breakpoints[n] && !this.dim.breakFlag) {
                boolean bl;
                boolean bl2 = bl = this.contextData.breakNextLine;
                if (bl) {
                    bl2 = bl;
                    if (this.contextData.stopAtFrameDepth >= 0) {
                        bl2 = this.contextData.frameCount() <= this.contextData.stopAtFrameDepth;
                    }
                }
                if (!bl2) {
                    return;
                }
                ContextData.access$1502(this.contextData, -1);
                ContextData.access$1402(this.contextData, false);
            }
            this.dim.handleBreakpointHit(this, context);
        }

        public Object scope() {
            return this.scope;
        }

        public SourceInfo sourceInfo() {
            return this.fsource.sourceInfo();
        }

        public Object thisObj() {
            return this.thisObj;
        }
    }
}

