/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.mozilla.javascript.tools.debugger.SwingGui;

class EvalTextArea
extends JTextArea
implements KeyListener,
DocumentListener {
    private static final long serialVersionUID = -3918033649601064194L;
    private SwingGui debugGui;
    private List<String> history;
    private int historyIndex = -1;
    private int outputMark;

    public EvalTextArea(SwingGui object) {
        this.debugGui = object;
        this.history = Collections.synchronizedList(new ArrayList());
        object = this.getDocument();
        object.addDocumentListener(this);
        this.addKeyListener(this);
        this.setLineWrap(true);
        this.setFont(new Font("Monospaced", 0, 12));
        this.append("% ");
        this.outputMark = object.getLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void returnPressed() {
        synchronized (this) {
            Document document = this.getDocument();
            int n = document.getLength();
            CharSequence charSequence = new Segment();
            try {
                int n2 = this.outputMark;
                document.getText(n2, n - n2, (Segment)charSequence);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            charSequence = ((Segment)charSequence).toString();
            if (this.debugGui.dim.stringIsCompilableUnit((String)charSequence)) {
                if (((String)charSequence).trim().length() > 0) {
                    this.history.add((String)charSequence);
                    this.historyIndex = this.history.size();
                }
                this.append("\n");
                charSequence = this.debugGui.dim.eval((String)charSequence);
                if (((String)charSequence).length() > 0) {
                    this.append((String)charSequence);
                    this.append("\n");
                }
                this.append("% ");
                this.outputMark = document.getLength();
            } else {
                this.append("\n");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        synchronized (this) {
            int n = documentEvent.getLength();
            int n2 = documentEvent.getOffset();
            int n3 = this.outputMark;
            if (n3 > n2) {
                this.outputMark = n3 + n;
            }
            return;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 8 && n != 37) {
            if (n == 36) {
                int n2;
                n = this.getCaretPosition();
                if (n == (n2 = this.outputMark)) {
                    keyEvent.consume();
                } else if (n > n2 && !keyEvent.isControlDown()) {
                    if (keyEvent.isShiftDown()) {
                        this.moveCaretPosition(this.outputMark);
                    } else {
                        this.setCaretPosition(this.outputMark);
                    }
                    keyEvent.consume();
                }
            } else if (n == 10) {
                this.returnPressed();
                keyEvent.consume();
            } else if (n == 38) {
                this.historyIndex = n = this.historyIndex - 1;
                if (n >= 0) {
                    if (n >= this.history.size()) {
                        this.historyIndex = this.history.size() - 1;
                    }
                    if ((n = this.historyIndex) >= 0) {
                        String string2 = this.history.get(n);
                        n = this.getDocument().getLength();
                        this.replaceRange(string2, this.outputMark, n);
                        n = this.outputMark + string2.length();
                        this.select(n, n);
                    } else {
                        this.historyIndex = n + 1;
                    }
                } else {
                    this.historyIndex = n + 1;
                }
                keyEvent.consume();
            } else if (n == 40) {
                int n3;
                n = n3 = this.outputMark;
                if (this.history.size() > 0) {
                    this.historyIndex = n = this.historyIndex + 1;
                    if (n < 0) {
                        this.historyIndex = 0;
                    }
                    n = this.getDocument().getLength();
                    if (this.historyIndex < this.history.size()) {
                        String string3 = this.history.get(this.historyIndex);
                        this.replaceRange(string3, this.outputMark, n);
                        n = this.outputMark;
                        n = string3.length() + n;
                    } else {
                        this.historyIndex = this.history.size();
                        this.replaceRange("", this.outputMark, n);
                        n = n3;
                    }
                }
                this.select(n, n);
                keyEvent.consume();
            }
        } else if (this.outputMark == this.getCaretPosition()) {
            keyEvent.consume();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void keyReleased(KeyEvent keyEvent) {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\b') {
            if (this.outputMark == this.getCaretPosition()) {
                keyEvent.consume();
            }
        } else {
            int n;
            int n2 = this.getCaretPosition();
            if (n2 < (n = this.outputMark)) {
                this.setCaretPosition(n);
            }
        }
    }

    public void postUpdateUI() {
        synchronized (this) {
            this.setCaret(this.getCaret());
            int n = this.outputMark;
            this.select(n, n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        synchronized (this) {
            int n = documentEvent.getLength();
            int n2 = documentEvent.getOffset();
            int n3 = this.outputMark;
            if (n3 > n2) {
                this.outputMark = n3 >= n2 + n ? n3 - n : n2;
            }
            return;
        }
    }

    @Override
    public void select(int n, int n2) {
        super.select(n, n2);
    }

    public void write(String string2) {
        synchronized (this) {
            this.insert(string2, this.outputMark);
            int n = string2.length();
            this.outputMark = n = this.outputMark + n;
            this.select(n, n);
            return;
        }
    }
}

