/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;

class FileHeader
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -2858905404778259127L;
    private FileWindow fileWindow;
    private int pressLine = -1;

    public FileHeader(FileWindow fileWindow) {
        this.fileWindow = fileWindow;
        this.addMouseListener(this);
        this.update();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getFontMetrics(this.fileWindow.textArea.getFont()).getHeight();
        this.pressLine = mouseEvent.getY() / n;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this && (mouseEvent.getModifiers() & 0x10) != 0) {
            int n = mouseEvent.getY() / this.getFontMetrics(this.fileWindow.textArea.getFont()).getHeight();
            if (n == this.pressLine) {
                this.fileWindow.toggleBreakPoint(n + 1);
            } else {
                this.pressLine = -1;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        FileTextArea fileTextArea = this.fileWindow.textArea;
        Object object = fileTextArea.getFont();
        graphics.setFont((Font)object);
        object = this.getFontMetrics((Font)object);
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = ((FontMetrics)object).getMaxAscent();
        int n2 = ((FontMetrics)object).getHeight();
        int n3 = fileTextArea.getLineCount() + 1;
        Integer.toString(n3).length();
        int n4 = rectangle.y / n2;
        int n5 = (rectangle.y + rectangle.height) / n2 + 1;
        int n6 = this.getWidth();
        if (n5 > n3) {
            n5 = n3;
        }
        while (n4 < n5) {
            int n7;
            n3 = -2;
            try {
                n3 = n7 = fileTextArea.getLineStartOffset(n4);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            object = this.fileWindow;
            n7 = n4 + 1;
            boolean bl = ((FileWindow)object).isBreakPoint(n7);
            object = new StringBuilder();
            ((StringBuilder)object).append(Integer.toString(n7));
            ((StringBuilder)object).append(" ");
            object = ((StringBuilder)object).toString();
            graphics.setColor(Color.blue);
            int n8 = (n4 *= n2) + n;
            graphics.drawString((String)object, 0, n8);
            int n9 = n6 - n;
            if (bl) {
                graphics.setColor(new Color(128, 0, 0));
                graphics.fillOval(n9, n8 -= 9, 9, 9);
                graphics.drawOval(n9, n8, 8, 8);
                graphics.drawOval(n9, n8, 9, 9);
            }
            if (n3 == this.fileWindow.currentPos) {
                object = new Polygon();
                int n10 = n4 + (n - 10);
                n3 = n10 + 3;
                ((Polygon)object).addPoint(n9, n3);
                n8 = n9 + 5;
                ((Polygon)object).addPoint(n8, n3);
                n3 = n10;
                n4 = n8;
                while (n4 <= n9 + 10) {
                    ((Polygon)object).addPoint(n4, n3);
                    ++n4;
                    ++n3;
                }
                n4 = n9 + 9;
                while (n4 >= n8) {
                    ((Polygon)object).addPoint(n4, n3);
                    --n4;
                    ++n3;
                }
                n3 = n10 + 7;
                ((Polygon)object).addPoint(n8, n3);
                ((Polygon)object).addPoint(n9, n3);
                graphics.setColor(Color.yellow);
                graphics.fillPolygon((Polygon)object);
                graphics.setColor(Color.black);
                graphics.drawPolygon((Polygon)object);
            }
            n4 = n7;
        }
    }

    public void update() {
        Object object = this.fileWindow.textArea;
        Object object2 = ((Component)object).getFont();
        this.setFont((Font)object2);
        FontMetrics fontMetrics = this.getFontMetrics((Font)object2);
        int n = fontMetrics.getHeight();
        int n2 = ((JTextArea)object).getLineCount() + 1;
        object = object2 = Integer.toString(n2);
        if (((String)object2).length() < 2) {
            object = "99";
        }
        object2 = new Dimension();
        ((Dimension)object2).width = fontMetrics.stringWidth((String)object) + 16;
        ((Dimension)object2).height = n2 * n + 100;
        this.setPreferredSize((Dimension)object2);
        this.setSize((Dimension)object2);
    }
}

