/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.RunProxy;
import org.mozilla.javascript.tools.debugger.SwingGui;

class FileWindow
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = -6212382604952082370L;
    int currentPos;
    private SwingGui debugGui;
    private FileHeader fileHeader;
    private JScrollPane p;
    private Dim.SourceInfo sourceInfo;
    FileTextArea textArea;

    public FileWindow(SwingGui container, Dim.SourceInfo sourceInfo) {
        super(SwingGui.getShortName(sourceInfo.url()), true, true, true, true);
        this.debugGui = container;
        this.sourceInfo = sourceInfo;
        this.updateToolTip();
        this.currentPos = -1;
        container = new FileTextArea(this);
        this.textArea = container;
        ((JTextArea)container).setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.updateText(sourceInfo);
        this.textArea.select(0);
    }

    private void updateToolTip() {
        Component component;
        int n = this.getComponentCount();
        int n2 = 1;
        if (--n <= 1) {
            if (n < 0) {
                return;
            }
            n2 = n;
        }
        if ((component = this.getComponent(n2)) != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.getUrl());
        }
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if (!((String)(object = ((ActionEvent)object).getActionCommand())).equals("Cut")) {
            if (((String)object).equals("Copy")) {
                this.textArea.copy();
            } else {
                ((String)object).equals("Paste");
            }
        }
    }

    public void clearBreakPoint(int n) {
        if (this.sourceInfo.breakableLine(n) && this.sourceInfo.breakpoint(n, false)) {
            this.fileHeader.repaint();
        }
    }

    @Override
    public void dispose() {
        this.debugGui.removeWindow(this);
        super.dispose();
    }

    public int getPosition(int n) {
        try {
            n = this.textArea.getLineStartOffset(n);
        }
        catch (BadLocationException badLocationException) {
            n = -1;
        }
        return n;
    }

    public String getUrl() {
        return this.sourceInfo.url();
    }

    public boolean isBreakPoint(int n) {
        boolean bl = this.sourceInfo.breakableLine(n) && this.sourceInfo.breakpoint(n);
        return bl;
    }

    void load() {
        String string2 = this.getUrl();
        if (string2 != null) {
            RunProxy runProxy = new RunProxy(this.debugGui, 2);
            runProxy.fileName = string2;
            runProxy.text = this.sourceInfo.source();
            new Thread(runProxy).start();
        }
    }

    public void select(int n, int n2) {
        int n3 = this.textArea.getDocument().getLength();
        this.textArea.select(n3, n3);
        this.textArea.select(n, n2);
    }

    public void setBreakPoint(int n) {
        if (this.sourceInfo.breakableLine(n) && this.sourceInfo.breakpoint(n, true)) {
            this.fileHeader.repaint();
        }
    }

    public void setPosition(int n) {
        this.textArea.select(n);
        this.currentPos = n;
        this.fileHeader.repaint();
    }

    public void toggleBreakPoint(int n) {
        if (!this.isBreakPoint(n)) {
            this.setBreakPoint(n);
        } else {
            this.clearBreakPoint(n);
        }
    }

    public void updateText(Dim.SourceInfo object) {
        this.sourceInfo = object;
        object = ((Dim.SourceInfo)object).source();
        if (!this.textArea.getText().equals(object)) {
            this.textArea.setText((String)object);
            int n = 0;
            int n2 = this.currentPos;
            if (n2 != -1) {
                n = n2;
            }
            this.textArea.select(n);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }
}

