/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.mozilla.javascript.tools.debugger.SwingGui;

class Menubar
extends JMenuBar
implements ActionListener {
    private static final long serialVersionUID = 3217170497245911461L;
    private JCheckBoxMenuItem breakOnEnter;
    private JCheckBoxMenuItem breakOnExceptions;
    private JCheckBoxMenuItem breakOnReturn;
    private SwingGui debugGui;
    private List<JMenuItem> interruptOnlyItems = Collections.synchronizedList(new ArrayList());
    private List<JMenuItem> runOnlyItems = Collections.synchronizedList(new ArrayList());
    private JMenu windowMenu;

    Menubar(SwingGui container) {
        int n;
        int[] nArray;
        int[] nArray2;
        this.debugGui = container;
        Object object = new String[]{"Open...", "Run...", "", "Exit"};
        int[] nArray3 = nArray2 = new int[4];
        nArray2[0] = 79;
        nArray3[1] = 78;
        nArray3[2] = 0;
        nArray3[3] = 81;
        Object object2 = new char[5];
        char[] cArray = object2;
        object2[0] = 66;
        cArray[1] = 71;
        cArray[2] = 73;
        cArray[3] = 79;
        cArray[4] = 84;
        int[] nArray4 = nArray = new int[7];
        nArray[0] = 19;
        nArray4[1] = 116;
        nArray4[2] = 122;
        nArray4[3] = 118;
        nArray4[4] = 119;
        nArray4[5] = 0;
        nArray4[6] = 0;
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenu jMenu3 = new JMenu("Platform");
        jMenu3.setMnemonic('P');
        container = new JMenu("Debug");
        ((AbstractButton)container).setMnemonic('D');
        JMenuItem jMenuItem = new JMenu("Window");
        this.windowMenu = jMenuItem;
        jMenuItem.setMnemonic('W');
        for (n = 0; n < 4; ++n) {
            if (object[n].length() == 0) {
                jMenu.addSeparator();
                continue;
            }
            jMenuItem = new JMenuItem(object[n], (new char[]{'0', 'N', '\u0000', 'X'})[n]);
            jMenuItem.setActionCommand((new String[]{"Open", "Load", "", "Exit"})[n]);
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            if (nArray2[n] == 0) continue;
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(nArray2[n], 2));
        }
        for (n = 0; n < 4; ++n) {
            object = new JMenuItem((new String[]{"Cut", "Copy", "Paste", "Go to function..."})[n], (new char[]{'T', 'C', 'P', 'F'})[n]);
            ((AbstractButton)object).addActionListener(this);
            jMenu2.add((JMenuItem)object);
        }
        for (n = 0; n < 3; ++n) {
            object = new JMenuItem((new String[]{"Metal", "Windows", "Motif"})[n], (new char[]{'M', 'W', 'F'})[n]);
            ((AbstractButton)object).addActionListener(this);
            jMenu3.add((JMenuItem)object);
        }
        for (n = 0; n < 5; ++n) {
            object = new JMenuItem((new String[]{"Break", "Go", "Step Into", "Step Over", "Step Out"})[n], (int)object2[n]);
            ((AbstractButton)object).addActionListener(this);
            if (nArray[n] != 0) {
                ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(nArray[n], 0));
            }
            if (n != 0) {
                this.interruptOnlyItems.add((JMenuItem)object);
            } else {
                this.runOnlyItems.add((JMenuItem)object);
            }
            ((JMenu)container).add((JMenuItem)object);
        }
        object2 = new JCheckBoxMenuItem("Break on Exceptions");
        this.breakOnExceptions = object2;
        ((AbstractButton)object2).setMnemonic('X');
        this.breakOnExceptions.addActionListener(this);
        this.breakOnExceptions.setSelected(false);
        ((JMenu)container).add(this.breakOnExceptions);
        this.breakOnEnter = object2 = new JCheckBoxMenuItem("Break on Function Enter");
        ((AbstractButton)object2).setMnemonic('E');
        this.breakOnEnter.addActionListener(this);
        this.breakOnEnter.setSelected(false);
        ((JMenu)container).add(this.breakOnEnter);
        this.breakOnReturn = object2 = new JCheckBoxMenuItem("Break on Function Return");
        ((AbstractButton)object2).setMnemonic('R');
        this.breakOnReturn.addActionListener(this);
        this.breakOnReturn.setSelected(false);
        ((JMenu)container).add(this.breakOnReturn);
        this.add(jMenu);
        this.add(jMenu2);
        this.add((JMenu)container);
        object2 = this.windowMenu;
        container = new JMenuItem("Cascade", 65);
        ((JMenu)object2).add((JMenuItem)container);
        ((AbstractButton)container).addActionListener(this);
        container = this.windowMenu;
        object2 = new JMenuItem("Tile", 84);
        ((JMenu)container).add((JMenuItem)object2);
        ((AbstractButton)object2).addActionListener(this);
        this.windowMenu.addSeparator();
        object2 = this.windowMenu;
        container = new JMenuItem("Console", 67);
        ((JMenu)object2).add((JMenuItem)container);
        ((AbstractButton)container).addActionListener(this);
        this.add(this.windowMenu);
        this.updateEnabled(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent object) {
        Object object2;
        block15: {
            block13: {
                block14: {
                    block12: {
                        object2 = ((ActionEvent)object).getActionCommand();
                        if (!((String)object2).equals("Metal")) break block12;
                        object = "javax.swing.plaf.metal.MetalLookAndFeel";
                        break block13;
                    }
                    if (!((String)object2).equals("Windows")) break block14;
                    object = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                    break block13;
                }
                if (!((String)object2).equals("Motif")) break block15;
                object = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            try {
                UIManager.setLookAndFeel((String)object);
                SwingUtilities.updateComponentTreeUI(this.debugGui);
                SwingUtilities.updateComponentTreeUI(this.debugGui.dlg);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        object2 = ((EventObject)object).getSource();
        if (object2 == this.breakOnExceptions) {
            this.debugGui.dim.setBreakOnExceptions(this.breakOnExceptions.isSelected());
            return;
        } else if (object2 == this.breakOnEnter) {
            this.debugGui.dim.setBreakOnEnter(this.breakOnEnter.isSelected());
            return;
        } else if (object2 == this.breakOnReturn) {
            this.debugGui.dim.setBreakOnReturn(this.breakOnReturn.isSelected());
            return;
        } else {
            this.debugGui.actionPerformed((ActionEvent)object);
        }
    }

    public void addFile(String object) {
        int n;
        int n2;
        int n3 = n2 = this.windowMenu.getItemCount();
        if (n2 == 4) {
            this.windowMenu.addSeparator();
            n3 = n2 + 1;
        }
        JMenuItem jMenuItem = this.windowMenu.getItem(n3 - 1);
        n2 = 0;
        if (jMenuItem != null && jMenuItem.getText().equals("More Windows...")) {
            n2 = 1;
            n = 6;
        } else {
            n = 5;
        }
        if (n2 == 0 && n3 - 4 == 5) {
            object = this.windowMenu;
            JMenuItem jMenuItem2 = new JMenuItem("More Windows...", 77);
            ((JMenu)object).add(jMenuItem2);
            jMenuItem2.setActionCommand("More Windows...");
            jMenuItem2.addActionListener(this);
            return;
        }
        if (n3 - 4 <= n) {
            n = n3;
            if (n2 != 0) {
                n = n3 - 1;
                this.windowMenu.remove(jMenuItem);
            }
            Object object2 = SwingGui.getShortName((String)object);
            JMenu jMenu = this.windowMenu;
            StringBuilder stringBuilder = new StringBuilder();
            n3 = n - 4 + 48;
            stringBuilder.append((char)n3);
            stringBuilder.append(" ");
            stringBuilder.append((String)object2);
            object2 = new JMenuItem(stringBuilder.toString(), n3);
            jMenu.add((JMenuItem)object2);
            if (n2 != 0) {
                this.windowMenu.add(jMenuItem);
            }
            ((AbstractButton)object2).setActionCommand((String)object);
            ((AbstractButton)object2).addActionListener(this);
        }
    }

    public JCheckBoxMenuItem getBreakOnEnter() {
        return this.breakOnEnter;
    }

    public JCheckBoxMenuItem getBreakOnExceptions() {
        return this.breakOnExceptions;
    }

    public JCheckBoxMenuItem getBreakOnReturn() {
        return this.breakOnReturn;
    }

    public JMenu getDebugMenu() {
        return this.getMenu(2);
    }

    public void updateEnabled(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (true) {
            if (n2 == this.interruptOnlyItems.size()) break;
            this.interruptOnlyItems.get(n2).setEnabled(bl);
            ++n2;
        }
        for (int i = n; i != this.runOnlyItems.size(); ++i) {
            this.runOnlyItems.get(i).setEnabled(bl ^ true);
        }
    }
}

