/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.mozilla.javascript.tools.debugger.SwingGui;

class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui debugGui;
    private List<String> expressions;
    private List<String> values;

    public MyTableModel(SwingGui swingGui) {
        this.debugGui = swingGui;
        this.expressions = Collections.synchronizedList(new ArrayList());
        this.values = Collections.synchronizedList(new ArrayList());
        this.expressions.add("");
        this.values.add("");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int n) {
        if (n != 0) {
            if (n != 1) {
                return null;
            }
            return "Value";
        }
        return "Expression";
    }

    @Override
    public int getRowCount() {
        return this.expressions.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 != 0) {
            if (n2 != 1) {
                return "";
            }
            return this.values.get(n);
        }
        return this.expressions.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (n2 == 0) break block6;
                        if (n2 == 1) {
                            this.fireTableDataChanged();
                        }
                        break block7;
                    }
                    object = object.toString();
                    this.expressions.set(n, (String)object);
                    if (((String)object).length() <= 0) break block8;
                    String string2 = this.debugGui.dim.eval((String)object);
                    object = string2;
                    if (string2 != null) break block9;
                }
                object = "";
            }
            this.values.set(n, (String)object);
            this.updateModel();
            if (++n == this.expressions.size()) {
                this.expressions.add("");
                this.values.add("");
                this.fireTableRowsInserted(n, n);
            }
        }
    }

    void updateModel() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            String string2;
            String string3 = this.expressions.get(i);
            int n = string3.length();
            String string4 = string2 = "";
            if (n > 0 && (string4 = this.debugGui.dim.eval(string3)) == null) {
                string4 = string2;
            }
            string4 = string4.replace('\n', ' ');
            this.values.set(i, string4);
        }
        this.fireTableDataChanged();
    }
}

