/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.SecurityUtilities;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.GuiCallback;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.RunProxy;

public class SwingGui
extends JFrame
implements GuiCallback {
    private static final long serialVersionUID = -8217029773456711621L;
    private EventQueue awtEventQueue;
    private JSInternalConsole console;
    private ContextWindow context;
    private FileWindow currentWindow;
    private JDesktopPane desk;
    Dim dim;
    JFileChooser dlg;
    private Runnable exitAction;
    private final Map<String, FileWindow> fileWindows;
    private Menubar menubar;
    private JSplitPane split1;
    private JLabel statusBar;
    private JToolBar toolBar;
    private final Map<String, JFrame> toplevels = Collections.synchronizedMap(new HashMap());

    public SwingGui(Dim dim, String string2) {
        super(string2);
        this.fileWindows = Collections.synchronizedMap(new HashMap());
        this.dim = dim;
        this.init();
        dim.setGuiCallback(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String chooseFile(String object) {
        this.dlg.setDialogTitle((String)object);
        object = SecurityUtilities.getSystemProperty("user.dir");
        object = object != null ? new File((String)object) : null;
        if (object != null) {
            this.dlg.setCurrentDirectory((File)object);
        }
        if (this.dlg.showOpenDialog(this) != 0) return null;
        try {
            object = this.dlg.getSelectedFile().getCanonicalPath();
            File file = this.dlg.getSelectedFile().getParentFile();
            Properties properties = System.getProperties();
            properties.put("user.dir", file.getPath());
            System.setProperties(properties);
            return object;
        }
        catch (IOException | SecurityException exception) {
            return null;
        }
    }

    private void exit() {
        Runnable runnable = this.exitAction;
        if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
        this.dim.setReturnValue(5);
    }

    private JInternalFrame getSelectedFrame() {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!jInternalFrameArray[i].isShowing()) continue;
            return jInternalFrameArray[i];
        }
        return jInternalFrameArray[jInternalFrameArray.length - 1];
    }

    static String getShortName(String string2) {
        int n;
        int n2 = n = string2.lastIndexOf(47);
        if (n < 0) {
            n2 = string2.lastIndexOf(92);
        }
        String string3 = string2;
        if (n2 >= 0) {
            string3 = string2;
            if (++n2 < string2.length()) {
                string3 = string2.substring(n2);
            }
        }
        return string3;
    }

    private JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    private void init() {
        Object object = new Menubar(this);
        this.menubar = object;
        this.setJMenuBar((JMenuBar)object);
        this.toolBar = new JToolBar();
        Object object2 = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        JComponent jComponent = new JButton("Break");
        jComponent.setToolTipText("Break");
        jComponent.setActionCommand("Break");
        jComponent.addActionListener(this.menubar);
        jComponent.setEnabled(true);
        jComponent.setToolTipText(object2[0]);
        JButton jButton = new JButton("Go");
        jButton.setToolTipText("Go");
        jButton.setActionCommand("Go");
        jButton.addActionListener(this.menubar);
        jButton.setEnabled(false);
        jButton.setToolTipText(object2[1]);
        JButton jButton2 = new JButton("Step Into");
        jButton2.setToolTipText("Step Into");
        jButton2.setActionCommand("Step Into");
        jButton2.addActionListener(this.menubar);
        jButton2.setEnabled(false);
        jButton2.setToolTipText(object2[2]);
        JComponent jComponent2 = new JButton("Step Over");
        jComponent2.setToolTipText("Step Over");
        ((AbstractButton)jComponent2).setActionCommand("Step Over");
        ((AbstractButton)jComponent2).setEnabled(false);
        ((AbstractButton)jComponent2).addActionListener(this.menubar);
        jComponent2.setToolTipText(object2[3]);
        object = new JButton("Step Out");
        ((JComponent)object).setToolTipText("Step Out");
        ((AbstractButton)object).setActionCommand("Step Out");
        ((AbstractButton)object).setEnabled(false);
        ((AbstractButton)object).addActionListener(this.menubar);
        ((JComponent)object).setToolTipText(object2[4]);
        object2 = jComponent2.getPreferredSize();
        jComponent.setPreferredSize((Dimension)object2);
        jComponent.setMinimumSize((Dimension)object2);
        jComponent.setMaximumSize((Dimension)object2);
        jComponent.setSize((Dimension)object2);
        jButton.setPreferredSize((Dimension)object2);
        jButton.setMinimumSize((Dimension)object2);
        jButton.setMaximumSize((Dimension)object2);
        jButton2.setPreferredSize((Dimension)object2);
        jButton2.setMinimumSize((Dimension)object2);
        jButton2.setMaximumSize((Dimension)object2);
        jComponent2.setPreferredSize((Dimension)object2);
        jComponent2.setMinimumSize((Dimension)object2);
        jComponent2.setMaximumSize((Dimension)object2);
        ((JComponent)object).setPreferredSize((Dimension)object2);
        ((JComponent)object).setMinimumSize((Dimension)object2);
        ((JComponent)object).setMaximumSize((Dimension)object2);
        this.toolBar.add(jComponent);
        this.toolBar.add(jButton);
        this.toolBar.add(jButton2);
        this.toolBar.add(jComponent2);
        this.toolBar.add((Component)object);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)object, "Center");
        jComponent2 = new JDesktopPane();
        this.desk = jComponent2;
        jComponent2.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        jComponent2 = this.desk;
        jComponent = new JSInternalConsole("JavaScript Console");
        this.console = jComponent;
        jComponent2.add(jComponent);
        jComponent2 = new ContextWindow(this);
        this.context = jComponent2;
        jComponent2.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        jComponent2 = new JSplitPane(0, this.desk, this.context);
        this.split1 = jComponent2;
        ((JSplitPane)jComponent2).setOneTouchExpandable(true);
        SwingGui.setResizeWeight(this.split1, 0.66);
        ((Container)object).add((Component)this.split1, "Center");
        jComponent2 = new JLabel();
        this.statusBar = jComponent2;
        ((JLabel)jComponent2).setText("Thread: ");
        ((Container)object).add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        object = new FileFilter(){

            @Override
            public boolean accept(File object) {
                if (((File)object).isDirectory()) {
                    return true;
                }
                int n = ((String)(object = ((File)object).getName())).lastIndexOf(46);
                return n > 0 && n < ((String)object).length() - 1 && ((String)object).substring(n + 1).toLowerCase().equals("js");
            }

            @Override
            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter((FileFilter)object);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SwingGui.this.exit();
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFile(String string2) {
        Object object;
        try {
            object = new FileReader(string2);
        }
        catch (IOException iOException) {
            object = iOException.getMessage();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error reading ");
            stringBuilder.append(string2);
            MessageDialogWrapper.showMessageDialog(this, (String)object, stringBuilder.toString(), 0);
            return null;
        }
        try {
            String string3 = Kit.readReader((Reader)object);
            return string3;
        }
        finally {
            ((Reader)object).close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setFilePosition(FileWindow var1_1, int var2_3) {
        block9: {
            var3_4 = var1_1.textArea;
            if (var2_3 != -1) ** GOTO lbl8
            var1_1.setPosition(-1);
            if (this.currentWindow == var1_1) {
                this.currentWindow = null;
            }
            break block9;
lbl8:
            // 1 sources

            var2_3 = var3_4.getLineStartOffset(var2_3 - 1);
            var3_4 = this.currentWindow;
            if (var3_4 == null || var3_4 == var1_1) ** GOTO lbl13
            try {
                var3_4.setPosition(-1);
lbl13:
                // 2 sources

                var1_1.setPosition(var2_3);
                this.currentWindow = var1_1;
            }
            catch (BadLocationException var3_5) {
                ** continue;
            }
        }
lbl16:
        // 2 sources

        while (true) {
            if (var1_1.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(var1_1);
            }
            this.desk.getDesktopManager().activateFrame(var1_1);
            var1_1.show();
            var1_1.toFront();
            var1_1.setSelected(true);
lbl24:
            // 2 sources

            return;
            break;
        }
        catch (Exception var1_2) {
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setResizeWeight(JSplitPane jSplitPane, double d) {
        try {
            Method method = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            Double d2 = new Double(d);
            method.invoke((Object)jSplitPane, d2);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return;
        }
    }

    private void updateEnabled(boolean bl) {
        ((Menubar)this.getJMenuBar()).updateEnabled(bl);
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            boolean bl2 = i == 0 ? bl ^ true : bl;
            this.toolBar.getComponent(i).setEnabled(bl2);
        }
        if (bl) {
            this.toolBar.setEnabled(true);
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            this.toFront();
            this.context.setEnabled(true);
        } else {
            FileWindow fileWindow = this.currentWindow;
            if (fileWindow != null) {
                fileWindow.setPosition(-1);
            }
            this.context.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent object) {
        int n;
        block28: {
            int n2;
            int n3;
            JInternalFrame[] jInternalFrameArray;
            block32: {
                int n4;
                int n5;
                block25: {
                    block26: {
                        String string2;
                        block31: {
                            block30: {
                                block29: {
                                    block27: {
                                        string2 = ((ActionEvent)object).getActionCommand();
                                        boolean bl = string2.equals("Cut");
                                        n = 2;
                                        if (bl || string2.equals("Copy") || string2.equals("Paste")) break block26;
                                        if (!string2.equals("Step Over")) break block27;
                                        n = 0;
                                        break block28;
                                    }
                                    if (!string2.equals("Step Into")) break block29;
                                    n = 1;
                                    break block28;
                                }
                                if (string2.equals("Step Out")) break block28;
                                if (!string2.equals("Go")) break block30;
                                n = 3;
                                break block28;
                            }
                            if (string2.equals("Break")) {
                                this.dim.setBreak();
                                return;
                            }
                            if (string2.equals("Exit")) {
                                this.exit();
                                return;
                            }
                            if (string2.equals("Open")) {
                                String string3 = this.chooseFile("Select a file to compile");
                                if (string3 == null) return;
                                object = this.readFile(string3);
                                if (object == null) return;
                                RunProxy runProxy = new RunProxy(this, 1);
                                runProxy.fileName = string3;
                                runProxy.text = object;
                                new Thread(runProxy).start();
                                return;
                            }
                            if (string2.equals("Load")) {
                                String string4 = this.chooseFile("Select a file to execute");
                                if (string4 == null) return;
                                object = this.readFile(string4);
                                if (object == null) return;
                                RunProxy runProxy = new RunProxy(this, 2);
                                runProxy.fileName = string4;
                                runProxy.text = object;
                                new Thread(runProxy).start();
                                return;
                            }
                            if (string2.equals("More Windows...")) {
                                new MoreWindows(this, this.fileWindows, "Window", "Files").showDialog(this);
                                return;
                            }
                            if (string2.equals("Console")) {
                                if (this.console.isIcon()) {
                                    this.desk.getDesktopManager().deiconifyFrame(this.console);
                                }
                                this.console.show();
                                this.desk.getDesktopManager().activateFrame(this.console);
                                this.console.consoleTextArea.requestFocus();
                                return;
                            }
                            if (string2.equals("Cut") || string2.equals("Copy") || string2.equals("Paste")) return;
                            if (string2.equals("Go to function...")) {
                                new FindFunction(this, "Go to function", "Function").showDialog(this);
                                return;
                            }
                            if (!string2.equals("Tile")) break block31;
                            object = this.desk.getAllFrames();
                            n5 = ((Object)object).length;
                            n = (int)Math.sqrt(n5);
                            if (n * n < n5) {
                                n4 = n + 1;
                                if (n * n4 < n5) {
                                    n = n4;
                                    break block25;
                                } else {
                                    n5 = n;
                                    n = n4;
                                    n4 = n5;
                                }
                                break block25;
                            } else {
                                n4 = n;
                            }
                            break block25;
                        }
                        if (string2.equals("Cascade")) {
                            jInternalFrameArray = this.desk.getAllFrames();
                            n3 = jInternalFrameArray.length;
                            n = n2 = this.desk.getHeight() / n3;
                            if (n2 > 30) {
                                n = 30;
                            }
                            break block32;
                        } else {
                            object = this.getFileWindow(string2);
                            if (object == null) return;
                            FileWindow fileWindow = (FileWindow)object;
                            try {
                                if (((JInternalFrame)object).isIcon()) {
                                    ((JInternalFrame)object).setIcon(false);
                                }
                                ((JComponent)object).setVisible(true);
                                ((JInternalFrame)object).moveToFront();
                                ((JInternalFrame)object).setSelected(true);
                                return;
                            }
                            catch (Exception exception) {}
                            return;
                        }
                    }
                    JInternalFrame jInternalFrame = this.getSelectedFrame();
                    if (jInternalFrame == null) return;
                    if (!(jInternalFrame instanceof ActionListener)) return;
                    ((ActionListener)((Object)jInternalFrame)).actionPerformed((ActionEvent)object);
                    return;
                }
                Dimension dimension = this.desk.getSize();
                int n6 = dimension.width / n;
                int n7 = dimension.height / n4;
                n5 = 0;
                int n8 = 0;
                while (n5 < n4) {
                    int n9;
                    int n10 = 0;
                    for (int i = 0; i < n && (n9 = n5 * n + i) < ((Object)object).length; n10 += n6, ++i) {
                        Object object2 = object[n9];
                        try {
                            ((JInternalFrame)object2).setIcon(false);
                            ((JInternalFrame)object2).setMaximum(false);
                        }
                        catch (Exception exception) {}
                        this.desk.getDesktopManager().setBoundsForFrame((JComponent)object2, n10, n8, n6, n7);
                    }
                    n8 += n7;
                    ++n5;
                }
                return;
            }
            int n11 = n3 - 1;
            n3 = 0;
            n2 = 0;
            while (n11 >= 0) {
                object = jInternalFrameArray[n11];
                try {
                    ((JInternalFrame)object).setIcon(false);
                    ((JInternalFrame)object).setMaximum(false);
                }
                catch (Exception exception) {}
                Dimension dimension = ((JComponent)object).getPreferredSize();
                int n12 = dimension.width;
                int n13 = dimension.height;
                this.desk.getDesktopManager().setBoundsForFrame((JComponent)object, n3, n2, n12, n13);
                --n11;
                n3 += n;
                n2 += n;
            }
            return;
        }
        if (n == -1) return;
        this.updateEnabled(false);
        this.dim.setReturnValue(n);
    }

    void addTopLevel(String string2, JFrame jFrame) {
        if (jFrame != this) {
            this.toplevels.put(string2, jFrame);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createFileWindow(Dim.SourceInfo object, int n) {
        String string2 = ((Dim.SourceInfo)object).url();
        object = new FileWindow(this, (Dim.SourceInfo)object);
        this.fileWindows.put(string2, (FileWindow)object);
        if (n != -1) {
            FileWindow fileWindow = this.currentWindow;
            if (fileWindow != null) {
                fileWindow.setPosition(-1);
            }
            try {
                ((FileWindow)object).setPosition(((FileWindow)object).textArea.getLineStartOffset(n - 1));
            }
            catch (BadLocationException badLocationException) {
                try {
                    ((FileWindow)object).setPosition(((FileWindow)object).textArea.getLineStartOffset(0));
                }
                catch (BadLocationException badLocationException2) {
                    ((FileWindow)object).setPosition(-1);
                }
            }
        }
        this.desk.add((Component)object);
        if (n != -1) {
            this.currentWindow = object;
        }
        this.menubar.addFile(string2);
        ((JComponent)object).setVisible(true);
        try {
            ((JInternalFrame)object).setMaximum(true);
            ((JInternalFrame)object).setSelected(true);
            ((JInternalFrame)object).moveToFront();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void dispatchNextGuiEvent() throws InterruptedException {
        Object object;
        Object object2 = object = this.awtEventQueue;
        if (object == null) {
            this.awtEventQueue = object2 = Toolkit.getDefaultToolkit().getSystemEventQueue();
        }
        if ((object2 = ((EventQueue)object2).getNextEvent()) instanceof ActiveEvent) {
            ((ActiveEvent)object2).dispatch();
        } else {
            object = ((EventObject)object2).getSource();
            if (object instanceof Component) {
                ((Component)object).dispatchEvent((AWTEvent)object2);
            } else if (object instanceof MenuComponent) {
                ((MenuComponent)object).dispatchEvent((AWTEvent)object2);
            }
        }
    }

    @Override
    public void enterInterrupt(Dim.StackFrame stackFrame, String string2, String string3) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.enterInterruptImpl(stackFrame, string2, string3);
        } else {
            RunProxy runProxy = new RunProxy(this, 4);
            runProxy.lastFrame = stackFrame;
            runProxy.threadTitle = string2;
            runProxy.alertMessage = string3;
            SwingUtilities.invokeLater(runProxy);
        }
    }

    void enterInterruptImpl(Dim.StackFrame object, String string2, String object2) {
        Object object3 = this.statusBar;
        Serializable serializable = new StringBuilder();
        ((StringBuilder)serializable).append("Thread: ");
        ((StringBuilder)serializable).append(string2);
        ((JLabel)object3).setText(((StringBuilder)serializable).toString());
        this.showStopLine((Dim.StackFrame)object);
        if (object2 != null) {
            MessageDialogWrapper.showMessageDialog(this, (String)object2, "Exception in Script", 0);
        }
        this.updateEnabled(true);
        object2 = ((Dim.StackFrame)object).contextData();
        serializable = this.context.context;
        object3 = this.context.toolTips;
        this.context.disableUpdate();
        int n = ((Dim.ContextData)object2).frameCount();
        ((JComboBox)serializable).removeAllItems();
        ((JComboBox)serializable).setSelectedItem(null);
        object3.clear();
        for (int i = 0; i < n; ++i) {
            object = ((Dim.ContextData)object2).getFrame(i);
            string2 = ((Dim.StackFrame)object).getUrl();
            int n2 = ((Dim.StackFrame)object).getLineNumber();
            if (string2.length() > 20) {
                object = new StringBuilder();
                ((StringBuilder)object).append("...");
                ((StringBuilder)object).append(string2.substring(string2.length() - 17));
                object = ((StringBuilder)object).toString();
            } else {
                object = string2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\"");
            stringBuilder.append((String)object);
            stringBuilder.append("\", line ");
            stringBuilder.append(n2);
            ((JComboBox)serializable).insertItemAt(stringBuilder.toString(), i);
            object = new StringBuilder();
            ((StringBuilder)object).append("\"");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append("\", line ");
            ((StringBuilder)object).append(n2);
            object3.add(((StringBuilder)object).toString());
        }
        this.context.enableUpdate();
        ((JComboBox)serializable).setSelectedIndex(0);
        ((JComponent)serializable).setMinimumSize(new Dimension(50, ((JComponent)serializable).getMinimumSize().height));
    }

    public JSInternalConsole getConsole() {
        return this.console;
    }

    FileWindow getFileWindow(String string2) {
        if (string2 != null && !string2.equals("<stdin>")) {
            return this.fileWindows.get(string2);
        }
        return null;
    }

    public Menubar getMenubar() {
        return this.menubar;
    }

    @Override
    public boolean isGuiEventThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    void removeWindow(FileWindow jComponent) {
        this.fileWindows.remove(((FileWindow)jComponent).getUrl());
        JMenu jMenu = this.getWindowMenu();
        int n = jMenu.getItemCount();
        int n2 = n - 1;
        JMenuItem jMenuItem = jMenu.getItem(n2);
        String string2 = SwingGui.getShortName(((FileWindow)jComponent).getUrl());
        for (int i = 5; i < n; ++i) {
            CharSequence charSequence;
            jComponent = jMenu.getItem(i);
            if (jComponent == null || !((String)(charSequence = ((AbstractButton)jComponent).getText())).substring(((String)charSequence).indexOf(32) + 1).equals(string2)) continue;
            jMenu.remove((JMenuItem)jComponent);
            if (n == 6) {
                jMenu.remove(4);
                break;
            }
            int n3 = i - 4;
            while (i < n2) {
                JMenuItem jMenuItem2 = jMenu.getItem(i);
                int n4 = n3;
                if (jMenuItem2 != null) {
                    string2 = jMenuItem2.getText();
                    if (string2.equals("More Windows...")) break;
                    int n5 = string2.indexOf(32);
                    charSequence = new StringBuilder();
                    n4 = n3 + 48;
                    ((StringBuilder)charSequence).append((char)n4);
                    ((StringBuilder)charSequence).append(" ");
                    ((StringBuilder)charSequence).append(string2.substring(n5 + 1));
                    jMenuItem2.setText(((StringBuilder)charSequence).toString());
                    jMenuItem2.setMnemonic(n4);
                    n4 = n3 + 1;
                }
                ++i;
                n3 = n4;
            }
            if (n - 6 != 0 || jMenuItem == jComponent || !jMenuItem.getText().equals("More Windows...")) break;
            jMenu.remove(jMenuItem);
            break;
        }
        jMenu.revalidate();
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) return;
        this.console.consoleTextArea.requestFocus();
        this.context.split.setDividerLocation(0.5);
        try {
            this.console.setMaximum(true);
            this.console.setSelected(true);
            this.console.show();
            this.console.consoleTextArea.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void showFileWindow(String string2, int n) {
        FileWindow fileWindow;
        FileWindow fileWindow2 = fileWindow = this.getFileWindow(string2);
        if (fileWindow == null) {
            this.createFileWindow(this.dim.sourceInfo(string2), -1);
            fileWindow2 = this.getFileWindow(string2);
        }
        if (n > -1) {
            int n2 = fileWindow2.getPosition(n - 1);
            n = fileWindow2.getPosition(n);
            fileWindow2.textArea.select(n2);
            fileWindow2.textArea.setCaretPosition(n2);
            fileWindow2.textArea.moveCaretPosition(n - 1);
        }
        try {
            if (fileWindow2.isIcon()) {
                fileWindow2.setIcon(false);
            }
            fileWindow2.setVisible(true);
            fileWindow2.moveToFront();
            fileWindow2.setSelected(true);
            this.requestFocus();
            fileWindow2.requestFocus();
            fileWindow2.textArea.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void showStopLine(Dim.StackFrame object) {
        String string2 = ((Dim.StackFrame)object).getUrl();
        if (string2 != null && !string2.equals("<stdin>")) {
            this.showFileWindow(string2, -1);
            int n = ((Dim.StackFrame)object).getLineNumber();
            object = this.getFileWindow(string2);
            if (object != null) {
                this.setFilePosition((FileWindow)object, n);
            }
        } else if (this.console.isVisible()) {
            this.console.show();
        }
    }

    protected boolean updateFileWindow(Dim.SourceInfo sourceInfo) {
        FileWindow fileWindow = this.getFileWindow(sourceInfo.url());
        if (fileWindow != null) {
            fileWindow.updateText(sourceInfo);
            fileWindow.show();
            return true;
        }
        return false;
    }

    @Override
    public void updateSourceText(Dim.SourceInfo sourceInfo) {
        RunProxy runProxy = new RunProxy(this, 3);
        runProxy.sourceInfo = sourceInfo;
        SwingUtilities.invokeLater(runProxy);
    }
}

