/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.treetable.TreeTableModel;

class VariableModel
implements TreeTableModel {
    private static final VariableNode[] CHILDLESS;
    private static final String[] cNames;
    private static final Class<?>[] cTypes;
    private Dim debugger;
    private VariableNode root;

    static {
        cNames = new String[]{" Name", " Value"};
        cTypes = new Class[]{TreeTableModel.class, String.class};
        CHILDLESS = new VariableNode[0];
    }

    public VariableModel() {
    }

    public VariableModel(Dim dim, Object object) {
        this.debugger = dim;
        this.root = new VariableNode(object, "this");
    }

    private VariableNode[] children(VariableNode variableNode) {
        VariableNode[] variableNodeArray;
        if (variableNode.children != null) {
            return variableNode.children;
        }
        Object object = this.getValue(variableNode);
        Object[] objectArray = this.debugger.getObjectIds(object);
        if (objectArray != null && objectArray.length != 0) {
            Arrays.sort(objectArray, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    if (object instanceof String) {
                        if (object2 instanceof Integer) {
                            return -1;
                        }
                        return ((String)object).compareToIgnoreCase((String)object2);
                    }
                    if (object2 instanceof String) {
                        return 1;
                    }
                    return (Integer)object - (Integer)object2;
                }
            });
            VariableNode[] variableNodeArray2 = new VariableNode[objectArray.length];
            int n = 0;
            while (true) {
                variableNodeArray = variableNodeArray2;
                if (n != objectArray.length) {
                    variableNodeArray2[n] = new VariableNode(object, objectArray[n]);
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            variableNodeArray = CHILDLESS;
        }
        VariableNode.access$002(variableNode, variableNodeArray);
        return variableNodeArray;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public Object getChild(Object object, int n) {
        if (this.debugger == null) {
            return null;
        }
        return this.children((VariableNode)object)[n];
    }

    @Override
    public int getChildCount(Object object) {
        if (this.debugger == null) {
            return 0;
        }
        return this.children((VariableNode)object).length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return cNames[n];
    }

    @Override
    public int getIndexOfChild(Object object, Object variableNodeArray) {
        if (this.debugger == null) {
            return -1;
        }
        VariableNode variableNode = (VariableNode)object;
        object = (VariableNode)variableNodeArray;
        variableNodeArray = this.children(variableNode);
        for (int i = 0; i != variableNodeArray.length; ++i) {
            if (variableNodeArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        if (this.debugger == null) {
            return null;
        }
        return this.root;
    }

    public Object getValue(VariableNode object) {
        try {
            object = this.debugger.getObjectProperty(((VariableNode)object).object, ((VariableNode)object).id);
            return object;
        }
        catch (Exception exception) {
            return "undefined";
        }
    }

    @Override
    public Object getValueAt(Object object, int n) {
        Object object2 = this.debugger;
        if (object2 == null) {
            return null;
        }
        object = (VariableNode)object;
        if (n != 0) {
            if (n != 1) {
                return null;
            }
            try {
                object = ((Dim)object2).objectToString(this.getValue((VariableNode)object));
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException.getMessage();
            }
            object2 = new StringBuilder();
            int n2 = ((String)object).length();
            for (n = 0; n < n2; ++n) {
                int n3;
                int n4 = n3 = ((String)object).charAt(n);
                if (Character.isISOControl((char)n3)) {
                    int n5;
                    n4 = n5 = 32;
                }
                ((StringBuilder)object2).append((char)n4);
            }
            return ((StringBuilder)object2).toString();
        }
        return ((VariableNode)object).toString();
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        boolean bl = n == 0;
        return bl;
    }

    @Override
    public boolean isLeaf(Object object) {
        Dim dim = this.debugger;
        boolean bl = true;
        if (dim == null) {
            return true;
        }
        if (this.children((VariableNode)object).length != 0) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    private static class VariableNode {
        private VariableNode[] children;
        private Object id;
        private Object object;

        public VariableNode(Object object, Object object2) {
            this.object = object;
            this.id = object2;
        }

        static /* synthetic */ VariableNode[] access$002(VariableNode variableNode, VariableNode[] variableNodeArray) {
            variableNode.children = variableNodeArray;
            return variableNodeArray;
        }

        public String toString() {
            Object object = this.id;
            if (object instanceof String) {
                object = (String)object;
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append((Integer)this.id);
                ((StringBuilder)object).append("]");
                object = ((StringBuilder)object).toString();
            }
            return object;
        }
    }
}

