/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger.treetable;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.mozilla.javascript.tools.debugger.treetable.AbstractCellEditor;
import org.mozilla.javascript.tools.debugger.treetable.TreeTableModel;
import org.mozilla.javascript.tools.debugger.treetable.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = -2103973006456695515L;
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel object) {
        this.tree = new TreeTableCellRenderer((TreeModel)object);
        super.setModel(new TreeTableModelAdapter((TreeTableModel)object, this.tree));
        object = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel((TreeSelectionModel)object);
        this.setSelectionModel(((ListToTreeSelectionModelWrapper)object).getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
    }

    @Override
    public int getEditingRow() {
        int n = this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
        return n;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        TreeTableCellRenderer treeTableCellRenderer = this.tree;
        if (treeTableCellRenderer != null && treeTableCellRenderer.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeTableCellRenderer treeTableCellRenderer = this.tree;
        if (treeTableCellRenderer != null) {
            treeTableCellRenderer.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 8168140829623071131L;
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        public ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                block6: {
                    int n;
                    int n2;
                    this.updatingListSelectionModel = true;
                    try {
                        n2 = this.listSelectionModel.getMaxSelectionIndex();
                        this.clearSelection();
                        if (n == -1 || n2 == -1) break block6;
                    }
                    catch (Throwable throwable) {
                        this.updatingListSelectionModel = false;
                        throw throwable;
                    }
                    for (n = this.listSelectionModel.getMinSelectionIndex(); n <= n2; ++n) {
                        TreePath treePath;
                        if (!this.listSelectionModel.isSelectedIndex(n) || (treePath = JTreeTable.this.tree.getPathForRow(n)) == null) continue;
                        this.addSelectionPath(treePath);
                    }
                }
                this.updatingListSelectionModel = false;
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                    eventObject = (MouseEvent)eventObject;
                    eventObject = new MouseEvent(JTreeTable.this.tree, ((AWTEvent)eventObject).getID(), ((InputEvent)eventObject).getWhen(), ((InputEvent)eventObject).getModifiers(), ((MouseEvent)eventObject).getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, ((MouseEvent)eventObject).getY(), ((MouseEvent)eventObject).getClickCount(), ((MouseEvent)eventObject).isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent((AWTEvent)eventObject);
                    break;
                }
            }
            return false;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = -193867880014600717L;
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                JTreeTable jTreeTable = JTreeTable.this;
                if (jTreeTable != null && jTreeTable.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                treeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                ((DefaultTreeCellRenderer)treeCellRenderer).setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                ((DefaultTreeCellRenderer)treeCellRenderer).setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }
    }
}

