/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

class CodePrinter {
    private static final int LITERAL_CHAR_MAX_SIZE = 6;
    private char[] buffer = new char[4096];
    private int indentStep = 4;
    private int indentTabSize = 8;
    private String lineTerminator = "\n";
    private int offset;

    CodePrinter() {
    }

    private int add_area(int n) {
        int n2 = this.ensure_area(n);
        this.offset = n + n2;
        return n2;
    }

    private static char digit_to_hex_letter(int n) {
        n = n < 10 ? (n += 48) : (n += 55);
        return (char)n;
    }

    private int ensure_area(int n) {
        int n2 = this.offset;
        char[] cArray = this.buffer;
        if ((n += n2) > cArray.length) {
            int n3 = cArray.length * 2;
            if (n <= n3) {
                n = n3;
            }
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            this.buffer = cArray2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int put_string_literal_char(int n, int n2, boolean bl) {
        boolean bl2;
        int n3;
        block9: {
            block11: {
                block7: {
                    block8: {
                        block10: {
                            if (n2 == 12) break block7;
                            if (n2 == 13) break block8;
                            n3 = n2;
                            bl2 = bl;
                            if (n2 == 34) break block9;
                            if (n2 == 39) break block10;
                            switch (n2) {
                                default: {
                                    bl2 = false;
                                    n3 = n2;
                                    break block9;
                                }
                                case 10: {
                                    n2 = 110;
                                    break;
                                }
                                case 9: {
                                    n2 = 116;
                                    break;
                                }
                                case 8: {
                                    n2 = 98;
                                    break;
                                }
                            }
                            break block11;
                        }
                        bl2 = bl ^ true;
                        n3 = n2;
                        break block9;
                    }
                    n2 = 114;
                    break block11;
                }
                n2 = 102;
            }
            bl2 = true;
            n3 = n2;
        }
        if (bl2) {
            char[] cArray = this.buffer;
            cArray[n] = (char)92;
            cArray[n + 1] = (char)n3;
            return n += 2;
        }
        if (32 <= n3 && n3 <= 126) {
            this.buffer[n] = (char)n3;
            return ++n;
        }
        char[] cArray = this.buffer;
        cArray[n] = (char)92;
        cArray[n + 1] = (char)117;
        cArray[n + 2] = CodePrinter.digit_to_hex_letter(n3 >> 12 & 0xF);
        this.buffer[n + 3] = CodePrinter.digit_to_hex_letter(n3 >> 8 & 0xF);
        this.buffer[n + 4] = CodePrinter.digit_to_hex_letter(n3 >> 4 & 0xF);
        this.buffer[n + 5] = CodePrinter.digit_to_hex_letter(n3 & 0xF);
        n += 6;
        return n;
    }

    public void clear() {
        this.offset = 0;
    }

    public void erase(int n, int n2) {
        char[] cArray = this.buffer;
        System.arraycopy(cArray, n2, cArray, n, this.offset - n2);
        this.offset -= n2 - n;
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public int getIndentTabSize() {
        return this.indentTabSize;
    }

    public int getLastChar() {
        int n = this.offset;
        n = n == 0 ? -1 : this.buffer[n - 1];
        return n;
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    public int getOffset() {
        return this.offset;
    }

    public void indent(int n) {
        int n2;
        int n3;
        int n4 = this.indentStep * n;
        n = this.indentTabSize;
        if (n <= 0) {
            n3 = 0;
        } else {
            n3 = n4 / n;
            n4 = n4 % n + n3;
        }
        n = n2 = this.add_area(n4);
        while (true) {
            if (n == n3 + n2) break;
            this.buffer[n] = (char)9;
        }
        for (int i = ++n; i != n4 + n2; ++i) {
            this.buffer[i] = (char)32;
        }
    }

    public void line(int n, String string2) {
        this.indent(n);
        this.p(string2);
        this.nl();
    }

    public void nl() {
        this.p('\n');
    }

    public void p(char c) {
        int n = this.add_area(1);
        this.buffer[n] = c;
    }

    public void p(int n) {
        this.p(Integer.toString(n));
    }

    public void p(String string2) {
        int n = string2.length();
        int n2 = this.add_area(n);
        string2.getChars(0, n, this.buffer, n2);
    }

    public final void p(char[] cArray) {
        this.p(cArray, 0, cArray.length);
    }

    public void p(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        n2 = this.add_area(n3);
        System.arraycopy(cArray, n, this.buffer, n2, n3);
    }

    public void qchar(int n) {
        int n2 = this.ensure_area(8);
        this.buffer[n2] = (char)39;
        n = this.put_string_literal_char(n2 + 1, n, false);
        this.buffer[n] = (char)39;
        this.offset = n + 1;
    }

    public void qstring(String string2) {
        int n = string2.length();
        int n2 = this.ensure_area(n * 6 + 2);
        this.buffer[n2] = (char)34;
        int n3 = n2 + 1;
        for (n2 = 0; n2 != n; ++n2) {
            n3 = this.put_string_literal_char(n3, string2.charAt(n2), true);
        }
        this.buffer[n3] = (char)34;
        this.offset = n3 + 1;
    }

    public void setIndentStep(int n) {
        this.indentStep = n;
    }

    public void setIndentTabSize(int n) {
        this.indentTabSize = n;
    }

    public void setLineTerminator(String string2) {
        this.lineTerminator = string2;
    }

    public String toString() {
        return new String(this.buffer, 0, this.offset);
    }
}

