/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class FileBody {
    private char[] buffer = new char[16384];
    private int bufferEnd;
    ReplaceItem firstReplace;
    ReplaceItem lastReplace;
    private int lineBegin;
    private int lineEnd;
    private int lineNumber;
    private int nextLineStart;

    private static boolean equals(String string2, char[] cArray, int n, int n2) {
        if (string2.length() == n2 - n) {
            int n3 = 0;
            while (n != n2) {
                if (cArray[n] != string2.charAt(n3)) {
                    return false;
                }
                ++n;
                ++n3;
            }
            return true;
        }
        return false;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int getLineBegin() {
        return this.lineBegin;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean nextLine() {
        int n = this.nextLineStart;
        int n2 = this.bufferEnd;
        int n3 = 0;
        int n4 = n;
        if (n == n2) {
            this.lineNumber = 0;
            return false;
        }
        while (true) {
            n2 = this.bufferEnd;
            n = n3;
            if (n4 == n2) break;
            n = n3 = this.buffer[n4];
            if (n3 == 10) break;
            if (n3 == 13) {
                n = n3;
                break;
            }
            ++n4;
        }
        this.lineBegin = this.nextLineStart;
        this.lineEnd = n4;
        this.nextLineStart = n4 == n2 ? n4 : (n == 13 && (n3 = n4 + 1) != n2 && this.buffer[n3] == '\n' ? n4 + 2 : n4 + 1);
        ++this.lineNumber;
        return true;
    }

    public void readData(Reader reader) throws IOException {
        int n = this.buffer.length;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = reader.read(this.buffer, n2, n - n2)) < 0) {
                this.bufferEnd = n2;
                return;
            }
            n2 = n3 = n2 + n3;
            if (n != n3) continue;
            char[] cArray = new char[n *= 2];
            System.arraycopy(this.buffer, 0, cArray, 0, n3);
            this.buffer = cArray;
            n2 = n3;
        }
    }

    public boolean setReplacement(int n, int n2, String object) {
        if (FileBody.equals((String)object, this.buffer, n, n2)) {
            return false;
        }
        ReplaceItem replaceItem = new ReplaceItem(n, n2, (String)object);
        object = this.firstReplace;
        if (object == null) {
            this.lastReplace = replaceItem;
            this.firstReplace = replaceItem;
        } else if (n < ((ReplaceItem)object).begin) {
            replaceItem.next = this.firstReplace;
            this.firstReplace = replaceItem;
        } else {
            Object object2 = this.firstReplace;
            object = ((ReplaceItem)object2).next;
            while (object != null) {
                if (n < ((ReplaceItem)object).begin) {
                    replaceItem.next = object;
                    ((ReplaceItem)object2).next = replaceItem;
                    break;
                }
                ReplaceItem replaceItem2 = ((ReplaceItem)object).next;
                object2 = object;
                object = replaceItem2;
            }
            if (object == null) {
                this.lastReplace.next = replaceItem;
            }
        }
        return true;
    }

    public void startLineLoop() {
        this.lineNumber = 0;
        this.nextLineStart = 0;
        this.lineEnd = 0;
        this.lineBegin = 0;
    }

    public boolean wasModified() {
        boolean bl = this.firstReplace != null;
        return bl;
    }

    public void writeData(Writer writer) throws IOException {
        int n;
        ReplaceItem replaceItem = this.firstReplace;
        int n2 = 0;
        while (replaceItem != null) {
            n = replaceItem.begin - n2;
            if (n > 0) {
                writer.write(this.buffer, n2, n);
            }
            writer.write(replaceItem.replacement);
            n2 = replaceItem.end;
            replaceItem = replaceItem.next;
        }
        n = this.bufferEnd - n2;
        if (n != 0) {
            writer.write(this.buffer, n2, n);
        }
    }

    public void writeInitialData(Writer writer) throws IOException {
        writer.write(this.buffer, 0, this.bufferEnd);
    }

    private static class ReplaceItem {
        int begin;
        int end;
        ReplaceItem next;
        String replacement;

        ReplaceItem(int n, int n2, String string2) {
            this.begin = n;
            this.end = n2;
            this.replacement = string2;
        }
    }
}

