/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.idswitch.CodePrinter;
import org.mozilla.javascript.tools.idswitch.FileBody;
import org.mozilla.javascript.tools.idswitch.IdValuePair;
import org.mozilla.javascript.tools.idswitch.SwitchGenerator;

public class Main {
    private static final int GENERATED_TAG = 2;
    private static final String GENERATED_TAG_STR = "generated";
    private static final int NORMAL_LINE = 0;
    private static final int STRING_TAG = 3;
    private static final String STRING_TAG_STR = "string";
    private static final int SWITCH_TAG = 1;
    private static final String SWITCH_TAG_STR = "string_id_map";
    private CodePrinter P;
    private ToolErrorReporter R;
    private final List<IdValuePair> all_pairs = new ArrayList<IdValuePair>();
    private FileBody body;
    private String source_file;
    private int tag_definition_end;
    private int tag_value_end;
    private int tag_value_start;

    private void add_id(char[] object, int n, int n2, int n3, int n4) {
        object = new IdValuePair(new String((char[])object, n3, n4 - n3), new String((char[])object, n, n2 - n));
        ((IdValuePair)object).setLineNumber(this.body.getLineNumber());
        this.all_pairs.add((IdValuePair)object);
    }

    private static boolean equals(String string2, char[] cArray, int n, int n2) {
        if (string2.length() == n2 - n) {
            int n3 = 0;
            int n4 = n;
            n = n3;
            while (n4 != n2) {
                if (cArray[n4] != string2.charAt(n)) {
                    return false;
                }
                ++n4;
                ++n;
            }
            return true;
        }
        return false;
    }

    private int exec(String[] stringArray) {
        CodePrinter codePrinter;
        this.R = new ToolErrorReporter(true, System.err);
        int n = this.process_options(stringArray);
        if (n == 0) {
            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.no_file_argument"));
            return -1;
        }
        if (n > 1) {
            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.too_many_arguments"));
            return -1;
        }
        this.P = codePrinter = new CodePrinter();
        codePrinter.setIndentStep(4);
        this.P.setIndentTabSize(0);
        try {
            this.process_file(stringArray[0]);
            return 0;
        }
        catch (EvaluatorException evaluatorException) {
            return -1;
        }
        catch (IOException iOException) {
            this.print_error(ToolErrorReporter.getMessage("msg.idswitch.io_error", iOException.toString()));
            return -1;
        }
    }

    private int extract_line_tag_id(char[] object, int n, int n2) {
        int n3;
        block16: {
            char c;
            int n4;
            int n5;
            boolean bl;
            int n6;
            block17: {
                int n7;
                n = Main.skip_white_space(object, n, n2);
                n6 = this.look_for_slash_slash((char[])object, n, n2);
                n3 = n7 = 0;
                if (n6 == n2) break block16;
                bl = n + 2 == n6;
                n = Main.skip_white_space(object, n6, n2);
                n3 = n7;
                if (n == n2) break block16;
                n3 = n7;
                if (object[n] != '#') break block16;
                if (++n != n2 && object[n] == '/') {
                    ++n;
                    n6 = 1;
                } else {
                    n6 = 0;
                }
                for (n5 = n; n5 != n2 && (n3 = object[n5]) != 35 && n3 != 61 && !Main.is_white_space(n3); ++n5) {
                }
                n3 = n7;
                if (n5 == n2) break block16;
                n4 = Main.skip_white_space(object, n5, n2);
                n3 = n7;
                if (n4 == n2) break block16;
                c = object[n4];
                if (c == '=') break block17;
                n3 = n7;
                if (c != '#') break block16;
            }
            n3 = n5 = this.get_tag_id((char[])object, n, n5, bl);
            if (n5 != 0) {
                Object var11_11 = null;
                String string2 = null;
                if (c == '#') {
                    n = n5;
                    object = string2;
                    if (n6 != 0) {
                        n = n2 = -n5;
                        object = string2;
                        if (Main.is_value_type(n2)) {
                            object = "msg.idswitch.no_end_usage";
                            n = n2;
                        }
                    }
                    this.tag_definition_end = n4 + 1;
                } else {
                    if (n6 != 0) {
                        string2 = "msg.idswitch.no_end_with_value";
                    } else {
                        string2 = var11_11;
                        if (!Main.is_value_type(n5)) {
                            string2 = "msg.idswitch.no_value_allowed";
                        }
                    }
                    n = this.extract_tag_value((char[])object, n4 + 1, n2, n5);
                    object = string2;
                }
                if (object == null) {
                    n3 = n;
                } else {
                    object = ToolErrorReporter.getMessage((String)object, Main.tag_name(n));
                    throw this.R.runtimeError((String)object, this.source_file, this.body.getLineNumber(), null, 0);
                }
            }
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int extract_tag_value(char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        block4: {
            n6 = Main.skip_white_space(cArray, n, n2);
            n5 = 1;
            if (n6 == n2) return 0;
            n = n6;
            while (n != n2) {
                n4 = cArray[n];
                if (Main.is_white_space(n4)) {
                    int n7 = Main.skip_white_space(cArray, n + 1, n2);
                    if (n7 != n2 && cArray[n7] == '#') {
                        n4 = n;
                        n = n7;
                        break block4;
                    }
                    n = n7 + 1;
                    continue;
                }
                if (n4 == 35) {
                    n4 = n;
                    break block4;
                }
                ++n;
            }
            n4 = n6;
        }
        if (n == n2) return 0;
        this.tag_value_start = n6;
        this.tag_value_end = n4;
        this.tag_definition_end = n + 1;
        n = n5;
        if (n == 0) return 0;
        return n3;
    }

    private void generate_java_code() {
        this.P.clear();
        IdValuePair[] idValuePairArray = new IdValuePair[this.all_pairs.size()];
        this.all_pairs.toArray(idValuePairArray);
        SwitchGenerator switchGenerator = new SwitchGenerator();
        switchGenerator.char_tail_test_threshold = 2;
        switchGenerator.setReporter(this.R);
        switchGenerator.setCodePrinter(this.P);
        switchGenerator.generateSwitch(idValuePairArray, "0");
    }

    private int get_tag_id(char[] cArray, int n, int n2, boolean bl) {
        if (bl) {
            if (Main.equals(SWITCH_TAG_STR, cArray, n, n2)) {
                return 1;
            }
            if (Main.equals(GENERATED_TAG_STR, cArray, n, n2)) {
                return 2;
            }
        }
        if (Main.equals(STRING_TAG_STR, cArray, n, n2)) {
            return 3;
        }
        return 0;
    }

    private String get_time_stamp() {
        return new SimpleDateFormat(" 'Last update:' yyyy-MM-dd HH:mm:ss z").format(new Date());
    }

    private static boolean is_value_type(int n) {
        return n == 3;
    }

    private static boolean is_white_space(int n) {
        boolean bl = n == 32 || n == 9;
        return bl;
    }

    private void look_for_id_definitions(char[] cArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = Main.skip_white_space(cArray, n, n2);
        if ((n = Main.skip_matched_prefix("Id_", cArray, n5, n2)) >= 0 && n != (n4 = Main.skip_name_char(cArray, n, n2)) && (n3 = Main.skip_white_space(cArray, n4, n2)) != n2 && cArray[n3] == '=') {
            if (bl) {
                n = this.tag_value_start;
                n2 = this.tag_value_end;
            } else {
                n2 = n4;
            }
            this.add_id(cArray, n5, n4, n, n2);
        }
    }

    private int look_for_slash_slash(char[] cArray, int n, int n2) {
        while (n + 2 <= n2) {
            int n3 = n + 1;
            if (cArray[n] == '/') {
                int n4;
                n = n4 = n3 + 1;
                if (cArray[n3] != '/') continue;
                return n4;
            }
            n = n3;
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        System.exit(new Main().exec(stringArray));
    }

    private void option_error(String string2) {
        this.print_error(ToolErrorReporter.getMessage("msg.idswitch.bad_invocation", string2));
    }

    private void print_error(String string2) {
        System.err.println(string2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void process_file() {
        var1_1 /* !! */  = this.body.getBuffer();
        this.body.startLineLoop();
        var2_2 = 0;
        var3_3 = -1;
        var4_4 = -1;
        var5_5 = -1;
        var6_6 = -1;
        while (this.body.nextLine()) {
            block13: {
                block18: {
                    block9: {
                        block16: {
                            block17: {
                                block15: {
                                    block14: {
                                        block10: {
                                            block12: {
                                                block11: {
                                                    var7_7 = this.body.getLineBegin();
                                                    var8_8 = this.body.getLineEnd();
                                                    var9_9 = this.extract_line_tag_id(var1_1 /* !! */ , var7_7, var8_8);
                                                    var10_10 = 1;
                                                    if (var2_2 == 0) break block9;
                                                    if (var2_2 == 1) break block10;
                                                    if (var2_2 == 2) break block11;
                                                    var11_11 = var2_2;
                                                    var12_12 = var3_3;
                                                    var13_13 = var4_4;
                                                    var14_14 = var5_5;
                                                    var8_8 = var6_6;
                                                    ** GOTO lbl-1000
                                                }
                                                if (var9_9 != 0) break block12;
                                                var11_11 = var2_2;
                                                var12_12 = var3_3;
                                                var13_13 = var4_4;
                                                var14_14 = var5_5;
                                                var8_8 = var6_6;
                                                if (var3_3 < 0) {
                                                    var12_12 = var7_7;
                                                    var11_11 = var2_2;
                                                    var13_13 = var4_4;
                                                    var14_14 = var5_5;
                                                    var8_8 = var6_6;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            var11_11 = var2_2;
                                            var12_12 = var3_3;
                                            var13_13 = var4_4;
                                            var14_14 = var5_5;
                                            var8_8 = var6_6;
                                            var2_2 = var10_10;
                                            if (var9_9 != -2) break block13;
                                            var12_12 = var3_3;
                                            if (var3_3 < 0) {
                                                var12_12 = var7_7;
                                            }
                                            var11_11 = 1;
                                            var13_13 = var7_7;
                                            var14_14 = var5_5;
                                            var8_8 = var6_6;
                                            ** GOTO lbl-1000
                                        }
                                        if (var9_9 != 0) break block14;
                                        this.look_for_id_definitions(var1_1 /* !! */ , var7_7, var8_8, false);
                                        var11_11 = var2_2;
                                        var12_12 = var3_3;
                                        var13_13 = var4_4;
                                        var14_14 = var5_5;
                                        var8_8 = var6_6;
                                        ** GOTO lbl-1000
                                    }
                                    if (var9_9 != 3) break block15;
                                    this.look_for_id_definitions(var1_1 /* !! */ , var7_7, var8_8, true);
                                    var11_11 = var2_2;
                                    var12_12 = var3_3;
                                    var13_13 = var4_4;
                                    var14_14 = var5_5;
                                    var8_8 = var6_6;
                                    ** GOTO lbl-1000
                                }
                                if (var9_9 != 2) break block16;
                                if (var3_3 < 0) break block17;
                                var11_11 = var2_2;
                                var12_12 = var3_3;
                                var13_13 = var4_4;
                                var14_14 = var5_5;
                                var8_8 = var6_6;
                                var2_2 = var10_10;
                                break block13;
                            }
                            var14_14 = this.tag_definition_end;
                            var11_11 = 2;
                            var12_12 = var3_3;
                            var13_13 = var4_4;
                            ** GOTO lbl-1000
                        }
                        var11_11 = var2_2;
                        var12_12 = var3_3;
                        var13_13 = var4_4;
                        var14_14 = var5_5;
                        var8_8 = var6_6;
                        var2_2 = var10_10;
                        if (var9_9 != -1) break block13;
                        if (var3_3 >= 0 && !this.all_pairs.isEmpty()) {
                            this.generate_java_code();
                            var15_15 = this.P.toString();
                            if (this.body.setReplacement(var3_3, var4_4, var15_15)) {
                                var15_15 = this.get_time_stamp();
                                this.body.setReplacement(var5_5, var6_6, var15_15);
                            }
                        }
                        var11_11 = 0;
                        var12_12 = var3_3;
                        var13_13 = var4_4;
                        var14_14 = var5_5;
                        var8_8 = var6_6;
                        ** GOTO lbl-1000
                    }
                    if (var9_9 != 1) break block18;
                    this.all_pairs.clear();
                    var11_11 = 1;
                    var12_12 = -1;
                    var13_13 = var4_4;
                    var14_14 = var5_5;
                    var8_8 = var6_6;
                    ** GOTO lbl-1000
                }
                var11_11 = var2_2;
                var12_12 = var3_3;
                var13_13 = var4_4;
                var14_14 = var5_5;
                var8_8 = var6_6;
                if (var9_9 == -1) {
                    var11_11 = var2_2;
                    var12_12 = var3_3;
                    var13_13 = var4_4;
                    var14_14 = var5_5;
                    var8_8 = var6_6;
                    var2_2 = var10_10;
                } else lbl-1000:
                // 9 sources

                {
                    var2_2 = 0;
                }
            }
            if (var2_2 == 0) {
                var2_2 = var11_11;
                var3_3 = var12_12;
                var4_4 = var13_13;
                var5_5 = var14_14;
                var6_6 = var8_8;
                continue;
            }
            var1_1 /* !! */  = (char[])ToolErrorReporter.getMessage("msg.idswitch.bad_tag_order", Main.tag_name(var9_9));
            throw this.R.runtimeError((String)var1_1 /* !! */ , this.source_file, this.body.getLineNumber(), null, 0);
        }
        if (var2_2 == 0) {
            return;
        }
        var1_1 /* !! */  = (char[])ToolErrorReporter.getMessage("msg.idswitch.file_end_in_switch", Main.tag_name(var2_2));
        throw this.R.runtimeError((String)var1_1 /* !! */ , this.source_file, this.body.getLineNumber(), null, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int process_options(String[] stringArray) {
        int n;
        int n2;
        int n3 = stringArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        block0: while (true) {
            block13: {
                block11: {
                    int n8;
                    String string2;
                    int n9;
                    block14: {
                        block12: {
                            block15: {
                                n9 = -1;
                                if (n5 == n3) break block12;
                                string2 = stringArray[n5];
                                n8 = string2.length();
                                n2 = n6;
                                n = n7;
                                if (n8 < 2) break block13;
                                n2 = n6;
                                n = n7;
                                if (string2.charAt(0) != '-') break block13;
                                if (string2.charAt(1) != '-') break block14;
                                if (n8 != 2) break block15;
                                stringArray[n5] = null;
                                break block12;
                            }
                            if (string2.equals("--help")) {
                                n6 = 1;
                                n = n7;
                                break block11;
                            } else if (string2.equals("--version")) {
                                n = 1;
                                break block11;
                            } else {
                                this.option_error(ToolErrorReporter.getMessage("msg.idswitch.bad_option", string2));
                                n = n6;
                                n2 = n9;
                                break;
                            }
                        }
                        n2 = 1;
                        n = n6;
                        break;
                    }
                    int n10 = 1;
                    n2 = n6;
                    while (true) {
                        n6 = n2;
                        n = n7;
                        if (n10 == n8) break;
                        char c = string2.charAt(n10);
                        if (c != 'h') {
                            this.option_error(ToolErrorReporter.getMessage("msg.idswitch.bad_option_char", String.valueOf(c)));
                            n = n2;
                            n2 = n9;
                            break block0;
                        }
                        ++n10;
                        n2 = 1;
                    }
                }
                stringArray[n5] = null;
                n2 = n6;
            }
            ++n5;
            n6 = n2;
            n7 = n;
        }
        n6 = n2;
        if (n2 == 1) {
            n6 = n2;
            if (n != 0) {
                this.show_usage();
                n6 = 0;
            }
            if (n7 != 0) {
                this.show_version();
                n6 = n4;
            }
        }
        if (n6 != 1) {
            System.exit(n6);
        }
        return this.remove_nulls(stringArray);
    }

    private int remove_nulls(String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        for (n = 0; n != n2 && stringArray[n] != null; ++n) {
        }
        int n3 = n;
        if (n != n2) {
            int n4 = n + 1;
            while (true) {
                n3 = n;
                if (n4 == n2) break;
                String string2 = stringArray[n4];
                n3 = n;
                if (string2 != null) {
                    stringArray[n] = string2;
                    n3 = n + 1;
                }
                ++n4;
                n = n3;
            }
        }
        return n3;
    }

    private void show_usage() {
        System.out.println(ToolErrorReporter.getMessage("msg.idswitch.usage"));
        System.out.println();
    }

    private void show_version() {
        System.out.println(ToolErrorReporter.getMessage("msg.idswitch.version"));
    }

    private static int skip_matched_prefix(String string2, char[] cArray, int n, int n2) {
        int n3;
        block3: {
            int n4;
            int n5 = string2.length();
            n3 = n4 = -1;
            if (n5 <= n2 - n) {
                n2 = 0;
                while (n2 != n5) {
                    if (string2.charAt(n2) != cArray[n]) {
                        n3 = n4;
                        break block3;
                    }
                    ++n2;
                    ++n;
                }
                n3 = n;
            }
        }
        return n3;
    }

    private static int skip_name_char(char[] cArray, int n, int n2) {
        char c;
        while (n != n2 && ('a' <= (c = cArray[n]) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_')) {
            ++n;
        }
        return n;
    }

    private static int skip_white_space(char[] cArray, int n, int n2) {
        while (n != n2 && Main.is_white_space(cArray[n])) {
            ++n;
        }
        return n;
    }

    private static String tag_name(int n) {
        if (n != -2) {
            if (n != -1) {
                if (n != 1) {
                    if (n != 2) {
                        return "";
                    }
                    return GENERATED_TAG_STR;
                }
                return SWITCH_TAG_STR;
            }
            return "/string_id_map";
        }
        return "/generated";
    }

    void process_file(String object) throws IOException {
        Closeable closeable;
        block6: {
            this.source_file = object;
            this.body = new FileBody();
            closeable = ((String)object).equals("-") ? System.in : new FileInputStream((String)object);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable, "ASCII");
            this.body.readData(inputStreamReader);
            this.process_file();
            if (!this.body.wasModified()) break block6;
            object = ((String)object).equals("-") ? System.out : new FileOutputStream((String)object);
            try {
                closeable = new OutputStreamWriter((OutputStream)object);
                this.body.writeData((Writer)closeable);
                ((Writer)closeable).flush();
            }
            finally {
                ((OutputStream)object).close();
            }
        }
        return;
        finally {
            ((InputStream)closeable).close();
        }
    }
}

