/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.idswitch;

import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.idswitch.CodePrinter;
import org.mozilla.javascript.tools.idswitch.IdValuePair;

public class SwitchGenerator {
    private CodePrinter P;
    private ToolErrorReporter R;
    private boolean c_was_defined;
    int char_tail_test_threshold = 2;
    private int[] columns;
    private String default_value;
    private IdValuePair[] pairs;
    private String source_file;
    int use_if_threshold = 3;
    String v_c = "c";
    String v_guess = "X";
    String v_id = "id";
    String v_label = "L";
    String v_length_suffix = "_length";
    String v_s = "s";
    String v_switch_label = "L0";

    private static boolean bigger(IdValuePair idValuePair, IdValuePair idValuePair2, int n) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (n < 0) {
            n = idValuePair.idLength - idValuePair2.idLength;
            if (n != 0) {
                if (n <= 0) {
                    bl3 = false;
                }
                return bl3;
            }
            bl3 = idValuePair.id.compareTo(idValuePair2.id) > 0 ? bl : false;
            return bl3;
        }
        bl3 = idValuePair.id.charAt(n) > idValuePair2.id.charAt(n) ? bl2 : false;
        return bl3;
    }

    private void check_all_is_different(int n, int n2) {
        if (n != n2) {
            IdValuePair idValuePair = this.pairs[n];
            while (++n != n2) {
                IdValuePair idValuePair2 = this.pairs[n];
                if (!idValuePair.id.equals(idValuePair2.id)) {
                    idValuePair = idValuePair2;
                    continue;
                }
                throw this.on_same_pair_fail(idValuePair, idValuePair2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int count_different_chars(int n, int n2, int n3) {
        int n4 = 0;
        int c = -1;
        while (n != n2) {
            void var5_6;
            char c2 = this.pairs[n].id.charAt(n3);
            int n5 = n4;
            char c3 = var5_6;
            if (c2 != var5_6) {
                n5 = n4 + 1;
                c3 = c2;
            }
            ++n;
            n4 = n5;
            var5_6 = c3;
        }
        return n4;
    }

    private int count_different_lengths(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        while (n != n2) {
            int n5 = this.pairs[n].idLength;
            int n6 = n3;
            int n7 = n4;
            if (n4 != n5) {
                n6 = n3 + 1;
                n7 = n5;
            }
            ++n;
            n3 = n6;
            n4 = n7;
        }
        return n3;
    }

    private int find_max_different_column(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i != n3; ++i) {
            int n6 = this.columns[i];
            this.sort_pairs(n, n2, n6);
            int n7 = this.count_different_chars(n, n2, n6);
            if (n7 == n2 - n) {
                return i;
            }
            n6 = n5;
            if (n5 < n7) {
                n4 = i;
                n6 = n7;
            }
            n5 = n6;
        }
        if (n4 != n3 - 1) {
            this.sort_pairs(n, n2, this.columns[n4]);
        }
        return n4;
    }

    private void generate_body(int n, int n2, int n3) {
        this.P.indent(n3);
        this.P.p(this.v_switch_label);
        this.P.p(": { ");
        this.P.p(this.v_id);
        this.P.p(" = ");
        this.P.p(this.default_value);
        this.P.p("; String ");
        this.P.p(this.v_guess);
        this.P.p(" = null;");
        this.c_was_defined = false;
        int n4 = this.P.getOffset();
        this.P.p(" int ");
        this.P.p(this.v_c);
        this.P.p(';');
        int n5 = this.P.getOffset();
        this.P.nl();
        int n6 = n3 + 1;
        this.generate_length_switch(n, n2, n6);
        if (!this.c_was_defined) {
            this.P.erase(n4, n5);
        }
        this.P.indent(n6);
        this.P.p("if (");
        this.P.p(this.v_guess);
        this.P.p("!=null && ");
        this.P.p(this.v_guess);
        this.P.p("!=");
        this.P.p(this.v_s);
        this.P.p(" && !");
        this.P.p(this.v_guess);
        this.P.p(".equals(");
        this.P.p(this.v_s);
        this.P.p(")) ");
        this.P.p(this.v_id);
        this.P.p(" = ");
        this.P.p(this.default_value);
        this.P.p(";");
        this.P.nl();
        this.P.indent(n6);
        this.P.p("break ");
        this.P.p(this.v_switch_label);
        this.P.p(";");
        this.P.nl();
        this.P.line(n3, "}");
    }

    private void generate_length_switch(int n, int n2, int n3) {
        boolean bl;
        this.sort_pairs(n, n2, -1);
        this.check_all_is_different(n, n2);
        int n4 = this.count_different_lengths(n, n2);
        this.columns = new int[this.pairs[n2 - 1].idLength];
        int n5 = this.use_if_threshold;
        int n6 = 0;
        if (n4 <= n5) {
            if (n4 != 1) {
                this.P.indent(n3);
                this.P.p("int ");
                this.P.p(this.v_s);
                this.P.p(this.v_length_suffix);
                this.P.p(" = ");
                this.P.p(this.v_s);
                this.P.p(".length();");
                this.P.nl();
            }
            bl = true;
        } else {
            this.P.indent(n3);
            this.P.p(this.v_label);
            this.P.p(": switch (");
            this.P.p(this.v_s);
            this.P.p(".length()) {");
            this.P.nl();
            bl = false;
        }
        int n7 = this.pairs[n].idLength;
        n5 = n;
        while (true) {
            int n8 = n5;
            while (++n8 != n2 && (n6 = this.pairs[n8].idLength) == n7) {
            }
            if (bl) {
                this.P.indent(n3);
                if (n5 != n) {
                    this.P.p("else ");
                }
                this.P.p("if (");
                if (n4 == 1) {
                    this.P.p(this.v_s);
                    this.P.p(".length()==");
                } else {
                    this.P.p(this.v_s);
                    this.P.p(this.v_length_suffix);
                    this.P.p("==");
                }
                this.P.p(n7);
                this.P.p(") {");
            } else {
                this.P.indent(n3);
                this.P.p("case ");
                this.P.p(n7);
                this.P.p(":");
            }
            this.generate_letter_switch(n5, n8, n3 + 1, bl ^ true, bl);
            if (bl) {
                this.P.p("}");
                this.P.nl();
            } else {
                this.P.p("break ");
                this.P.p(this.v_label);
                this.P.p(";");
                this.P.nl();
            }
            if (n8 == n2) {
                if (!bl) {
                    this.P.indent(n3);
                    this.P.p("}");
                    this.P.nl();
                }
                return;
            }
            n7 = n6;
            n5 = n8;
        }
    }

    private void generate_letter_switch(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = this.pairs[n].idLength;
        for (int i = 0; i != n4; ++i) {
            this.columns[i] = i;
        }
        this.generate_letter_switch_r(n, n2, n4, n3, bl, bl2);
    }

    private boolean generate_letter_switch_r(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        boolean bl3;
        boolean bl4 = false;
        int n6 = 1;
        if (n + 1 == n2) {
            this.P.p(' ');
            IdValuePair idValuePair = this.pairs[n];
            if (n3 > this.char_tail_test_threshold) {
                this.P.p(this.v_guess);
                this.P.p("=");
                this.P.qstring(idValuePair.id);
                this.P.p(";");
                this.P.p(this.v_id);
                this.P.p("=");
                this.P.p(idValuePair.value);
                this.P.p(";");
                bl = bl4;
            } else if (n3 == 0) {
                this.P.p(this.v_id);
                this.P.p("=");
                this.P.p(idValuePair.value);
                this.P.p("; break ");
                this.P.p(this.v_switch_label);
                this.P.p(";");
                bl = true;
            } else {
                this.P.p("if (");
                n = this.columns[0];
                this.P.p(this.v_s);
                this.P.p(".charAt(");
                this.P.p(n);
                this.P.p(")==");
                this.P.qchar(idValuePair.id.charAt(n));
                for (n = n6; n != n3; ++n) {
                    this.P.p(" && ");
                    n2 = this.columns[n];
                    this.P.p(this.v_s);
                    this.P.p(".charAt(");
                    this.P.p(n2);
                    this.P.p(")==");
                    this.P.qchar(idValuePair.id.charAt(n2));
                }
                this.P.p(") {");
                this.P.p(this.v_id);
                this.P.p("=");
                this.P.p(idValuePair.value);
                this.P.p("; break ");
                this.P.p(this.v_switch_label);
                this.P.p(";}");
                bl = bl4;
            }
            this.P.p(' ');
            return bl;
        }
        int n7 = this.find_max_different_column(n, n2, n3);
        int n8 = this.columns[n7];
        n6 = this.count_different_chars(n, n2, n8);
        int[] nArray = this.columns;
        int n9 = n3 - 1;
        nArray[n7] = nArray[n9];
        if (bl2) {
            this.P.nl();
            this.P.indent(n4);
        } else {
            this.P.p(' ');
        }
        if (n6 <= this.use_if_threshold) {
            this.c_was_defined = true;
            this.P.p(this.v_c);
            this.P.p("=");
            this.P.p(this.v_s);
            this.P.p(".charAt(");
            this.P.p(n8);
            this.P.p(");");
            bl3 = true;
            bl4 = bl;
            bl = bl3;
        } else {
            if (!bl) {
                this.P.p(this.v_label);
                this.P.p(": ");
                bl = true;
            }
            this.P.p("switch (");
            this.P.p(this.v_s);
            this.P.p(".charAt(");
            this.P.p(n8);
            this.P.p(")) {");
            bl4 = bl;
            bl = false;
        }
        int n10 = this.pairs[n].id.charAt(n8);
        n6 = n5 = n;
        n3 = 0;
        while (true) {
            int n11 = n6 + 1;
            n6 = n3;
            if (n11 != n2) {
                n3 = this.pairs[n11].id.charAt(n8);
                if (n3 != n10) {
                    n6 = n3;
                } else {
                    n6 = n11;
                    continue;
                }
            }
            if (bl) {
                this.P.nl();
                this.P.indent(n4);
                if (n5 != n) {
                    this.P.p("else ");
                }
                this.P.p("if (");
                this.P.p(this.v_c);
                this.P.p("==");
                this.P.qchar(n10);
                this.P.p(") {");
            } else {
                this.P.nl();
                this.P.indent(n4);
                this.P.p("case ");
                this.P.qchar(n10);
                this.P.p(":");
            }
            bl3 = this.generate_letter_switch_r(n5, n11, n9, n4 + 1, bl4, bl);
            if (bl) {
                this.P.p("}");
            } else if (!bl3) {
                this.P.p("break ");
                this.P.p(this.v_label);
                this.P.p(";");
            }
            if (n11 == n2) {
                if (bl) {
                    this.P.nl();
                    if (bl2) {
                        this.P.indent(n4 - 1);
                    } else {
                        this.P.indent(n4);
                    }
                } else {
                    this.P.nl();
                    this.P.indent(n4);
                    this.P.p("}");
                    if (bl2) {
                        this.P.nl();
                        this.P.indent(n4 - 1);
                    } else {
                        this.P.p(' ');
                    }
                }
                this.columns[n7] = n8;
                return false;
            }
            int n12 = n3 = n11;
            n11 = n6;
            n10 = n6;
            n5 = n3;
            n6 = n12;
            n3 = n11;
        }
    }

    private static void heap4Sort(IdValuePair[] idValuePairArray, int n, int n2, int n3) {
        if (n2 <= 1) {
            return;
        }
        SwitchGenerator.makeHeap4(idValuePairArray, n, n2, n3);
        while (n2 > 1) {
            int n4 = n + --n2;
            IdValuePair idValuePair = idValuePairArray[n4];
            int n5 = n + 0;
            idValuePairArray[n4] = idValuePairArray[n5];
            idValuePairArray[n5] = idValuePair;
            SwitchGenerator.heapify4(idValuePairArray, n, n2, 0, n3);
        }
    }

    private static void heapify4(IdValuePair[] idValuePairArray, int n, int n2, int n3, int n4) {
        IdValuePair idValuePair = idValuePairArray[n + n3];
        int n5 = n3;
        while (true) {
            IdValuePair idValuePair2;
            IdValuePair idValuePair3;
            IdValuePair idValuePair4;
            int n6 = n5 << 2;
            n3 = n6 | 1;
            int n7 = n6 | 2;
            int n8 = n6 | 3;
            int n9 = n6 + 4;
            if (n9 >= n2) {
                if (n3 < n2) {
                    idValuePair3 = idValuePair4 = idValuePairArray[n + n3];
                    n6 = n3;
                    if (n7 != n2) {
                        idValuePair3 = idValuePairArray[n + n7];
                        idValuePair2 = idValuePair4;
                        if (SwitchGenerator.bigger(idValuePair3, idValuePair4, n4)) {
                            n3 = n7;
                            idValuePair2 = idValuePair3;
                        }
                        idValuePair3 = idValuePair2;
                        n6 = n3;
                        if (n8 != n2) {
                            idValuePair4 = idValuePairArray[n + n8];
                            idValuePair3 = idValuePair2;
                            n6 = n3;
                            if (SwitchGenerator.bigger(idValuePair4, idValuePair2, n4)) {
                                idValuePair3 = idValuePair4;
                                n6 = n8;
                            }
                        }
                    }
                    if (SwitchGenerator.bigger(idValuePair3, idValuePair, n4)) {
                        idValuePairArray[n5 + n] = idValuePair3;
                        idValuePairArray[n + n6] = idValuePair;
                    }
                }
                return;
            }
            IdValuePair idValuePair5 = idValuePairArray[n + n3];
            idValuePair3 = idValuePairArray[n + n7];
            IdValuePair idValuePair6 = idValuePairArray[n + n8];
            idValuePair4 = idValuePairArray[n + n9];
            idValuePair2 = idValuePair5;
            if (SwitchGenerator.bigger(idValuePair3, idValuePair5, n4)) {
                n3 = n7;
                idValuePair2 = idValuePair3;
            }
            n6 = n8;
            idValuePair3 = idValuePair6;
            if (SwitchGenerator.bigger(idValuePair4, idValuePair6, n4)) {
                n6 = n9;
                idValuePair3 = idValuePair4;
            }
            idValuePair4 = idValuePair2;
            if (SwitchGenerator.bigger(idValuePair3, idValuePair2, n4)) {
                n3 = n6;
                idValuePair4 = idValuePair3;
            }
            if (SwitchGenerator.bigger(idValuePair, idValuePair4, n4)) {
                return;
            }
            idValuePairArray[n5 + n] = idValuePair4;
            idValuePairArray[n + n3] = idValuePair;
            n5 = n3;
        }
    }

    private static void makeHeap4(IdValuePair[] idValuePairArray, int n, int n2, int n3) {
        int n4 = n2 + 2 >> 2;
        while (n4 != 0) {
            SwitchGenerator.heapify4(idValuePairArray, n, n2, --n4, n3);
        }
    }

    private EvaluatorException on_same_pair_fail(IdValuePair object, IdValuePair idValuePair) {
        int n = ((IdValuePair)object).getLineNumber();
        int n2 = idValuePair.getLineNumber();
        if (n2 > n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        object = ToolErrorReporter.getMessage("msg.idswitch.same_string", ((IdValuePair)object).id, new Integer(n2));
        return this.R.runtimeError((String)object, this.source_file, n, null, 0);
    }

    private void sort_pairs(int n, int n2, int n3) {
        SwitchGenerator.heap4Sort(this.pairs, n, n2 - n, n3);
    }

    public void generateSwitch(String[] stringArray, String string2) {
        int n = stringArray.length / 2;
        IdValuePair[] idValuePairArray = new IdValuePair[n];
        for (int i = 0; i != n; ++i) {
            int n2 = i * 2;
            idValuePairArray[i] = new IdValuePair(stringArray[n2], stringArray[n2 + 1]);
        }
        this.generateSwitch(idValuePairArray, string2);
    }

    public void generateSwitch(IdValuePair[] idValuePairArray, String string2) {
        int n = idValuePairArray.length;
        if (n == 0) {
            return;
        }
        this.pairs = idValuePairArray;
        this.default_value = string2;
        this.generate_body(0, n, 2);
    }

    public CodePrinter getCodePrinter() {
        return this.P;
    }

    public ToolErrorReporter getReporter() {
        return this.R;
    }

    public String getSourceFileName() {
        return this.source_file;
    }

    public void setCodePrinter(CodePrinter codePrinter) {
        this.P = codePrinter;
    }

    public void setReporter(ToolErrorReporter toolErrorReporter) {
        this.R = toolErrorReporter;
    }

    public void setSourceFileName(String string2) {
        this.source_file = string2;
    }
}

