/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private String characterEncoding;
    private ClassCompiler compiler;
    private CompilerEnvirons compilerEnv;
    private String destinationDir;
    private boolean printHelp;
    private ToolErrorReporter reporter = new ToolErrorReporter(true);
    private String targetName;
    private String targetPackage;

    public Main() {
        CompilerEnvirons compilerEnvirons;
        this.compilerEnv = compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setErrorReporter(this.reporter);
        this.compiler = new ClassCompiler(this.compilerEnv);
    }

    private void addError(String string2, String string3) {
        string2 = string3 == null ? ToolErrorReporter.getMessage(string2) : ToolErrorReporter.getMessage(string2, string3);
        this.addFormatedError(string2);
    }

    private void addFormatedError(String string2) {
        this.reporter.error(string2, null, -1, null, -1);
    }

    private static void badUsage(String string2) {
        System.err.println(ToolErrorReporter.getMessage("msg.jsc.bad.usage", Main.class.getName(), string2));
    }

    private File getOutputFile(File file, String object) {
        if ((object = (file = new File(file, ((String)object).replace('.', File.separatorChar).concat(".class"))).getParent()) != null && !((File)(object = new File((String)object))).exists()) {
            ((File)object).mkdirs();
        }
        return file;
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        if ((stringArray = main.processOptions(stringArray)) == null) {
            if (main.printHelp) {
                System.out.println(ToolErrorReporter.getMessage("msg.jsc.usage", Main.class.getName()));
                System.exit(0);
            }
            System.exit(1);
        }
        if (!main.reporter.hasReportedError()) {
            main.processSource(stringArray);
        }
    }

    private static void p(String string2) {
        System.out.println(string2);
    }

    private String readSource(File object) {
        String string2 = ((File)object).getAbsolutePath();
        if (!((File)object).isFile()) {
            this.addError("msg.jsfile.not.found", string2);
            return null;
        }
        try {
            object = (String)SourceReader.readFileOrUrl(string2, true, this.characterEncoding);
            return object;
        }
        catch (IOException iOException) {
            this.addFormatedError(iOException.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addError("msg.couldnt.open", string2);
        }
        return null;
    }

    String getClassName(String string2) {
        int n = string2.length();
        int n2 = 1;
        char[] cArray = new char[n + 1];
        n = 0;
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            cArray[0] = (char)95;
        } else {
            n2 = 0;
        }
        while (n < string2.length()) {
            char c = string2.charAt(n);
            cArray[n2] = Character.isJavaIdentifierPart(c) ? c : (char)95;
            ++n;
            ++n2;
        }
        return new String(cArray).trim();
    }

    /*
     * Unable to fully structure code
     */
    public String[] processOptions(String[] var1_1) {
        this.targetPackage = "";
        var2_4 = this.compilerEnv;
        var3_6 = 0;
        var2_4.setGenerateDebugInfo(false);
        var4_7 = 0;
        while (var4_7 < var1_1.length) {
            block38: {
                block40: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block39: {
                                        block37: {
                                            block36: {
                                                block35: {
                                                    var2_4 = var1_1[var4_7];
                                                    if (!var2_4.startsWith("-")) {
                                                        var5_8 = var1_1.length - var4_7;
                                                        var2_4 = this.targetName;
                                                        if (var2_4 != null && var5_8 > 1) {
                                                            this.addError("msg.multiple.js.to.file", (String)var2_4);
                                                            return null;
                                                        }
                                                        var2_4 = new String[var5_8];
                                                        for (var6_9 = var3_6; var6_9 != var5_8; ++var6_9) {
                                                            var2_4[var6_9] = var1_1[var4_7 + var6_9];
                                                        }
                                                        return var2_4;
                                                    }
                                                    if (var2_4.equals("-help") || var2_4.equals("-h") || var2_4.equals("--help")) break block38;
                                                    var5_8 = var4_7;
                                                    var6_9 = var4_7++;
                                                    if (!var2_4.equals("-version")) break block35;
                                                    var5_8 = var4_7;
                                                    var6_9 = var4_7;
                                                    if (var4_7 >= var1_1.length) break block35;
                                                    var6_9 = var4_7;
                                                    var5_8 = Integer.parseInt(var1_1[var4_7]);
                                                    var6_9 = var4_7;
                                                    this.compilerEnv.setLanguageVersion(var5_8);
                                                    var6_9 = var4_7;
                                                }
                                                var6_9 = var5_8;
                                                if (var2_4.equals("-opt")) break block36;
                                                var4_7 = var5_8;
                                                var6_9 = var5_8;
                                                if (!var2_4.equals("-O")) break block37;
                                            }
                                            var4_7 = ++var5_8;
                                            var6_9 = var5_8;
                                            if (var5_8 >= var1_1.length) break block37;
                                            var6_9 = var5_8;
                                            var4_7 = Integer.parseInt(var1_1[var5_8]);
                                            var6_9 = var5_8;
                                            try {
                                                this.compilerEnv.setOptimizationLevel(var4_7);
                                                var6_9 = var5_8;
                                            }
                                            catch (NumberFormatException var2_5) {
                                                Main.badUsage(var1_1[var6_9]);
                                                return null;
                                            }
                                        }
                                        if (!var2_4.equals("-nosource")) break block39;
                                        this.compilerEnv.setGeneratingSource(false);
                                        var6_9 = var4_7;
                                        break block40;
                                    }
                                    if (var2_4.equals("-debug") || var2_4.equals("-g")) ** GOTO lbl169
                                    var6_9 = var4_7++;
                                    if (!var2_4.equals("-main-method-class")) break block41;
                                    var6_9 = var4_7;
                                    if (var4_7 >= var1_1.length) break block41;
                                    this.compiler.setMainMethodClass(var1_1[var4_7]);
                                    var6_9 = var4_7;
                                    break block40;
                                }
                                var5_8 = var6_9++;
                                if (!var2_4.equals("-encoding")) break block42;
                                var5_8 = var6_9;
                                if (var6_9 >= var1_1.length) break block42;
                                this.characterEncoding = var1_1[var6_9];
                                break block40;
                            }
                            var4_7 = var5_8;
                            if (!var2_4.equals("-o")) break block43;
                            var4_7 = var6_9 = var5_8 + 1;
                            if (var6_9 >= var1_1.length) break block43;
                            var7_10 = var1_1[var6_9];
                            var5_8 = var7_10.length();
                            if (var5_8 != 0 && Character.isJavaIdentifierStart(var7_10.charAt(0))) {
                                var4_7 = 1;
                                while (true) {
                                    var2_4 = var7_10;
                                    if (var4_7 >= var5_8) break;
                                    var8_11 = var7_10.charAt(var4_7);
                                    if (!Character.isJavaIdentifierPart(var8_11)) {
                                        if (var8_11 == '.' && var4_7 == var5_8 - 6 && var7_10.endsWith(".class")) {
                                            var2_4 = var7_10.substring(0, var4_7);
                                            break;
                                        }
                                        this.addError("msg.invalid.classfile.name", var7_10);
                                        var2_4 = var7_10;
                                        break;
                                    }
                                    ++var4_7;
                                }
                                this.targetName = var2_4;
                            } else {
                                this.addError("msg.invalid.classfile.name", var7_10);
                            }
                            break block40;
                        }
                        if (var2_4.equals("-observe-instruction-count")) {
                            this.compilerEnv.setGenerateObserverCount(true);
                        }
                        var6_9 = var4_7++;
                        if (!var2_4.equals("-package")) break block44;
                        var6_9 = var4_7;
                        if (var4_7 >= var1_1.length) break block44;
                        var2_4 = var1_1[var4_7];
                        var9_12 = var2_4.length();
                        var6_9 = 0;
                        while (var6_9 != var9_12) {
                            var8_11 = var2_4.charAt(var6_9);
                            if (Character.isJavaIdentifierStart(var8_11)) {
                                var10_13 = var8_11;
                                while ((var5_8 = var6_9 + 1) != var9_12) {
                                    var8_11 = var2_4.charAt(var5_8);
                                    var6_9 = var5_8;
                                    var10_13 = var8_11;
                                    if (Character.isJavaIdentifierPart(var8_11)) continue;
                                    var10_13 = var8_11;
                                    break;
                                }
                                if (var5_8 == var9_12) break;
                                if (var10_13 == '.' && var5_8 != var9_12 - 1) {
                                    var6_9 = var5_8 + 1;
                                    continue;
                                }
                            }
                            this.addError("msg.package.name", this.targetPackage);
                            return null;
                        }
                        this.targetPackage = var2_4;
                        var6_9 = var4_7;
                        break block40;
                    }
                    var4_7 = var6_9++;
                    if (var2_4.equals("-extends")) {
                        var4_7 = var6_9;
                        if (var6_9 < var1_1.length) {
                            var2_4 = var1_1[var6_9];
                            try {
                                var2_4 = Class.forName((String)var2_4);
                                this.compiler.setTargetExtends((Class<?>)var2_4);
                            }
                            catch (ClassNotFoundException var1_2) {
                                throw new Error(var1_2.toString());
                            }
                        }
                    }
                    var6_9 = var4_7++;
                    if (!var2_4.equals("-implements")) ** GOTO lbl-1000
                    var6_9 = var4_7;
                    if (var4_7 < var1_1.length) {
                        var11_14 = new StringTokenizer(var1_1[var4_7], ",");
                        var2_4 = new ArrayList<E>();
                        while (var11_14.hasMoreTokens()) {
                            var7_10 = var11_14.nextToken();
                            try {
                                var2_4.add(Class.forName(var7_10));
                            }
                            catch (ClassNotFoundException var1_3) {
                                throw new Error(var1_3.toString());
                            }
                        }
                        var2_4 = var2_4.toArray(new Class[var2_4.size()]);
                        this.compiler.setTargetImplements((Class<?>[])var2_4);
                        var6_9 = var4_7;
                    } else if (var2_4.equals("-d") && ++var6_9 < var1_1.length) {
                        this.destinationDir = var1_1[var6_9];
                    } else {
                        Main.badUsage((String)var2_4);
                        return null;
lbl169:
                        // 1 sources

                        this.compilerEnv.setGenerateDebugInfo(true);
                        var6_9 = var4_7;
                    }
                }
                var4_7 = var6_9 + 1;
                continue;
            }
            this.printHelp = true;
            return null;
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processSource(String[] stringArray) {
        int i = 0;
        while (i != stringArray.length) {
            Object object = stringArray[i];
            if (!((String)object).endsWith(".js")) {
                this.addError("msg.extension.not.js", (String)object);
                return;
            }
            Object object2 = new File((String)object);
            Object object3 = this.readSource((File)object2);
            if (object3 == null) {
                return;
            }
            CharSequence charSequence = this.targetName;
            Object object4 = charSequence;
            if (charSequence == null) {
                object4 = ((File)object2).getName();
                object4 = this.getClassName(((String)object4).substring(0, ((String)object4).length() - 3));
            }
            charSequence = object4;
            if (this.targetPackage.length() != 0) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(this.targetPackage);
                ((StringBuilder)charSequence).append(".");
                ((StringBuilder)charSequence).append((String)object4);
                charSequence = ((StringBuilder)charSequence).toString();
            }
            if ((charSequence = this.compiler.compileToClassFiles((String)object3, (String)object, 1, (String)charSequence)) == null) return;
            if (((CharSequence)charSequence).length == 0) {
                return;
            }
            object4 = null;
            if (this.destinationDir != null) {
                object4 = new File(this.destinationDir);
            } else if ((object2 = ((File)object2).getParent()) != null) {
                object4 = new File((String)object2);
            }
            for (int j = 0; j != ((CharSequence)charSequence).length; j += 2) {
                object2 = (String)charSequence[j];
                object3 = (byte[])charSequence[j + 1];
                object = this.getOutputFile((File)object4, (String)object2);
                try {
                    object2 = new FileOutputStream((File)object);
                }
                catch (IOException iOException) {
                    this.addFormatedError(iOException.toString());
                    continue;
                }
                try {
                    ((FileOutputStream)object2).write((byte[])object3);
                    continue;
                }
                finally {
                    ((FileOutputStream)object2).close();
                }
            }
            ++i;
        }
    }
}

